/*
 * Decompiled with CFR 0.152.
 */
package simple.video;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import simple.core.Application;
import simple.core.Device;
import simple.events.Event;
import simple.input.Keys;
import simple.input.Pointers;
import simple.video.Screen;

public class SimpleCanvas
extends GameCanvas
implements CommandListener {
    private Screen pScreen;
    private Graphics pGraphics = null;

    SimpleCanvas(Screen pScreen, boolean suppressKeyEvents) {
        super(suppressKeyEvents);
        super.setFullScreenMode(Device.getPropertyAsLong("DISABLE_FULLSCREEN") != 1L);
        this.pScreen = pScreen;
    }

    public Graphics getGraphics() {
        if (this.pGraphics == null) {
            return super.getGraphics();
        }
        return this.pGraphics;
    }

    public void paint(Graphics g) {
        this.pGraphics = g;
        Application.getSingleton().paintScreen(this.pScreen);
    }

    public void commandAction(Command arg0, Displayable arg1) {
        this.keyPressed(Keys.KEY_FNRIGHT);
    }

    protected void keyPressed(int iKeyCode) {
        if (Pointers.bPointersAvailable && !Keys.getSingleton().isFunctionKey(iKeyCode)) {
            return;
        }
        Keys.getSingleton().pressKey(iKeyCode);
    }

    protected void keyReleased(int iKeyCode) {
        if (Pointers.bPointersAvailable && !Keys.getSingleton().isFunctionKey(iKeyCode)) {
            return;
        }
        Keys.getSingleton().releaseKey(iKeyCode);
    }

    protected void keyRepeated(int iKeyCode) {
    }

    protected void pointerDragged(int x, int y) {
        Pointers.getSingleton().dragPointer(0, x, y, 0, 0);
    }

    protected void pointerPressed(int x, int y) {
        Pointers.getSingleton().pressPointer(0, x, y, 0, 0);
    }

    protected void pointerReleased(int x, int y) {
        Pointers.getSingleton().releasePointer(0, x, y, 0, 0);
    }

    protected void sizeChanged(int w, int h) {
        Event event = new Event("SimpleCanvas", "sizeChanged", "", null);
        Application.getSingleton().getDevice().fireEvent(event);
        event = null;
    }

    protected void showNotify() {
        Application.getSingleton().resume();
    }

    protected void hideNotify() {
        Application.getSingleton().pause();
    }
}

