/*
 * Decompiled with CFR 0.152.
 */
package simple.scene;

import java.util.Hashtable;
import java.util.Vector;
import simple.scene.SceneObject;
import simple.video.Graphics;

public class Scene
extends SceneObject {
    private Vector vecSceneObjects;
    private Hashtable mapSceneObjectsLayers;

    public void addObject(int iLayer, SceneObject pSceneObject) {
        this.vecSceneObjects.addElement(pSceneObject);
        this.mapSceneObjectsLayers.put(pSceneObject, new Integer(iLayer));
        this.quickSortObjects(0, this.vecSceneObjects.size() - 1);
    }

    void quickSortObjects(int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            int mid = ((Integer)this.mapSceneObjectsLayers.get(this.vecSceneObjects.elementAt(lo0)) + (Integer)this.mapSceneObjectsLayers.get(this.vecSceneObjects.elementAt(hi0))) / 2;
            while (lo <= hi) {
                while (lo < hi0 && (Integer)this.mapSceneObjectsLayers.get(this.vecSceneObjects.elementAt(lo)) < mid) {
                    ++lo;
                }
                while (hi > lo0 && (Integer)this.mapSceneObjectsLayers.get(this.vecSceneObjects.elementAt(hi)) > mid) {
                    --hi;
                }
                if (lo > hi) continue;
                SceneObject pSceneObjectLo = (SceneObject)this.vecSceneObjects.elementAt(lo);
                SceneObject pSceneObjectHi = (SceneObject)this.vecSceneObjects.elementAt(hi);
                this.vecSceneObjects.removeElementAt(lo);
                this.vecSceneObjects.insertElementAt(pSceneObjectHi, lo);
                this.vecSceneObjects.removeElementAt(hi);
                this.vecSceneObjects.insertElementAt(pSceneObjectLo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.quickSortObjects(lo0, hi);
            }
            if (lo < hi0) {
                this.quickSortObjects(lo, hi0);
            }
        }
    }

    public void removeObject(SceneObject pSceneObject) {
        for (int i = this.vecSceneObjects.size() - 1; i >= 0; --i) {
            if (this.vecSceneObjects.elementAt(i) != pSceneObject) continue;
            this.vecSceneObjects.removeElementAt(i);
            this.mapSceneObjectsLayers.remove(pSceneObject);
            pSceneObject.pScene = null;
            return;
        }
    }

    public boolean containObject(SceneObject pSceneObject) {
        for (int i = this.vecSceneObjects.size() - 1; i >= 0; --i) {
            if (this.vecSceneObjects.elementAt(i) != pSceneObject) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        while (this.vecSceneObjects.size() > 0) {
            SceneObject pSceneObject = (SceneObject)this.vecSceneObjects.elementAt(0);
            this.vecSceneObjects.removeElementAt(0);
            this.mapSceneObjectsLayers.remove(pSceneObject);
            pSceneObject.pScene = null;
        }
    }

    public void paint(Graphics pGraphics, int iPositionX, int iPositionY) {
        int iLen = this.vecSceneObjects.size();
        for (int i = 0; i < iLen; ++i) {
            SceneObject pSceneObject = (SceneObject)this.vecSceneObjects.elementAt(i);
            pSceneObject.paint(pGraphics, pSceneObject.getPositionX() + iPositionX, pSceneObject.getPositionY() + iPositionY);
        }
    }

    public void paint(Graphics pGraphics) {
        this.paint(pGraphics, this.iPositionX, this.iPositionY);
    }
}

