/*
 * Decompiled with CFR 0.152.
 */
package simple.audio;

import java.util.Vector;
import simple.audio.AudioPlayer;
import simple.core.Device;
import simple.debug.DebugOutput;

public class AudioSystem {
    private static AudioSystem pSingleton;
    Vector vecExistingAudioPlayers;

    AudioPlayer getPlayerByResourceName(String strResourceName) {
        for (int i = this.vecExistingAudioPlayers.size() - 1; i >= 0; --i) {
            AudioPlayer pAudioPlayer = (AudioPlayer)this.vecExistingAudioPlayers.elementAt(i);
            if (pAudioPlayer.strResourceName.compareTo(strResourceName) != 0) continue;
            return pAudioPlayer;
        }
        return null;
    }

    public AudioSystem(Device pDevice) {
        DebugOutput.traceIn(2, "SIMPLE", "AudioSystem.AudioSystem()");
        this.vecExistingAudioPlayers = new Vector();
        pSingleton = this;
        DebugOutput.traceOut(2, "SIMPLE", "AudioSystem.AudioSystem()");
    }

    protected void finalize() throws Throwable {
    }

    public static AudioSystem getSingleton() {
        return pSingleton;
    }

    public AudioPlayer getAudioPlayer(String strResourceName) {
        AudioPlayer pAudioPlayer = this.getPlayerByResourceName(strResourceName);
        if (pAudioPlayer != null) {
            return pAudioPlayer;
        }
        pAudioPlayer = new AudioPlayer(this);
        pAudioPlayer.loadAudioData(strResourceName);
        this.vecExistingAudioPlayers.addElement(pAudioPlayer);
        return pAudioPlayer;
    }

    public void deleteAudioPlayer(AudioPlayer pAudioPlayer) {
        for (int i = this.vecExistingAudioPlayers.size() - 1; i >= 0; --i) {
            if (pAudioPlayer != (AudioPlayer)this.vecExistingAudioPlayers.elementAt(i)) continue;
            this.vecExistingAudioPlayers.removeElement(pAudioPlayer);
            pAudioPlayer = null;
        }
    }

    public void muteAll() {
        for (int i = this.vecExistingAudioPlayers.size() - 1; i >= 0; --i) {
            AudioPlayer pAudioPlayer = (AudioPlayer)this.vecExistingAudioPlayers.elementAt(i);
            pAudioPlayer.mute();
        }
    }

    public void unmuteAll() {
        for (int i = this.vecExistingAudioPlayers.size() - 1; i >= 0; --i) {
            AudioPlayer pAudioPlayer = (AudioPlayer)this.vecExistingAudioPlayers.elementAt(i);
            pAudioPlayer.unmute();
        }
    }

    public void stopAll() {
        for (int i = this.vecExistingAudioPlayers.size() - 1; i >= 0; --i) {
            AudioPlayer pAudioPlayer = (AudioPlayer)this.vecExistingAudioPlayers.elementAt(i);
            pAudioPlayer.stop();
        }
    }
}

