/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.system;

import baltorogames.core.ApplicationData;
import baltorogames.core.LanguagePack;
import baltorogames.core_gui.UIScreen;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.AboutTB;
import baltorogames.project_gui.MainListAnimated;
import baltorogames.project_gui.ResetAppDataTB;
import baltorogames.system.BGStore;
import baltorogames.system.ObjectsCache;
import baltorogames.system.SoundEngine;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Options
extends MainListAnimated {
    public static int OPTION_MUSIC = 0;
    public static int OPTION_LANGID = -1;
    public static int OPTION_ABOUT = 1;
    public static int OPTION_RESETAPP = 2;
    public static boolean GfxOnOff = false;
    public static boolean Vibration = false;
    public static int languageID = 0;
    public static String netResultsURL = new String();
    private static String[] languageNames = new String[]{"TID_ENG", "TID_GER", "TID_SPA", "TID_ITA", "TID_FRE"};

    public Options() {
        this.drawTop = false;
        this.drawTitle = true;
        this.setCaption(ApplicationData.lp.getTranslatedString(languageID, "TID_MAIN_MENU_OPTIONS"));
        this.refreshList();
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
    }

    public static void reset() {
        int currlanguage = languageID;
        Options.readDefaults();
        if (currlanguage != languageID) {
            ApplicationData.lp = LanguagePack.create("/gameTexts.EEE", languageID);
        }
        CGAchievements.Reset();
        CGUserCareer.Reset();
    }

    public static void readDefaults() {
    }

    public static boolean readConfigurationFromStore() {
        BGStore store = BGStore.openStoreToRead("Configuration");
        try {
            DataInputStream inputStream = store.getInStream();
            if (inputStream != null && inputStream.available() > 0) {
                boolean bS = inputStream.readBoolean();
                Vibration = inputStream.readBoolean();
                SoundEngine.soundVolume = inputStream.readInt();
                netResultsURL = inputStream.readUTF();
                ApplicationData.demoTimeLeft = inputStream.readInt();
                ApplicationData.demoLevelsLeft = inputStream.readInt();
            }
            store.close();
        }
        catch (Exception e) {
            Options.readDefaults();
            return false;
        }
        return true;
    }

    public static void writeConfigurationToStore() {
        BGStore store = BGStore.openStoreToWrite("Configuration");
        try {
            DataOutputStream outputStream = store.getOutStream();
            outputStream.writeBoolean(GfxOnOff);
            outputStream.writeBoolean(Vibration);
            outputStream.writeInt(SoundEngine.soundVolume);
            outputStream.writeUTF(netResultsURL);
            outputStream.writeInt(ApplicationData.demoTimeLeft);
            outputStream.writeInt(ApplicationData.demoLevelsLeft);
            store.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void refreshList() {
        this.clearList();
        if (languageID != LanguagePack.currentLanguageID) {
            ApplicationData.lp = LanguagePack.create("/gameTexts.EEE", languageID);
            this.setCaption(ApplicationData.lp.getTranslatedString(languageID, "TID_MAIN_MENU_OPTIONS"));
            this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        }
        if (ApplicationData.soundEngine.isSoundEnabled()) {
            if (SoundEngine.soundVolume == SoundEngine.SOUND_VOLUME_LOW) {
                this.append(ApplicationData.lp.getTranslatedString(languageID, "TID_OPTIONS_SOUND_ON"));
            } else if (SoundEngine.soundVolume == SoundEngine.SOUND_VOLUME_MEDIUM) {
                this.append(ApplicationData.lp.getTranslatedString(languageID, "TID_OPTIONS_SOUND_ON"));
            } else if (SoundEngine.soundVolume == SoundEngine.SOUND_VOLUME_HIGH) {
                this.append(ApplicationData.lp.getTranslatedString(languageID, "TID_OPTIONS_SOUND_ON"));
            }
        } else {
            this.append(ApplicationData.lp.getTranslatedString(languageID, "TID_OPTIONS_SOUND_OFF"));
        }
        this.append(ApplicationData.lp.getTranslatedString(languageID, "TID_CREDITS"));
        if (ApplicationData.generalGameMode != 4) {
            this.append(ApplicationData.lp.getTranslatedString(languageID, "TID_RESETGAME"));
        }
    }

    public void currentItemSelected(int currentItemId) {
        if (currentItemId == OPTION_MUSIC) {
            boolean currentState = ApplicationData.soundEngine.isSoundEnabled();
            ApplicationData.soundEngine.onGameEvent(19, null);
            if (ApplicationData.soundEngine.isSoundEnabled()) {
                GfxOnOff = true;
                if (!currentState) {
                    if (ApplicationData.isMainMenuMode()) {
                        CGSoundSystem.PlayMusic("/mainmenu.mid");
                    } else {
                        CGSoundSystem.PlayMusic("/galaxy_3.mid");
                    }
                }
            } else {
                GfxOnOff = false;
            }
        } else if (currentItemId == OPTION_RESETAPP) {
            CGSoundSystem.Play(2, false);
            UIScreen.SetNextScreen(new ResetAppDataTB());
            UIScreen.GetNextScreen().setParent(this);
            this.readyForClose = true;
        } else if (currentItemId == OPTION_LANGID) {
            if (ApplicationData.Enable_Multilang) {
                ++languageID;
            }
        } else if (currentItemId == OPTION_ABOUT) {
            AboutTB dlg = new AboutTB(true, 0, false, this);
            CGSoundSystem.Play(2, false);
            UIScreen.SetNextScreen(dlg);
            UIScreen.GetNextScreen().setParent(this);
            this.readyForClose = true;
        }
        if (languageID < 0) {
            languageID = ApplicationData.lp.getNumLanguages() - 1;
        }
        if (languageID >= ApplicationData.lp.getNumLanguages()) {
            languageID = 0;
        }
        this.refreshList();
    }

    public boolean rightSoftButton() {
        CGSoundSystem.Play(2, false);
        if (this.parentScreen != null) {
            this.readyForClose = true;
            return true;
        }
        return false;
    }

    public boolean leftSoftButton() {
        this.currentItemSelected(this.currentItem);
        return true;
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (pressed) {
            return super.actionSoftButton(nID, pressed);
        }
        this.currentItemSelected(nID - 1000);
        return true;
    }
}

