/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core;

import baltorogames.core.ApplicationData;
import baltorogames.system.FileManager;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class LanguagePack {
    private int numStringID;
    private int[] stringIDs = null;
    private int[] fontIDs = null;
    private int numLanguages;
    private String[] languageNames;
    private Vector stringTranslations;
    private Vector stringTranslationsFonts;
    private Vector stringHashIDs;
    public static int currentLanguageID = -1;
    private static final int MAX_STRING_LETTERS = 1536;
    private static char[] charBuffer = new char[1536];
    private static byte[] byteBuffer = new byte[1536];
    private static byte[] byteBuffer2 = new byte[3072];

    public int getNumLanguages() {
        return this.numLanguages;
    }

    public static LanguagePack create(String langPackFilename, int selectedLanguage) {
        LanguagePack lp = new LanguagePack();
        try {
            InputStream is = FileManager.OpenFile(langPackFilename);
            DataInputStream dis = new DataInputStream(is);
            lp.deserializeLanguagePack(dis, selectedLanguage);
            dis.close();
            currentLanguageID = selectedLanguage;
        }
        catch (Exception e) {
            lp = null;
        }
        return lp;
    }

    public String getTranslatedString(int languageID, String stringID) {
        if (languageID >= this.numLanguages) {
            languageID = 0;
        }
        int i = 0;
        try {
            for (i = 0; i < this.stringHashIDs.size(); ++i) {
                String s = (String)this.stringHashIDs.elementAt(i);
                if (s.compareTo(stringID) != 0) continue;
                return (String)this.stringTranslations.elementAt(i);
            }
            return "NO_STRING_FOUND";
        }
        catch (Exception e) {
            return "NO_STRING_FOUND";
        }
    }

    private void deserializeLanguagePack(DataInputStream dis, int selectedLanguage) throws IOException {
        int i;
        this.numStringID = dis.readInt();
        this.stringIDs = new int[this.numStringID];
        this.stringHashIDs = new Vector();
        this.fontIDs = new int[this.numStringID];
        for (i = 0; i < this.numStringID; ++i) {
            this.stringIDs[i] = dis.readInt();
            this.stringHashIDs.addElement(LanguagePack.deSerializeString(dis));
            this.fontIDs[i] = dis.readInt();
        }
        this.numLanguages = dis.readInt();
        this.languageNames = new String[this.numLanguages];
        this.stringTranslations = null;
        this.stringTranslationsFonts = null;
        for (i = 0; i < this.numLanguages; ++i) {
            String languageName;
            this.languageNames[i] = languageName = LanguagePack.deSerializeString2(dis);
            if (selectedLanguage == i) {
                this.stringTranslations = new Vector();
            }
            for (int k = 0; k < this.numStringID; ++k) {
                if (selectedLanguage == i) {
                    String stringTranslation = LanguagePack.deSerializeAndDecodeString(dis);
                    this.stringTranslations.addElement(stringTranslation);
                    continue;
                }
                LanguagePack.skipShortsString(dis);
            }
            int numFonts = dis.readInt();
            if (selectedLanguage == i) {
                this.stringTranslationsFonts = new Vector();
            }
            for (int j = 0; j < numFonts; ++j) {
                if (selectedLanguage == i) {
                    String fontName = LanguagePack.deSerializeString(dis);
                    this.stringTranslationsFonts.addElement(fontName);
                    continue;
                }
                LanguagePack.skipString(dis);
            }
        }
    }

    public static String deSerializeString(DataInputStream dis) throws IOException {
        int nameStringLength = dis.readInt();
        dis.read(byteBuffer, 0, nameStringLength);
        return new String(byteBuffer, 0, nameStringLength);
    }

    public static String deSerializeString2(DataInputStream dis) throws IOException {
        int nameStringLength = dis.readInt();
        dis.read(byteBuffer2, 0, nameStringLength * 2);
        for (int i = 0; i < nameStringLength; ++i) {
            LanguagePack.byteBuffer[i] = byteBuffer2[i * 2 + 1];
        }
        return new String(byteBuffer, 0, nameStringLength);
    }

    public static String deSerializeAndDecodeString(DataInputStream dis) throws IOException {
        int nameStringLength = dis.readInt();
        for (int i = 0; i < nameStringLength; ++i) {
            short charUnicode = dis.readShort();
            if (charUnicode == 13) {
                charUnicode = dis.readShort();
                if (charUnicode == 10) {
                    LanguagePack.charBuffer[i] = 255;
                    --nameStringLength;
                    continue;
                }
                LanguagePack.charBuffer[i] = ApplicationData.defaultFont.getDecodedCharIndex(13);
                LanguagePack.charBuffer[i + 1] = ApplicationData.defaultFont.getDecodedCharIndex(charUnicode);
                ++i;
                continue;
            }
            LanguagePack.charBuffer[i] = ApplicationData.defaultFont.getDecodedCharIndex(charUnicode);
        }
        return new String(charBuffer, 0, nameStringLength);
    }

    public static void skipString(DataInputStream dis) throws IOException {
        int nameStringLength = dis.readInt();
        dis.skip(nameStringLength);
    }

    public static void skipShortsString(DataInputStream dis) throws IOException {
        int nameStringLength = dis.readInt();
        dis.skip(nameStringLength * 2);
    }
}

