/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.project_gameplay.TmpWorldObject;
import baltorogames.project_gameplay.TmpWorldObjectsDataBase;
import baltorogames.project_gameplay.WorldObject;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public class WorldLayerPiece {
    protected Vector m_Vector = new Vector();

    public int Load(DataInputStream dis) throws IOException {
        this.Destroy();
        int nSize = dis.readInt();
        for (int i = 0; i < nSize; ++i) {
            byte nTemplateIndex = dis.readByte();
            TmpWorldObject tmp = TmpWorldObjectsDataBase.GetByID(nTemplateIndex);
            if (tmp == null) {
                System.out.println("ERROR: Bad object ID (" + nTemplateIndex + ")");
                continue;
            }
            WorldObject pO = null;
            String str = new String(tmp.m_szTextureName);
            pO = new WorldObject();
            int nRet = pO.Load(dis, nTemplateIndex);
            if (nRet <= 0 || pO == null) continue;
            this.m_Vector.addElement(pO);
        }
        return 1;
    }

    public int GetObjectsSize() {
        return this.m_Vector.size();
    }

    public WorldObject GetObject(int nIndex) {
        return (WorldObject)this.m_Vector.elementAt(nIndex);
    }

    public void RemoveObject(int nIndex) {
        this.m_Vector.removeElementAt(nIndex);
    }

    public void Destroy() {
        this.m_Vector.removeAllElements();
    }

    public void ActiveAllObjects() {
        int nS = this.m_Vector.size();
        for (int i = 0; i < nS; ++i) {
            WorldObject pO = (WorldObject)this.m_Vector.elementAt(i);
            pO.m_nActive = 1;
        }
    }

    public void Render() {
        int nS = this.m_Vector.size();
        for (int i = 0; i < nS; ++i) {
            WorldObject pO = (WorldObject)this.m_Vector.elementAt(i);
            pO.Render();
        }
    }

    WorldObject FindByTextureName(String name) {
        int nS = this.m_Vector.size();
        for (int i = 0; i < nS; ++i) {
            WorldObject pO = (WorldObject)this.m_Vector.elementAt(i);
            if (pO.m_TextureName[0] == null || pO.m_TextureName[0].intern() != name.intern()) continue;
            return pO;
        }
        return null;
    }

    WorldObject FindByCollisionID(int nID) {
        int nS = this.m_Vector.size();
        for (int i = 0; i < nS; ++i) {
            WorldObject pO = (WorldObject)this.m_Vector.elementAt(i);
            if (pO.m_nCollisionID != nID) continue;
            return pO;
        }
        return null;
    }
}

