/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngineRenderer;
import java.util.Vector;

public class GiftScore {
    public static int[] nFrames = new int[]{0, 1, 2, 3, 2, 1, 0, 1, 2, 3, 2, 1, 0, 1, 2, 3, 2, 1, 0, 1, 2, 3, 2, 1, 0};
    public float m_fStartX;
    public float m_fStartY;
    public float m_fStopX = 10.0f;
    public float m_fStopY = 10.0f;
    public float m_fCurrentX;
    public float m_fCurrentY;
    public int m_nTime = 1000000;
    public int m_nFullTime = 300;
    public int m_nType;
    int m_nCurrentFrame;
    float m_fScale = 1.0f;
    public static CGTexture[] m_GiftTextures = null;
    public static CGTexture[] m_2SecondsTextures = null;
    static Vector m_TmpVector = null;
    static Vector m_Vector = null;

    public static void Initialize() {
        m_GiftTextures = new CGTexture[4];
        GiftScore.m_GiftTextures[0] = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/POINTS/point_1_1.png");
        GiftScore.m_GiftTextures[1] = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/POINTS/point_1_2.png");
        GiftScore.m_GiftTextures[2] = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/POINTS/point_1_3.png");
        GiftScore.m_GiftTextures[3] = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/POINTS/point_1_4.png");
        m_2SecondsTextures = new CGTexture[4];
        GiftScore.m_2SecondsTextures[0] = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/POINTS/minus2s.png");
        GiftScore.m_2SecondsTextures[1] = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/POINTS/minus2s.png");
        GiftScore.m_2SecondsTextures[2] = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/POINTS/minus2s.png");
        GiftScore.m_2SecondsTextures[3] = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/POINTS/minus2s.png");
        m_TmpVector = new Vector();
        m_Vector = new Vector();
        for (int i = 0; i < 64; ++i) {
            GiftScore pH = new GiftScore();
            m_TmpVector.addElement(pH);
        }
    }

    public static void Reset() {
        int nS = m_Vector.size();
        if (nS > 0) {
            for (int i = nS - 1; i >= 0; --i) {
                m_TmpVector.addElement(m_Vector.elementAt(i));
            }
            m_Vector.removeAllElements();
        }
    }

    public static void NewGifts(float x, float y, int nCoins) {
        if (nCoins > 0) {
            for (int i = 0; i < nCoins; ++i) {
                GiftScore.NewGift(0.4f, x, y, -i * 70, 0);
            }
        } else {
            GiftScore.NewGift(0.6f, x, y, 0, 1);
        }
    }

    public static void NewGift(float fScale, float x, float y, int nDelay, int nT) {
        int nS = m_TmpVector.size();
        if (nS > 0) {
            GiftScore pH = (GiftScore)m_TmpVector.elementAt(nS - 1);
            m_TmpVector.removeElementAt(nS - 1);
            pH.Active(fScale, x, y, nDelay, nT);
            m_Vector.addElement(pH);
        }
    }

    public static void StepAll(int nDeltaTimeInMs) {
        int nS = m_Vector.size();
        for (int i = nS - 1; i >= 0; --i) {
            GiftScore pH = (GiftScore)m_Vector.elementAt(i);
            pH.Step(nDeltaTimeInMs);
            if (pH.m_nTime < 1000000) continue;
            m_Vector.removeElementAt(i);
            m_TmpVector.addElement(pH);
        }
    }

    public static void RenderAll() {
        int nS = m_Vector.size();
        for (int i = nS - 1; i >= 0; --i) {
            ((GiftScore)m_Vector.elementAt(i)).Render();
        }
    }

    public void Init() {
        this.m_nTime = -1;
    }

    public void Active(float fScale, float x, float y, int nDelay, int nT) {
        this.m_nTime = nDelay;
        this.m_nCurrentFrame = 0;
        this.m_nType = nT;
        if (this.m_nType == 0) {
            this.m_fStopX = 120.0f;
            this.m_fStopY = 10.0f;
            this.m_nFullTime = 300;
        } else {
            this.m_fStopX = 270.0f;
            this.m_fStopY = 10.0f;
            this.m_nFullTime = 600;
        }
        this.m_fStartX = x;
        this.m_fStartY = y;
        this.m_fScale = fScale;
    }

    public void Disactive() {
        this.m_nTime = 1000000;
    }

    public void Step(int nDeltaTimeInMs) {
        this.m_nTime += nDeltaTimeInMs;
        if (this.m_nTime < 0) {
            return;
        }
        if (this.m_nTime > this.m_nFullTime) {
            this.m_nTime = 1000000;
            return;
        }
        float fT = (float)this.m_nTime / (float)this.m_nFullTime;
        this.m_fCurrentX = this.m_fStartX + fT * (this.m_fStopX - this.m_fStartX);
        this.m_fCurrentY = this.m_fStartY + fT * (this.m_fStopY - this.m_fStartY);
        this.m_nCurrentFrame = this.m_nTime / 50;
        this.m_nCurrentFrame %= nFrames.length;
        this.m_nCurrentFrame = nFrames[this.m_nCurrentFrame];
    }

    public void Render() {
        if (this.m_nTime < 0) {
            return;
        }
        CGEngineRenderer.RenderGiftScore(this);
    }
}

