/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.RandSync;
import baltorogames.core.VectorF2;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;

public class CGJewel {
    public static int NUM_JEWEL_COLORS = 7;
    public static int NUM_JEWEL_SPECIAL = 5;
    public static int eSpecial_Bomb = 7;
    public static int eSpecial_Color = 8;
    public static int eSpecial_Destroyer = 9;
    public static int eSpecial_Random = 10;
    public static int eSpecial_Star = 11;
    public static int NUM_FRAME_ANIM_JEWEL = 1;
    public static int eType_Unvisible = 100;
    static boolean FIRST_TIME_ANIM = true;
    public static float m_fPixelsPerSec = 750.0f;
    static CGTexture[][] m_animTextures = null;
    public float m_fRadiusX;
    public float m_fRadiusY;
    public int frameOfAnim = 0;
    public boolean isJewelAnimationPlayed = true;
    public float m_fX;
    public float m_fY;
    public float m_fRotateX;
    public float m_fRotateY;
    public float m_fTargetY;
    public int m_nType = -1;
    public boolean m_bToDestroy = false;

    public static void Initialize() {
        m_animTextures = new CGTexture[NUM_JEWEL_COLORS + NUM_JEWEL_SPECIAL][NUM_FRAME_ANIM_JEWEL];
        for (int i = 0; i < NUM_JEWEL_COLORS; ++i) {
            for (int j = 0; j < NUM_FRAME_ANIM_JEWEL; ++j) {
                CGJewel.m_animTextures[i][j] = TextureManager.AddTexture("/gameplay/jewel/jewel_" + (i + 1) + "_" + (j + 1) + ".png");
            }
        }
        for (int j = 0; j < NUM_FRAME_ANIM_JEWEL; ++j) {
            CGJewel.m_animTextures[CGJewel.NUM_JEWEL_COLORS][j] = TextureManager.AddTexture("/gameplay/jewel/jewel_bomb.png");
            CGJewel.m_animTextures[CGJewel.NUM_JEWEL_COLORS + 1][j] = TextureManager.AddTexture("/gameplay/jewel/jewel_color.png");
            CGJewel.m_animTextures[CGJewel.NUM_JEWEL_COLORS + 2][j] = TextureManager.AddTexture("/gameplay/jewel/jewel_destroy.png");
            CGJewel.m_animTextures[CGJewel.NUM_JEWEL_COLORS + 3][j] = TextureManager.AddTexture("/gameplay/jewel/jewel_rand.png");
            CGJewel.m_animTextures[CGJewel.NUM_JEWEL_COLORS + 4][j] = TextureManager.AddTexture("/gameplay/jewel/jewel_star.png");
        }
    }

    public void Init(int nType, float x, float y) {
        this.m_fX = x;
        this.m_fY = y;
        this.m_nType = nType;
        this.m_fRadiusX = -1000.0f;
        this.m_fRadiusY = -1000.0f;
    }

    public void SetTargetY(float y) {
        this.m_fTargetY = y;
        CGEngine.m_Board.m_Board[this.GetBoardX()][this.GetBoardY()] = this;
    }

    public void Step(int nDeltaTimeInMs) {
        if (this.m_fRadiusX == -1000.0f && this.m_fRadiusY == -1000.0f) {
            float fAdd = m_fPixelsPerSec * (float)nDeltaTimeInMs / 1000.0f;
            if (this.m_fY < this.m_fTargetY) {
                this.m_fY += fAdd;
                if (this.m_fY >= this.m_fTargetY) {
                    this.m_fY = this.m_fTargetY;
                }
            }
        } else if (this.m_fRadiusX != -1000.0f) {
            VectorF2 src = VectorF2.vecTmp1;
            src.x = this.m_fRadiusX;
            src.y = 0.0;
            VectorF2 dst = VectorF2.vecTmp2;
            VectorF2.RotateVector(src, CGBoard.m_fCurrentRotateAngle, dst);
            this.m_fRotateX = CGBoard.m_fCurrentRotateCenterX + (float)dst.x;
            this.m_fRotateY = CGBoard.m_fCurrentRotateCenterY + (float)dst.y;
        } else if (this.m_fRadiusY != -1000.0f) {
            VectorF2 src = VectorF2.vecTmp1;
            src.x = 0.0;
            src.y = this.m_fRadiusY;
            VectorF2 dst = VectorF2.vecTmp2;
            VectorF2.RotateVector(src, CGBoard.m_fCurrentRotateAngle, dst);
            this.m_fRotateX = CGBoard.m_fCurrentRotateCenterX + (float)dst.x;
            this.m_fRotateY = CGBoard.m_fCurrentRotateCenterY + (float)dst.y;
        }
    }

    public void Render() {
        if (this.m_nType >= eType_Unvisible) {
            return;
        }
        if (this.m_fRadiusX == -1000.0f && this.m_fRadiusY == -1000.0f) {
            if (this.IsInBoard()) {
                this.RenderAnimationWhenLvlStarts(this);
            }
            CGEngineRenderer.RenderJewel(this);
        } else {
            CGEngineRenderer.RenderRotateJewel(this);
        }
    }

    int GetBoardX() {
        return (int)this.m_fX / (int)CGBoard.m_fSize;
    }

    int GetBoardY() {
        return (int)this.m_fTargetY / (int)CGBoard.m_fSize;
    }

    boolean IsInBoard() {
        return !(this.m_fY < this.m_fTargetY);
    }

    public void RenderAnimationWhenLvlStarts(CGJewel j) {
        if (this.m_nType == RandSync.nextInt(800)) {
            this.isJewelAnimationPlayed = true;
        }
        if (this.frameOfAnim >= NUM_FRAME_ANIM_JEWEL - 1) {
            this.frameOfAnim = 0;
            this.isJewelAnimationPlayed = false;
        } else if (System.currentTimeMillis() % 2L == 0L) {
            ++this.frameOfAnim;
        }
    }
}

