/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.IndexedSprite;
import ca.jamdat.flight.KeyFrameController;
import ca.jamdat.flight.MediaPlayer;
import ca.jamdat.flight.ProgressionBar;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.Selector;
import ca.jamdat.flight.SelectorMenu;
import ca.jamdat.flight.StaticHost0;
import ca.jamdat.flight.TimeSystem;

public final class MainMenu
extends SelectorMenu {
    public TimeSystem mIdleAnimations;
    public IndexedSprite mGameLogoISprite;
    public IndexedSprite mRightBirdISprite;
    public ProgressionBar mProgressionBar = new ProgressionBar(this);
    public TimeSystem mExitTimeAnimations;
    public KeyFrameController mRightBirdHoveringKFC;
    public IndexedSprite mLeftBirdISprite;
    public KeyFrameController mLeftBirdHoveringKFC;

    public final void ReceiveFocus() {
        super.ReceiveFocus();
        this.StartAnim(this.mIdleAnimations);
    }

    public final boolean IsClosingAnimsEnded() {
        return super.IsClosingAnimsEnded() && this.mExitTimeAnimations.mTotalTime >= 600;
    }

    public final boolean SaveFiles(int n) {
        if (n == 0) {
            return StaticHost0.ca_jamdat_flight_FileHandler_OnSerialize_SB(1, ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mFileManager.mFiles[0]);
        }
        return super.SaveFiles(n);
    }

    public final void StartOpeningAnims() {
        super.StartOpeningAnims();
        StaticHost0.ca_jamdat_flight_ProgressionBar_Start_SB(0, this.mProgressionBar);
    }

    public final void StartClosingAnims() {
        super.StartClosingAnims();
        this.StartAnim(this.mExitTimeAnimations);
    }

    public final void StartAnim(TimeSystem timeSystem) {
        if (timeSystem != null) {
            StaticHost0.ca_jamdat_flight_Utilities_StartAnimationTimeSystem(timeSystem, 0);
        }
    }

    public final void StopAnim(TimeSystem timeSystem) {
        if (timeSystem != null) {
            timeSystem.mTotalTime = 0;
            timeSystem.mPaused = true;
            StaticHost0.rockband2_mFrameworkGlobals.application.mApplicationTimeSystem.UnRegister(timeSystem);
        }
    }

    public final void Unload() {
        TimeSystem timeSystem;
        MediaPlayer mediaPlayer = ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mMediaPlayer;
        StaticHost0.ca_jamdat_flight_MediaPlayer_ResetMidiPool_SB(mediaPlayer);
        StaticHost0.ca_jamdat_flight_MediaPlayer_StopSound_SB(mediaPlayer);
        if (this.mIdleAnimations != null) {
            timeSystem = this.mIdleAnimations;
            timeSystem.mTotalTime = 0;
            timeSystem.mPaused = true;
            StaticHost0.rockband2_mFrameworkGlobals.application.mApplicationTimeSystem.UnRegister(timeSystem);
            this.mIdleAnimations = null;
        }
        if (this.mExitTimeAnimations != null) {
            timeSystem = this.mExitTimeAnimations;
            timeSystem.mTotalTime = 0;
            timeSystem.mPaused = true;
            StaticHost0.rockband2_mFrameworkGlobals.application.mApplicationTimeSystem.UnRegister(timeSystem);
            this.mExitTimeAnimations = null;
        }
        StaticHost0.ca_jamdat_flight_ProgressionBar_Unload_SB(this.mProgressionBar);
        super.Unload();
    }

    public final boolean OnMsg(Component component, int n, int n2) {
        int n3 = ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mPopupManager.mCurrentPopup != null ? 1 : 0;
        if (n3 == 0 && component != null && component instanceof Selection && n == -128 && n2 == 1 && (n3 = this.mSelector.mCurrentSelectionIndex) >= 0) {
            StaticHost0.ca_jamdat_flight_MainMenu_UpdateBirdsPos_SB(n3, this);
            this.mRightBirdHoveringKFC.mStartState = 0;
            this.mLeftBirdHoveringKFC.mStartState = 0;
        }
        return super.OnMsg(component, n, n2);
    }

    public MainMenu(int n, int n2) {
        super(n, n2);
    }

    public final boolean OnCommand(int n) {
        boolean bl = false;
        if (n == -23) {
            bl = true;
            ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mCommandHandler.Execute(-23);
        }
        return bl || super.OnCommand(n);
    }

    public final void GetEntryPoints() {
        super.GetEntryPoints();
        this.mGameLogoISprite = StaticHost0.ca_jamdat_flight_EntryPoint_GetIndexedSprite(this.mPackage, 6);
        this.mIdleAnimations = StaticHost0.ca_jamdat_flight_EntryPoint_GetTimeSystem(this.mPackage, 7);
        this.mExitTimeAnimations = StaticHost0.ca_jamdat_flight_EntryPoint_GetTimeSystem(this.mPackage, 10);
        this.mRightBirdHoveringKFC = StaticHost0.ca_jamdat_flight_EntryPoint_GetKeyFrameController(this.mPackage, 8);
        this.mLeftBirdHoveringKFC = StaticHost0.ca_jamdat_flight_EntryPoint_GetKeyFrameController(this.mPackage, 9);
        this.mRightBirdISprite = StaticHost0.ca_jamdat_flight_EntryPoint_GetIndexedSprite(this.mPackage, 5);
        this.mLeftBirdISprite = StaticHost0.ca_jamdat_flight_EntryPoint_GetIndexedSprite(this.mPackage, 4);
    }

    public final void Initialize() {
        super.Initialize();
        int n = ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mMoreGames16.mImpl != 0 ? 1 : 0;
        if (n == 0 && (n = StaticHost0.ca_jamdat_flight_Utilities_GetSelectionIndexFromCommand(this.mSelector, -25)) >= 0) {
            StaticHost0.ca_jamdat_flight_Utilities_RemoveElement(this.mSelector, n);
        }
        if (StaticHost0.ca_jamdat_flight_Settings_GetApplicationLanguage_SB$8d45444() == 14) {
            StaticHost0.ca_jamdat_flight_IndexedSprite_SetCurrentFrame_SB(1, this.mGameLogoISprite);
        } else {
            StaticHost0.ca_jamdat_flight_IndexedSprite_SetCurrentFrame_SB(0, this.mGameLogoISprite);
        }
        int n2 = this.mSelector.mNumElements;
        n = n2 * StaticHost0.ca_jamdat_flight_Selector_GetSelectionAt_SB((int)0, (Selector)this.mSelector).mRect_height;
        n = (n2 - 1) * 15 + n;
        if (this.mSelector.mRect_height > n) {
            StaticHost0.ca_jamdat_flight_Component_SetTopLeft_SB(this.mSelector.mRect_left, (short)((this.mSelector.mRect_height - n) / 2 + this.mSelector.mRect_top), this.mSelector);
        }
        StaticHost0.ca_jamdat_flight_VerticalSelector_Initialize(this.mSelector, 15, this.mFocusedSelectionIndex, 1);
        StaticHost0.ca_jamdat_flight_MainMenu_UpdateBirdsPos_SB(this.mFocusedSelectionIndex, this);
        StaticHost0.ca_jamdat_flight_BaseScene_InsertProgressionBarViewport_SB(StaticHost0.ca_jamdat_flight_EntryPoint_GetViewport(StaticHost0.ca_jamdat_flight_GameLibrary_GetPreLoadedPackage(262152), 0), this);
        StaticHost0.ca_jamdat_flight_ProgressionBar_Initialize_SB(false, this.mProgressionBar);
    }
}

