/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.CalibrationSceneIntroOutroAnimator;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.GameplayEventSender;
import ca.jamdat.flight.GemEvent;
import ca.jamdat.flight.Highway;
import ca.jamdat.flight.InstrumentGemEvent;
import ca.jamdat.flight.LaneManager;
import ca.jamdat.flight.MediaPlayer;
import ca.jamdat.flight.MetaPackage;
import ca.jamdat.flight.OverdriveInterval;
import ca.jamdat.flight.OverdriveIntervalMonitor;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Playline;
import ca.jamdat.flight.PopupBuilder;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.Settings;
import ca.jamdat.flight.Shape;
import ca.jamdat.flight.Softkey;
import ca.jamdat.flight.SongData;
import ca.jamdat.flight.StaticHost0;
import ca.jamdat.flight.TempoEvent;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.TimerSequence;
import ca.jamdat.flight.Viewport;

public final class InstrumentsCalibrationScene
extends BaseScene {
    public int mPlayTotalTime;
    public SongData mSongData;
    private int mVisualCalibrationDeltaTotalMs;
    public int mCurrentStage = 0;
    private boolean mAudioCalibrationAccepted;
    private Viewport mCalibrationBackgroundViewport;
    public Text mCalibrationDescription;
    public int mAudioCalibrationDeltaMS;
    private GameplayEventSender mGameplayEventSender;
    public Viewport mCalibrationArrowRightViewport;
    public boolean mVisualCalibrationAccepted;
    public Text mCalibrationTitle;
    private boolean mIsExitingScene;
    private Viewport mCalibrationPlaylineViewport;
    public LaneManager mLaneManager;
    public int mVisualInstructionDurationMs;
    public boolean mWasTutorialShown;
    private int mOldAudioCalibrationMS;
    public Highway mHighway = new Highway();
    public int mAudioInstructionDurationMs;
    private boolean mVisualStageKeyUp;
    private OverdriveIntervalMonitor mOverdriveIntervalMonitor;
    private int mVisualCalibrationNoteCount;
    public Viewport mCalibrationArrowLeftViewport;
    public Playline mPlayline = new Playline();
    private CalibrationSceneIntroOutroAnimator mIntroOutroAnimator;
    public MetaPackage mCalibrationPackage;
    private MetaPackage mSoundsPackage;
    private boolean mVisualStageKeyDown;
    public int mAudioCalibrationVisualNoteCount;
    private int mOldVisualCalibrationMs;
    public int mAudioCalibrationAudioNoteCount;
    private Shape mBackgroundShape;

    public final void ReceiveFocus() {
        StaticHost0.rockband2_mFrameworkGlobals.application.mApplicationTimeSystem.Register(this.mView);
        if (this.mCurrentStage == 0) {
            StaticHost0.ca_jamdat_flight_InputMapper_MapSoftKeys_SB(false, ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mInputMapper);
            this.mIntroOutroAnimator.StartIntro();
        }
        if (this.mCurrentStage == 1 || this.mCurrentStage == 3) {
            StaticHost0.ca_jamdat_flight_InstrumentsCalibrationScene_OnStageOver_SB(this);
        }
        super.ReceiveFocus();
        StaticHost0.ca_jamdat_flight_Component_SetVisible_SB(true, this.mHighway.mHighwayViewport);
    }

    public final void StartClosingAnims() {
        if (this.mCurrentStage != 0) {
            this.mIntroOutroAnimator.StartOutro();
        }
        if (this.mCalibrationArrowLeftViewport != null) {
            StaticHost0.ca_jamdat_flight_Component_SetVisible_SB(false, this.mCalibrationArrowLeftViewport);
        }
        if (this.mCalibrationArrowRightViewport != null) {
            StaticHost0.ca_jamdat_flight_Component_SetVisible_SB(false, this.mCalibrationArrowRightViewport);
        }
    }

    public final boolean IsClosingAnimsEnded() {
        CalibrationSceneIntroOutroAnimator calibrationSceneIntroOutroAnimator = this.mIntroOutroAnimator;
        TimerSequence timerSequence = calibrationSceneIntroOutroAnimator.mOutroSequence;
        TimeSystem timeSystem = calibrationSceneIntroOutroAnimator.mMainTimeSystem;
        return !StaticHost0.ca_jamdat_flight_TimeSystem_IsRegistered_SB(timerSequence, timeSystem) || StaticHost0.ca_jamdat_flight_IntroOutroAnimator_IsOutroOver_SB(this.mIntroOutroAnimator);
    }

    public final void OnTime(int n, int n2) {
        super.OnTime(n, n2);
        if (this.mCurrentStage == 0) {
            this.mIntroOutroAnimator.OnTime(n, n2);
            if (StaticHost0.ca_jamdat_flight_IntroOutroAnimator_IsIntroOver_SB(this.mIntroOutroAnimator)) {
                this.mCurrentStage = 1;
                if (!this.mWasTutorialShown) {
                    PopupBuilder popupBuilder;
                    this.mVisualInstructionDurationMs = 0;
                    PopupBuilder popupBuilder2 = popupBuilder;
                    popupBuilder = new PopupBuilder();
                    popupBuilder2.mString = StaticHost0.ca_jamdat_flight_EntryPoint_GetFlString(this.mCalibrationPackage.mPackage, 10);
                    popupBuilder2.mSelectSKEnabled = true;
                    popupBuilder2.mSelectSKCmd = 167;
                    popupBuilder2.mType = 1;
                    StaticHost0.ca_jamdat_flight_PopupBuilder_Build_SB(popupBuilder2);
                    StaticHost0.ca_jamdat_flight_TutorialManager_SetTutorialShown$25dace4_SB(this.mId, ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mTutorialManager);
                } else {
                    this.mVisualInstructionDurationMs = 2500;
                }
            }
        } else {
            this.mPlayTotalTime += n2;
            this.mHighway.OnTime(this.mPlayTotalTime, n2);
        }
        if (this.mCurrentStage == 1 && !this.mWasTutorialShown) {
            this.mVisualInstructionDurationMs += n2;
        } else if (this.mCurrentStage == 2) {
            if (this.mVisualStageKeyDown) {
                this.mVisualStageKeyDown = false;
                StaticHost0.ca_jamdat_flight_LaneManager_HitLane_SB(this.mPlayTotalTime, 1, this.mSongData, this.mOverdriveIntervalMonitor, this.mLaneManager);
                StaticHost0.ca_jamdat_flight_PlaylineButton_Hit_SB(this.mPlayline.mButtons[1]);
            }
            StaticHost0.ca_jamdat_flight_LaneManager_Update_SB(this.mPlayTotalTime, n2, this.mSongData, this.mLaneManager);
            if (this.mVisualStageKeyUp) {
                this.mVisualStageKeyUp = false;
                StaticHost0.ca_jamdat_flight_Lane_ReleaseActiveNote_SB(this.mLaneManager.mLanes[1]);
                StaticHost0.ca_jamdat_flight_PlaylineButton_ReleaseButton_SB(this.mPlayline.mButtons[1]);
            }
        } else if (this.mCurrentStage == 3 && !this.mWasTutorialShown) {
            this.mAudioInstructionDurationMs += n2;
        } else if (this.mCurrentStage == 4) {
            StaticHost0.ca_jamdat_flight_LaneManager_Update_SB(this.mPlayTotalTime, n2, this.mSongData, this.mLaneManager);
            if (this.mAudioCalibrationAudioNoteCount < StaticHost0.ca_jamdat_flight_SongData_GetLaneGemsCount_SB(1, this.mSongData) && this.mPlayTotalTime - this.mAudioCalibrationDeltaMS > (n2 = ((GemEvent)this.mSongData.mGems.mVector.elementAt((int)this.mAudioCalibrationAudioNoteCount)).mStartTime) && !this.mIsExitingScene) {
                ++this.mAudioCalibrationAudioNoteCount;
                StaticHost0.ca_jamdat_flight_MediaPlayer_PlaySound$4870cd2e_SB(3, false, ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mMediaPlayer);
            }
            if (this.mAudioCalibrationVisualNoteCount < StaticHost0.ca_jamdat_flight_SongData_GetLaneGemsCount_SB(1, this.mSongData) && this.mPlayTotalTime > (n2 = ((GemEvent)this.mSongData.mGems.mVector.elementAt((int)this.mAudioCalibrationVisualNoteCount)).mStartTime) && !this.mIsExitingScene) {
                ++this.mAudioCalibrationVisualNoteCount;
                StaticHost0.ca_jamdat_flight_LaneManager_HitLane_SB(this.mPlayTotalTime, 1, this.mSongData, this.mOverdriveIntervalMonitor, this.mLaneManager);
            }
        }
        n2 = 0;
        n = !this.mWasTutorialShown ? 1 : 0;
        if ((this.mCurrentStage == 1 || this.mCurrentStage == 3) && n == 0) {
            n2 = this.mPlayTotalTime > 2500 ? 1 : 0;
        } else if (this.mCurrentStage == 2 || this.mCurrentStage == 4) {
            n2 = this.mPlayTotalTime > this.mSongData.mDuration ? 1 : 0;
        }
        if (n2 != 0) {
            StaticHost0.ca_jamdat_flight_InstrumentsCalibrationScene_OnStageOver_SB(this);
        }
    }

    public InstrumentsCalibrationScene(int n, int n2) {
        super(75, n2);
        this.mLaneManager = new LaneManager();
        this.mOverdriveIntervalMonitor = new OverdriveIntervalMonitor();
        this.mIntroOutroAnimator = new CalibrationSceneIntroOutroAnimator();
        this.mGameplayEventSender = new GameplayEventSender();
        this.mSongData = new SongData();
        this.mType |= 4;
    }

    public final boolean OnKeyDown(int n) {
        boolean bl = false;
        if (this.mCurrentStage == 2 && StaticHost0.ca_jamdat_flight_RBUtils_GetLaneIndexFromKey(n) != -1) {
            bl = true;
            this.mVisualStageKeyDown = true;
        }
        return bl || super.OnKeyDown(n);
    }

    public final boolean OnKeyUp(int n) {
        boolean bl = false;
        Settings settings = ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mSettings;
        if (this.mCurrentStage == 2 && StaticHost0.ca_jamdat_flight_RBUtils_GetLaneIndexFromKey(n) != -1) {
            bl = true;
            this.mVisualStageKeyUp = true;
        } else if (this.mCurrentStage == 1 || this.mCurrentStage == 3) {
            if (((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mPopupManager.mCurrentPopup != null) {
                if (n == 13) {
                    StaticHost0.ca_jamdat_flight_PopupManager_HidePopup_SB(((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mPopupManager);
                }
            } else if (n == 6 || n == 13) {
                bl = true;
            }
        } else if (this.mCurrentStage == 2) {
            if (n == 6 && settings.mInitialCalibrationDone) {
                bl = true;
                this.mPlayTotalTime = this.mSongData.mDuration;
                StaticHost0.ca_jamdat_flight_InstrumentsCalibrationScene_OnStageOver_SB(this);
                this.mVisualCalibrationAccepted = false;
            }
        } else if (this.mCurrentStage == 4) {
            if (n == 25 || n == 2) {
                this.mAudioCalibrationDeltaMS += 50;
                if (this.mAudioCalibrationDeltaMS > 0) {
                    this.mAudioCalibrationDeltaMS = 0;
                }
                bl = true;
                StaticHost0.ca_jamdat_flight_InstrumentsCalibrationScene_SetCalibrationText_SB(5, 6, this);
            } else if (n == 19 || n == 1) {
                this.mAudioCalibrationDeltaMS -= 50;
                if (this.mAudioCalibrationDeltaMS < -1000) {
                    this.mAudioCalibrationDeltaMS = -1000;
                }
                StaticHost0.ca_jamdat_flight_InstrumentsCalibrationScene_SetCalibrationText_SB(5, 6, this);
                bl = true;
            } else if (n == 5 || n == 13 || n == 6 && settings.mInitialCalibrationDone) {
                bl = n != 6;
                this.mAudioCalibrationAccepted = bl;
                this.mIsExitingScene = true;
                this.OnCommand(156);
                bl = true;
            }
        }
        return bl || super.OnKeyUp(n);
    }

    public final void GetEntryPoints() {
        super.GetEntryPoints();
        Package package_ = this.mPackage;
        Highway highway = this.mHighway;
        highway.mHighwayAnimTS = StaticHost0.ca_jamdat_flight_EntryPoint_GetTimeSystem(package_, 5);
        highway.mHighwayViewport = StaticHost0.ca_jamdat_flight_EntryPoint_GetViewport(package_, 4);
        StaticHost0.ca_jamdat_flight_Playline_GetEntryPoints_SB(package_, this.mPlayline);
        this.mIntroOutroAnimator.GetEntryPoints();
        Package package_2 = this.mCalibrationPackage.mPackage;
        this.mCalibrationTitle = StaticHost0.ca_jamdat_flight_EntryPoint_GetText(package_2, 17);
        this.mCalibrationDescription = StaticHost0.ca_jamdat_flight_EntryPoint_GetText(package_2, 18);
        this.mCalibrationBackgroundViewport = StaticHost0.ca_jamdat_flight_EntryPoint_GetViewport(package_2, 15);
        this.mCalibrationPlaylineViewport = StaticHost0.ca_jamdat_flight_EntryPoint_GetViewport(package_2, 16);
        this.mCalibrationArrowLeftViewport = StaticHost0.ca_jamdat_flight_EntryPoint_GetViewport(package_2, 21);
        this.mCalibrationArrowRightViewport = StaticHost0.ca_jamdat_flight_EntryPoint_GetViewport(package_2, 22);
        StaticHost0.ca_jamdat_flight_Component_SetVisible_SB(false, this.mCalibrationArrowLeftViewport);
        StaticHost0.ca_jamdat_flight_Component_SetVisible_SB(false, this.mCalibrationArrowRightViewport);
        this.mBackgroundShape = StaticHost0.ca_jamdat_flight_EntryPoint_GetShape(package_, 3);
    }

    public final void Unload() {
        if (this.mCalibrationBackgroundViewport != null) {
            StaticHost0.ca_jamdat_flight_Component_SetViewport_SB(null, this.mCalibrationBackgroundViewport);
        }
        if (this.mCalibrationTitle != null) {
            StaticHost0.ca_jamdat_flight_Component_SetViewport_SB(null, this.mCalibrationTitle);
        }
        if (this.mCalibrationDescription != null) {
            StaticHost0.ca_jamdat_flight_Component_SetViewport_SB(null, this.mCalibrationDescription);
        }
        if (this.mCalibrationPlaylineViewport != null) {
            Component component = StaticHost0.ca_jamdat_flight_Viewport_GetChild_SB(0, this.mCalibrationPlaylineViewport);
            StaticHost0.ca_jamdat_flight_Component_SetViewport_SB(StaticHost0.ca_jamdat_flight_EntryPoint_GetViewport(this.mPackage, 29), component);
            StaticHost0.ca_jamdat_flight_Component_SetViewport_SB(null, this.mCalibrationPlaylineViewport);
            StaticHost0.ca_jamdat_flight_Component_SetViewport_SB(null, StaticHost0.ca_jamdat_flight_EntryPoint_GetViewport(this.mPackage, 29));
        }
        StaticHost0.ca_jamdat_flight_Highway_Unload_SB(this.mHighway);
        StaticHost0.ca_jamdat_flight_Playline_Unload_SB(this.mPlayline);
        StaticHost0.ca_jamdat_flight_LaneManager_Reset_SB(this.mLaneManager);
        this.mLaneManager.mEventSender = null;
        StaticHost0.ca_jamdat_flight_SongData_Reset_SB(this.mSongData);
        StaticHost0.ca_jamdat_flight_OverdriveIntervalMonitor_Unload_SB(this.mOverdriveIntervalMonitor);
        StaticHost0.ca_jamdat_flight_IntroOutroAnimator_Unload_SB(this.mIntroOutroAnimator);
        if (this.mCalibrationArrowLeftViewport != null) {
            StaticHost0.ca_jamdat_flight_Component_SetViewport_SB(null, this.mCalibrationArrowLeftViewport);
            this.mCalibrationArrowLeftViewport = null;
        }
        if (this.mCalibrationArrowRightViewport != null) {
            StaticHost0.ca_jamdat_flight_Component_SetViewport_SB(null, this.mCalibrationArrowRightViewport);
            this.mCalibrationArrowRightViewport = null;
        }
        ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mSettings.mInitialCalibrationDone = true;
        int n = this.mOldVisualCalibrationMs;
        int n2 = this.mOldAudioCalibrationMS;
        if (this.mVisualCalibrationAccepted) {
            n = 0;
            if (this.mVisualCalibrationNoteCount != 0) {
                n = this.mVisualCalibrationDeltaTotalMs / this.mVisualCalibrationNoteCount;
            }
        }
        if (this.mAudioCalibrationAccepted) {
            n2 = this.mAudioCalibrationDeltaMS;
        }
        ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mSettings.mVisualLagDeltaMs = n;
        ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mSettings.mAudioLagDeltaMs = n2;
        ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).SaveGame();
        super.Unload();
        MediaPlayer mediaPlayer = ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mMediaPlayer;
        StaticHost0.ca_jamdat_flight_MediaPlayer_ResetMidiPool_SB(mediaPlayer);
        StaticHost0.ca_jamdat_flight_MediaPlayer_StopSound_SB(mediaPlayer);
        StaticHost0.ca_jamdat_flight_MediaPlayer_StopSoundFx$1385ff_SB(mediaPlayer);
        StaticHost0.ca_jamdat_flight_MediaPlayer_SetMenuSoundsPackage_SB(null, mediaPlayer);
        if (this.mSoundsPackage != null) {
            StaticHost0.ca_jamdat_flight_GameLibrary_ReleasePackage(this.mSoundsPackage);
            this.mSoundsPackage = null;
        }
        if (this.mCalibrationPackage != null) {
            StaticHost0.ca_jamdat_flight_GameLibrary_ReleasePackage(this.mCalibrationPackage);
            this.mCalibrationPackage = null;
        }
        if (this.mView != null) {
            StaticHost0.rockband2_mFrameworkGlobals.application.mApplicationTimeSystem.UnRegister(this.mView);
        }
        ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mCheatActivationController.mCheatingEnabled = true;
    }

    public final boolean IsLoaded() {
        MetaPackage metaPackage;
        return super.IsLoaded() && (metaPackage = this.mSoundsPackage) != null && StaticHost0.ca_jamdat_flight_MetaPackage_IsLoaded_SB(metaPackage) && (metaPackage = this.mCalibrationPackage) != null && StaticHost0.ca_jamdat_flight_MetaPackage_IsLoaded_SB(metaPackage);
    }

    public final boolean OnMsg(Component component, int n, int n2) {
        switch (n) {
            case 1: {
                int n3 = StaticHost0.ca_jamdat_flight_SongData_GetInstrumentGemEvent_SB((int)(n2 & 3), (int)(n2 >> 2 & 0x3FFF), (SongData)this.mSongData).mStartTime;
                this.mVisualCalibrationDeltaTotalMs = this.mPlayTotalTime - n3 + this.mVisualCalibrationDeltaTotalMs;
                ++this.mVisualCalibrationNoteCount;
                StaticHost0.ca_jamdat_flight_PlaylineButton_Explode$1385ff_SB(this.mPlayline.mButtons[1]);
                if (this.mCurrentStage != 4) break;
                StaticHost0.ca_jamdat_flight_Lane_ReleaseActiveNote_SB(this.mLaneManager.mLanes[1]);
                StaticHost0.ca_jamdat_flight_PlaylineButton_ReleaseButton_SB(this.mPlayline.mButtons[1]);
                break;
            }
            case 10: {
                StaticHost0.ca_jamdat_flight_LaneManager_UpdateTempo_SB(n2, this.mLaneManager);
            }
        }
        return super.OnMsg(component, n, n2);
    }

    public final void Load() {
        super.Load();
        ((InstrumentsCalibrationScene)((Object)mediaPlayer)).mSoundsPackage = StaticHost0.ca_jamdat_flight_GameLibrary_GetPackage(98307);
        StaticHost0.ca_jamdat_flight_MediaPlayer_SetMenuSoundsPackage_SB(((InstrumentsCalibrationScene)((Object)mediaPlayer)).mSoundsPackage, ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mMediaPlayer);
        ((InstrumentsCalibrationScene)((Object)mediaPlayer)).mCalibrationPackage = StaticHost0.ca_jamdat_flight_GameLibrary_GetPackage(1409067);
        MediaPlayer mediaPlayer = ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mMediaPlayer;
        StaticHost0.ca_jamdat_flight_MediaPlayer_Prefetch_SB(StaticHost0.ca_jamdat_flight_SoundResourcesHandler_GetSound_SB(3, mediaPlayer.mSoundResourcesHandler), mediaPlayer);
    }

    public final void Initialize() {
        TempoEvent tempoEvent;
        super.Initialize();
        this.mSongData.mDifficulty = 0;
        this.mSongData.mChannel = 1;
        Object object = tempoEvent;
        tempoEvent = new TempoEvent(500000, 0);
        this.mSongData.mTempos.mVector.addElement(object);
        this.mSongData.mTimeDiv = 480;
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            InstrumentGemEvent instrumentGemEvent;
            object = instrumentGemEvent;
            instrumentGemEvent = new InstrumentGemEvent(1, n += 1500, n);
            this.mSongData.mGems.mVector.addElement(object);
        }
        this.mSongData.mDuration = n + 1500;
        StaticHost0.ca_jamdat_flight_SongData_PostBuildProcess_SB(this.mSongData);
        StaticHost0.ca_jamdat_flight_Softkey_SetIndexedSpriteFrameIndex_SB(2, this.mClearSoftKey);
        StaticHost0.ca_jamdat_flight_Softkey_SetCommand_SB(-60, this.mClearSoftKey);
        StaticHost0.ca_jamdat_flight_Softkey_SetCommand_SB(0, this.mSelectSoftKey);
        this.mGameplayEventSender.mBaseScene = this;
        StaticHost0.ca_jamdat_flight_Highway_Initialize_SB(this.mGameplayEventSender, this.mHighway);
        StaticHost0.ca_jamdat_flight_Playline_Initialize_SB(this.mPlayline);
        StaticHost0.ca_jamdat_flight_LaneManager_Initialize_SB(this.mSongData, 4000, this.mLaneManager);
        this.mLaneManager.mEventSender = this.mGameplayEventSender;
        StaticHost0.ca_jamdat_flight_OverdriveIntervalMonitor_Initialize_SB(this.mSongData, this.mOverdriveIntervalMonitor);
        this.mOverdriveIntervalMonitor.mGameplayEventSender = this.mGameplayEventSender;
        StaticHost0.ca_jamdat_flight_IntroOutroAnimator_Initialize_SB(this.mIntroOutroAnimator);
        Object object2 = StaticHost0.ca_jamdat_flight_Viewport_GetChild_SB(0, StaticHost0.ca_jamdat_flight_EntryPoint_GetViewport(this.mPackage, 29));
        StaticHost0.ca_jamdat_flight_Component_SetViewport_SB(this.mCalibrationPlaylineViewport, (Component)object2);
        StaticHost0.ca_jamdat_flight_EntryPoint_GetViewport((Package)this.mPackage, (int)29).mClipChildren = true;
        object2 = this.mCalibrationPlaylineViewport;
        StaticHost0.ca_jamdat_flight_Component_SetViewport_SB(StaticHost0.ca_jamdat_flight_EntryPoint_GetViewport(this.mPackage, 29), (Component)object2);
        StaticHost0.ca_jamdat_flight_Component_SetViewport_SB(this.mViewport, this.mCalibrationBackgroundViewport);
        object2 = this.mCalibrationBackgroundViewport;
        StaticHost0.ca_jamdat_flight_Viewport_SendComponentToBack_SB((Component)object2, object2.m_pViewport);
        StaticHost0.ca_jamdat_flight_Component_Invalidate_SB((Component)object2);
        object2 = this.mBackgroundShape;
        StaticHost0.ca_jamdat_flight_Viewport_SendComponentToBack_SB((Component)object2, object2.m_pViewport);
        StaticHost0.ca_jamdat_flight_Component_Invalidate_SB((Component)object2);
        StaticHost0.ca_jamdat_flight_Component_SetViewport_SB(this.mViewport, this.mCalibrationArrowLeftViewport);
        StaticHost0.ca_jamdat_flight_Component_SetViewport_SB(this.mViewport, this.mCalibrationArrowRightViewport);
        StaticHost0.ca_jamdat_flight_Component_SetViewport_SB(this.mViewport, this.mCalibrationTitle);
        StaticHost0.ca_jamdat_flight_Component_SetViewport_SB(this.mViewport, this.mCalibrationDescription);
        FlFont[] flFontArray = new FlFont[3];
        object2 = flFontArray;
        object = StaticHost0.ca_jamdat_flight_EntryPoint_GetFlFont(StaticHost0.ca_jamdat_flight_GameLibrary_GetPreLoadedPackage(3506283), 0);
        flFontArray[0] = StaticHost0.ca_jamdat_flight_EntryPoint_GetFlFont(StaticHost0.ca_jamdat_flight_GameLibrary_GetPreLoadedPackage(3506283), 0);
        object2[1] = null;
        object2[2] = object;
        StaticHost0.ca_jamdat_flight_Text_SetMultipleFonts_SB(object2, (short)3, this.mCalibrationDescription);
        StaticHost0.ca_jamdat_flight_InstrumentsCalibrationScene_SetCalibrationText_SB(3, 4, this);
        object2 = (GameApp)StaticHost0.rockband2_mFrameworkGlobals.application;
        object = object2.mImpl.mSettings;
        this.mCurrentStage = 0;
        this.mPlayTotalTime = 0;
        this.mVisualCalibrationNoteCount = 0;
        this.mVisualCalibrationDeltaTotalMs = 0;
        this.mAudioCalibrationAudioNoteCount = 0;
        this.mAudioCalibrationVisualNoteCount = 0;
        this.mAudioCalibrationDeltaMS = ((Settings)object).mAudioLagDeltaMs;
        StaticHost0.ca_jamdat_flight_LaneManager_Reset_SB(this.mLaneManager);
        ((Settings)object).mAudioLagDeltaMs = 0;
        Object object3 = this.mHighway;
        this.mHighway.mCurrentState = 0;
        StaticHost0.ca_jamdat_flight_Highway_ResetTS_SB((Highway)object3);
        StaticHost0.ca_jamdat_flight_TimeSystem_SetTimeFlowSpeed_SB(-65536, ((Highway)object3).mHighwayAnimTS);
        object3 = this.mOverdriveIntervalMonitor;
        this.mOverdriveIntervalMonitor.mOverdriveIntervalQueueIterator.mCurrentIndex = -1;
        while (StaticHost0.ca_jamdat_flight_RBQueueIterator_OverdriveInterval_HasNext_SB(((OverdriveIntervalMonitor)object3).mOverdriveIntervalQueueIterator)) {
            OverdriveInterval overdriveInterval = StaticHost0.ca_jamdat_flight_RBQueueIterator_OverdriveInterval_GetNext_SB(((OverdriveIntervalMonitor)object3).mOverdriveIntervalQueueIterator);
            overdriveInterval.mProcessedNoteCount = 0;
            overdriveInterval.mMissedANote = false;
        }
        ((Settings)object).mAudioLagDeltaMs = this.mAudioCalibrationDeltaMS;
        MediaPlayer mediaPlayer = object2.mImpl.mMediaPlayer;
        StaticHost0.ca_jamdat_flight_MediaPlayer_ResetMidiPool_SB(mediaPlayer);
        StaticHost0.ca_jamdat_flight_MediaPlayer_StopSound_SB(mediaPlayer);
        this.mVisualCalibrationAccepted = false;
        this.mAudioCalibrationAccepted = false;
        this.mVisualStageKeyDown = false;
        this.mVisualStageKeyUp = false;
        this.mOldVisualCalibrationMs = ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mSettings.mVisualLagDeltaMs;
        ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mSettings.mVisualLagDeltaMs = 0;
        this.mOldAudioCalibrationMS = ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mSettings.mAudioLagDeltaMs;
        this.mAudioCalibrationDeltaMS = ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mSettings.mAudioLagDeltaMs;
        object2 = ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mTutorialManager;
        int n2 = this.mId == 75 ? 1 : 2;
        boolean bl = n2 != 2 ? object2.mIntroTutorialStates[1] : false;
        this.mWasTutorialShown = bl;
        StaticHost0.ca_jamdat_flight_InstrumentsCalibrationScene_ToggleHighwayMovement_SB(false, this);
        ((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mCheatActivationController.mCheatingEnabled = false;
        StaticHost0.ca_jamdat_flight_Softkey_SetCommand_SB(0, this.mSelectSoftKey);
        Softkey softkey = this.mSelectSoftKey;
        object = softkey.mSoftkey;
        StaticHost0.ca_jamdat_flight_Selection_SetEnabledState_SB(false, (Selection)object);
        StaticHost0.ca_jamdat_flight_Component_SetVisible_SB(false, softkey.mSoftkey);
        if (!((GameApp)StaticHost0.rockband2_mFrameworkGlobals.application).mImpl.mSettings.mInitialCalibrationDone) {
            Softkey softkey2 = this.mClearSoftKey;
            object = softkey2.mSoftkey;
            StaticHost0.ca_jamdat_flight_Selection_SetEnabledState_SB(false, (Selection)object);
            StaticHost0.ca_jamdat_flight_Component_SetVisible_SB(false, softkey2.mSoftkey);
            StaticHost0.ca_jamdat_flight_Softkey_SetCommand_SB(0, this.mClearSoftKey);
        }
    }
}

