/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Package;
import ca.jamdat.flight.StaticHost0;
import ca.jamdat.flight.TimeControlled;
import java.util.Vector;

public class TimeSystem
extends TimeControlled {
    public Vector mTimeControlleds = new Vector(0, 32);
    public boolean mPaused;
    private boolean mDirty;
    public int mTotalTime;
    public int mTimeFlowSpeed = 65536;
    private int mDeltaError = 0;

    public void OnSerialize(Package package_) {
        this.mTotalTime = StaticHost0.ca_jamdat_flight_LibraryStream_ReadLong_SB(package_.mStream);
        boolean bl = StaticHost0.ca_jamdat_flight_LibraryStream_ReadByte_SB(package_.mStream) != 0;
        this.mPaused = bl;
        this.mTimeFlowSpeed = StaticHost0.ca_jamdat_flight_LibraryStream_ReadLong_SB(package_.mStream);
        Vector vector = this.mTimeControlleds;
        int n = StaticHost0.ca_jamdat_flight_LibraryStream_ReadLong_SB(package_.mStream);
        vector.removeAllElements();
        vector.ensureCapacity(n);
        for (int i = 0; i < n; ++i) {
            vector.addElement((TimeControlled)StaticHost0.ca_jamdat_flight_Package_ReadObjectPointer_SB((byte)0, true, false, package_));
        }
        this.mDirty = false;
    }

    public final void OnTime(int n, int n2) {
        if (!StaticHost0.ca_jamdat_flight_TimeSystem_IsPaused_SB(this)) {
            n = this.mTimeFlowSpeed == 65536 ? 1 : 0;
            if (n == 0) {
                int n3 = (int)((long)(n2 << 16) * (long)this.mTimeFlowSpeed >> 16) + this.mDeltaError;
                n2 = n3 >> 16;
                this.mDeltaError = n3 - (n2 << 16);
            }
            this.mTotalTime += n2;
            this.SendOnTime(this.mTotalTime, n2);
        }
        this.CleanUpTimeTable();
    }

    public void Register(TimeControlled timeControlled) {
        if (!StaticHost0.ca_jamdat_flight_TimeSystem_IsRegistered_SB(timeControlled, this)) {
            this.mTimeControlleds.addElement(timeControlled);
        }
    }

    public void UnRegister(TimeControlled timeControlled) {
        int n = this.mTimeControlleds.indexOf(timeControlled);
        if (n >= 0) {
            this.mTimeControlleds.setElementAt(null, n);
            this.mDirty = true;
        }
    }

    public void SetTotalTimeRecursively(int n) {
        this.mTotalTime = n;
        for (int i = 0; i < this.mTimeControlleds.size(); ++i) {
            TimeControlled timeControlled = (TimeControlled)this.mTimeControlleds.elementAt(i);
            if (timeControlled == null || !(timeControlled instanceof TimeSystem)) continue;
            ((TimeSystem)timeControlled).SetTotalTimeRecursively(n);
        }
    }

    public void CleanUpTimeTable() {
        if (this.mDirty) {
            int n;
            Vector vector = this.mTimeControlleds;
            while ((n = vector.indexOf(null)) != -1) {
                vector.setElementAt((TimeControlled)vector.elementAt(vector.size() - 1), n);
                vector.removeElementAt(vector.size() - 1);
            }
            this.mDirty = false;
        }
    }

    public void SendOnTime(int n, int n2) {
        int n3 = this.mTimeControlleds.size();
        for (int i = 0; i < this.mTimeControlleds.size(); ++i) {
            TimeControlled timeControlled = (TimeControlled)this.mTimeControlleds.elementAt(i);
            if (timeControlled == null) continue;
            if (i >= n3) {
                n2 = 0;
            }
            timeControlled.OnTime(n, n2);
        }
    }
}

