/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public final class MainCanvas
extends Canvas {
    public static final int MX = 176;
    public static final int MY = 220;
    public SubCanvas currentCanvas;
    public GameCanvas gameCanvas;
    public MenuCanvas menuCanvas;
    public MainThread mainThread = null;
    public static SudokuMidlet midlet;
    private boolean isCanvasToChange = false;
    private SubCanvas newCanvas = null;
    private static Image imgLogo;
    private static boolean isLogo;
    private static int loadingStage;
    private static final int NUM_LD_STAGES = 6;
    public boolean isActive = true;
    boolean canvasIsShown;
    boolean wasFirstShown = false;
    int actionCodePressed = 0;
    int actionCodeReleased = 0;
    int keyCodePressed = 0;
    int keyCodeReleased = 0;
    boolean is_keyPressed = false;
    boolean is_keyReleased = false;
    int nativeKey = 0;
    public static final int actFIRE = 299;
    public static final int actUP = 300;
    public static final int actDOWN = 301;
    public static final int actLEFT = 302;
    public static final int actRIGHT = 303;
    public static final int actSOFT1 = 304;
    public static final int actSOFT2 = 305;
    public static final int actCancel = 306;
    public static final int KEY_SOFTKEY1 = -6;
    public static final int KEY_SOFTKEY2 = -7;
    static final String REC_NAME = "bp_sud1.02";

    public MainCanvas(SudokuMidlet sudokuMidlet) {
        midlet = sudokuMidlet;
        isLogo = true;
        loadingStage = 0;
        try {
            imgLogo = Image.createImage((String)"/l");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mainThread = new MainThread();
        this.mainThread.start();
    }

    public void initAll(int n) {
        if (n == 0) {
            BPFontReader.init(midlet, "PL", true);
        } else if (n == 1) {
            this.gameCanvas = new GameCanvas(this);
        } else if (n == 2) {
            this.menuCanvas = new MenuCanvas(this);
        } else if (n == 3) {
            this.menuCanvas.initGraph();
        } else if (n == 4) {
            this.gameCanvas.initGraph();
        } else if (n == 5) {
            this.load();
        } else if (n == 6) {
            this.menuCanvas.init();
            this.currentCanvas = this.menuCanvas;
        }
    }

    void setActive(boolean bl) {
        this.isActive = bl;
    }

    public void theEnd() {
        this.isActive = false;
    }

    protected void setCanvasOff() {
        if (this.canvasIsShown && this.wasFirstShown) {
            SudokuMidlet.playSound(100);
            this.canvasIsShown = false;
            if (this.gameCanvas != null) {
                GameCanvas.isLeft = false;
                GameCanvas.isUp = false;
                GameCanvas.isDown = false;
                GameCanvas.isRight = false;
            }
        }
    }

    protected void hideNotify() {
        this.setCanvasOff();
    }

    public void keyPressed(int n) {
        if (!this.is_keyPressed) {
            this.is_keyPressed = true;
            this.keyCodePressed = this.getKey(n);
            this.actionCodePressed = this.getAction(n);
        }
    }

    public void keyReleased(int n) {
        if (!this.is_keyReleased) {
            this.is_keyReleased = true;
            this.keyCodeReleased = this.getKey(n);
            this.actionCodeReleased = this.getAction(n);
        }
    }

    public void changeCanvas(SubCanvas subCanvas) {
        this.newCanvas = subCanvas;
        this.isCanvasToChange = true;
    }

    public void paint(Graphics graphics) {
        if (isLogo) {
            int n = 88;
            int n2 = 198;
            graphics.setClip(0, 0, 176, 220);
            graphics.setColor(0);
            graphics.fillRect(0, 0, 176, 220);
            graphics.drawImage(imgLogo, 88, 110, 3);
            this.drawProgressBar(graphics, loadingStage, 6, n, n2);
            return;
        }
        this.currentCanvas.paint(graphics);
    }

    public void drawProgressBar(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(0x99FF99);
        graphics.fillRect(n3 - 47, n4 - 1, 92, 7);
        graphics.setColor(0);
        graphics.fillRect(n3 - 46, n4, 90, 5);
        graphics.setColor(43616);
        graphics.fillRect(n3 - 46, n4, 90 * n / n2, 5);
    }

    public void init() {
    }

    public void dispose() {
    }

    public int getAction(int n) {
        int n2 = this.getGameAction(n);
        if (n == -6) {
            return 304;
        }
        if (n == -7) {
            return 305;
        }
        if (n2 == 8) {
            return 299;
        }
        if (n2 == 1) {
            return 300;
        }
        if (n2 == 6) {
            return 301;
        }
        if (n2 == 2) {
            return 302;
        }
        if (n2 == 5) {
            return 303;
        }
        if (n == -8) {
            return 306;
        }
        return n;
    }

    public int getKey(int n) {
        int n2 = this.getAction(n);
        if (n == 52 || n == 54 || n == 50 || n == 56 || n == 53) {
            return n;
        }
        return n2;
    }

    public int loadImages(String string, Image[] imageArray) {
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + string);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        try {
            try {
                n3 = 0;
                while (!bl) {
                    n3 = 1;
                    n = dataInputStream.readInt();
                    n3 = 2;
                    if (n > 0) {
                        byte[] byArray = new byte[n];
                        n3 = 3;
                        for (int i = 0; i < n; ++i) {
                            byArray[i] = dataInputStream.readByte();
                        }
                        n3 = 4;
                        imageArray[n2] = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
                        n3 = 5;
                    }
                    n3 = 6;
                    ++n2;
                }
            }
            catch (EOFException eOFException) {
                try {
                    dataInputStream.close();
                    dataInputStream = null;
                    inputStream = null;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            inputStream = null;
        }
        if (dataInputStream != null) {
            try {
                dataInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            dataInputStream = null;
        }
        return n2;
    }

    public void save() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        if (this.menuCanvas != null) {
            this.menuCanvas.saveMenu(dataOutputStream);
        }
        if (this.gameCanvas.continueGame.Active) {
            this.gameCanvas.saveGame(dataOutputStream);
        }
        MainCanvas.writeToRMS(byteArrayOutputStream.toByteArray(), REC_NAME);
    }

    public void load() {
        byte[] byArray = MainCanvas.readFromRMS(REC_NAME);
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            try {
                this.menuCanvas.loadMenu(dataInputStream);
                if (this.gameCanvas.continueGame.Active) {
                    this.gameCanvas.loadState(dataInputStream);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            byteArrayInputStream = null;
            dataInputStream = null;
        }
    }

    public static void writeToRMS(byte[] byArray, String string) {
        if (byArray == null || string == null) {
            throw new NullPointerException("byte = " + byArray + "name = " + string);
        }
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            if (recordStore.getNumRecords() != 0) {
                recordStore.deleteRecord(recordStore.getNextRecordID() - 1);
            }
            recordStore.addRecord(byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] readFromRMS(String string) {
        if (string == null) {
            throw new NullPointerException("name = " + string);
        }
        byte[] byArray = null;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            if (recordStore.getNumRecords() != 0) {
                byArray = recordStore.getRecord(recordStore.getNextRecordID() - 1);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            byArray = null;
        }
        return byArray;
    }

    public static int pack(int n, int n2) {
        return n << 4 | n2;
    }

    public static int unpackOld(int n) {
        return (n & 0xF0) >> 4;
    }

    public static int unpackYoung(int n) {
        return n & 0xF;
    }

    public class MainThread
    extends Thread {
        private long lastTime;
        private long timeNow;
        private long timeUsed;
        private long sleepTime = 90L;
        private long fullTime;

        public void run() {
            this.lastTime = System.currentTimeMillis() - 100L;
            MainCanvas.this.canvasIsShown = true;
            while (MainCanvas.this.isActive) {
                if (MainCanvas.this.isShown()) {
                    this.fullTime = System.currentTimeMillis() - this.timeNow;
                    this.timeNow = System.currentTimeMillis();
                    this.timeUsed = this.timeNow - this.lastTime;
                    try {
                        Thread.sleep(this.sleepTime - this.timeUsed > 1L ? this.sleepTime - this.timeUsed : 1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.lastTime = System.currentTimeMillis();
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    MainCanvas.this.wasFirstShown = true;
                    if (isLogo) {
                        MainCanvas.this.initAll(loadingStage);
                        if (++loadingStage > 6) {
                            isLogo = false;
                            imgLogo = null;
                        }
                        MainCanvas.this.is_keyPressed = false;
                        MainCanvas.this.is_keyReleased = false;
                    } else {
                        if (MainCanvas.this.is_keyPressed) {
                            if (!MainCanvas.this.canvasIsShown) {
                                MainCanvas.this.canvasIsShown = true;
                                if (MainCanvas.this.currentCanvas instanceof MenuCanvas) {
                                    SudokuMidlet.playSound(0);
                                }
                            }
                            MainCanvas.this.currentCanvas.actionKeyPressed(MainCanvas.this.actionCodePressed, MainCanvas.this.keyCodePressed);
                            MainCanvas.this.is_keyPressed = false;
                        }
                        MainCanvas.this.currentCanvas.run();
                        if (MainCanvas.this.is_keyReleased) {
                            MainCanvas.this.currentCanvas.actionKeyReleased(MainCanvas.this.actionCodeReleased, MainCanvas.this.keyCodeReleased);
                            MainCanvas.this.is_keyReleased = false;
                        }
                        if (MainCanvas.this.isCanvasToChange) {
                            MainCanvas.this.is_keyPressed = false;
                            MainCanvas.this.is_keyReleased = false;
                            MainCanvas.this.currentCanvas.dispose();
                            MainCanvas.this.currentCanvas = MainCanvas.this.newCanvas;
                            MainCanvas.this.currentCanvas.init();
                            MainCanvas.this.isCanvasToChange = false;
                            MainCanvas.this.is_keyPressed = false;
                            MainCanvas.this.is_keyReleased = false;
                        }
                    }
                    MainCanvas.this.repaint();
                    MainCanvas.this.serviceRepaints();
                    continue;
                }
                MainCanvas.this.setCanvasOff();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            MainCanvas.this.menuCanvas.disposeGraph();
            MainCanvas.this.gameCanvas.disposeGraph();
            SudokuMidlet.playSound(100);
            midlet.destroyApp(true);
            midlet.notifyDestroyed();
            MainCanvas.this.menuCanvas = null;
            MainCanvas.this.gameCanvas = null;
        }
    }
}

