/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class MenuCanvas
extends SubCanvas {
    public static final int SIGN_X = 2;
    public static final int MAX_PENCIL_MARK_COUNT = 6;
    public static final int SIGN_Y = 1;
    public static int MENU_Y;
    public static final int MENU_X = 52;
    public static final int SUDOKU_HEIGHT = 85;
    public static final int LINES_IN_TEXT = 10;
    public static final int LINES_SPACE = 1;
    public static final boolean ALLWAYS_GRAPH = true;
    public static final int LOGO_TIME = 25;
    public static final int SMALL_REC_HEIGHT = 10;
    public static final int SLIDE_SPACE = 3;
    public static int FONT_HEIGHT;
    public static int SMALLFONT_HEIGHT;
    public static int SOFT_KEYS_FONT_HEIGHT;
    public MainCanvas parent;
    public static Menu activeMenu;
    public static Menu lastMenu;
    public static int diagramNumber;
    public boolean isTotal = false;
    public boolean isBestTime = false;
    public static int totalPoints;
    public static int[][] bestTimes;
    public static final int MENU_IMG_CNT = 2;
    public static int COM_IMG_CNT;
    public static Image[] imgCommon;
    public static Image[] imgMenu;
    public static Image imgArrowUp;
    public static Image imgArrowDown;
    public static Image imgPen;
    public static Image imgBack;
    public static Image imgStress;
    public int logoCounter = 25;
    public static Image imgNote;
    public static int stressFrame;
    public static int[][][] solverGrids;
    public boolean[] isSolverGrid;
    public static Random rand;
    public static Menu mainMenu;
    public static Menu newGameMenu;
    public static Menu solverMenu;
    public static Menu highScoresMenu;
    public static Menu settingsMenu;
    public static Menu helpMenu;
    public static Menu exitMenu;
    public static Menu resetScoresMenu;
    public static Menu netModeMenu;
    public static Menu diagramMenu;
    public static TextMenu rulesTxt;
    public static TextMenu controlsTxt;
    public static TextMenu pointsTxt;
    public static TextMenu aboutTxt;
    public static TextMenu cancelTxt;
    public static MenuItem continueGame;
    public static MenuItem newGame;
    public static MenuItem solver;
    public static MenuItem highScores;
    public static MenuItem settings;
    public static MenuItem help;
    public static MenuItem about;
    public static MenuItem exit;
    public static MenuItem exitTxt;
    public static MenuItem easy;
    public static MenuItem medium;
    public static MenuItem hard;
    public static MenuItem netMode;
    public static MenuItem diagram1;
    public static MenuItem diagram2;
    public static MenuItem diagram3;
    public static MenuItem edit;
    public static MenuItem playsolver;
    public static MenuItem playNetMode;
    public static MenuItem getNew;
    public static MenuItem total;
    public static MenuItem HSEasy;
    public static MenuItem HSMedium;
    public static MenuItem HSHard;
    public static MenuItem hSDailySudoku;
    public static SlideItem sound;
    public static SlideItem tutorial;
    public static SlideItem markRow;
    public static SlideItem markColumn;
    public static MenuItem resetScores;
    public static MenuItem resetScoresTxt1;
    public static MenuItem resetScoresTxt2;
    public static MenuItem rules;
    public static MenuItem controls;
    public static MenuItem points;
    public static final int IDContinueOn = 0;
    public static final int IDNewGame = 2;
    public static final int IDsolver = 3;
    public static final int IDHighScores = 4;
    public static final int IDSettings = 5;
    public static final int IDHelp = 6;
    public static final int IDAbout = 7;
    public static final int IDExit = 8;
    public static final int IDEasy = 9;
    public static final int IDMedium = 10;
    public static final int IDHard = 11;
    public static final int IDNetMode = 12;
    public static final int IDPlay = 13;
    public static final int IDGetNew = 15;
    public static final int IDDiagram1 = 16;
    public static final int IDDiagram2 = 17;
    public static final int IDDiagram3 = 18;
    public static final int IDEdit = 19;
    public static final int IDSend = 20;
    public static final int IDTotal = 22;
    public static final int IDBestTime = 23;
    public static final int IDSendScores = 24;
    public static final int IDGetScores = 25;
    public static final int IDSound = 26;
    public static final int IDResetScores = 27;
    public static final int IDSoundLevels = 28;
    public static final int IDRules = 34;
    public static final int IDControls = 35;
    public static final int IDPoints = 36;
    public static final int IDRulesTxt = 37;
    public static final int IDControlTxt = 38;
    public static final int IDPointsTxt = 39;
    public static final int IDAboutTxt = 40;
    public static final int IDExitTxt = 41;
    public static final int IDResetScoresTxt1 = 42;
    public static final int IDResetScoresTxt2 = 43;
    public static final int IDBack = 44;
    public static final int IDYes = 45;
    public static final int IDNo = 46;
    public static final int IDSelect = 47;
    public static final int IDMarkRow = 58;
    public static final int IDMarkColumn = 59;
    public static final int IDOn = 60;
    public static final int IDTutorial = 62;
    public static final int IDCancelTxt = 89;

    public MenuCanvas(MainCanvas mainCanvas) {
        COM_IMG_CNT = 4;
        bestTimes = new int[4][4];
        FONT_HEIGHT = BPFontReader.fontHeight[0];
        SOFT_KEYS_FONT_HEIGHT = BPFontReader.fontHeight[6];
        SMALLFONT_HEIGHT = BPFontReader.fontHeight[7];
        try {
            this.parent = mainCanvas;
            continueGame = new MenuItem(0, 1, FONT_HEIGHT);
            MenuCanvas.continueGame.Active = false;
            newGame = new MenuItem(2, 1, FONT_HEIGHT);
            solver = new MenuItem(3, 1, FONT_HEIGHT);
            highScores = new MenuItem(4, 1, FONT_HEIGHT);
            settings = new MenuItem(5, 1, FONT_HEIGHT);
            help = new MenuItem(6, 1, FONT_HEIGHT);
            about = new MenuItem(7, 1, FONT_HEIGHT);
            exit = new MenuItem(8, 1, FONT_HEIGHT);
            exitTxt = new MenuItem(41, 1, FONT_HEIGHT);
            easy = new MenuItem(9, 1, FONT_HEIGHT);
            medium = new MenuItem(10, 1, FONT_HEIGHT);
            hard = new MenuItem(11, 1, FONT_HEIGHT);
            netMode = new MenuItem(12, 1, FONT_HEIGHT);
            playNetMode = new MenuItem(13, 1, FONT_HEIGHT);
            getNew = new MenuItem(15, 1, FONT_HEIGHT);
            diagram1 = new MenuItem(16, 1, FONT_HEIGHT);
            diagram2 = new MenuItem(17, 1, FONT_HEIGHT);
            diagram3 = new MenuItem(18, 1, FONT_HEIGHT);
            edit = new MenuItem(19, 1, FONT_HEIGHT);
            playsolver = new MenuItem(13, 1, FONT_HEIGHT);
            total = new MenuItem(22, 1, FONT_HEIGHT);
            HSEasy = new MenuItem(9, 1, FONT_HEIGHT);
            HSMedium = new MenuItem(10, 1, FONT_HEIGHT);
            HSHard = new MenuItem(11, 1, FONT_HEIGHT);
            hSDailySudoku = new MenuItem(12, 1, FONT_HEIGHT);
            sound = new SlideItem(26, 28, 2, 1, FONT_HEIGHT);
            tutorial = new SlideItem(62, 60, 2, 1, FONT_HEIGHT);
            markRow = new SlideItem(58, 60, 2, 1, FONT_HEIGHT);
            markColumn = new SlideItem(59, 60, 2, 1, FONT_HEIGHT);
            resetScores = new MenuItem(27, 1, FONT_HEIGHT);
            resetScoresTxt1 = new MenuItem(42, 1, FONT_HEIGHT);
            resetScoresTxt2 = new MenuItem(43, 1, FONT_HEIGHT);
            rules = new MenuItem(34, 1, FONT_HEIGHT);
            controls = new MenuItem(35, 1, FONT_HEIGHT);
            points = new MenuItem(36, 1, FONT_HEIGHT);
            mainMenu = new Menu(176, 220, 1);
            mainMenu.addItem(continueGame);
            mainMenu.addItem(newGame);
            mainMenu.addItem(solver);
            mainMenu.addItem(highScores);
            mainMenu.addItem(settings);
            mainMenu.addItem(help);
            mainMenu.addItem(about);
            mainMenu.addItem(exit);
            activeMenu = mainMenu;
            MenuCanvas.activeMenu.selected = 1;
            newGameMenu = new Menu(176, 220, 1);
            newGameMenu.addItem(easy);
            newGameMenu.addItem(medium);
            newGameMenu.addItem(hard);
            if (SudokuMidlet.ONLINE) {
                newGameMenu.addItem(netMode);
            }
            MenuCanvas.newGameMenu.parent = mainMenu;
            solverMenu = new Menu(176, 220, 1);
            solverMenu.addItem(diagram1);
            solverMenu.addItem(diagram2);
            solverMenu.addItem(diagram3);
            MenuCanvas.solverMenu.parent = mainMenu;
            highScoresMenu = new Menu(176, 220, 1);
            highScoresMenu.addItem(total);
            highScoresMenu.addItem(HSEasy);
            highScoresMenu.addItem(HSMedium);
            highScoresMenu.addItem(HSHard);
            if (SudokuMidlet.ONLINE) {
                highScoresMenu.addItem(hSDailySudoku);
            }
            MenuCanvas.highScoresMenu.parent = mainMenu;
            settingsMenu = new Menu(176, 220, 1);
            settingsMenu.addItem(sound);
            settingsMenu.addItem(tutorial);
            settingsMenu.addItem(markRow);
            settingsMenu.addItem(markColumn);
            settingsMenu.addItem(resetScores);
            MenuCanvas.settingsMenu.parent = mainMenu;
            helpMenu = new Menu(176, 220, 1);
            helpMenu.addItem(rules);
            helpMenu.addItem(controls);
            helpMenu.addItem(points);
            MenuCanvas.helpMenu.parent = mainMenu;
            netModeMenu = new Menu(176, 220, 1);
            netModeMenu.addItem(playNetMode);
            netModeMenu.addItem(getNew);
            MenuCanvas.netModeMenu.parent = newGameMenu;
            diagramMenu = new Menu(176, 220, 1);
            diagramMenu.addItem(edit);
            diagramMenu.addItem(playsolver);
            MenuCanvas.diagramMenu.parent = solverMenu;
            exitMenu = new Menu(176, 220, 1);
            exitMenu.addItem(exitTxt);
            MenuCanvas.exitMenu.parent = mainMenu;
            exitMenu.noStress();
            resetScoresMenu = new Menu(176, 220, 1);
            resetScoresMenu.addItem(resetScoresTxt1);
            resetScoresMenu.addItem(resetScoresTxt2);
            MenuCanvas.resetScoresMenu.parent = settingsMenu;
            resetScoresMenu.noStress();
            rulesTxt = new TextMenu(176, 220, 37, 10, FONT_HEIGHT, 1, 10);
            MenuCanvas.rulesTxt.parent = helpMenu;
            controlsTxt = new TextMenu(176, 220, 38, 10, FONT_HEIGHT, 1, 10);
            MenuCanvas.controlsTxt.parent = helpMenu;
            pointsTxt = new TextMenu(176, 220, 39, 10, FONT_HEIGHT, 1, 10);
            MenuCanvas.pointsTxt.parent = helpMenu;
            aboutTxt = new TextMenu(176, 220, 40, 10, FONT_HEIGHT, 1, 10);
            MenuCanvas.aboutTxt.parent = mainMenu;
            cancelTxt = new TextMenu(176, 220, 89, 10, FONT_HEIGHT, 1, 10);
            MenuCanvas.cancelTxt.parent = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        solverGrids = new int[3][9][9];
        this.isSolverGrid = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            this.isSolverGrid[i] = false;
        }
        rand = new Random();
        rand.setSeed(System.currentTimeMillis());
    }

    public void actionKeyPressed(int n, int n2) {
        if (this.isTotal || this.isBestTime) {
            activeMenu.show();
            this.isTotal = false;
            this.isBestTime = false;
            return;
        }
        if (activeMenu == cancelTxt) {
            if (n == 304) {
                MenuCanvas.continueGame.Active = false;
                activeMenu = lastMenu;
            } else {
                if (n == 305) {
                    activeMenu = lastMenu;
                    activeMenu.show();
                    return;
                }
                return;
            }
        }
        if (activeMenu == exitMenu) {
            if (n == 304) {
                this.parent.theEnd();
                return;
            }
        } else if (activeMenu == resetScoresMenu) {
            if (n == 304) {
                this.resetScores();
                --MenuCanvas.mainMenu.selected;
                activeMenu = highScoresMenu;
                MenuCanvas.activeMenu.selected = 0;
                activeMenu.show();
                this.isTotal = true;
                return;
            }
        } else if (activeMenu instanceof TextMenu) {
            activeMenu.keyPressed(n);
            return;
        }
        if (n == 305) {
            if (activeMenu != mainMenu) {
                activeMenu = MenuCanvas.activeMenu.parent;
                activeMenu.show();
                return;
            }
            MenuCanvas.activeMenu.selected = MenuCanvas.activeMenu.items.size() - 1;
        }
        boolean bl = false;
        if (MenuCanvas.sound.value == 1) {
            bl = true;
        }
        if (n == 299 || n == 304) {
            MenuItem menuItem = activeMenu.getSelected();
            if (!menuItem.Active) {
                return;
            }
            if (menuItem == continueGame) {
                this.parent.changeCanvas(this.parent.gameCanvas);
            } else if (menuItem == newGame) {
                activeMenu = newGameMenu;
                MenuCanvas.activeMenu.selected = 0;
                activeMenu.show();
            } else if (menuItem == easy || menuItem == medium || menuItem == hard) {
                if (MenuCanvas.continueGame.Active) {
                    lastMenu = activeMenu;
                    activeMenu = cancelTxt;
                    MenuCanvas.activeMenu.selected = 0;
                    activeMenu.show();
                    MENU_Y = 85 + (220 - (87 + 2 * SOFT_KEYS_FONT_HEIGHT) >> 1) - (MenuCanvas.activeMenu.h >> 1);
                } else {
                    this.startGame(menuItem == easy ? 0 : (menuItem == medium ? 1 : 2));
                }
            } else if (menuItem == solver) {
                activeMenu = solverMenu;
                MenuCanvas.activeMenu.selected = 0;
                activeMenu.show();
            } else if (menuItem == diagram1) {
                GameCanvas cfr_ignored_0 = this.parent.gameCanvas;
                GameCanvas.GridNumber = 0;
                MenuCanvas.playsolver.Active = this.isSolverGrid[0];
                activeMenu = diagramMenu;
                MenuCanvas.activeMenu.selected = 0;
                activeMenu.show();
            } else if (menuItem == diagram2) {
                MenuCanvas.playsolver.Active = this.isSolverGrid[1];
                GameCanvas cfr_ignored_1 = this.parent.gameCanvas;
                GameCanvas.GridNumber = 1;
                activeMenu = diagramMenu;
                MenuCanvas.activeMenu.selected = 0;
                activeMenu.show();
            } else if (menuItem == diagram3) {
                MenuCanvas.playsolver.Active = this.isSolverGrid[2];
                GameCanvas cfr_ignored_2 = this.parent.gameCanvas;
                GameCanvas.GridNumber = 2;
                activeMenu = diagramMenu;
                MenuCanvas.activeMenu.selected = 0;
                activeMenu.show();
            } else if (menuItem == edit) {
                if (MenuCanvas.continueGame.Active) {
                    lastMenu = activeMenu;
                    activeMenu = cancelTxt;
                    MenuCanvas.activeMenu.selected = 0;
                    activeMenu.show();
                    MENU_Y = 85 + (220 - (87 + 2 * SOFT_KEYS_FONT_HEIGHT) >> 1) - (MenuCanvas.activeMenu.h >> 1);
                } else {
                    GameCanvas cfr_ignored_3 = this.parent.gameCanvas;
                    this.editGrid(GameCanvas.GridNumber);
                }
            } else if (menuItem == playsolver) {
                if (MenuCanvas.continueGame.Active) {
                    lastMenu = activeMenu;
                    activeMenu = cancelTxt;
                    MenuCanvas.activeMenu.selected = 0;
                    activeMenu.show();
                    MENU_Y = 85 + (220 - (87 + 2 * SOFT_KEYS_FONT_HEIGHT) >> 1) - (MenuCanvas.activeMenu.h >> 1);
                } else {
                    GameCanvas cfr_ignored_4 = this.parent.gameCanvas;
                    this.startGridGame(GameCanvas.GridNumber);
                }
            } else if (menuItem == highScores) {
                activeMenu = highScoresMenu;
                MenuCanvas.activeMenu.selected = 0;
                activeMenu.show();
            } else if (menuItem == settings) {
                activeMenu = settingsMenu;
                MenuCanvas.activeMenu.selected = 0;
                activeMenu.show();
            } else if (menuItem == help) {
                activeMenu = helpMenu;
                MenuCanvas.activeMenu.selected = 0;
                activeMenu.show();
            } else if (menuItem == rules) {
                activeMenu = rulesTxt;
                MenuCanvas.activeMenu.selected = 0;
                activeMenu.show();
            } else if (menuItem == controls) {
                activeMenu = controlsTxt;
                MenuCanvas.activeMenu.selected = 0;
                activeMenu.show();
            } else if (menuItem == points) {
                activeMenu = pointsTxt;
                MenuCanvas.activeMenu.selected = 0;
                activeMenu.show();
            } else if (menuItem == about) {
                activeMenu = aboutTxt;
                MenuCanvas.activeMenu.selected = 0;
                activeMenu.show();
            } else if (menuItem == exit) {
                activeMenu = exitMenu;
                MenuCanvas.activeMenu.selected = 0;
                activeMenu.show();
            } else if (menuItem == netMode) {
                activeMenu = netModeMenu;
                MenuCanvas.activeMenu.selected = 0;
                activeMenu.show();
            } else if (menuItem == resetScores) {
                activeMenu = resetScoresMenu;
                MenuCanvas.activeMenu.selected = 0;
                activeMenu.show();
            } else if (menuItem == total) {
                this.isTotal = true;
                MENU_Y = 85 + (220 - (87 + 2 * SOFT_KEYS_FONT_HEIGHT) >> 1) - FONT_HEIGHT;
            } else if (menuItem == HSEasy || menuItem == HSMedium || menuItem == HSHard) {
                this.isBestTime = true;
                MENU_Y = 85 + (220 - (87 + 2 * SOFT_KEYS_FONT_HEIGHT) >> 1) - (5 * FONT_HEIGHT + 4 >> 1);
            } else if (menuItem instanceof SlideItem) {
                ((SlideItem)menuItem).increment();
            }
        } else {
            activeMenu.keyPressed(n);
        }
        GameCanvas.sound.value = MenuCanvas.sound.value;
        if (MenuCanvas.sound.value == 1 || bl) {
            SudokuMidlet.playSound(0);
        }
    }

    public void savePuzzle(int[][] nArray, int n) {
        this.isSolverGrid[n] = true;
        MenuCanvas.solverGrids[n] = nArray;
    }

    public void editGrid(int n) {
        MenuCanvas.continueGame.Active = true;
        this.parent.gameCanvas.startCreating(solverGrids[n]);
        this.parent.changeCanvas(this.parent.gameCanvas);
    }

    public void startGame(int n) {
        MenuCanvas.continueGame.Active = true;
        this.parent.gameCanvas.startGame(n);
        this.parent.changeCanvas(this.parent.gameCanvas);
    }

    public void startGridGame(int n) {
        MenuCanvas.continueGame.Active = true;
        this.parent.gameCanvas.startCreating(solverGrids[n]);
        this.parent.gameCanvas.startPlayingInSolverMode();
        this.parent.changeCanvas(this.parent.gameCanvas);
    }

    public void actionKeyReleased(int n, int n2) {
        if (activeMenu instanceof TextMenu) {
            activeMenu.keyReleased(n);
        }
    }

    public void paint(Graphics graphics) {
        graphics.setClip(0, 0, 176, 220);
        if (activeMenu instanceof TextMenu && activeMenu != cancelTxt) {
            graphics.drawImage(imgNote, 0, 0, 0);
            BPFontReader.drawGraphicText(44, 0, 174 - BPFontReader.getGraphicTextWidth(44, 0), 220 - SOFT_KEYS_FONT_HEIGHT - 1, graphics);
            activeMenu.paint(graphics, 88, MENU_Y);
            return;
        }
        graphics.drawImage(imgBack, 0, 0, 0);
        if (this.isTotal) {
            int n = BPFontReader.getTextWidth(":", 0, 1);
            int n2 = BPFontReader.getGraphicTextWidth(22, 0) + n >> 1;
            BPFontReader.drawGraphicText(22, 0, 52 - n2, MENU_Y, graphics);
            BPFontReader.drawGraphicText(":", 52 + n2 - n, MENU_Y, 0, 1, graphics);
            n2 = BPFontReader.getTextWidth("" + totalPoints, 0, 2) >> 1;
            BPFontReader.drawGraphicText("" + totalPoints, 52 - n2, MENU_Y + FONT_HEIGHT + 1, 0, 2, graphics);
            BPFontReader.drawGraphicText(44, 0, 174 - BPFontReader.getGraphicTextWidth(44, 0), 220 - SOFT_KEYS_FONT_HEIGHT - 1, graphics);
            return;
        }
        if (this.isBestTime) {
            int n = 8 + MenuCanvas.activeMenu.selected;
            int n3 = BPFontReader.getTextWidth(":", 0, 1);
            int n4 = BPFontReader.getGraphicTextWidth(n, 0) + n3 >> 1;
            BPFontReader.drawGraphicText(n, 0, 52 - n4, MENU_Y, graphics);
            BPFontReader.drawGraphicText(":", 52 + n4 - n3, MENU_Y, 0, 1, graphics);
            graphics.translate(0, MENU_Y);
            for (int i = 0; i < bestTimes[n - 9].length; ++i) {
                graphics.translate(0, FONT_HEIGHT + 1);
                n4 = BPFontReader.getTextWidth(i + ". " + bestTimes[n - 9][i], 0, 2) >> 1;
                BPFontReader.drawGraphicText(i + ". " + bestTimes[n - 9][i], 52 - n4, 0, 0, 2, graphics);
            }
            graphics.translate(0, -graphics.getTranslateY());
            BPFontReader.drawGraphicText(44, 0, 174 - BPFontReader.getGraphicTextWidth(44, 0), 220 - SOFT_KEYS_FONT_HEIGHT - 1, graphics);
            return;
        }
        activeMenu.paint(graphics, 52, MENU_Y);
        graphics.setClip(0, 0, 176, 220);
        graphics.translate(-graphics.getTranslateX(), -graphics.getTranslateY());
        if (activeMenu == exitMenu || activeMenu == resetScoresMenu || activeMenu == cancelTxt) {
            BPFontReader.drawGraphicText(45, 0, 2, 220 - SOFT_KEYS_FONT_HEIGHT - 1, graphics);
            BPFontReader.drawGraphicText(46, 0, 174 - BPFontReader.getGraphicTextWidth(46, 0), 220 - SOFT_KEYS_FONT_HEIGHT - 1, graphics);
        } else if (activeMenu == mainMenu) {
            BPFontReader.drawGraphicText(47, 0, 2, 220 - SOFT_KEYS_FONT_HEIGHT - 1, graphics);
        } else {
            BPFontReader.drawGraphicText(47, 0, 2, 220 - SOFT_KEYS_FONT_HEIGHT - 1, graphics);
            BPFontReader.drawGraphicText(44, 0, 174 - BPFontReader.getGraphicTextWidth(44, 0), 220 - SOFT_KEYS_FONT_HEIGHT - 1, graphics);
        }
    }

    public void init() {
        Menu.animadedStress = true;
        activeMenu = mainMenu;
        MenuCanvas.activeMenu.selected = MenuCanvas.continueGame.Active ? 0 : 1;
        activeMenu.show();
        SudokuMidlet.playSound(0);
    }

    public void initGraph() {
        try {
            imgMenu = new Image[2];
            this.parent.loadImages("m", imgMenu);
            imgBack = imgMenu[0];
            imgStress = imgMenu[1];
            this.initCommonGraph();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initCommonGraph() {
        try {
            imgCommon = new Image[COM_IMG_CNT];
            this.parent.loadImages("c", imgCommon);
            imgArrowDown = imgCommon[0];
            imgArrowUp = imgCommon[1];
            imgPen = imgCommon[2];
            imgNote = imgCommon[3];
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void disposeCommonGraph() {
        if (imgCommon != null) {
            for (int i = 0; i < COM_IMG_CNT; ++i) {
                MenuCanvas.imgCommon[i] = null;
            }
        }
        imgCommon = null;
        imgArrowDown = null;
        imgArrowUp = null;
        imgPen = null;
        imgNote = null;
    }

    public void dispose() {
        SudokuMidlet.playSound(100);
    }

    public void disposeGraph() {
        if (imgMenu != null) {
            for (int i = 0; i < 2; ++i) {
                MenuCanvas.imgMenu[i] = null;
            }
        }
        this.disposeCommonGraph();
        imgMenu = null;
        imgBack = null;
        imgStress = null;
        System.gc();
    }

    public void run() {
        activeMenu.run();
    }

    public void resetScores() {
        totalPoints = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < bestTimes[i].length; ++j) {
                MenuCanvas.bestTimes[i][j] = 0;
                MenuCanvas.bestTimes[i][j] = 0;
            }
        }
    }

    public void saveMenu(DataOutputStream dataOutputStream) {
        try {
            int n;
            int n2;
            dataOutputStream.writeBoolean(MenuCanvas.continueGame.Active);
            int n3 = MainCanvas.pack(MenuCanvas.sound.value, MenuCanvas.tutorial.value);
            dataOutputStream.writeByte(n3);
            n3 = MainCanvas.pack(MenuCanvas.markColumn.value, MenuCanvas.markRow.value);
            dataOutputStream.writeByte(n3);
            dataOutputStream.writeInt(totalPoints);
            for (n2 = 0; n2 < 4; ++n2) {
                for (n = 0; n < bestTimes[n2].length; ++n) {
                    dataOutputStream.writeInt(bestTimes[n2][n]);
                }
            }
            for (n2 = 0; n2 < 3; ++n2) {
                for (n = 0; n < 40; ++n) {
                    int n4 = 2 * n % 9;
                    int n5 = 2 * n / 9;
                    int n6 = (2 * n + 1) % 9;
                    int n7 = (2 * n + 1) / 9;
                    n3 = MainCanvas.pack(solverGrids[n2][n4][n5], solverGrids[n2][n6][n7]);
                    dataOutputStream.writeByte(n3);
                }
                dataOutputStream.writeByte(solverGrids[n2][8][8]);
                dataOutputStream.writeBoolean(this.isSolverGrid[n2]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadMenu(DataInputStream dataInputStream) {
        try {
            int n;
            int n2;
            MenuCanvas.continueGame.Active = dataInputStream.readBoolean();
            byte by = dataInputStream.readByte();
            MenuCanvas.sound.value = MainCanvas.unpackOld(by);
            MenuCanvas.tutorial.value = MainCanvas.unpackYoung(by);
            by = dataInputStream.readByte();
            MenuCanvas.markColumn.value = MainCanvas.unpackOld(by);
            MenuCanvas.markRow.value = MainCanvas.unpackYoung(by);
            totalPoints = dataInputStream.readInt();
            for (n2 = 0; n2 < 4; ++n2) {
                for (n = 0; n < bestTimes[n2].length; ++n) {
                    MenuCanvas.bestTimes[n2][n] = dataInputStream.readInt();
                }
            }
            for (n2 = 0; n2 < 3; ++n2) {
                for (n = 0; n < 40; ++n) {
                    int n3 = 2 * n % 9;
                    int n4 = 2 * n / 9;
                    int n5 = (2 * n + 1) % 9;
                    int n6 = (2 * n + 1) / 9;
                    by = dataInputStream.readByte();
                    MenuCanvas.solverGrids[n2][n3][n4] = MainCanvas.unpackOld(by);
                    MenuCanvas.solverGrids[n2][n5][n6] = MainCanvas.unpackYoung(by);
                }
                MenuCanvas.solverGrids[n2][8][8] = dataInputStream.readByte();
                this.isSolverGrid[n2] = dataInputStream.readBoolean();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        diagramNumber = 0;
        totalPoints = 0;
        stressFrame = 0;
    }
}

