/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public final class BPFontReader {
    private static final boolean IS_DEBUG = false;
    private static final String RESOURCES_FILE_NAME = "r.b";
    public static String[][] textAsString;
    public static int[][][] textAsOffset;
    private static char[][] alphabetAsChar;
    private static int[][] alphabetAsOffset;
    public static Image[] alphabetAsImage;
    public static int[] fontHeight;
    private static int[] alphabetIndex;
    private static int[] letterSpacing;

    public static void init(MIDlet mIDlet, String string, boolean bl) {
        DataInputStream dataInputStream = null;
        try {
            int n;
            dataInputStream = new DataInputStream(mIDlet.getClass().getResourceAsStream(RESOURCES_FILE_NAME));
            int n2 = dataInputStream.readInt();
            alphabetAsImage = new Image[n2];
            for (n = 0; n < n2; ++n) {
                byte[] byArray = new byte[dataInputStream.readInt()];
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = dataInputStream.readByte();
                }
                Image image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
                if (!bl) continue;
                BPFontReader.alphabetAsImage[n] = image;
            }
            if (string == null) {
                return;
            }
            fontHeight = new int[n2];
            alphabetAsChar = new char[n2][];
            alphabetAsOffset = new int[n2][];
            for (n = 0; n < n2; ++n) {
                int n3;
                BPFontReader.fontHeight[n] = dataInputStream.readInt();
                int n4 = dataInputStream.readInt();
                BPFontReader.alphabetAsOffset[n] = new int[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    BPFontReader.alphabetAsOffset[n][n3] = dataInputStream.readInt();
                }
                n3 = dataInputStream.readInt();
                BPFontReader.alphabetAsChar[n] = new char[n3];
                for (int i = 0; i < n3; ++i) {
                    BPFontReader.alphabetAsChar[n][i] = (char)(dataInputStream.readChar() ^ i);
                }
            }
            n = dataInputStream.readInt();
            boolean bl2 = false;
            for (int i = 0; i < n; ++i) {
                String string2 = dataInputStream.readUTF();
                int n5 = dataInputStream.readInt();
                textAsString = new String[n5][];
                alphabetIndex = new int[n5];
                letterSpacing = new int[n5];
                textAsOffset = new int[n5][][];
                for (int j = 0; j < n5; ++j) {
                    int n6;
                    int n7;
                    int n8 = dataInputStream.readInt();
                    if (n8 == 0 || n8 == 1) {
                        n7 = dataInputStream.readInt();
                        BPFontReader.textAsString[j] = new String[n7];
                        for (n6 = 0; n6 < n7; ++n6) {
                            BPFontReader.textAsString[j][n6] = new String(BPFontReader.decodeText(dataInputStream.readUTF()));
                        }
                        continue;
                    }
                    BPFontReader.alphabetIndex[j] = n8 - 2;
                    BPFontReader.letterSpacing[j] = dataInputStream.readInt();
                    n7 = dataInputStream.readInt();
                    BPFontReader.textAsOffset[j] = new int[n7][];
                    for (n6 = 0; n6 < n7; ++n6) {
                        int n9 = dataInputStream.readInt();
                        BPFontReader.textAsOffset[j][n6] = new int[n9];
                        for (int k = 0; k < n9; ++k) {
                            BPFontReader.textAsOffset[j][n6][k] = dataInputStream.readInt();
                        }
                    }
                }
                if (!string2.equals(string)) continue;
                bl2 = true;
                break;
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    public static void freeMemory(boolean bl) {
        alphabetAsImage = null;
        if (bl) {
            textAsString = null;
            textAsOffset = null;
            alphabetAsChar = null;
            alphabetAsOffset = null;
            fontHeight = null;
            alphabetIndex = null;
        }
        System.gc();
    }

    private static char[] decodeText(String string) {
        char[] cArray = new char[string.length()];
        for (int n = 0; n < string.length(); n = (int)((char)(n + 1))) {
            cArray[n] = (char)(string.charAt(n) ^ n);
        }
        return cArray;
    }

    public static void drawSystemText(String string, int n, int n2, Font font, int n3, Graphics graphics) {
        graphics.setFont(font);
        graphics.setColor(n3);
        graphics.drawString(string, n, n2, 20);
    }

    public static void drawGraphicText(int n, int n2, int n3, int n4, Graphics graphics) {
        try {
            int[] nArray = textAsOffset[n][n2];
            int n5 = alphabetIndex[n];
            int n6 = alphabetAsImage[n5].getWidth();
            for (int i = 0; i < nArray.length; ++i) {
                int n7 = alphabetAsOffset[n5][nArray[i]];
                int n8 = alphabetAsOffset[n5][nArray[i] + 1] - n7;
                int n9 = n7 / n6;
                int n10 = n7 - n9 * n6;
                graphics.setClip(n3 - i, n4, n8, fontHeight[n5]);
                graphics.drawImage(alphabetAsImage[n5], n3 - i - n10, n4 - n9 * fontHeight[n5], 20);
                n3 += n8 + letterSpacing[n];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void drawGraphicText(String string, int n, int n2, int n3, int n4, Graphics graphics) {
        int n5 = alphabetAsImage[n3].getWidth();
        for (int i = 0; i < string.length(); ++i) {
            int n6;
            char c = string.charAt(i);
            for (n6 = 0; n6 < alphabetAsChar[n3].length && alphabetAsChar[n3][n6] != c; ++n6) {
            }
            int n7 = alphabetAsOffset[n3][n6];
            int n8 = alphabetAsOffset[n3][n6 + 1] - n7;
            int n9 = n7 / n5;
            int n10 = n7 - n9 * n5;
            graphics.setClip(n - i, n2, n8, fontHeight[n3]);
            graphics.drawImage(alphabetAsImage[n3], n - n10 - i, n2 - n9 * fontHeight[n3], 20);
            n += n8 + n4;
        }
    }

    public static int getTextWidth(String string, int n, int n2) {
        int n3 = n2 - 1;
        int n4 = 0;
        for (int i = 0; i < string.length(); ++i) {
            int n5;
            char c = string.charAt(i);
            for (n5 = 0; n5 < alphabetAsChar[n].length && alphabetAsChar[n][n5] != c; ++n5) {
            }
            n4 += alphabetAsOffset[n][n5 + 1] - alphabetAsOffset[n][n5] + n3;
        }
        return n4 - n3;
    }

    public static int getGraphicTextWidth(int n, int n2) {
        int n3 = 0;
        int n4 = alphabetIndex[n];
        int[] nArray = textAsOffset[n][n2];
        for (int i = 0; i < nArray.length; ++i) {
            n3 += alphabetAsOffset[n4][nArray[i] + 1] - alphabetAsOffset[n4][nArray[i]] + letterSpacing[n] - 1;
        }
        return n3 - letterSpacing[n] + 1;
    }
}

