/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import portinglib.Debug;
import userapp.GameMath;
import userapp.Physics;

class TrackRecorder {
    private static final float GUTTER_DEPTH = 0.02f;
    public static int x;
    public static int dx;
    public static int dy;
    private int result;
    public static int iterLimit;
    private boolean finished = false;
    private int totalTime;
    private static final float EPS = 0.01f;
    private int currentMove;
    private int currentIter;
    private int numMoves;
    private float[][] moves = new float[300][4];
    private float[] startCoord = new float[4];
    private float[] oldCoord = new float[4];
    public static final float[] ZERO;

    TrackRecorder() {
    }

    public void calcMovingTrack(float f, float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[4];
        fArray3[0] = fArray[0] - fArray2[0];
        fArray3[1] = fArray[1] - fArray2[1];
        fArray3[2] = fArray[2] - fArray2[2];
        this.startCoord[0] = fArray[0];
        this.startCoord[1] = fArray[1];
        this.startCoord[2] = fArray[2];
        this.oldCoord[0] = fArray2[0];
        this.oldCoord[1] = fArray2[1];
        this.oldCoord[2] = fArray2[2];
        float f2 = 13.700001f;
        this.numMoves = (int)(f2 / fArray3[1] + 0.99f);
        this.currentMove = 0;
        int n = 0;
        this.moves[0][0] = f;
        this.moves[0][1] = -17.2f;
        this.moves[0][2] = fArray[2];
        this.currentIter = 1;
        while (this.moves[n][1] < -3.5f) {
            this.moves[++n][1] = this.moves[n - 1][1] + fArray3[1];
            f2 = -3.5f - this.moves[n][1];
            float f3 = f2 * fArray3[0] / fArray3[1];
            float f4 = 1.0f - f2 / 13.700001f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.moves[n][0] = this.moves[0][0] * (1.0f - f4) + f4 * (fArray[0] - f3 / 2.0f);
            this.moves[n][0] = TrackRecorder.keepOnTrack(this.moves[n][0], true);
            this.moves[n][2] = fArray[2] - (TrackRecorder.isInGutter(this.moves[n][0], true) ? 0.02f : 0.0f);
            ++this.currentIter;
        }
    }

    public static float halfOfTrack(boolean bl) {
        float f = bl ? 0.22f : 0.32999998f;
        return 0.745f - f;
    }

    public static float keepOnTrack(float f, boolean bl) {
        float f2 = 0.0f;
        if (bl) {
            f2 = 0.745f;
        }
        if (f > f2 + TrackRecorder.halfOfTrack(bl)) {
            f = f2 + TrackRecorder.halfOfTrack(bl);
        }
        if (f < f2 - TrackRecorder.halfOfTrack(bl)) {
            f = f2 - TrackRecorder.halfOfTrack(bl);
        }
        return f;
    }

    public static boolean isInGutter(float f, boolean bl) {
        float f2 = 0.0f;
        float f3 = 0.22f;
        if (bl) {
            f2 = 0.745f;
        }
        return f > f2 + (0.745f - f3) || f < f2 - (0.745f - f3);
    }

    public void calcCollidingTrack(Physics physics, TrackRecorder[][] trackRecorderArray, float[] fArray, float[] fArray2) {
        if (TrackRecorder.isInGutter(fArray[0], true)) {
            fArray[2] = fArray[2] - 0.02f;
            fArray2[2] = fArray2[2] - 0.02f;
        }
        this.startCoord[0] = fArray[0];
        this.startCoord[1] = fArray[1];
        this.startCoord[2] = fArray[2];
        this.oldCoord[0] = fArray2[0];
        this.oldCoord[1] = fArray2[1];
        this.oldCoord[2] = fArray2[2];
        this.playBack();
        this.totalTime = 0;
        this.finished = false;
    }

    public void calcCollidingTrackIter(Physics physics, TrackRecorder[][] trackRecorderArray, boolean bl) {
        int n;
        if (this.currentIter >= 300 || this.currentIter >= iterLimit && iterLimit > 0 || this.finished) {
            return;
        }
        int n2 = (int)System.currentTimeMillis();
        if (bl || this.currentIter + 1 == 300 || this.currentIter + 1 == iterLimit && iterLimit > 0) {
            this.result = 0;
            this.finished = true;
        }
        int n3 = this.currentIter;
        if (this.currentIter == 0) {
            for (n = 0; n < 10; ++n) {
                trackRecorderArray[n][0].playBack();
                trackRecorderArray[n][1].playBack();
            }
            physics.setBallTranslation(this.startCoord, false);
            physics.setBallTranslation(this.oldCoord, true);
        }
        if (physics.ball.remains) {
            if (this.moves[n3].equals(ZERO)) {
                this.moves[n3] = new float[4];
            }
            this.moves[n3][0] = GameMath.get_float(physics.ball.x[0].y);
            this.moves[n3][1] = GameMath.get_float(-physics.ball.x[0].x);
            this.moves[n3][2] = GameMath.get_float(physics.ball.x[0].z);
        } else if (!this.moves[n3].equals(ZERO)) {
            this.moves[n3] = null;
            this.moves[n3] = ZERO;
        }
        for (n = 0; n < 10; ++n) {
            if (physics.pins[n].remains) {
                if (trackRecorderArray[n][0].moves[n3].equals(ZERO)) {
                    trackRecorderArray[n][0].moves[n3] = new float[4];
                }
                if (trackRecorderArray[n][1].moves[n3].equals(ZERO)) {
                    trackRecorderArray[n][1].moves[n3] = new float[4];
                }
                trackRecorderArray[n][0].moves[n3][0] = GameMath.get_float(physics.pins[n].x[0].y);
                trackRecorderArray[n][0].moves[n3][1] = GameMath.get_float(-physics.pins[n].x[0].x);
                trackRecorderArray[n][0].moves[n3][2] = GameMath.get_float(physics.pins[n].x[0].z);
                trackRecorderArray[n][1].moves[n3][0] = GameMath.get_float(physics.pins[n].x[1].y);
                trackRecorderArray[n][1].moves[n3][1] = GameMath.get_float(-physics.pins[n].x[1].x);
                trackRecorderArray[n][1].moves[n3][2] = GameMath.get_float(physics.pins[n].x[1].z);
                if (bl) {
                    Debug.TRACE("boom!! " + this.currentIter);
                    trackRecorderArray[n][0].moves[n3][2] = GameMath.get_float(physics.pins[n].radius[0]);
                    trackRecorderArray[n][1].moves[n3][2] = GameMath.get_float(physics.pins[n].radius[1]);
                }
            } else if (!trackRecorderArray[n][0].moves[n3].equals(ZERO) || !trackRecorderArray[n][1].moves[n3].equals(ZERO)) {
                trackRecorderArray[n][0].moves[n3] = null;
                trackRecorderArray[n][1].moves[n3] = null;
                trackRecorderArray[n][0].moves[n3] = ZERO;
                trackRecorderArray[n][1].moves[n3] = ZERO;
            }
            if (!(!bl || TrackRecorder.checkStanding(trackRecorderArray[n][0], trackRecorderArray[n][1], false) && physics.pins[n].remains)) {
                ++this.result;
            }
            ++trackRecorderArray[n][0].currentIter;
            ++trackRecorderArray[n][1].currentIter;
        }
        ++this.currentIter;
        physics.singleUpdate(41.0f);
        this.totalTime += (int)System.currentTimeMillis() - n2;
    }

    private void move(float f, Physics physics) {
        if (physics.ball.remains) {
            float[] fArray = new float[4];
            fArray[0] = GameMath.get_float(physics.ball.old_x[0].y) + f;
            fArray[1] = GameMath.get_float(-physics.ball.old_x[0].x);
            fArray[2] = GameMath.get_float(physics.ball.old_x[0].z);
            physics.setBallTranslation(fArray, true);
        }
    }

    public void moveRight(Physics physics) {
        this.move(-0.005f, physics);
    }

    public void moveLeft(Physics physics) {
        this.move(0.005f, physics);
    }

    public float[] getTranslation(int n) {
        if (n < this.currentIter - 1) {
            return this.moves[n];
        }
        return this.moves[this.currentIter - 1];
    }

    public float[] getLastTranslation() {
        this.currentMove = this.numMoves;
        return this.moves[this.numMoves - 1];
    }

    public float[] getLastOldTranslation() {
        return this.moves[this.numMoves - 2];
    }

    public float getSpin(float f) {
        if (this.currentMove >= 2) {
            f = this.moves[this.currentMove][0] + this.moves[this.currentMove - 2][0] - 2.0f * this.moves[this.currentMove - 1][0];
        }
        return f;
    }

    public float[] getNextTranslation(float[] fArray) {
        fArray[0] = this.moves[this.currentMove][0];
        fArray[1] = this.moves[this.currentMove][1];
        fArray[2] = this.moves[this.currentMove][2];
        this.nextMove();
        return fArray;
    }

    public void fillStartTranslation(float[] fArray) {
        fArray[0] = this.startCoord[0];
        fArray[1] = this.startCoord[1];
        fArray[2] = this.startCoord[2];
    }

    public void fillStartOldTranslation(float[] fArray) {
        fArray[0] = this.oldCoord[0];
        fArray[1] = this.oldCoord[1];
        fArray[2] = this.oldCoord[2];
    }

    public static boolean checkStanding(TrackRecorder trackRecorder, TrackRecorder trackRecorder2, boolean bl) {
        int n;
        int n2 = n = bl ? trackRecorder.getCurrentMove() : trackRecorder.getCurrentIter();
        return Math.abs(trackRecorder.moves[n][0] - trackRecorder2.moves[n][0]) < 0.01f && Math.abs(trackRecorder.moves[n][1] - trackRecorder2.moves[n][1]) < 0.01f && trackRecorder.remains() && trackRecorder2.remains();
    }

    public void playBack() {
        this.currentMove = 0;
        this.currentIter = 0;
    }

    public boolean remains() {
        return !this.moves[this.currentMove].equals(ZERO);
    }

    public int getCurrentMove() {
        return this.currentMove;
    }

    public void setCurrentMove(int n) {
        this.currentMove = n;
    }

    public void nextMove() {
        if (this.isNextMove()) {
            ++this.currentMove;
        }
    }

    public boolean isNextMove() {
        return this.currentMove < this.currentIter - 1 && this.currentMove < 300;
    }

    public float GetSpeed() {
        return this.startCoord[2] - this.oldCoord[2];
    }

    public void debug(boolean bl) {
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    public int getCurrentIter() {
        return this.currentIter;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isStrike() {
        return this.result == 10;
    }

    static {
        ZERO = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    }
}

