/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import portinglib.Debug;
import portinglib.Graphics2D;
import portinglib.StringTable;
import userapp.Device;
import userapp.FlatObject;
import userapp.Game;
import userapp.PinObject;
import userapp.Tools;
import userapp.UserApp;

class ThrowResultObject
extends FlatObject {
    private int blinkCounter = 0;
    private int blinkAmount = 3;
    private int timeOfLastBlink;
    private int showTime = 300;
    private int hideTime = 300;
    private boolean blinkShowOn = true;
    private int m_faceFrameIndex;
    private int m_ringIndex;
    private int m_crossIndex;
    private int m_firstPinIndex;
    private int m_faceIndex;
    private int m_anim01Index;
    private int m_anim02Index;
    private int m_animFrameDelay = 100;
    private boolean m_animIsStarted;
    private String m_text = new String();
    private int m_triangleX;
    private int m_triangleY;
    private int m_symbCurrent;
    private int m_symbStartTime;
    private int m_symbAnimSpeed;
    private int m_startTime;
    private static final int TRHOW_RESULTS_AUTOHIDE_TIME = 2000;

    public ThrowResultObject(Game game) {
        super(game);
        this.timeOfLastBlink = game.getApplicationTime();
        FlatObject.TFlatElement tFlatElement = new FlatObject.TFlatElement();
        tFlatElement.isVisible = true;
        this.m_triangleX = (UserApp.getWidth() - Graphics2D.getWidth(14)) / 2;
        this.m_triangleY = Graphics2D.getHeight(17) + (UserApp.getHeight() - Graphics2D.getFontHeight(2) - Graphics2D.getHeight(17) - Graphics2D.getHeight(14)) / 2;
        tFlatElement.imageId = 14;
        tFlatElement.xPos = this.m_triangleX;
        tFlatElement.yPos = this.m_triangleY;
        this.elements.addElement(tFlatElement.duplicate());
        tFlatElement.imageId = 18;
        this.m_firstPinIndex = this.elements.size();
        for (int i = 0; i < 10; ++i) {
            tFlatElement.xPos = 0;
            tFlatElement.yPos = 0;
            this.elements.addElement(tFlatElement.duplicate());
        }
        tFlatElement.xPos = -200;
        tFlatElement.yPos = -200;
        tFlatElement.imageId = 15;
        this.m_ringIndex = this.elements.size();
        this.elements.addElement(tFlatElement.duplicate());
        tFlatElement.imageId = 16;
        this.m_crossIndex = this.elements.size();
        this.elements.addElement(tFlatElement.duplicate());
        tFlatElement.xPos = UserApp.getWidth() - Graphics2D.getWidth(17);
        tFlatElement.yPos = 0;
        tFlatElement.imageId = 17;
        this.m_faceFrameIndex = this.elements.size();
        this.elements.addElement(tFlatElement.duplicate());
        tFlatElement.xPos = UserApp.getWidth() - Graphics2D.getWidth(17) + 6;
        tFlatElement.yPos = 3;
        tFlatElement.imageId = 19;
        this.m_faceIndex = this.elements.size();
        this.elements.addElement(tFlatElement.duplicate());
        tFlatElement.xPos = this.m_triangleX;
        tFlatElement.yPos = this.m_triangleY;
        tFlatElement.imageId = 9;
        this.m_anim01Index = this.elements.size();
        this.elements.addElement(tFlatElement.duplicate());
        tFlatElement.xPos = this.m_triangleX;
        tFlatElement.yPos = this.m_triangleY;
        tFlatElement.imageId = 9;
        this.m_anim02Index = this.elements.size();
        this.elements.addElement(tFlatElement.duplicate());
    }

    public void resetPins(int n) {
        int n2;
        super.getElement((int)0).isVisible = true;
        if (n != -1) {
            super.getElement((int)this.m_faceIndex).imageId = n;
        }
        super.getElement((int)this.m_faceIndex).isVisible = n != -1;
        super.getElement((int)this.m_faceFrameIndex).isVisible = n != -1;
        this.blinkCounter = 0;
        ThrowResultObject throwResultObject = this;
        this.timeOfLastBlink = throwResultObject.game.getApplicationTime();
        this.blinkShowOn = true;
        super.getElement((int)this.m_anim01Index).isVisible = false;
        super.getElement((int)this.m_anim02Index).isVisible = false;
        this.m_animIsStarted = false;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 9; n2 >= 0; --n2) {
            PinObject pinObject = this.game.lnkPhysics.hashedPins[n2];
            float[] fArray = pinObject.getTranslation();
            super.getElement((int)(n3 + this.m_firstPinIndex)).xPos = this.m_triangleX + Device.SCREEN_PINS_POSITION_DELTA_X + (int)(fArray[0] * Device.SCREEN_PINS_POSITION_SCALE);
            super.getElement((int)(n3 + this.m_firstPinIndex)).yPos = this.m_triangleY + Device.SCREEN_PINS_POSITION_DELTA_Y - (int)(fArray[1] * Device.SCREEN_PINS_POSITION_SCALE);
            super.getElement((int)(n3 + this.m_firstPinIndex)).isVisible = this.game.lnkPhysics.lastFrameLeftPins[n3];
            if (this.game.gameMode == 5) {
                if (this.game.getGameWorld().getGameState() == 23) {
                    super.getElement((int)this.m_faceFrameIndex).isVisible = false;
                    if (n4 == this.game.precisionTarget) {
                        super.getElement((int)this.m_ringIndex).xPos = this.m_triangleX + Device.SCREEN_PINS_POSITION_DELTA_X + (int)(fArray[0] * Device.SCREEN_PINS_POSITION_SCALE);
                        super.getElement((int)this.m_ringIndex).yPos = this.m_triangleY + Device.SCREEN_PINS_POSITION_DELTA_Y - (int)(fArray[1] * Device.SCREEN_PINS_POSITION_SCALE);
                    }
                    super.getElement((int)this.m_crossIndex).xPos = -200;
                } else {
                    super.getElement((int)this.m_faceFrameIndex).isVisible = true;
                    if (this.game.lnkPhysics.getFirstPin() == this.game.precisionTarget) {
                        super.getElement((int)(n3 + this.m_firstPinIndex)).xPos = -200;
                    } else if (n4 == this.game.precisionTarget) {
                        super.getElement((int)this.m_ringIndex).xPos = this.m_triangleX + Device.SCREEN_PINS_POSITION_DELTA_X - 1 + (int)(fArray[0] * Device.SCREEN_PINS_POSITION_SCALE);
                        super.getElement((int)this.m_ringIndex).yPos = this.m_triangleY + Device.SCREEN_PINS_POSITION_DELTA_Y - (int)(fArray[1] * Device.SCREEN_PINS_POSITION_SCALE);
                    } else if (n4 == this.game.lnkPhysics.getFirstPin()) {
                        super.getElement((int)this.m_crossIndex).xPos = this.m_triangleX + Device.SCREEN_PINS_POSITION_DELTA_X + (int)(fArray[0] * Device.SCREEN_PINS_POSITION_SCALE);
                        super.getElement((int)this.m_crossIndex).yPos = this.m_triangleY + Device.SCREEN_PINS_POSITION_DELTA_Y + (Graphics2D.getWidth(18) - Graphics2D.getWidth(16)) / 2 - (int)(fArray[1] * Device.SCREEN_PINS_POSITION_SCALE);
                    }
                }
            }
            ++n3;
            ++n4;
        }
        while (n3 < 10) {
            super.getElement((int)(n3 + this.m_firstPinIndex)).xPos = -200;
            super.getElement((int)(n3 + this.m_firstPinIndex)).yPos = -200;
            ++n3;
        }
        if (this.game.gameMode != 5 || this.game.lnkPhysics.getFirstPin() == this.game.precisionTarget && this.game.getGameWorld().getGameState() != 23) {
            super.getElement((int)this.m_ringIndex).xPos = -200;
            super.getElement((int)this.m_crossIndex).xPos = -200;
        }
        if (this.game.gameMode != 5 && this.game.getGameWorld().getGameState() == 23) {
            super.getElement((int)this.m_crossIndex).xPos = -200;
        }
        this.m_symbCurrent = 0;
        ThrowResultObject throwResultObject2 = this;
        this.m_symbStartTime = throwResultObject2.game.getApplicationTime();
        this.m_symbAnimSpeed = 100;
        this.m_text = "";
        if (this.game.gameMode == 5 && this.game.lnkPhysics.getFirstPin() == this.game.precisionTarget && this.game.getGameWorld().getGameState() != 23) {
            this.m_text = StringTable.get(56);
        }
        if (this.game.gameMode != 5 && this.game.lnkPhysics.getThrowResult() == 0 && !this.game.getGameWorld().wasFault) {
            int n5;
            this.m_text = this.game.firstThrow ? (this.game.scores[this.game.getGameWorld().getCurrentBowler()].strikesInARow == 2 && this.game.throwResult == 0 ? StringTable.get(114) : (this.game.scores[this.game.getGameWorld().getCurrentBowler()].strikesInARow == 5 && this.game.throwResult == 0 ? StringTable.get(115) : StringTable.get(53))) : ((n2 = this.game.scores[this.game.currentPlayer].currentThrow) - (n5 = this.game.scores[this.game.currentPlayer].playerFrames[this.game.scores[this.game.currentPlayer].currentFrame]) > 1 ? StringTable.get(55) : StringTable.get(54));
        }
    }

    public void paintText(Graphics2D graphics2D) {
        ThrowResultObject throwResultObject = this;
        if (throwResultObject.game.getApplicationTime() - this.m_startTime > 2000 && this.game.gameMode == 4 && this.game.getGameWorld().getCurrentBowler() == 1) {
            Debug.TRACE("auto hiding for AI");
            this.game.onKeyPressed(-20);
            return;
        }
        this.symbAnimUpdate(graphics2D);
    }

    public FlatObject.TFlatElement getElement(int n) {
        FlatObject.TFlatElement tFlatElement = super.getElement(n);
        if (this.game.gameMode == 5) {
            if (this.game.getGameWorld().getGameState() == 23 && n == this.game.precisionTarget + 1) {
                tFlatElement.isVisible = false;
                return tFlatElement;
            }
            if ((n == this.m_ringIndex && this.game.getGameWorld().getGameState() == 23 || (n == this.m_crossIndex || n == this.game.lnkPhysics.getFirstPin() + this.m_firstPinIndex && this.game.lnkPhysics.getFirstPin() >= 0) && this.game.getGameWorld().getGameState() != 23) && this.blinkCounter < this.blinkAmount) {
                ThrowResultObject throwResultObject = this;
                int n2 = throwResultObject.game.getApplicationTime() - this.timeOfLastBlink;
                if (n2 >= (this.blinkShowOn ? this.showTime : this.hideTime)) {
                    ThrowResultObject throwResultObject2 = this;
                    this.timeOfLastBlink = throwResultObject2.game.getApplicationTime();
                    this.blinkShowOn ^= true;
                    if (this.blinkShowOn) {
                        ++this.blinkCounter;
                    }
                }
                if (this.game.gameMode == 5) {
                    tFlatElement.isVisible = this.blinkShowOn;
                } else if (!this.blinkShowOn) {
                    tFlatElement.xPos = -200;
                }
            }
        } else if (n >= this.m_firstPinIndex && n < 10 + this.m_firstPinIndex && this.game.gameMode != 5) {
            tFlatElement.isVisible = this.game.lnkPhysics.lastFrameLeftPins[n - this.m_firstPinIndex];
            if (this.blinkCounter < this.blinkAmount) {
                ThrowResultObject throwResultObject = this;
                int n3 = throwResultObject.game.getApplicationTime() - this.timeOfLastBlink;
                if (n3 >= (this.blinkShowOn ? this.showTime : this.hideTime)) {
                    ThrowResultObject throwResultObject3 = this;
                    this.timeOfLastBlink = throwResultObject3.game.getApplicationTime();
                    this.blinkShowOn ^= true;
                    if (this.blinkShowOn) {
                        ++this.blinkCounter;
                    }
                }
                if (this.game.lnkPhysics.lastFrameLeftPins[n - this.m_firstPinIndex]) {
                    tFlatElement.isVisible = this.blinkShowOn;
                }
            }
        }
        return tFlatElement;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            ThrowResultObject throwResultObject = this;
            this.m_startTime = throwResultObject.game.getApplicationTime();
        }
    }

    public void setBlinkingTime(int n, int n2) {
        this.showTime = n;
        this.hideTime = n2;
    }

    public void setBlinksAmount(int n) {
        this.blinkAmount = n;
    }

    private void symbAnimUpdate(Graphics2D graphics2D) {
        ThrowResultObject throwResultObject = this;
        int n = throwResultObject.game.getApplicationTime();
        if (this.m_animIsStarted) {
            if (n - this.m_symbStartTime >= this.m_animFrameDelay) {
                this.m_symbStartTime = n;
            }
        } else {
            if (this.m_text.length() == 0) {
                return;
            }
            if (n - this.m_symbStartTime >= this.m_symbAnimSpeed && this.m_symbCurrent < this.m_text.length()) {
                this.m_symbStartTime = n;
                ++this.m_symbCurrent;
            }
            int n2 = UserApp.getWidth() / 2 - 3;
            int n3 = this.m_triangleY + Graphics2D.getWidth(14) / 5;
            Tools.drawJigglingString(graphics2D, (n - this.m_symbStartTime) * 2, 2, this.m_text.substring(0, this.m_symbCurrent), n2, n3, 17);
        }
    }
}

