/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import portinglib.Graphics2D;
import portinglib.StringTable;
import userapp.UserApp;

class RunningText {
    protected UserApp m_pApp;
    protected Graphics2D m_pG2D;
    protected boolean m_active = false;
    protected int m_speed;
    protected int m_y;
    protected int m_xOffset = 999999;
    protected int m_lastTime;
    protected int m_lastActiveTime;
    protected String m_pText;
    protected static final int RUNNING_TEXT_INFINITY = 999999;
    protected static final int RUNNING_TEXT_DEFAULT_SCROLLING_SPEED = 50;
    protected int m_regularTime;
    protected boolean m_keyReset;

    public RunningText(UserApp userApp) {
        this.m_pApp = userApp;
        this.m_regularTime = -1;
        this.m_keyReset = true;
    }

    public void render2D(Graphics2D graphics2D) {
        if (this.m_pApp.m_menuIsActive) {
            return;
        }
        this.m_pG2D = graphics2D;
        if (graphics2D == null || this.m_pText == null || !this.m_active) {
            return;
        }
        this.m_pG2D.setFont(2);
        this.m_pG2D.setClip(0, 0, UserApp.getWidth(), UserApp.getHeight());
        int n = Graphics2D.getWidth(31);
        int n2 = Graphics2D.getHeight(31);
        this.m_pG2D.setFillColor(0x444444);
        this.m_pG2D.setFillMode(1);
        this.m_pG2D.drawRect(0, this.m_y, UserApp.getWidth(), n2 + Graphics2D.getFontHeight(2) * 2);
        int n3 = UserApp.getWidth() / n + 1;
        for (int i = 0; i < n3; ++i) {
            this.m_pG2D.drawImage(31, i * n, this.m_y, 20);
            this.m_pG2D.drawImage(31, i * n, this.m_y + (n2 + Graphics2D.getFontHeight(2) * 2), 20);
        }
        this.drawText();
    }

    public void set(int n) {
        this.set(n, 0, 50);
    }

    public void set(String string) {
        this.set(string, 0, 50);
    }

    public void set(int n, int n2, int n3) {
        if (n == -1) {
            return;
        }
        this.release();
        this.loadStringFromRes(n);
        this.m_y = n2;
        this.m_speed = n3;
        this.restart();
    }

    public void set(String string, int n, int n2) {
        if (string == null) {
            return;
        }
        this.release();
        this.m_pText = string;
        this.m_y = n;
        this.m_speed = n2;
        this.restart();
    }

    void append(int n) {
        String string = new String(this.m_pText);
        this.loadStringFromRes(n);
        this.m_pText = string + this.m_pText;
    }

    void append(String string) {
        this.m_pText = this.m_pText + string;
    }

    public void setPosition(int n) {
        this.m_y = n;
    }

    public void setSpeed(int n) {
        this.m_speed = n;
    }

    public void release() {
        this.m_pText = null;
        this.m_y = 0;
        this.m_speed = 0;
    }

    public void update(int n) {
        UserApp userApp = this.m_pApp;
        n = userApp.game.getApplicationTime();
        if (this.m_pApp.m_menuIsActive) {
            this.m_lastTime = n;
            return;
        }
        if (!this.m_active && this.m_regularTime != -1 && n - this.m_lastActiveTime > this.m_regularTime) {
            this.start();
        }
        if (this.m_pG2D == null) {
            return;
        }
        if (this.m_pText == null) {
            return;
        }
        if (!this.m_active) {
            return;
        }
        this.m_lastActiveTime = n;
        if (this.m_xOffset >= 999999) {
            this.m_xOffset = UserApp.getWidth();
            this.m_lastTime = n;
        } else {
            int n2 = (n - this.m_lastTime) * this.m_speed / 1000;
            if (n2 != 0) {
                this.m_xOffset -= n2;
                this.m_lastTime = n;
                if (this.m_xOffset < -Graphics2D.charsWidth(2, this.m_pText.toCharArray(), 0, this.m_pText.length())) {
                    this.m_active = false;
                }
            }
        }
    }

    public boolean isActive() {
        return this.m_pText != null && this.m_active;
    }

    public void setActive(boolean bl) {
        this.m_active = bl;
    }

    public int getLastActiveTime() {
        return this.m_lastActiveTime;
    }

    public void restart() {
        this.m_xOffset = 999999;
        UserApp userApp = this.m_pApp;
        this.m_lastActiveTime = userApp.game.getApplicationTime();
    }

    public void start() {
        this.restart();
        this.m_active = true;
    }

    protected void loadStringFromRes(int n) {
        this.m_pText = StringTable.get(n);
    }

    protected void drawText() {
        if (this.m_pText != null) {
            this.m_pG2D.setFont(2);
            this.m_pG2D.drawChars(this.m_pText.toCharArray(), 0, this.m_pText.length(), this.m_xOffset, this.m_y + Graphics2D.getHeight(31) + Graphics2D.getFontHeight(2) / 2, 20);
        }
    }

    void regular(int n) {
        this.m_regularTime = n;
        UserApp userApp = this.m_pApp;
        this.m_lastActiveTime = userApp.game.getApplicationTime();
    }

    boolean onKeyPressed(int n) {
        if (this.m_keyReset) {
            this.m_active = false;
        }
        UserApp userApp = this.m_pApp;
        this.m_lastActiveTime = userApp.game.getApplicationTime();
        return false;
    }
}

