/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.World;
import portinglib.Debug;
import portinglib.Graphics2D;
import portinglib.ResourceManager;
import userapp.Device;
import userapp.Game;
import userapp.UserApp;

class MenuLanguageSelection {
    private static final String[] _Language = new String[]{"English", "Fran\u00e7ais", "Italiano", "Deutsch", "Espa\u00f1ol"};
    private static final String[] _Lang = new String[]{"en", "fr", "it", "de", "es"};
    public int langsel = 0;
    protected Node effectsNode;
    protected Node allNode;
    protected int m_itemCurr;
    protected int m_itemNext;
    protected boolean m_lArrowIsHidden;
    protected boolean m_rArrowIsHidden;
    protected int m_text;
    protected int m_text2;
    protected String m_textString;
    protected boolean isExitFlag;
    protected int[] m_itemList;
    protected int m_itemNum;
    protected int m_header;
    private int m_laneTextOffset;
    private int m_itemScrollStartTime;
    private int m_itemScrollDirection;
    protected static Group group;
    protected static Camera camera;
    protected Game game;
    protected static int oldTime;
    protected static int realOldTime;
    protected static int ITEM_SCROLL_SPEED_PIXEL_IN_MS;
    protected static int ITEM_SCROLL_ITEMS_DISTANCE;
    protected boolean promoteGames = false;
    protected int promoteSplashNum = 0;
    private static final boolean DEBUG = false;

    public MenuLanguageSelection() {
        this.onStart();
    }

    public void loadGroup() {
    }

    public void onStart() {
        this.m_text2 = -1;
        this.m_laneTextOffset = 0;
    }

    public void onShow() {
    }

    public void onHide() {
    }

    public void update(int n) {
        if (Game.m_app.m_continueScreenIsActive) {
            return;
        }
        if (realOldTime == 0 || oldTime == 0) {
            realOldTime = n;
            oldTime = n;
        }
        int n2 = 0;
        if (realOldTime != 0) {
            n2 = (int)((float)(n - realOldTime) * 1.0f);
        }
        MenuLanguageSelection menuLanguageSelection = this;
        Game.setApplicationTime(menuLanguageSelection.game.getApplicationTime() + n2);
        oldTime += n2;
        realOldTime = n;
        ++this.m_laneTextOffset;
        if (this.isMostLeft() != this.m_lArrowIsHidden) {
            this.updateArrows(true);
        }
        if (this.isMostRight() != this.m_rArrowIsHidden) {
            this.updateArrows(false);
        }
    }

    public int getLangsel() {
        return this.langsel;
    }

    public void clearBack() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render3DLayer(Graphics2D graphics2D, boolean bl) {
        Graphics3D graphics3D = Graphics3D.getInstance();
        graphics3D.bindTarget((Object)graphics2D.getGraphics());
        try {
            if (this.effectsNode != null && this.allNode != null) {
                if (bl) {
                    this.effectsNode.setRenderingEnable(false);
                    this.allNode.setRenderingEnable(true);
                } else {
                    this.effectsNode.setRenderingEnable(true);
                    this.allNode.setRenderingEnable(false);
                }
            }
            graphics3D.render((World)group);
            if (this.effectsNode != null && this.allNode != null) {
                this.effectsNode.setRenderingEnable(true);
                this.allNode.setRenderingEnable(true);
            }
        }
        catch (IllegalStateException illegalStateException) {
            Debug.TRACE("porting: GameWorld::render3D failed:");
            Debug.TRACE(illegalStateException.toString());
        }
        finally {
            graphics3D.releaseTarget();
        }
    }

    public void render3D(Graphics2D graphics2D) {
        graphics2D.setColor(0);
        graphics2D.fillRect(0, 0, UserApp.getWidth(), UserApp.getHeight());
    }

    protected int getTextOffset(String string, Graphics2D graphics2D) {
        return 0;
    }

    public void render2D(Graphics2D graphics2D) {
        graphics2D.setFont(2);
        graphics2D.setColor(0);
        graphics2D.fillRect(0, 0, UserApp.getWidth(), UserApp.getHeight());
        graphics2D.setFillColor(50);
        graphics2D.fillRect(0, 0, UserApp.getWidth(), UserApp.getHeight());
        for (int i = 0; i < 5; ++i) {
            graphics2D.drawString(_Language[i], UserApp.getWidth() / 2, UserApp.getHeight() * 2 / 4 - 50 + i * 15, 1);
            if (this.langsel != i) continue;
            graphics2D.setFillColor(8661033);
            graphics2D.setFillMode(1);
            graphics2D.drawRect(UserApp.getWidth() / 2 - Graphics2D.stringWidth(2, _Language[i]) / 2 - 4, graphics2D.getHeight() * 2 / 4 - 53 + i * 15 + 2, Graphics2D.stringWidth(2, _Language[i]) + 8, 13);
            graphics2D.drawString(_Language[i], UserApp.getWidth() / 2, UserApp.getHeight() * 2 / 4 - 50 + i * 15, 1);
        }
        graphics2D.drawString("Select", 5, UserApp.getHeight() - 16, 4);
    }

    protected void drawSoftKey(Graphics2D graphics2D, String string, int n, boolean bl) {
    }

    protected boolean drawExit() {
        return false;
    }

    protected boolean drawBack() {
        return false;
    }

    protected boolean drawSelect() {
        return false;
    }

    protected void setHeader(int n) {
        this.m_header = n;
    }

    protected void setTextString(String string) {
        this.m_textString = string;
    }

    protected void setText(int n) {
        this.m_text = n;
    }

    protected void setText2(int n) {
        this.m_text2 = n;
    }

    protected int getHeaderTop() {
        return UserApp.getHeight() - Device.SCREEN_MENU_PLATE_HEIGHT - Graphics2D.getHeight(40) - Device.SCREEN_MENU_PLATE_HEADER_OFFSET_Y;
    }

    protected int getText2Center() {
        return 0;
    }

    protected int getTextCenter() {
        return UserApp.getHeight() - Device.SCREEN_MENU_PLATE_HEIGHT / 2 - Graphics2D.getHeight(40);
    }

    protected int getArrowsOffset() {
        return 0;
    }

    public boolean onKeyPressed(int n) {
        switch (n) {
            case -1: 
            case 50: {
                --this.langsel;
                if (this.langsel < 0) {
                    this.langsel = 4;
                }
                return true;
            }
            case -6: 
            case 56: {
                ++this.langsel;
                if (this.langsel > 4) {
                    this.langsel = 0;
                }
                return true;
            }
            case -21: 
            case -20: 
            case 53: {
                ResourceManager.setLocale(_Lang[this.langsel]);
                Game.m_app.m_menuIsActive = true;
                UserApp.m_LangSelIsActive = false;
                return !this.isExitFlag;
            }
        }
        return false;
    }

    public boolean onKeyReleased(int n) {
        return false;
    }

    public int getCurrentItemName() {
        return this.m_itemList[this.m_itemCurr];
    }

    public boolean isMostLeft() {
        return this.m_itemNext == -1 ? this.m_itemCurr == 0 : this.m_itemNext == 0;
    }

    public boolean isMostRight() {
        return this.m_itemNext == -1 ? this.m_itemCurr == this.m_itemNum - 1 : this.m_itemNext == this.m_itemNum - 1;
    }

    public void updateArrows(boolean bl) {
        if (bl) {
            this.m_lArrowIsHidden = this.isMostLeft();
        }
        if (!bl) {
            this.m_rArrowIsHidden = this.isMostRight();
        }
    }

    public void hideArrows() {
    }

    public void setItemCur(int n) {
        this.m_itemCurr = n;
    }

    protected void onItemSelect(int n) {
    }

    protected void onItemChange(int n) {
    }

    static {
        ITEM_SCROLL_SPEED_PIXEL_IN_MS = 400;
        ITEM_SCROLL_ITEMS_DISTANCE = 130;
    }
}

