/*
 * Decompiled with CFR 0.152.
 */
package portinglib;

import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import portinglib.ResourceManager;

public final class Graphics2D {
    public static final int DEF_PALETTE = -1;
    public static final int FILL = 1;
    public static final int OUTLINE = 2;
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int VCENTER_EX = 64;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROTATE180 = 3;
    public static final int TRANS_ROTATE270 = 6;
    public static final int TRANS_ROTATE90 = 5;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    private int xClip;
    private int yClip;
    private int wClip;
    private int hClip;
    private static Object[] images;
    private static Object[] young;
    private static Object[] old;
    private static final byte UNUSING_PALETTE = -2;
    private static final int NUM_CACHE_DATA = 6;
    private static final int IDX_CACHE_AFTER_TIME = 0;
    private static final int IDX_CACHE_BEFORE_TIME = 1;
    private static final int IDX_CACHE_PICTURE = 2;
    private static final int IDX_CACHE_PALETTE = 3;
    private static final int IDX_CACHE_NEXT_ID = 4;
    private static final int IDX_CACHE_PREV_ID = 5;
    private static int CACHE_SIZE;
    private static int cacheSize;
    private static int[] resIndexes;
    private static short[] dimensions;
    private static Font[] systemFonts;
    private static short[] leadingSystemFonts;
    private static short[] vcenterSystemFonts;
    private static int[] systemFontColor;
    private static int idCurrentFont;
    private static int idCurrentBitmapFont;
    private static short[][] bitmapFonts;
    private static short[] bitmapFontsDescription;
    private static byte[] bitmapFontsLinks;
    private static final int NUM_BTMP_FONT_ARGS = 8;
    private static final int IDX_BTMP_PICID = 0;
    private static final int IDX_BTMP_NUM_ROWS = 1;
    private static final int IDX_BTMP_H_ROW = 2;
    private static final int IDX_BTMP_KERNING = 3;
    private static final int IDX_BTMP_LEADING = 4;
    private static final int IDX_BTMP_ABSENCE = 5;
    private static final int IDX_BTMP_NUM_LINES = 6;
    private static final int IDX_BTMP_VCENTER = 7;
    private static final byte IDX_ID_FILE_NAME = 0;
    private static final byte IDX_X_FRAME = 1;
    private static final byte IDX_Y_FRAME = 2;
    private static final byte IDX_W_FRAME = 3;
    private static final byte IDX_H_FRAME = 4;
    private static final byte IDX_X_OFFSET_FRAME = 5;
    private static final byte IDX_Y_OFFSET_FRAME = 6;
    private static final byte IDX_W_REAL_FRAME = 7;
    private static final byte IDX_H_REAL_FRAME = 8;
    private static final byte NUM_FRAMES_DATA = 9;
    private static short[] frameDatas;
    private static int startFrameIds;
    private static short[] idsInfo;
    private Image img;
    private Graphics g;
    private int lineColor;
    private int fillColor;
    private int fillMode;
    private static final int DEF_COLOR = 0;
    private static final int DEF_FILL = 0;
    private static final int DEF_OUTLINE = 2;
    private static final int MASK_MATCHALL = 0;
    private int idCurPalette = -1;
    private static final boolean DEBUG = false;
    private static boolean enableMultipalette;

    public Graphics2D(int n, int n2) {
        this.img = Image.createImage((int)n, (int)n2);
        this.g = this.img.getGraphics();
    }

    public Graphics getGraphics() {
        return this.g;
    }

    public static void prefetch(int n) {
        Graphics2D.prefetch(n, -1);
    }

    public static void prefetch(int n, int n2) {
        int n3 = Graphics2D.getImageId(n);
        Graphics2D.prefetchImage(n3, n, n2);
    }

    public static void prefetchFont(int n) {
        Graphics2D.prefetchFont(n, -1);
    }

    public static void prefetchFont(int n, int n2) {
        int n3 = n - systemFonts.length;
        if (n3 >= 0) {
            short s = bitmapFontsDescription[bitmapFontsLinks[n3 * 2] * 8 + 0];
            int n4 = Graphics2D.getImageId(s);
            Graphics2D.prefetchImage(n4, s, n2);
        }
    }

    public static void deallocateFont(int n) {
        Graphics2D.deallocateFont(n, -2);
    }

    public static void deallocateFont(int n, int n2) {
        int n3 = n - systemFonts.length;
        if (n3 >= 0) {
            short s = bitmapFontsDescription[bitmapFontsLinks[n3 * 2] * 8 + 0];
            Graphics2D.deallocate(s, n2);
        }
    }

    public static void deallocate(int n) {
        Graphics2D.deallocate(n, -2);
    }

    public static void deallocate(int n, int n2) {
        if (n < 0) {
            return;
        }
        Graphics2D.deallocate(Graphics2D.getImageId(n), n2, 0);
    }

    public void drawImage(int n, int n2, int n3, int n4) {
        int n5 = Graphics2D.getImageId(n);
        int n6 = idsInfo[n];
        Object object = Graphics2D.prefetchImage(n5, n, this.idCurPalette);
        Image image = (Image)object;
        if ((n6 -= startFrameIds) < 0) {
            this.g.drawImage(image, n2, n3, n4);
        } else {
            int n7 = n6 * 9;
            int n8 = Graphics2D.getWidth(n);
            int n9 = Graphics2D.getHeight(n);
            this.g.drawRegion(image, (int)frameDatas[n7 + 1], (int)frameDatas[n7 + 2], (int)frameDatas[n7 + 3], (int)frameDatas[n7 + 4], 0, Graphics2D.xAnchor(n2 - frameDatas[n7 + 5], n8, n4), Graphics2D.yAnchor(n3 - frameDatas[n7 + 6], n9, n4), 20);
        }
    }

    public void drawImageTransformed(int n, int n2, int n3, int n4, int n5) {
        if (n5 == 0) {
            this.drawImage(n, n2, n3, n4);
            return;
        }
        int n6 = idsInfo[n];
        int n7 = Graphics2D.getImageId(n);
        n6 -= startFrameIds;
        Object object = Graphics2D.prefetchImage(n7, n, this.idCurPalette);
        int n8 = Graphics2D.getWidth(n);
        int n9 = Graphics2D.getHeight(n);
        if (n5 == 5 || n5 == 6 || n5 == 7 || n5 == 4) {
            int n10 = n8;
            n8 = n9;
            n9 = n10;
        }
        if (n6 < 0) {
            Image image = (Image)object;
            this.g.drawRegion(image, 0, 0, image.getWidth(), image.getHeight(), n5, n2, n3, n4);
        } else {
            Image image = (Image)object;
            int n11 = n6 * 9;
            int[] nArray = new int[]{0, 0};
            this.calcOffsetForRegion(n11, n5, n8, n9, nArray);
            this.drawRegion(image, frameDatas[n11 + 1], frameDatas[n11 + 2], frameDatas[n11 + 3], frameDatas[n11 + 4], n5, Graphics2D.xAnchor(n2, n8, n4) + nArray[0], Graphics2D.yAnchor(n3, n9, n4) + nArray[1]);
        }
    }

    private void drawRegion(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.g.drawRegion(image, n, n2, n3, n4, n5, n6, n7, 20);
    }

    private void calcOffsetForRegion(int n, int n2, int n3, int n4, int[] nArray) {
        int n5 = nArray[0];
        int n6 = nArray[1];
        switch (n2) {
            case 5: {
                n5 = n3 - frameDatas[n + 4] + frameDatas[n + 6];
                n6 = -frameDatas[n + 5];
                break;
            }
            case 3: {
                n5 = n3 - frameDatas[n + 3] + frameDatas[n + 5];
                n6 = n4 - frameDatas[n + 4] + frameDatas[n + 6];
                break;
            }
            case 6: {
                n5 = -frameDatas[n + 6];
                n6 = n4 - frameDatas[n + 3] + frameDatas[n + 5];
                break;
            }
            case 2: {
                n5 = n3 - frameDatas[n + 3] + frameDatas[n + 5];
                n6 = -frameDatas[n + 6];
                break;
            }
            case 7: {
                n5 = n3 - frameDatas[n + 4] + frameDatas[n + 6];
                n6 = n4 - frameDatas[n + 3] + frameDatas[n + 5];
                break;
            }
            case 1: {
                n5 = n3 - frameDatas[n + 3] + frameDatas[n + 5];
                n6 = -frameDatas[n + 6];
                break;
            }
            case 4: {
                n5 = -frameDatas[n + 6];
                n6 = -frameDatas[n + 5];
            }
        }
        nArray[0] = n5;
        nArray[1] = n6;
    }

    private void calcOffsetForClip(int n, Image image, int n2, int n3, int n4, int[] nArray) {
        int n5 = nArray[0];
        int n6 = nArray[1];
        switch (n2) {
            case 5: {
                n5 = -image.getHeight() + frameDatas[n + 2] + n3 + frameDatas[n + 6];
                n6 = -frameDatas[n + 1] - frameDatas[n + 5];
                break;
            }
            case 3: {
                n5 = -image.getWidth() + frameDatas[n + 1] + n3 + frameDatas[n + 5];
                n6 = -image.getHeight() + frameDatas[n + 2] + n4 + frameDatas[n + 6];
                break;
            }
            case 6: {
                n5 = -frameDatas[n + 2] - frameDatas[n + 6];
                n6 = -image.getWidth() + frameDatas[n + 1] + n4 + frameDatas[n + 5];
                break;
            }
            case 2: {
                n5 = -image.getWidth() + frameDatas[n + 1] + n3 + frameDatas[n + 5];
                n6 = -frameDatas[n + 6] - frameDatas[n + 2];
                break;
            }
            case 7: {
                n5 = -image.getHeight() + frameDatas[n + 2] + n3 + frameDatas[n + 6];
                n6 = -image.getWidth() + frameDatas[n + 1] + n4 + frameDatas[n + 5];
                break;
            }
            case 1: {
                n5 = -frameDatas[n + 5] - frameDatas[n + 1];
                n6 = -image.getHeight() + frameDatas[n + 2] + n4 + frameDatas[n + 6];
                break;
            }
            case 4: {
                n5 = -frameDatas[n + 6] - frameDatas[n + 2];
                n6 = -frameDatas[n + 5] - frameDatas[n + 1];
            }
        }
        nArray[0] = n5;
        nArray[1] = n6;
    }

    public void drawImage(Graphics2D graphics2D, int n, int n2, int n3) {
        this.g.drawImage(graphics2D.img, n, n2, n3);
    }

    public int getWidth() {
        return this.img.getWidth();
    }

    public static int getWidth(int n) {
        int n2 = Graphics2D.getPaletteID(n);
        short s = idsInfo[n];
        if (s >= startFrameIds) {
            return frameDatas[(s - startFrameIds) * 9 + 7];
        }
        return dimensions[s << 1];
    }

    public int getHeight() {
        return this.img.getHeight();
    }

    public static int getHeight(int n) {
        int n2 = Graphics2D.getPaletteID(n);
        short s = idsInfo[n];
        if (s >= startFrameIds) {
            return frameDatas[(s - startFrameIds) * 9 + 8];
        }
        return dimensions[s * 2 + 1];
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.g.setColor(this.lineColor);
        this.g.drawLine(n, n2, n3, n4);
    }

    public void drawString(String string, int n, int n2, int n3) {
        if (string == null) {
            return;
        }
        n2 = Graphics2D.yAnchorString(n2, n3, idCurrentFont);
        if (idCurrentBitmapFont < 0) {
            int n4 = systemFontColor[idCurrentFont];
            if (n4 < 0) {
                n4 = this.lineColor;
            }
            this.g.setColor(n4);
            this.g.drawString(string, (n3 & 4) != 4 ? Graphics2D.xAnchor(n, Graphics2D.stringWidth(idCurrentFont, string), n3) : n, n2, 0);
        } else {
            this.drawBitmapString(string, 0, string.length(), n, n2, n3);
        }
    }

    public void drawSubstring(String string, int n, int n2, int n3, int n4, int n5) {
        if (n2 <= 0 || string == null) {
            return;
        }
        n4 = Graphics2D.yAnchorString(n4, n5, idCurrentFont);
        if (idCurrentBitmapFont < 0) {
            int n6 = systemFontColor[idCurrentFont];
            if (n6 < 0) {
                n6 = this.lineColor;
            }
            this.g.setColor(n6);
            this.g.drawSubstring(string, n, n2, (n5 & 4) != 4 ? Graphics2D.xAnchor(n3, Graphics2D.substringWidth(idCurrentFont, string, n, n2), n5) : n3, n4, 0);
        } else {
            this.drawBitmapString(string, n, n2, n3, n4, n5);
        }
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4, int n5) {
        if ((n5 & 0x10) != 16) {
            n4 = Graphics2D.yAnchorString(n4, n5, idCurrentFont);
        }
        if (idCurrentBitmapFont < 0) {
            int n6 = systemFontColor[idCurrentFont];
            if (n6 < 0) {
                n6 = this.lineColor;
            }
            this.g.setColor(n6);
            this.g.drawChars(cArray, n, n2, (n5 & 4) != 4 ? Graphics2D.xAnchor(n3, Graphics2D.charsWidth(idCurrentFont, cArray, n, n2), n5) : n3, n4, 0);
        } else {
            int n7;
            n2 += n;
            int n8 = 0;
            if ((n5 & 4) != 4) {
                n7 = Graphics2D.getKerning(idCurrentFont);
                for (int i = n; i < n2; ++i) {
                    n8 += Graphics2D.charWidth(idCurrentFont, cArray[i]) + n7;
                }
                n3 = Graphics2D.xAnchor(n3, n8 - n7, n5);
                n8 = 0;
            }
            for (n7 = n; n7 < n2; ++n7) {
                n8 += this.drawChar(cArray[n7], n3 + n8, n4);
            }
        }
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        if ((this.fillMode & 1) != 0) {
            this.g.setColor(this.fillColor);
            this.g.fillRect(n, n2, n3, n4);
        }
        if ((this.fillMode & 2) != 0) {
            this.g.setColor(this.lineColor);
            this.g.drawRect(n, n2, n3 - 1, n4 - 1);
        }
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.g.setColor(this.lineColor);
        this.g.fillRect(n, n2, n3, n4);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if ((this.fillMode & 1) != 0) {
            this.g.setColor(this.fillColor);
            this.g.fillRoundRect(n, n2, n3, n4, n5, n6);
        }
        if ((this.fillMode & 2) != 0) {
            this.g.setColor(this.lineColor);
            this.g.drawRoundRect(n, n2, n3 - 1, n4 - 1, n5, n6);
        }
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if ((this.fillMode & 1) != 0) {
            this.g.setColor(this.fillColor);
            this.g.fillArc(n, n2, n3 - 1, n4 - 1, n5, n6);
        }
        if ((this.fillMode & 2) != 0) {
            this.g.setColor(this.lineColor);
            this.g.drawArc(n, n2, n3 - 1, n4 - 1, n5, n6);
        }
        if ((this.fillMode & 3) == 3) {
            int n7 = n3 / 2;
            int n8 = n4 / 2;
            int n9 = n + n7;
            int n10 = n2 + n8;
            float f = (float)n5 * ((float)Math.PI / 180);
            float f2 = (float)(n5 + n6) * ((float)Math.PI / 180);
            int n11 = n9 + (int)((float)Math.cos(f) * (float)n7);
            int n12 = n10 - (int)((float)Math.sin(f) * (float)n8) - 1;
            int n13 = n9 + (int)((float)Math.cos(f2) * (float)n7);
            int n14 = n10 - (int)((float)Math.sin(f2) * (float)n8) - 1;
            this.g.drawLine(n9, n10, n11, n12);
            this.g.drawLine(n9, n10, n13, n14);
        }
    }

    public void drawTriangle(int n, int n2, int n3, int n4, int n5, int n6) {
        if ((this.fillMode & 1) != 0) {
            this.g.setColor(this.fillColor);
            this.g.fillTriangle(n, n2, n3, n4, n5, n6);
        }
        if ((this.fillMode & 2) != 0) {
            this.g.setColor(this.lineColor);
            this.g.drawLine(n, n2, n3, n4);
            this.g.drawLine(n3, n4, n5, n6);
            this.g.drawLine(n, n2, n5, n6);
        }
    }

    public void getRGB(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.img == null) {
            nArray = null;
        } else {
            this.img.getRGB(nArray, n, n2, n3, n4, n5, n6);
        }
    }

    public void drawRGB(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.g.drawRGB(nArray, n, n2, n3, n4, n5, n6, bl);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.g.setClip(n, n2, n3, n4);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.g.clipRect(n, n2, n3, n4);
    }

    public int getClipX() {
        return this.g.getClipX();
    }

    public int getClipY() {
        return this.g.getClipY();
    }

    public int getClipWidth() {
        return this.g.getClipWidth();
    }

    public int getClipHeight() {
        return this.g.getClipHeight();
    }

    public void setColor(int n) {
        this.lineColor = n;
    }

    public void setFont(int n) {
        idCurrentFont = n;
        idCurrentBitmapFont = n - systemFonts.length;
        if (idCurrentBitmapFont < 0) {
            this.g.setFont(systemFonts[n]);
        }
    }

    public void setFillColor(int n) {
        this.fillColor = n;
    }

    public void setFillMode(int n) {
        this.fillMode = n;
    }

    public void translate(int n, int n2) {
        this.g.translate(n, n2);
    }

    public static final int charsWidth(int n, char[] cArray, int n2, int n3) {
        if (n < systemFonts.length) {
            return systemFonts[n].charsWidth(cArray, n2, n3);
        }
        int n4 = 0;
        int n5 = Graphics2D.getKerning(idCurrentFont);
        for (int i = n2; i < n2 + n3; ++i) {
            n4 += Graphics2D.charWidth(n, cArray[i]) + n5;
        }
        return n4 - n5;
    }

    public static final int charWidth(int n, char c) {
        if (n < systemFonts.length) {
            return systemFonts[n].charWidth(c);
        }
        int n2 = (n - systemFonts.length) * 2;
        short[] sArray = bitmapFonts[bitmapFontsLinks[n2]];
        int n3 = Graphics2D.remapCharacter(sArray, c);
        return n3 >= 0 ? sArray[n3 + 2] : bitmapFontsDescription[bitmapFontsLinks[n2] * 8 + 5];
    }

    public static final int substringWidth(int n, String string, int n2, int n3) {
        if (n < systemFonts.length) {
            return systemFonts[n].substringWidth(string, n2, n3);
        }
        int n4 = 0;
        int n5 = Graphics2D.getKerning(n);
        for (int i = n2; i < n2 + n3; ++i) {
            n4 += Graphics2D.charWidth(n, string.charAt(i)) + n5;
        }
        return n4 - n5;
    }

    public static final int stringWidth(int n, String string) {
        return Graphics2D.substringWidth(n, string, 0, string.length());
    }

    public static final int fit(String string, int n, int n2, int n3) {
        int n4;
        int n5 = string.length();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n6 = n;
        int n7 = n;
        int n8 = 0;
        boolean bl4 = ResourceManager.isHieroglyphicLocale();
        for (n4 = n; n4 != n5; ++n4) {
            char c = string.charAt(n4);
            if (c == '\r' || c == '\n') {
                if (!bl) {
                    n7 = n4;
                }
                return n7;
            }
            int n9 = 0;
            if (n2 - systemFonts.length >= 0) {
                n9 = Graphics2D.getKerning(n2);
            }
            n8 += Graphics2D.charWidth(n2, c) + n9;
            if ((c & 0xFFFF) <= 32 || bl4) {
                if (bl2) {
                    bl3 = true;
                }
                if (!bl || !bl3) {
                    n7 = n4;
                }
                bl = true;
            }
            if ((c & 0xFFFF) <= 32) continue;
            if (bl) {
                n6 = n4;
            }
            if (!bl3) {
                n7 = n4;
            }
            if (n8 > n3) {
                if (!bl3) break;
                n4 = n6;
                break;
            }
            bl = false;
            bl2 = true;
        }
        if (n4 == n5 && !bl) {
            n7 = n4;
        }
        return n7;
    }

    public static int getFontHeight(int n) {
        if (n < systemFonts.length) {
            return systemFonts[n].getHeight() + leadingSystemFonts[n];
        }
        int n2 = bitmapFontsLinks[(n - systemFonts.length) * 2] * 8;
        return bitmapFontsDescription[n2 + 4] + bitmapFontsDescription[n2 + 2];
    }

    public static final int getFontLeading(int n) {
        if (n < systemFonts.length) {
            return leadingSystemFonts[n];
        }
        return bitmapFontsDescription[bitmapFontsLinks[(n - systemFonts.length) * 2] * 8 + 4];
    }

    public final void setPalette(int n) {
    }

    public final int getPalette() {
        return this.idCurPalette;
    }

    public static final void enableMultipalette(boolean bl) {
        enableMultipalette = bl;
    }

    public static Image createImage(int n, int n2) throws Throwable {
        Object object = Graphics2D.createImage(Graphics2D.getImageId(n), n, n2, false);
        if (object instanceof short[]) {
            return null;
        }
        return (Image)object;
    }

    public static final void flush(int n) {
        if (n != 0) {
            Graphics2D.clearCache(n);
        }
    }

    public static final void flushAll() {
        Graphics2D.clearCache(0);
    }

    private static final void clearCache(int n) {
        for (int i = 0; i < images.length; ++i) {
            Graphics2D.deallocate(i, -2, n);
        }
    }

    public static int getImageId(int n) {
        short s = idsInfo[n];
        if (s >= startFrameIds) {
            return frameDatas[(s - startFrameIds) * 9 + 0];
        }
        return s;
    }

    public static final int getKerning(int n) {
        if (n - systemFonts.length < 0) {
            return 0;
        }
        return bitmapFontsDescription[bitmapFontsLinks[(n - systemFonts.length) * 2] * 8 + 3];
    }

    Graphics2D() {
    }

    void setGraphics(Graphics graphics) {
        this.g = graphics;
        this.lineColor = 0;
        this.fillColor = 0;
        this.fillMode = 2;
        this.idCurPalette = -1;
    }

    static void loadData(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        CACHE_SIZE = dataInputStream.readInt();
        int n3 = dataInputStream.readUnsignedShort();
        idsInfo = new short[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            Graphics2D.idsInfo[n2] = dataInputStream.readShort();
        }
        n3 = dataInputStream.readUnsignedShort();
        images = new Object[n3];
        resIndexes = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            Graphics2D.images[n2] = new Object[6];
            Graphics2D.resIndexes[n2] = dataInputStream.readUnsignedShort();
        }
        startFrameIds = n3;
        n3 = dataInputStream.readUnsignedShort();
        frameDatas = new short[n3 * 9];
        for (n2 = 0; n2 < n3 * 9; ++n2) {
            Graphics2D.frameDatas[n2] = dataInputStream.readShort();
        }
        young = new Object[6];
        old = new Object[6];
        Graphics2D.old[0] = young;
        Graphics2D.young[1] = old;
        dimensions = new short[resIndexes.length << 1];
        n3 = dataInputStream.readUnsignedShort();
        systemFonts = new Font[n3];
        leadingSystemFonts = new short[n3];
        vcenterSystemFonts = new short[n3];
        systemFontColor = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            n = dataInputStream.readByte();
            byte by = dataInputStream.readByte();
            byte by2 = dataInputStream.readByte();
            Graphics2D.systemFonts[n2] = Font.getFont((int)n, (int)by, (int)by2);
            Graphics2D.leadingSystemFonts[n2] = dataInputStream.readShort();
            Graphics2D.vcenterSystemFonts[n2] = dataInputStream.readShort();
            Graphics2D.systemFontColor[n2] = dataInputStream.readInt();
        }
        n3 = dataInputStream.readUnsignedShort();
        bitmapFonts = new short[n3][];
        bitmapFontsDescription = new short[n3 * 8];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < 8; ++n) {
                Graphics2D.bitmapFontsDescription[n2 * 8 + n] = dataInputStream.readShort();
            }
            Graphics2D.bitmapFonts[n2] = new short[dataInputStream.readUnsignedShort()];
            for (n = 0; n < bitmapFonts[n2].length; ++n) {
                Graphics2D.bitmapFonts[n2][n] = dataInputStream.readShort();
            }
        }
        bitmapFontsLinks = new byte[dataInputStream.readUnsignedShort()];
        dataInputStream.readFully(bitmapFontsLinks);
    }

    private static final void deallocate(int n, int n2, int n3) {
        Object[] objectArray;
        if (n3 != 0) {
            return;
        }
        do {
            if ((objectArray = Graphics2D.findPicture(n, n2)) == null) {
                return;
            }
            Graphics2D.removeFromIdSeq(objectArray);
            Graphics2D.removeFromTimeSeq(objectArray);
            Graphics2D.cacheReduce(objectArray);
        } while (objectArray != null && n2 == -2);
    }

    private static Object prefetchImage(int n, int n2, int n3) {
        n3 = -1;
        Object[] objectArray = Graphics2D.findPicture(n, n3);
        if (objectArray == null || objectArray[2] == null) {
            Object object = null;
            try {
                object = Graphics2D.createImage(n, n2, n3, true);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                boolean bl;
                do {
                    if (!(bl = (objectArray = Graphics2D.removeOld()) == null)) {
                        Graphics2D.cacheReduce(objectArray);
                    }
                    try {
                        object = Graphics2D.createImage(n, n2, n3, true);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                } while (!bl && object == null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (object != null) {
                Object[] objectArray2;
                objectArray = new Object[6];
                objectArray[2] = object;
                objectArray[3] = new Integer(n3);
                Graphics2D.insertIntoIdSeq((Object[])images[n], objectArray);
                Graphics2D.insertIntoTimeSeq(objectArray);
                while (cacheSize > CACHE_SIZE && (objectArray2 = Graphics2D.removeOld()) != null) {
                    Graphics2D.cacheReduce(objectArray2);
                }
            }
        } else {
            Graphics2D.removeFromTimeSeq(objectArray);
            Graphics2D.insertIntoTimeSeq(objectArray);
        }
        return objectArray[2];
    }

    private static Object getImage(int n, int n2) {
        n2 = -1;
        Object[] objectArray = Graphics2D.findPicture(n, n2);
        return objectArray != null ? objectArray[2] : null;
    }

    private static Object createImage(int n, int n2, int n3, boolean bl) throws Throwable {
        byte[] byArray = null;
        Object var5_5 = null;
        Object var6_6 = null;
        boolean bl2 = ResourceManager.isResourcePacked(resIndexes[n]);
        byArray = ResourceManager.getResource(resIndexes[n]);
        Graphics2D.deallocate(n2);
        Image image = null;
        image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        Graphics2D.dimensions[n << 1] = (short)image.getWidth();
        Graphics2D.dimensions[n * 2 + 1] = (short)image.getHeight();
        if (image != null && bl) {
            cacheSize += image.getWidth() * image.getHeight();
        }
        return image;
    }

    private static int remapCharacter(short[] sArray, char c) {
        int n = 0;
        int n2 = sArray.length / 3 - 1;
        int n3 = n + n2 >> 1;
        int n4 = n3 * 3;
        while (n < n2 && sArray[n4] != c) {
            if (sArray[n4] > c) {
                n2 = n3 - 1;
            } else {
                n = n3 + 1;
            }
            n3 = n + n2 >> 1;
            n4 = n3 * 3;
        }
        return n4 >= 0 && n4 < sArray.length && sArray[n4] == c ? n4 : -1;
    }

    private int drawChar(char c, int n, int n2) {
        int n3 = idCurrentBitmapFont * 2;
        short s = bitmapFontsDescription[bitmapFontsLinks[n3] * 8 + 0];
        int n4 = Graphics2D.getImageId(s);
        Object object = Graphics2D.prefetchImage(n4, s, this.idCurPalette);
        short s2 = bitmapFontsDescription[bitmapFontsLinks[n3] * 8 + 2];
        int n5 = s2 * bitmapFontsLinks[n3 + 1] * bitmapFontsDescription[bitmapFontsLinks[n3] * 8 + 6];
        short[] sArray = bitmapFonts[bitmapFontsLinks[n3]];
        int n6 = Graphics2D.getKerning(idCurrentFont);
        short s3 = dimensions[n4 << 1];
        int n7 = Graphics2D.remapCharacter(sArray, c);
        if (-1 != n7) {
            short s4 = sArray[n7 + 2];
            int n8 = sArray[n7 + 1];
            int n9 = n8 / s3;
            this.g.drawRegion((Image)object, n9 == 0 ? n8 : n8 % s3, n5 + n9 * s2, (int)s4, (int)s2, 0, n, n2, 0);
            return s4 + n6;
        }
        return bitmapFontsDescription[bitmapFontsLinks[n3] * 8 + 5] + n6;
    }

    private void drawBitmapString(String string, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        if ((n5 & 4) != 4) {
            n3 = Graphics2D.xAnchor(n3, Graphics2D.substringWidth(idCurrentFont, string, n, n2), n5);
        }
        n2 += n;
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            n6 += this.drawChar(c, n3 + n6, n4);
        }
    }

    private final void storeClip() {
        this.xClip = this.getClipX();
        this.yClip = this.getClipY();
        this.wClip = this.getClipWidth();
        this.hClip = this.getClipHeight();
    }

    private final void restoreClip() {
        this.setClip(this.xClip, this.yClip, this.wClip, this.hClip);
    }

    private static int xAnchor(int n, int n2, int n3) {
        if ((n3 & 8) == 8) {
            return n - n2;
        }
        if ((n3 & 1) == 1) {
            return n - n2 / 2;
        }
        return n;
    }

    private static final int yAnchor(int n, int n2, int n3) {
        if ((n3 & 0x20) == 32) {
            return n - n2;
        }
        if ((n3 & 2) == 2 || (n3 & 0x40) == 64) {
            return n - n2 / 2;
        }
        return n;
    }

    private static final int yAnchorString(int n, int n2, int n3) {
        n = (n2 & 0x40) == 64 ? (n3 < systemFonts.length ? (n -= vcenterSystemFonts[n3]) : (n -= bitmapFontsDescription[bitmapFontsLinks[(n3 - systemFonts.length) * 2] * 8 + 7])) : Graphics2D.yAnchor(n, Graphics2D.getFontHeight(n3), n2);
        return n;
    }

    private static final void insertIntoTimeSeq(Object[] objectArray) {
        Object[] objectArray2;
        if (objectArray == null) {
            return;
        }
        Object[] objectArray3 = young;
        objectArray[1] = objectArray2 = (Object[])objectArray3[1];
        objectArray2[0] = objectArray;
        objectArray3[1] = objectArray;
        objectArray[0] = objectArray3;
    }

    private static final void removeFromTimeSeq(Object[] objectArray) {
        Object[] objectArray2;
        if (objectArray == null) {
            return;
        }
        Object[] objectArray3 = (Object[])objectArray[0];
        objectArray3[1] = objectArray2 = (Object[])objectArray[1];
        objectArray2[0] = objectArray3;
    }

    private static final void insertIntoIdSeq(Object[] objectArray, Object[] objectArray2) {
        Object[] objectArray3;
        if (objectArray2 == null) {
            return;
        }
        objectArray2[4] = objectArray3 = objectArray[4] != null ? (Object[])objectArray[4] : null;
        if (objectArray3 != null) {
            objectArray3[5] = objectArray2;
        }
        objectArray[4] = objectArray2;
        objectArray2[5] = objectArray;
    }

    private static final void removeFromIdSeq(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        Object[] objectArray2 = objectArray[4] != null ? (Object[])objectArray[4] : null;
        Object[] objectArray3 = (Object[])objectArray[5];
        if (objectArray2 != null) {
            objectArray2[5] = objectArray3;
        }
        objectArray3[4] = objectArray2;
    }

    private static final Object[] removeOld() {
        Object object = old[0];
        if (object == null) {
            return null;
        }
        Object[] objectArray = (Object[])object;
        Graphics2D.removeFromTimeSeq(objectArray);
        Graphics2D.removeFromIdSeq(objectArray);
        return objectArray;
    }

    private static final Object[] findPicture(int n, int n2) {
        Object[] objectArray = (Object[])images[n];
        if (objectArray[4] != null) {
            while (objectArray != null) {
                Object object = objectArray[3];
                if (object != null && ((Integer)object == n2 || n2 == -2)) {
                    return objectArray;
                }
                Object object2 = objectArray[4];
                objectArray = object2 != null ? (Object[])object2 : null;
            }
        }
        return null;
    }

    private static final void cacheReduce(Object[] objectArray) {
        Image image = (Image)objectArray[2];
        cacheSize -= image.getWidth() * image.getHeight();
    }

    private static final int getPaletteID(int n) {
        int n2 = -1;
        Object[] objectArray = Graphics2D.findPicture(Graphics2D.getImageId(n), -2);
        if (objectArray != null) {
            n2 = (Integer)objectArray[3];
        }
        Graphics2D.prefetch(n, n2);
        return n2;
    }

    public static int getBitmapLength(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            int n3 = idCurrentBitmapFont * 2;
            short[] sArray = bitmapFonts[bitmapFontsLinks[n3]];
            int n4 = Graphics2D.getKerning(idCurrentFont);
            int n5 = Graphics2D.remapCharacter(sArray, c);
            if (-1 == n5) continue;
            short s = sArray[n5 + 2];
            n += s + n4;
        }
        return n;
    }

    static {
        CACHE_SIZE = 0x500000;
        cacheSize = 0;
        idCurrentBitmapFont = -1;
        enableMultipalette = true;
    }
}

