/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import portinglib.Debug;
import portinglib.ResourceManager;

class SkeletalAnimation {
    private boolean m_valid = false;
    private float m_scale;
    private float m_biasX;
    private float m_biasY;
    private float m_biasZ;
    private int m_duration;
    private int m_boneCount;
    private byte[] m_data;
    private short[] m_position;
    private short[] m_rotation;
    private static final int SIGNATURE = 20033;
    private static final int VERSION = 3;
    private static final int VERSION_OLD = 2;
    private static final int CHUNK_EOF = 0;
    private static final int CHUNK_POSITION = 1;
    private static final int CHUNK_ROTATION = 2;

    SkeletalAnimation(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n;
            int n2 = dataInputStream.readUnsignedShort();
            byte by = dataInputStream.readByte();
            if (by == 0) {
                by = dataInputStream.readByte();
            }
            switch (by) {
                case 3: {
                    file_header_t file_header_t2 = new file_header_t();
                    file_header_t2.signature = n2;
                    file_header_t2.version = by;
                    file_header_t2.reserved = dataInputStream.readByte();
                    file_header_t2.scale = dataInputStream.readFloat();
                    file_header_t2.biasX = dataInputStream.readFloat();
                    file_header_t2.biasY = dataInputStream.readFloat();
                    file_header_t2.biasZ = dataInputStream.readFloat();
                    file_header_t2.duration = dataInputStream.readUnsignedShort();
                    file_header_t2.nBones = dataInputStream.readUnsignedShort();
                    if (file_header_t2.reserved != 0) {
                        return;
                    }
                    this.m_scale = file_header_t2.scale;
                    this.m_biasX = file_header_t2.biasX;
                    this.m_biasY = file_header_t2.biasY;
                    this.m_biasZ = file_header_t2.biasZ;
                    this.m_duration = file_header_t2.duration;
                    this.m_boneCount = file_header_t2.nBones;
                    file_header_t2 = null;
                    break;
                }
                case 2: {
                    file_header_old_t file_header_old_t2 = new file_header_old_t();
                    file_header_old_t2.signature = n2;
                    file_header_old_t2.version = by;
                    file_header_old_t2.exp = dataInputStream.readUnsignedShort();
                    file_header_old_t2.duration = dataInputStream.readUnsignedShort();
                    file_header_old_t2.nBones = dataInputStream.readUnsignedShort();
                    this.m_duration = file_header_old_t2.duration;
                    this.m_boneCount = file_header_old_t2.nBones;
                    file_header_old_t2 = null;
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown vertion: " + by);
                }
            }
            while ((n = dataInputStream.readUnsignedShort()) != 0) {
                int n3 = dataInputStream.readUnsignedShort() / 2;
                if (n3 == 0) continue;
                short[] sArray = new short[n3];
                switch (n) {
                    case 1: {
                        this.m_position = sArray;
                        break;
                    }
                    case 2: {
                        this.m_rotation = sArray;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown chunk type: " + n);
                    }
                }
                for (int i = 0; i < n3; ++i) {
                    sArray[i] = (short)dataInputStream.readUnsignedShort();
                }
            }
        }
        catch (IOException iOException) {
            Debug.TRACE("cannot read SkeletalAnimation data:");
            iOException.printStackTrace();
            return;
        }
        this.m_valid = true;
        byteArrayInputStream = null;
        dataInputStream = null;
    }

    public static SkeletalAnimation load(int n) {
        SkeletalAnimation skeletalAnimation = null;
        byte[] byArray = ResourceManager.getResource(n);
        if (byArray != null) {
            skeletalAnimation = new SkeletalAnimation(byArray);
            if (!skeletalAnimation.m_valid) {
                Debug.TRACE("SkeletalAnimation resId=" + n + " not valid");
            }
        }
        byArray = null;
        System.gc();
        return skeletalAnimation;
    }

    public int getDuration() {
        return this.m_duration;
    }

    public int getBoneCount() {
        return this.m_boneCount;
    }

    public void DUMP() {
    }

    public boolean getPosition(int n, String string, int n2, float[] fArray) {
        int n3;
        int n4;
        int n5;
        if (this.m_position == null || n < 0 || n >= this.m_boneCount) {
            return false;
        }
        short s = this.m_position[n *= 2];
        int n6 = Math.min(400, this.m_position[n + 1]);
        if (n6 == 0) {
            if (string == "Player01_Pelvis") {
                Debug.TRACE("nKeys=" + n6);
            }
            return false;
        }
        int n7 = s + (n6 - 1) * 4;
        if (n2 <= this.m_position[s]) {
            n5 = this.m_position[s + 1];
            n4 = this.m_position[s + 2];
            n3 = this.m_position[s + 3];
        } else if (n2 >= this.m_position[n7]) {
            n5 = this.m_position[n7 + 1];
            n4 = this.m_position[n7 + 2];
            n3 = this.m_position[n7 + 3];
        } else {
            int n8;
            for (n8 = n7 - 4; n8 > s && this.m_position[n8] > n2; n8 -= 4) {
            }
            short s2 = this.m_position[n8];
            short s3 = this.m_position[n8 + 4];
            if (n2 == s2) {
                n5 = this.m_position[n8 + 1];
                n4 = this.m_position[n8 + 2];
                n3 = this.m_position[n8 + 3];
            } else {
                int n9 = s3 - s2;
                int n10 = n2 - s2;
                n5 = this.m_position[n8 + 1] + (this.m_position[n8 + 5] - this.m_position[n8 + 1]) * n10 / n9;
                n4 = this.m_position[n8 + 2] + (this.m_position[n8 + 6] - this.m_position[n8 + 2]) * n10 / n9;
                n3 = this.m_position[n8 + 3] + (this.m_position[n8 + 7] - this.m_position[n8 + 3]) * n10 / n9;
            }
        }
        fArray[0] = (float)n5 * this.m_scale + this.m_biasX;
        fArray[1] = (float)n4 * this.m_scale + this.m_biasY;
        fArray[2] = (float)n3 * this.m_scale + this.m_biasZ;
        return true;
    }

    public boolean getOrientation(int n, String string, int n2, float[] fArray) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.m_rotation == null || n < 0 || n >= this.m_boneCount) {
            return false;
        }
        short s = this.m_rotation[n *= 2];
        int n7 = Math.min(400, this.m_rotation[n + 1]);
        if (n7 == 0) {
            return false;
        }
        int n8 = s + (n7 - 1) * 5;
        if (n2 <= this.m_rotation[s]) {
            n6 = this.m_rotation[s + 1];
            n5 = this.m_rotation[s + 2];
            n4 = this.m_rotation[s + 3];
            n3 = this.m_rotation[s + 4];
        } else if (n2 >= this.m_rotation[n8]) {
            n6 = this.m_rotation[n8 + 1];
            n5 = this.m_rotation[n8 + 2];
            n4 = this.m_rotation[n8 + 3];
            n3 = this.m_rotation[n8 + 4];
        } else {
            int n9;
            for (n9 = n8 - 5; n9 > s && this.m_rotation[n9] > n2; n9 -= 5) {
            }
            short s2 = this.m_rotation[n9];
            short s3 = this.m_rotation[n9 + 5];
            if (n2 == s2) {
                n6 = this.m_rotation[n9 + 1];
                n5 = this.m_rotation[n9 + 2];
                n4 = this.m_rotation[n9 + 3];
                n3 = this.m_rotation[n9 + 4];
            } else {
                int n10 = s3 - s2;
                int n11 = n2 - s2;
                n6 = this.m_rotation[n9 + 1] + (this.m_rotation[n9 + 6] - this.m_rotation[n9 + 1]) * n11 / n10;
                n5 = this.m_rotation[n9 + 2] + (this.m_rotation[n9 + 7] - this.m_rotation[n9 + 2]) * n11 / n10;
                n4 = this.m_rotation[n9 + 3] + (this.m_rotation[n9 + 8] - this.m_rotation[n9 + 3]) * n11 / n10;
                n3 = this.m_rotation[n9 + 4] + (short)(this.m_rotation[n9 + 9] - this.m_rotation[n9 + 4]) * n11 / n10;
            }
        }
        fArray[0] = (float)n3 * 0.0054933317f;
        fArray[1] = (float)n6 * 3.051851E-5f;
        fArray[2] = (float)n5 * 3.051851E-5f;
        fArray[3] = (float)n4 * 3.051851E-5f;
        return true;
    }

    class file_header_old_t {
        int signature;
        byte version;
        int exp;
        int duration;
        int nBones;

        file_header_old_t() {
        }
    }

    class file_header_t {
        int signature;
        byte version;
        byte reserved;
        float scale;
        float biasX;
        float biasY;
        float biasZ;
        int duration;
        int nBones;

        file_header_t() {
        }
    }
}

