/*
 * Decompiled with CFR 0.152.
 */
package portinglib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Displayable;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;
import portinglib.Framework;
import portinglib.Graphics2D;

public final class Debug {
    public static final boolean DEBUG = false;
    public static final int TRACE_CHANNEL_CONSOLE = 1;
    public static final int TRACE_CHANNEL_ALERT = 2;
    public static final int TRACE_CHANNEL_SCREEN = 4;
    public static final int TRACE_CHANNEL_RMS = 8;
    public static final int TRACE_MASK_RESOURCEMANAGER = Integer.MIN_VALUE;
    public static final int TRACE_MASK_GRAPHICS2D = 0x40000000;
    public static final int TRACE_MASK_SOUNDMANAGER = 0x20000000;
    private static int m_consoleChannelFilter = -1;
    private static int m_screenChannelFilter = 0;
    private static int m_storageChannelFilter = 0;
    private static int m_alertChannelFilter = 0;
    private static int m_traceFilter = 0x1FFFFFFF;
    private static final int STEP = 16;
    private static final String RMS_NAME = "_debug_";
    private static final String RMS_NAME_LAST_RECORD = "_lastrecord_";
    private static final int NUM_MESSAGES = 5;
    private static final int NUM_MESSAGE_ON_SCREEN = 6;
    private static final int TIMEOUT_LIVE_MESSAGE = 5000;
    private static int startScreenPoint;
    private static int endScreenPoint;
    private static int endLogPoint;
    private static Stack scopeStore;
    private static String[] log;
    private static long startTime;

    public static final void setTraceFilter(int n) {
    }

    public static final int getTraceFilter() {
        return m_traceFilter;
    }

    public static final void setChannelMask(int n, int n2) {
    }

    public static final int getChannelMask(int n) {
        switch (n) {
            case 2: {
                return m_alertChannelFilter;
            }
            case 1: {
                return m_consoleChannelFilter;
            }
            case 8: {
                return m_storageChannelFilter;
            }
            case 4: {
                return m_screenChannelFilter;
            }
        }
        throw new IllegalArgumentException();
    }

    public static void TRACE(String string) {
    }

    public static void TRACE(int n, String string) {
    }

    public static void ASSERT(boolean bl, String string) {
    }

    public static final void openScope(String string) {
    }

    public static final void closeScope() {
    }

    public static void traceScope() {
    }

    Debug() {
    }

    static void paint(Graphics2D graphics2D) {
    }

    static final void getRmsData() {
    }

    private static final void closeRS(RecordStore recordStore) {
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static RecordStore openRS(String string) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
        }
        catch (Exception exception) {
            Debug.closeRS(recordStore);
            return null;
        }
        return recordStore;
    }

    private static final void putToRms(String string) {
        RecordStore recordStore = null;
        recordStore = Debug.openRS(RMS_NAME);
        if (recordStore != null) {
            int n = Debug.getNumRecord(recordStore);
            if (n != -1) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                try {
                    dataOutputStream.writeUTF(string);
                    if (n > endLogPoint && n != 0) {
                        recordStore.setRecord(endLogPoint, byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
                    } else {
                        endLogPoint = recordStore.addRecord(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
                    }
                    endLogPoint = endLogPoint == 5 ? 1 : endLogPoint;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Debug.closeOutputStream(dataOutputStream);
                Debug.closeOutputStream(byteArrayOutputStream);
            }
            Debug.closeRS(recordStore);
            Debug.setEndLogPoint();
        }
    }

    private static int getNumRecord(RecordStore recordStore) {
        if (recordStore == null) {
            return -1;
        }
        try {
            int n = recordStore.getNumRecords();
            return n;
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            Debug.closeRS(recordStore);
            return -1;
        }
    }

    private static final void getEndPoint() {
        RecordStore recordStore = null;
        recordStore = Debug.openRS(RMS_NAME_LAST_RECORD);
        if (recordStore != null) {
            DataInputStream dataInputStream = null;
            if (Debug.getNumRecord(recordStore) > 0) {
                try {
                    dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(1)));
                    endLogPoint = dataInputStream.readInt();
                }
                catch (Exception exception) {}
            } else {
                endLogPoint = 0;
            }
            Debug.closeRS(recordStore);
            Debug.closeInputStream(dataInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void setEndLogPoint() {
        RecordStore recordStore = null;
        recordStore = Debug.openRS(RMS_NAME_LAST_RECORD);
        if (recordStore != null) {
            int n = Debug.getNumRecord(recordStore);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeInt(endLogPoint);
                if (n > 0) {
                    recordStore.setRecord(1, byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
                } else if (n != -1) {
                    recordStore.addRecord(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
                }
                Debug.closeRS(recordStore);
            }
            catch (Exception exception) {
                Debug.closeRS(recordStore);
            }
            finally {
                Debug.closeOutputStream(dataOutputStream);
                Debug.closeOutputStream(byteArrayOutputStream);
            }
        }
    }

    private static final void getFromRms() {
        RecordStore recordStore = null;
        recordStore = Debug.openRS(RMS_NAME);
        if (recordStore != null) {
            int n = Debug.getNumRecord(recordStore);
            if (n > 0) {
                DataInputStream dataInputStream = null;
                try {
                    int n2;
                    String string = "";
                    int n3 = endLogPoint;
                    do {
                        if (n3 > n) continue;
                        dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(n3)));
                        string = string + dataInputStream.readUTF() + '\n';
                    } while ((n3 = (n2 = (n3 + n - 1) % n) == 0 ? n : n2) != endLogPoint);
                    Debug.TRACE(m_traceFilter, string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Debug.closeInputStream(dataInputStream);
            }
            Debug.closeRS(recordStore);
        }
        try {
            RecordStore.deleteRecordStore((String)RMS_NAME);
            RecordStore.deleteRecordStore((String)RMS_NAME_LAST_RECORD);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private static final void closeOutputStream(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final void outToConsole(String string) {
        System.out.println(string);
    }

    private static final void alert(String string) {
        Alert alert = new Alert("Error", string, null, AlertType.ERROR);
        alert.setTimeout(-2);
        Framework.theDisplay.setCurrent((Displayable)alert);
    }

    private static final void toScreen(String string) {
        endScreenPoint = (endScreenPoint + 1) % 5;
        Debug.log[Debug.endScreenPoint] = string;
        if (startScreenPoint == endScreenPoint) {
            startScreenPoint = (startScreenPoint + 1) % 5;
        }
        if ((endScreenPoint - startScreenPoint + 5) % 5 > 5) {
            startScreenPoint = (0 + endScreenPoint) % 5;
        }
        startTime = System.currentTimeMillis();
    }

    static {
        scopeStore = new Stack();
        log = new String[5];
    }
}

