/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import portinglib.Application;
import portinglib.Debug;
import portinglib.Graphics2D;
import portinglib.SoundManager;
import portinglib.StringTable;
import userapp.ExpoInObject;
import userapp.Game;
import userapp.LoaderBar;
import userapp.MenuBaseChoosePlayer;
import userapp.MenuBaseSinglePlate;
import userapp.MenuDialogGameResults;
import userapp.MenuDialogMainMenu;
import userapp.MenuDialogWinnerResults;
import userapp.MenuLanguageSelection;
import userapp.OptimizationUtils;
import userapp.PortingUtils;
import userapp.RunningText;

public final class UserApp
extends Application {
    private static Image shadow;
    public static boolean gameFreeze;
    private static Graphics2D pic;
    private static int[] rgbData;
    public DefaultCharacterRecord[] defaultCharParams = new DefaultCharacterRecord[4];
    public CharacterRecord[] records = new CharacterRecord[4];
    public Settings settings = new Settings();
    public MenuDialogGameResults gameResMenu;
    public MenuDialogWinnerResults winnerResMenu;
    public MenuDialogMainMenu mainMenu;
    public MenuBaseChoosePlayer playerMenu;
    public MenuBaseChoosePlayer laneMenu;
    public MenuLanguageSelection langMenu;
    public LoaderBar m_pLoaderBar;
    public RunningText m_pRunningText;
    public Game game;
    public boolean initMainMenu_after_continueScreen = false;
    public boolean m_continueScreenIsActive = false;
    public boolean m_gameResMenuIsActive = false;
    public boolean m_winnerResMenuIsActive = false;
    public boolean m_laneMenuIsActive = false;
    public boolean m_playerMenuIsActive = false;
    public boolean m_menuIsActive = false;
    public static boolean m_splashIsActive;
    private boolean menubackWasDeallocated = false;
    public static boolean m_LangSelIsActive;
    public static boolean m_SoundPoundOffScreen;
    private final int CHECK_CODE;
    private final int DATA_SIZE;
    private RecordStore rs;
    private int currentCheatKey;
    private int beginSplashTime;
    private final int SPLASH_SLEEP_TIME;
    public boolean gameReady = false;
    private final int cheatsSequenceSize;
    private final int[] cheatsSequence = new int[]{-1, -1, -6, -6, -2, -5, -2, -5, 49, 51, 49, 51};
    public boolean cheatsEnabled = false;
    public boolean specialAnimCheatEnabled = false;
    public boolean useStrips = false;
    public static byte gamesPlayed;
    public static final int AMF_BOWLING = 0;
    public static final int BLOX = 1;
    public static final int CAPONE = 2;
    public static final int SCUBA = 3;
    public static boolean precacheState;
    private static final boolean DEBUG = false;

    public UserApp() {
        this.CHECK_CODE = 13;
        this.DATA_SIZE = 1072;
        this.SPLASH_SLEEP_TIME = 2000;
        this.cheatsSequenceSize = 12;
    }

    protected void onStart() {
        try {
            int[] nArray = new int[1024];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = -1895825408;
            }
            shadow = Image.createRGBImage((int[])nArray, (int)32, (int)32, (boolean)true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.getDemoCounter();
        this.loadPrefs();
        this.game = new Game(this);
        if (this.game == null) {
            return;
        }
        this.m_pLoaderBar = new LoaderBar(this);
        if (this.m_pLoaderBar == null) {
            return;
        }
        this.game.getGameWorld().expoInObj = new ExpoInObject(this.game);
        this.mainMenu = new MenuDialogMainMenu(this.game);
        Game.m_app.mainMenu.onStart();
        this.langMenu = new MenuLanguageSelection();
        m_LangSelIsActive = true;
        this.gameReady = true;
    }

    public void startSplashScreens() {
        this.m_menuIsActive = false;
        m_splashIsActive = true;
        this.m_pLoaderBar.start(4);
    }

    private void loadApp() {
        int n = (int)System.currentTimeMillis();
        if (this.beginSplashTime == 0) {
            this.beginSplashTime = n;
        }
        if (n - this.beginSplashTime < 2000) {
            return;
        }
        switch (this.m_pLoaderBar.getState()) {
            case 0: {
                this.beginSplashTime = n;
                this.m_pRunningText = new RunningText(this);
                break;
            }
            case 1: {
                this.beginSplashTime = n;
                this.playerMenu = new MenuBaseChoosePlayer(this.game, true);
                this.laneMenu = new MenuBaseChoosePlayer(this.game, false);
                this.gameResMenu = new MenuDialogGameResults(this.game);
                this.winnerResMenu = new MenuDialogWinnerResults(this.game);
                break;
            }
            case 2: {
                this.beginSplashTime = n;
                Game.m_app.mainMenu.loadGroup();
                Game.m_app.mainMenu.setState(142, false);
                break;
            }
            case 3: {
                this.beginSplashTime = n;
                this.game.init();
                this.m_pLoaderBar.stop();
                m_splashIsActive = false;
                this.m_menuIsActive = true;
                Game.m_app.mainMenu.onStart();
                Graphics2D.deallocate(56);
                Graphics2D.deallocate(55);
                Graphics2D.deallocate(53);
                Graphics2D.deallocate(54);
                return;
            }
        }
        this.m_pLoaderBar.nextState();
    }

    protected int update(int n) {
        if (this.m_continueScreenIsActive) {
            return 0;
        }
        if (!PortingUtils.PROFILE) {
            PortingUtils.beginProf("UPDATE", true);
            Game.pickUpdateTime();
            if (this.isAnyMenuActive() && this.settings.musicOn) {
                try {
                    Thread.sleep(10L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (m_splashIsActive) {
                this.loadApp();
            } else if (this.m_winnerResMenuIsActive) {
                this.winnerResMenu.update(n);
            } else if (this.m_gameResMenuIsActive) {
                this.gameResMenu.update(n);
            } else if (this.m_menuIsActive) {
                this.mainMenu.update(n);
            } else if (this.m_playerMenuIsActive) {
                this.playerMenu.update(n);
            } else if (this.m_laneMenuIsActive) {
                this.laneMenu.update(n);
            } else if (m_LangSelIsActive) {
                this.langMenu.update(n);
            } else if (!gameFreeze) {
                this.game.update(n);
            }
            PortingUtils.updateCamera();
            if (this.m_pRunningText != null) {
                this.m_pRunningText.update(n);
            }
            PortingUtils.endProf(true);
        }
        return 0;
    }

    public void playSound(int n, boolean bl) {
        if (this.settings.soundOn && !precacheState) {
            SoundManager.stopAllSounds();
            SoundManager.setSoundVolume(30);
            SoundManager.playSound(n, bl);
        }
    }

    public void stopSound(int n) {
        if (this.settings.soundOn) {
            SoundManager.stopSound(n);
        }
    }

    public void playMenuSound() {
        if (this.settings.musicOn && this.isAnyMenuActive() && !m_splashIsActive && !this.m_continueScreenIsActive && !SoundManager.isPlaying(4)) {
            SoundManager.setSoundVolume(30);
            if (!MenuDialogMainMenu.isPaused) {
                SoundManager.playSound(4, true);
            }
        }
    }

    protected void onKeyPressed(int n) {
        if (MenuBaseSinglePlate.demoSoftkey) {
            if (MenuBaseSinglePlate.whichDemoScreen == 1) {
                this.playerMenu.onKeyPressed(n);
            } else if (MenuBaseSinglePlate.whichDemoScreen == 2) {
                if (n == -21) {
                    MenuBaseSinglePlate.doDemoScreen = false;
                    MenuBaseSinglePlate.demoSoftkey = false;
                    try {
                        if (Application.platformRequest(Application.getProperty("ms-demoUrl"))) {
                            UserApp.destroy();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    UserApp.destroy();
                } else if (n == -22) {
                    MenuBaseSinglePlate.doDemoScreen = false;
                    MenuBaseSinglePlate.demoSoftkey = false;
                }
            } else if (MenuBaseSinglePlate.whichDemoScreen == 3) {
                if (n == -21) {
                    MenuBaseSinglePlate.doDemoScreen = false;
                    MenuBaseSinglePlate.demoSoftkey = false;
                    this.getTheGame(0);
                } else if (n == -22) {
                    UserApp.destroy();
                    MenuBaseSinglePlate.doDemoScreen = false;
                    MenuBaseSinglePlate.demoSoftkey = false;
                }
            }
        } else {
            if (this.m_continueScreenIsActive) {
                if (n == -20 || n == 53) {
                    this.m_continueScreenIsActive = false;
                    if (this.initMainMenu_after_continueScreen) {
                        Game.m_app.mainMenu.setState(144, false);
                        Game.m_app.mainMenu.onStart();
                        this.initMainMenu_after_continueScreen = false;
                    }
                    this.playMenuSound();
                }
                return;
            }
            if (this.m_menuIsActive && this.mainMenu.isAbout() && n == 49 && this.cheatsEnabled) {
                boolean bl = this.specialAnimCheatEnabled = !this.specialAnimCheatEnabled;
            }
            if (n == 35 && (this.settings.soundOn || this.settings.musicOn) && !m_LangSelIsActive && !m_SoundPoundOffScreen) {
                this.settings.soundOn = false;
                this.settings.musicOn = false;
                SoundManager.stopAllSounds();
                return;
            }
            if (!(n != 35 || this.settings.soundOn && this.settings.musicOn || m_LangSelIsActive || m_SoundPoundOffScreen)) {
                this.settings.soundOn = true;
                this.settings.musicOn = true;
                this.playMenuSound();
                if (!this.isAnyMenuActive() && this.game.getGameWorld().getGameState() == 1) {
                    this.playSound(2, true);
                }
                return;
            }
            if (this.game != null && this.game.getGameWorld().expoInObj != null && this.game.getGameWorld().expoInObj.onKeyPressed(n)) {
                return;
            }
            if (m_splashIsActive) {
                this.beginSplashTime -= 2000;
                return;
            }
            if (this.m_pRunningText != null) {
                this.m_pRunningText.onKeyPressed(n);
            }
            if (this.m_menuIsActive) {
                this.mainMenu.onKeyPressed(n);
            } else if (this.m_gameResMenuIsActive) {
                this.gameResMenu.onKeyPressed(n);
            } else if (this.m_winnerResMenuIsActive) {
                this.winnerResMenu.onKeyPressed(n);
            } else if (this.m_playerMenuIsActive) {
                this.playerMenu.onKeyPressed(n);
            } else if (this.m_laneMenuIsActive) {
                this.laneMenu.onKeyPressed(n);
            } else if (m_LangSelIsActive) {
                this.langMenu.onKeyPressed(n);
            } else if (this.game != null) {
                this.game.onKeyPressed(n);
            }
        }
    }

    protected void onKeyReleased(int n) {
        if (precacheState && !this.m_continueScreenIsActive) {
            return;
        }
        if (this.game != null && !this.isAnyMenuActive()) {
            this.game.onKeyReleased(n);
        }
    }

    public boolean isAnyMenuActive() {
        return this.m_menuIsActive || this.m_gameResMenuIsActive || this.m_winnerResMenuIsActive || this.m_laneMenuIsActive || m_splashIsActive || this.m_playerMenuIsActive || m_LangSelIsActive;
    }

    protected void onPause() {
        pic = null;
        if (this.m_continueScreenIsActive) {
            return;
        }
        SoundManager.stopAllSounds();
        this.m_continueScreenIsActive = true;
        if (this.game != null && !this.isAnyMenuActive() && !this.game.getGameWorld().isLoading() && this.gameReady) {
            this.initMainMenu_after_continueScreen = true;
            this.game.pauseMatch();
        }
    }

    protected void onResume() {
        this.m_continueScreenIsActive = true;
        SoundManager.stopAllSounds();
    }

    protected void onDestroy() {
        this.savePrefs();
    }

    public static void restoreBufferClip() {
        if (pic != null) {
            pic.setClip(0, 0, pic.getWidth(), pic.getHeight());
        }
    }

    protected void paint(Graphics2D graphics2D) {
        if (!PortingUtils.PROFILE) {
            PortingUtils.beginProf("PAINT", true);
        }
        if (!PortingUtils.PROFILE) {
            if (pic == null || pic.getWidth() != UserApp.getWidth() || pic.getHeight() != UserApp.getHeight()) {
                pic = new Graphics2D(UserApp.getWidth(), UserApp.getHeight());
            }
            if (!(this.useStrips || !this.game.getGameWorld().expoInObj.isVisible || this.game.getGameWorld().isLoading() || this.m_continueScreenIsActive || precacheState)) {
                this.renderAll(pic);
                if (rgbData == null || pic.getWidth() != UserApp.getWidth() || pic.getHeight() != UserApp.getHeight()) {
                    rgbData = new int[UserApp.getWidth() * UserApp.getHeight()];
                }
                pic.getRGB(rgbData, 0, UserApp.getWidth(), 0, 0, UserApp.getWidth(), UserApp.getHeight());
                graphics2D.drawRGB(this.game.getGameWorld().expoInObj.postProcess(rgbData), 0, UserApp.getWidth(), 0, 0, UserApp.getWidth(), UserApp.getHeight(), false);
            } else {
                if (this.m_continueScreenIsActive) {
                    pic.setClip(0, 0, pic.getWidth(), pic.getHeight());
                }
                this.renderAll(pic);
                graphics2D.drawImage(pic, 0, 0, 0);
            }
        } else {
            PortingUtils.paintProfiling(graphics2D);
        }
        if (!this.m_continueScreenIsActive) {
            if (!(this.game.getGameWorld().expoInObj == null || this.game.getGameWorld().isLoading() || this.m_continueScreenIsActive || precacheState)) {
                this.game.getGameWorld().expoInObj.draw(graphics2D);
            }
            if (!PortingUtils.PROFILE) {
                PortingUtils.endProf(true);
            }
        }
    }

    private void drawDebug(Graphics2D graphics2D) {
    }

    private void renderAll(Graphics2D graphics2D) {
        PortingUtils.beginProf("paintRect");
        if (!OptimizationUtils.isImage() || PortingUtils.PROFILE || this.m_continueScreenIsActive) {
            graphics2D.setColor(0);
            graphics2D.setFillColor(m_splashIsActive && !this.m_continueScreenIsActive ? 0xFFFFFF : 0);
            graphics2D.setFillMode(1);
            graphics2D.drawRect(0, 0, graphics2D.getClipWidth(), graphics2D.getClipHeight());
        }
        Game.pickUpdateTime();
        PortingUtils.endProf();
        if (this.m_continueScreenIsActive && !MenuBaseSinglePlate.doDemoScreen) {
            graphics2D.setFont(2);
            graphics2D.drawString(StringTable.get(317), UserApp.getWidth() / 2, UserApp.getHeight() / 2, 3);
            this.drawDebug(graphics2D);
            return;
        }
        if (this.game != null && this.game.getGameWorld().isLoading() && this.m_pLoaderBar != null) {
            this.menubackWasDeallocated = false;
            this.m_pLoaderBar.render2D(graphics2D);
        } else if (this.isAnyMenuActive()) {
            this.menubackWasDeallocated = false;
            if (this.m_gameResMenuIsActive) {
                this.gameResMenu.render3D(graphics2D);
                this.gameResMenu.render2D(graphics2D);
            } else if (this.m_winnerResMenuIsActive) {
                this.winnerResMenu.render3D(graphics2D);
                this.winnerResMenu.render2D(graphics2D);
            } else if (this.m_menuIsActive) {
                this.mainMenu.render3D(graphics2D);
                this.mainMenu.render2D(graphics2D);
            } else if (this.m_laneMenuIsActive) {
                this.laneMenu.render3D(graphics2D);
                this.laneMenu.render2D(graphics2D);
            } else if (this.m_playerMenuIsActive) {
                this.playerMenu.render3D(graphics2D);
                this.playerMenu.render2D(graphics2D);
            } else if (m_splashIsActive && this.m_pLoaderBar != null) {
                this.renderSplashes(graphics2D);
            } else if (m_LangSelIsActive) {
                this.langMenu.render3D(graphics2D);
                this.langMenu.render2D(graphics2D);
            }
        } else if (this.game != null) {
            if (!this.menubackWasDeallocated) {
                Graphics2D.deallocate(38);
                this.menubackWasDeallocated = true;
                System.gc();
            }
            this.game.render3D(graphics2D);
        }
        if (this.m_pRunningText != null) {
            this.m_pRunningText.render2D(graphics2D);
        }
        this.drawDebug(graphics2D);
    }

    private void renderSplashes(Graphics2D graphics2D) {
        int n = 0;
        switch (this.m_pLoaderBar.getState()) {
            case 0: {
                n = 56;
                break;
            }
            case 1: {
                n = 55;
                break;
            }
            case 2: {
                n = 53;
                break;
            }
            case 3: {
                n = 54;
                break;
            }
            case 4: {
                n = 38;
            }
        }
        int n2 = UserApp.getWidth() / 2;
        int n3 = UserApp.getHeight() / 2;
        graphics2D.drawImage(n, n2, n3, 3);
        if (this.m_pLoaderBar.getState() == 4) {
            if (gamesPlayed < 3) {
                UserApp.whatToShow(false, graphics2D);
                MenuBaseSinglePlate.whichDemoScreen = (byte)2;
                MenuBaseSinglePlate.demoEndShowed = false;
            } else {
                UserApp.whatToShow(true, graphics2D);
                MenuBaseSinglePlate.whichDemoScreen = (byte)2;
                MenuBaseSinglePlate.demoEndShowed = false;
            }
        }
    }

    public static void darkenBackground(Graphics2D graphics2D) {
        Image image = null;
        int[] nArray = new int[UserApp.getWidth() * UserApp.getHeight()];
        for (int i = 0; i < UserApp.getWidth() * UserApp.getHeight(); ++i) {
            nArray[i] = -16777216;
        }
        image = Image.createRGBImage((int[])nArray, (int)UserApp.getWidth(), (int)UserApp.getHeight(), (boolean)true);
        nArray = null;
        graphics2D.getGraphics().drawImage(image, UserApp.getWidth() / 2, UserApp.getHeight() / 2, 3);
        image = null;
    }

    public static void whatToShow(boolean bl, Graphics2D graphics2D) {
        UserApp.darkenBackground(graphics2D);
        MenuBaseSinglePlate.demoSoftkey = true;
        graphics2D.setColor(0xFFFFFF);
        graphics2D.setFillColor(0xFFFFFF);
        graphics2D.drawRect(0, 0, 240, 300);
        graphics2D.drawImage(55, 120, 150, 3);
        if (shadow != null) {
            for (int i = 0; i < 240; i += 32) {
                for (int j = 0; j < 300; j += 32) {
                    graphics2D.getGraphics().drawImage(shadow, i, j, 20);
                }
            }
        }
        if (MenuBaseSinglePlate.whichDemoScreen == 1) {
            graphics2D.drawString(StringTable.get(341), 120, 5, 17);
            UserApp.drawBlinkStr(graphics2D, 333, 3000, 10, 30);
            graphics2D.drawString(StringTable.get(337), 5, 284, 20);
            graphics2D.drawString(StringTable.get(142), 235, 284, 24);
        } else if (MenuBaseSinglePlate.whichDemoScreen == 2) {
            if (gamesPlayed != 3) {
                graphics2D.drawString(StringTable.get(341), 120, 1, 17);
                UserApp.drawBlinkStr(graphics2D, 333, 3000, 10, 30);
            } else {
                graphics2D.drawString(StringTable.get(342), 120, 5, 17);
                UserApp.drawBlinkStr(graphics2D, 334, 3000, 25, 30);
            }
            graphics2D.drawString(StringTable.get(340), 5, 284, 20);
            graphics2D.drawString(StringTable.get(142), 235, 284, 24);
        } else if (MenuBaseSinglePlate.whichDemoScreen == 3) {
            if (gamesPlayed != 3) {
                graphics2D.drawString(StringTable.get(341), 120, 1, 17);
                UserApp.drawBlinkStr(graphics2D, 333, 3000, 10, 30);
                UserApp.drawBlinkStr(graphics2D, 334, 3000, 25, 100);
            } else {
                graphics2D.drawString(StringTable.get(342), 120, 5, 17);
                UserApp.drawBlinkStr(graphics2D, 334, 3000, 25, 30);
            }
            graphics2D.drawString(StringTable.get(340), 5, 284, 20);
            graphics2D.drawString(StringTable.get(33), 235, 284, 24);
        }
        UserApp.drawText(graphics2D, StringTable.get(332), 40, 140);
    }

    public static void drawText(Graphics2D graphics2D, String string, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = 200;
        int n6 = 0;
        while (n6 < string.length()) {
            int n7 = Graphics2D.fit(string, n6, 2, n5);
            graphics2D.drawSubstring(string, n6, n7 - n6, n3, n4, 18);
            n4 += Graphics2D.getFontHeight(2);
            n6 = StringTable.skip(string, n7);
        }
    }

    public static void drawBlinkStr(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5 = n3;
        int n6 = n4;
        if (n == 333) {
            String[] stringArray = new String[]{Integer.toString(3 - gamesPlayed)};
            UserApp.drawText(graphics2D, StringTable.get(StringTable.get(n), stringArray), n3, n4);
        } else {
            UserApp.drawText(graphics2D, StringTable.get(n), n3, n4);
        }
    }

    void setRunStr(String string) {
        this.m_pRunningText.set(string);
    }

    void setRunStr(int n) {
        if (n == 163) {
            this.m_pRunningText.set(ExpoInObject.formatTextWithButtons(163));
        } else {
            this.m_pRunningText.set(n);
        }
    }

    boolean isRunStrActive() {
        return this.m_pRunningText.isActive();
    }

    int getRunStrLastTime() {
        return this.m_pRunningText.getLastActiveTime();
    }

    void regularRunStr(int n) {
        this.m_pRunningText.regular(n);
    }

    void setActiveRunStr(boolean bl) {
        if (bl) {
            this.m_pRunningText.restart();
        } else {
            this.m_pRunningText.setActive(false);
        }
    }

    public void saveDemoCounter(byte by) {
        try {
            this.rs = RecordStore.openRecordStore((String)"demo_mode", (boolean)true);
            byte[] byArray = new byte[]{by};
            if (this.rs.getNumRecords() == 0) {
                this.rs.addRecord(byArray, 0, 1);
                gamesPlayed = byArray[0];
            } else {
                this.rs.setRecord(1, byArray, 0, 1);
            }
            this.rs.closeRecordStore();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void getDemoCounter() {
        try {
            this.rs = RecordStore.openRecordStore((String)"demo_mode", (boolean)true);
            byte[] byArray = new byte[1];
            if (this.rs.getNumRecords() == 0) {
                this.rs.closeRecordStore();
                this.saveDemoCounter((byte)0);
                return;
            }
            this.rs.getRecord(1, byArray, 0);
            gamesPlayed = byArray[0];
            this.rs.closeRecordStore();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean savePrefs() {
        int n;
        if (MenuBaseSinglePlate.demoEnabled) {
            return true;
        }
        boolean bl = false;
        byte[] byArray = new byte[1072];
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 6; ++n) {
            byArray[n2++] = (byte)(this.settings.unlockedLanes[n] ? 1 : 0);
            if (!bl) continue;
            Debug.TRACE(n2 + " settings.unlockedLanes[i]=" + byArray[n2 - 1]);
        }
        byArray[n2++] = (byte)(this.settings.musicOn ? 1 : 0);
        if (bl) {
            Debug.TRACE(n2 + " settings.musicOn=" + byArray[n2 - 1]);
        }
        byArray[n2++] = (byte)(this.settings.soundOn ? 1 : 0);
        if (bl) {
            Debug.TRACE(n2 + " settings.soundOn=" + byArray[n2 - 1]);
        }
        byArray[n2++] = (byte)(this.settings.vibOn ? 1 : 0);
        if (bl) {
            Debug.TRACE(n2 + " settings.vibOn=" + byArray[n2 - 1]);
        }
        for (n = 0; n < 4; ++n) {
            if (bl) {
                Debug.TRACE("");
            }
            byArray[n2++] = (byte)(this.records[n].localScore & 0xFF);
            if (bl) {
                Debug.TRACE(n2 + " records[i].localScore=" + byArray[n2 - 1]);
            }
            byArray[n2++] = (byte)((this.records[n].localScore & 0xFF00) >> 8);
            if (bl) {
                Debug.TRACE(n2 + " records[i].localScore=" + byArray[n2 - 1]);
            }
            byArray[n2++] = (byte)(this.records[n].localMatches & 0xFF);
            if (bl) {
                Debug.TRACE(n2 + " records[i].localMatches=" + byArray[n2 - 1]);
            }
            byArray[n2++] = (byte)((this.records[n].localMatches & 0xFF00) >> 8);
            if (bl) {
                Debug.TRACE(n2 + " records[i].localMatches=" + byArray[n2 - 1]);
            }
            byArray[n2++] = (byte)(this.records[n].localMatchRecord & 0xFF);
            if (bl) {
                Debug.TRACE(n2 + " records[i].localMatchRecord=" + byArray[n2 - 1]);
            }
            byArray[n2++] = (byte)((this.records[n].localMatchRecord & 0xFF00) >> 8);
            if (bl) {
                Debug.TRACE(n2 + " records[i].localMatchRecord=" + byArray[n2 - 1]);
            }
            byArray[n2++] = (byte)(this.records[n].localTournRecord & 0xFF);
            if (bl) {
                Debug.TRACE(n2 + " records[i].localTournRecord=" + byArray[n2 - 1]);
            }
            byArray[n2++] = (byte)((this.records[n].localTournRecord & 0xFF00) >> 8);
            if (bl) {
                Debug.TRACE(n2 + " records[i].localTournRecord=" + byArray[n2 - 1]);
            }
            byArray[n2++] = this.records[n].nextMatch;
            if (bl) {
                Debug.TRACE(n2 + " records[i].nextMatch=" + byArray[n2 - 1]);
            }
            byArray[n2++] = this.records[n].precisionSequence;
            if (bl) {
                Debug.TRACE(n2 + " records[i].precisionSequence=" + byArray[n2 - 1]);
            }
            byArray[n2++] = this.records[n].tournamentsUnlocked;
            if (bl) {
                Debug.TRACE(n2 + " records[i].tournamentsUnlocked=" + byArray[n2 - 1]);
            }
            byArray[n2++] = this.records[n].control;
            if (bl) {
                Debug.TRACE(n2 + " records[i].control=" + byArray[n2 - 1]);
            }
            byArray[n2++] = this.records[n].power;
            if (bl) {
                Debug.TRACE(n2 + " records[i].power=" + byArray[n2 - 1]);
            }
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    byArray[n2++] = (byte)(this.records[n].unlockedStats[i][j] ? 1 : 0);
                }
            }
            byArray[n2++] = (byte)(this.records[n].unlocked ? 1 : 0);
            if (bl) {
                Debug.TRACE(n2 + " records[i].unlocked=" + byArray[n2 - 1]);
            }
            byArray[n2++] = (byte)(this.records[n].ballWon ? 1 : 0);
            if (bl) {
                Debug.TRACE(n2 + " records[i].ballWon=" + byArray[n2 - 1]);
            }
            byArray[n2++] = (byte)(this.records[n].goldenBallWon ? 1 : 0);
            if (!bl) continue;
            Debug.TRACE(n2 + " records[i].goldenBallWon=" + byArray[n2 - 1]);
        }
        for (n = 0; n < n2; ++n) {
            n3 += byArray[n];
        }
        byArray[n2++] = (byte)n3;
        if (bl) {
            Debug.TRACE(n2 + " data[bufferIndex-1]=" + byArray[n2 - 1] + " bufferIndex=" + n2);
        }
        try {
            this.rs = RecordStore.openRecordStore((String)"amf_store", (boolean)true);
            if (this.rs.getNumRecords() > 0) {
                this.rs.setRecord(1, byArray, 0, byArray.length);
            } else {
                this.rs.addRecord(byArray, 0, byArray.length);
            }
            this.rs.closeRecordStore();
            byArray = null;
            System.gc();
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    private short readInt(byte[] byArray, int n) {
        int n2 = byArray[n];
        if (n2 < 0) {
            n2 += 256;
        }
        return (short)(n2 += 256 * byArray[n + 1]);
    }

    boolean readPrefs() {
        int n;
        if (MenuBaseSinglePlate.demoEnabled) {
            this.erasePrefs();
            return false;
        }
        boolean bl = false;
        byte[] byArray = new byte[1072];
        int n2 = 0;
        int n3 = 0;
        this.rs = null;
        try {
            this.rs = RecordStore.openRecordStore((String)"amf_store", (boolean)true);
            if (this.rs.getNumRecords() == 0) {
                this.rs.closeRecordStore();
                return false;
            }
            byArray = this.rs.getRecord(1);
            this.rs.closeRecordStore();
        }
        catch (Exception exception) {
            return false;
        }
        for (n = 0; n < 6; ++n) {
            boolean bl2 = this.settings.unlockedLanes[n] = byArray[n2++] == 1;
            if (!bl) continue;
            Debug.TRACE(n2 + " settings.unlockedLanes[i]=" + this.settings.unlockedLanes[n]);
        }
        this.settings.musicOn = false;
        ++n2;
        if (bl) {
            Debug.TRACE(n2 + " settings.musicOn=" + this.settings.musicOn);
        }
        this.settings.soundOn = false;
        ++n2;
        if (bl) {
            Debug.TRACE(n2 + " settings.soundOn=" + this.settings.soundOn);
        }
        boolean bl3 = this.settings.vibOn = byArray[n2++] == 1;
        if (bl) {
            Debug.TRACE(n2 + " settings.vibOn=" + this.settings.vibOn);
        }
        for (n = 0; n < 4; ++n) {
            if (bl) {
                Debug.TRACE("");
            }
            this.records[n].localScore = this.readInt(byArray, n2++);
            ++n2;
            if (bl) {
                Debug.TRACE(n2 + " records[i].localScore=" + this.records[n].localScore);
            }
            this.records[n].localMatches = this.readInt(byArray, n2++);
            ++n2;
            if (bl) {
                Debug.TRACE(n2 + " records[i].localMatches=" + this.records[n].localMatches);
            }
            this.records[n].localMatchRecord = this.readInt(byArray, n2++);
            ++n2;
            if (bl) {
                Debug.TRACE(n2 + " records[i].localMatchRecord=" + this.records[n].localMatchRecord);
            }
            this.records[n].localTournRecord = this.readInt(byArray, n2++);
            ++n2;
            if (bl) {
                Debug.TRACE(n2 + " records[i].localTournRecord=" + this.records[n].localMatchRecord);
            }
            this.records[n].nextMatch = byArray[n2++];
            if (bl) {
                Debug.TRACE(n2 + " records[i].nextMatch=" + this.records[n].nextMatch);
            }
            this.records[n].precisionSequence = byArray[n2++];
            if (bl) {
                Debug.TRACE(n2 + " records[i].precisionSequence=" + this.records[n].precisionSequence);
            }
            this.records[n].tournamentsUnlocked = byArray[n2++];
            if (bl) {
                Debug.TRACE(n2 + " records[i].tournamentsUnlocked=" + this.records[n].tournamentsUnlocked);
            }
            this.records[n].control = byArray[n2++];
            if (bl) {
                Debug.TRACE(n2 + " records[i].control=" + this.records[n].control);
            }
            this.records[n].power = byArray[n2++];
            if (bl) {
                Debug.TRACE(n2 + " records[i].power=" + this.records[n].power);
            }
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.records[n].unlockedStats[i][j] = byArray[n2++] == 1;
                }
            }
            boolean bl4 = this.records[n].unlocked = byArray[n2++] == 1;
            if (bl) {
                Debug.TRACE(n2 + " records[i].unlocked=" + this.records[n].unlocked);
            }
            boolean bl5 = this.records[n].ballWon = byArray[n2++] == 1;
            if (bl) {
                Debug.TRACE(n2 + " records[i].ballWon=" + this.records[n].ballWon);
            }
            boolean bl6 = this.records[n].goldenBallWon = byArray[n2++] == 1;
            if (!bl) continue;
            Debug.TRACE(n2 + " records[i].goldenBallWon=" + this.records[n].goldenBallWon);
        }
        for (n = 0; n < n2; ++n) {
            n3 += byArray[n];
        }
        if (byArray[n2++] != (byte)n3) {
            // empty if block
        }
        if (bl) {
            Debug.TRACE(n2 + " checksum=" + n3 + " data[bufferIndex-1]=" + byArray[n2 - 1] + " bufferIndex=" + n2);
        }
        byArray = null;
        System.gc();
        return true;
    }

    void loadPrefs() {
        if (MenuBaseSinglePlate.demoEnabled) {
            this.erasePrefs();
            return;
        }
        this.defaultCharParams[0] = new DefaultCharacterRecord(0, 3);
        this.defaultCharParams[2] = new DefaultCharacterRecord(1, 2);
        this.defaultCharParams[1] = new DefaultCharacterRecord(2, 1);
        this.defaultCharParams[3] = new DefaultCharacterRecord(3, 2);
        String string = null;
        if (Application.getProperty("ms-demoUrl") != null) {
            string = Application.getProperty("ms-demoMode");
            if (string != null) {
                if (string.compareTo("1") == 0) {
                    MenuBaseSinglePlate.demoEnabled = false;
                } else if (string.compareTo("2") == 0) {
                    MenuBaseSinglePlate.demoEnabled = true;
                }
            } else {
                MenuBaseSinglePlate.demoEnabled = false;
            }
        }
        String string2 = Application.getProperty("ms-upSell");
        MenuBaseSinglePlate.upsellEnabled = false;
        if (Application.getProperty("ms-upSellUrl") != null && string2 != null) {
            MenuBaseSinglePlate.upsellEnabled = string2.equals("2");
        }
        for (int i = 0; i < 4; ++i) {
            if (this.records[i] != null) continue;
            this.records[i] = new CharacterRecord();
        }
        if (!this.readPrefs()) {
            this.erasePrefs();
        }
    }

    public void erasePrefs() {
        this.cheatsEnabled = false;
        this.specialAnimCheatEnabled = false;
        if (MenuBaseSinglePlate.demoEnabled) {
            this.records[0].unlocked = true;
            this.records[2].unlocked = false;
            this.records[1].unlocked = false;
            this.records[3].unlocked = false;
        } else {
            this.records[0].unlocked = true;
            this.records[2].unlocked = true;
            this.records[1].unlocked = true;
            this.records[3].unlocked = false;
        }
        for (int i = 0; i < 4; ++i) {
            this.records[0 + i].control = this.defaultCharParams[0 + i].control;
            this.records[0 + i].power = this.defaultCharParams[0 + i].power;
            this.records[0 + i].localScore = 0;
            this.records[0 + i].localMatches = 0;
            this.records[0 + i].localMatchRecord = 0;
            this.records[0 + i].localTournRecord = 0;
            this.records[0 + i].nextMatch = 0;
            this.records[0 + i].precisionSequence = 0;
            this.records[0 + i].tournamentsUnlocked = 0;
            this.records[0 + i].ballWon = false;
            this.records[0 + i].goldenBallWon = false;
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 3; ++k) {
                    this.records[0 + i].unlockedStats[j][k] = false;
                }
            }
        }
        this.settings.unlockedLanes[0] = true;
        this.settings.unlockedLanes[2] = false;
        this.settings.unlockedLanes[1] = false;
        this.settings.unlockedLanes[3] = false;
        this.settings.unlockedLanes[4] = false;
        this.settings.unlockedLanes[5] = false;
        this.settings.vibOn = false;
    }

    public static boolean useSystemFont() {
        return Graphics2D.getFontHeight(2) == Graphics2D.getFontHeight(0);
    }

    public void getTheGame(int n) {
        try {
            switch (n) {
                case 0: {
                    if (!UserApp.platformRequest(Application.getProperty("ms-demoUrl"))) break;
                    UserApp.destroy();
                    break;
                }
                case 1: {
                    if (!UserApp.platformRequest(Application.getProperty("ms-demoUrl"))) break;
                    UserApp.destroy();
                    break;
                }
                case 2: {
                    if (!UserApp.platformRequest(Application.getProperty("ms-demoUrl"))) break;
                    UserApp.destroy();
                    break;
                }
                case 3: {
                    if (!UserApp.platformRequest(Application.getProperty("ms-demoUrl"))) break;
                    UserApp.destroy();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UserApp.destroy();
    }

    public void seeMoreGames() {
        try {
            if (UserApp.platformRequest(Application.getProperty("ms-upSellUrl"))) {
                UserApp.destroy();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UserApp.destroy();
    }

    static {
        gameFreeze = false;
        pic = null;
        rgbData = null;
        m_splashIsActive = false;
        m_LangSelIsActive = false;
        m_SoundPoundOffScreen = true;
        gamesPlayed = 0;
    }

    class Settings {
        boolean soundOn;
        boolean musicOn;
        boolean vibOn;
        boolean[] unlockedLanes = new boolean[6];
        short xxx;

        Settings() {
        }
    }

    class DefaultCharacterRecord {
        byte power;
        byte control;

        public DefaultCharacterRecord(int n, int n2) {
            this.control = (byte)n;
            this.power = (byte)n2;
        }
    }

    class CharacterRecord {
        short localScore;
        short localMatches;
        short localMatchRecord;
        short localTournRecord;
        byte nextMatch;
        byte precisionSequence;
        byte tournamentsUnlocked;
        byte control;
        byte power;
        boolean[][] unlockedStats = new boolean[2][3];
        boolean unlocked;
        boolean ballWon;
        boolean goldenBallWon;
        short xxx;

        CharacterRecord() {
        }

        public boolean canContinue() {
            if (this.nextMatch == 0) {
                return true;
            }
            return this.nextMatch < 12;
        }

        public void reset() {
            this.nextMatch = 0;
            this.tournamentsUnlocked = 0;
            this.localScore = 0;
        }

        public String progressSubscript() {
            if (this.canContinue()) {
                if (this.nextMatch == 0) {
                    return StringTable.get(118);
                }
                return StringTable.get(122) + (this.nextMatch % 3 + 1) + StringTable.get(123) + StringTable.get(118 + this.nextMatch / 3);
            }
            return StringTable.get(118);
        }
    }
}

