/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import javax.microedition.m3g.Group;
import portinglib.Graphics2D;
import userapp.FlatObject;
import userapp.Game;

class PowerMeterObject
extends FlatObject {
    private static final int MAX_ARROWS_NUM = 6;
    private int type;
    public static final int POWER_METER_TYPE = 0;
    public static final int SPIN_METER_TYPE = 1;
    private int cycleTime = 1500;
    private int startTime;
    private float dx;

    PowerMeterObject(Game game, int n) {
        super(game);
        this.game = game;
        this.type = n;
        this.setVisible(false);
    }

    public int GetCycleTime() {
        return this.cycleTime;
    }

    public void SetCycleTime(int n) {
        this.cycleTime = n;
    }

    public void setValue(int n) {
        if (this.startTime == 0) {
            return;
        }
        n -= this.startTime;
        switch (this.type) {
            case 0: {
                if (n <= this.cycleTime) break;
                n = this.cycleTime;
                break;
            }
            case 1: {
                if ((n %= this.cycleTime * 2) <= this.cycleTime) break;
                n = 2 * this.cycleTime - n;
            }
        }
        this.dx = 100.0f * (float)n / (float)this.cycleTime;
    }

    public int GetStartTime() {
        return this.startTime;
    }

    public void setStartTime(int n) {
        this.startTime = n;
    }

    private static boolean isCloseTo(float f, float f2, float f3) {
        return Math.abs(f - f2) < f3;
    }

    private void snapTo(float f, float f2) {
        if (PowerMeterObject.isCloseTo(this.dx, f, f2)) {
            this.dx = f;
        }
    }

    public void snapDX() {
        int n = 7;
        int n2 = (int)(this.getDX() * 13.0f / 100.0f) - 6;
        this.snapTo(50.0f, n / 2);
        this.snapTo(0.0f, n);
        this.snapTo(100.0f, n);
        if (n2 == 0) {
            this.dx = 50.0f;
        }
    }

    public void setDX(float f) {
        this.dx = f;
        if (this.dx >= 100.0f) {
            this.dx = 99.0f;
        }
        if (this.dx < 0.0f) {
            this.dx = 0.0f;
        }
    }

    public void incDX(float f) {
        this.setDX(this.dx + f);
    }

    public void incArrows(int n) {
        int n2 = 7;
        this.setDX(this.dx / (float)n2 * (float)n2);
        this.incDX(n * n2);
    }

    public float getDX() {
        return this.dx;
    }

    public void drawForegrownd(Graphics2D graphics2D) {
        if (this.isVisible && this.type == 1) {
            float[] fArray = new float[4];
            Group group = (Group)this.game.getGameWorld().ballRootObj.getSwerveObject().find(848439943);
            group.getTranslation(fArray);
            int n = 0;
            if (this.getDX() * 2.0f == 100.0f) {
                PowerMeterObject powerMeterObject = this;
                int n2 = powerMeterObject.game.getApplicationTime() % 1000;
                n = n2 < 700 ? n2 / 8 - 50 : (700 + (700 - n2) * 700 / 300) / 8 - 50;
            }
            float f = 1.0f - (this.getDX() - (float)n) / 100.0f;
            float f2 = 0.25f * (1.0f + f);
            group.setScale(f2, f2, f2);
            group.setTranslation(-(0.15f + f * 0.04f), fArray[1], fArray[2]);
            f = (this.getDX() + (float)n) / 100.0f;
            group = (Group)this.game.getGameWorld().ballRootObj.getSwerveObject().find(238539955);
            f2 = 0.25f * (1.0f + f);
            group.getTranslation(fArray);
            group.setTranslation(0.15f + f * 0.04f, fArray[1], fArray[2]);
            group.setScale(f2, f2, f2);
        }
    }
}

