/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import java.util.Random;
import javax.microedition.m3g.Node;
import portinglib.Debug;
import portinglib.Graphics2D;
import userapp.AIThrowParams;
import userapp.ExpoInObject;
import userapp.Game;
import userapp.GameMath;
import userapp.OptimizationUtils;
import userapp.PhisicsVerlet;
import userapp.PhysicObject;
import userapp.PinObject;
import userapp.TrackRecorder;
import userapp.UserApp;

class Physics {
    final byte[] sequence1 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    final byte[] sequence2 = new byte[]{0, 2, 5, 1, 3, 4, 9, 8, 7, 6};
    final byte[] sequence3 = new byte[]{0, 2, 1, 4, 3, 6, 7, 5, 8, 9};
    final byte[] sequence4 = new byte[]{1, 3, 0, 2, 5, 4, 8, 7, 6, 9};
    final byte[] sequence5 = new byte[]{2, 5, 4, 0, 3, 1, 6, 8, 7, 9};
    public static final float DELTA_FLOAT = 1.0E-7f;
    public static final float[] PINS_POSITIONS = new float[]{0.0f, 0.0f, -0.268f, -0.155f, -0.268f, 0.155f, -0.537f, -0.31f, -0.537f, 0.0f, -0.537f, 0.31f, -0.805f, -0.464f, -0.805f, -0.155f, -0.805f, 0.155f, -0.805f, 0.464f};
    public PhisicsVerlet.xaoc_particle_system_3d_t ball;
    public PhisicsVerlet.xaoc_particle_system_3d_t[] pins = new PhisicsVerlet.xaoc_particle_system_3d_t[10];
    private PhisicsVerlet.xaoc_vec3_t collisionPoint1 = new PhisicsVerlet.xaoc_vec3_t();
    private PhisicsVerlet.xaoc_vec3_t collisionPoint2 = new PhisicsVerlet.xaoc_vec3_t();
    private int lastTime;
    private int lastPhysicsTime;
    private int throwResult;
    private boolean ballInGutter;
    private float nSpin;
    private float nPlayerPos;
    public TrackRecorder movingBall;
    public TrackRecorder collidingBall;
    private TrackRecorder[][] collidingPins = new TrackRecorder[10][2];
    private boolean aiMove;
    private int ballRadius;
    private int pinRadius;
    private int pinHeadRadius;
    private int pinHeight;
    private int firstPin;
    private boolean[] pinRemoved = new boolean[10];
    private UserApp m_app;
    private Game game;
    public PinObject[] hashedPins = new PinObject[10];
    public boolean[] leftPins = new boolean[10];
    public boolean[] lastFrameLeftPins = new boolean[10];
    public Node holes;
    private boolean wasVibration = false;
    private boolean playedCollide = false;
    public static int currentTest = 0;
    public static boolean testPhysics = false;
    public static final int PREROTATE_Y_COEF_FAST = 200;
    public static final int PREROTATE_Y_COEF = 50;
    public static final int PREROTATE_X_COEF = 300;
    public static final int TIMESTEP = 41;
    public static final int TIMESTEP_MS = 10;
    public static final int WORLDBORDER = (int)GameMath.AS_FP(14.9f);
    public static final int WORLD_FIRST_PIN_OFFSET = (WORLDBORDER >> 1) + (WORLDBORDER >> 4);
    public static final int GUTTER_WIDTH = (int)GameMath.AS_FP(2.2f);
    public static final int GUTTER_GLUE = 0;
    public static final int NUM_INTERATIONS = 1;
    public static final int GRAVITY = GameMath.FP(-98.0f);
    public static final int USE_PIN_BALL_IMPULSE = 1;
    public static final int USE_PINS_IMPULSE = 1;
    public static final int UNIFORM_PIN_WEIGHT = 1;
    public static final float SLOMO_BORDER_FLOAT = -1.5f;
    public static final int THRESHOLD_OF_FALLING = 250;
    public static final int THRESHOLD_OF_FALLING_2 = 62500 >> GameMath.FP_SHIFT;
    private static final float IMPULSE_COEF = 0.1f;
    private static final boolean DEBUG = false;

    Physics() {
    }

    public void init(Game game, int n) {
        this.game = game;
        this.m_app = Game.m_app;
        this.ball = PhisicsVerlet.createParticleSystem();
        if (this.ball == null) {
            return;
        }
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t2 = new PhisicsVerlet.xaoc_vec3_t();
        PhisicsVerlet.xaoc_particle_system_3d_init(this.ball, 1);
        PhisicsVerlet.xaoc_fill_vec3(this.ball.a, xaoc_vec3_t2, 1);
        this.ball.remains = true;
        int n2 = 0;
        for (int i = 0; i < 10; ++i) {
            this.pins[i] = PhisicsVerlet.createParticleSystem();
            if (this.pins[i] == null) {
                return;
            }
            PhisicsVerlet.xaoc_particle_system_3d_init(this.pins[i], 2);
            this.pins[i].remains = true;
            PhisicsVerlet.xaoc_fill_vec3(this.pins[i].a, xaoc_vec3_t2, 2);
            this.lastFrameLeftPins[n2] = true;
            ++n2;
        }
    }

    public void initRecorders() {
        this.movingBall = new TrackRecorder();
        this.collidingBall = new TrackRecorder();
        int n = 0;
        for (int i = 0; i < 10; ++i) {
            this.collidingPins[n][0] = new TrackRecorder();
            this.collidingPins[n][1] = new TrackRecorder();
            ++n;
        }
    }

    public void deinitRecorders() {
        int n = 0;
        for (int i = 0; i < 10; ++i) {
            this.collidingPins[n][0] = null;
            this.collidingPins[n][1] = null;
            ++n;
        }
        this.movingBall = null;
        this.collidingBall = null;
        System.gc();
    }

    public void deInit() {
    }

    private void setPrecalcTranslationToObjects(int n, boolean bl) {
        int n2;
        if (n == 0) {
            return;
        }
        this.throwResult = 0;
        PhysicObject physicObject = this.game.getGameWorld().ballRootObj;
        for (n2 = 0; n2 < n; ++n2) {
            this.collidingBall.nextMove();
        }
        if (bl) {
            while (this.collidingBall.isNextMove()) {
                this.collidingBall.nextMove();
            }
        }
        physicObject.setTranslation(this.collidingBall.getNextTranslation(physicObject.getTranslation()));
        physicObject.getSwerveObject().setRenderingEnable(this.collidingBall.remains());
        int n3 = 0;
        for (int i = 9; i >= 0; --i) {
            boolean bl2;
            PinObject pinObject = this.hashedPins[i];
            PinObject pinObject2 = this.hashedPins[i];
            float[] fArray = pinObject.getTranslation();
            float[] fArray2 = pinObject2.getTopTranslation();
            for (n2 = 0; n2 < n; ++n2) {
                this.collidingPins[n3][0].nextMove();
                this.collidingPins[n3][1].nextMove();
            }
            if (bl) {
                while (this.collidingPins[n3][0].isNextMove()) {
                    this.collidingPins[n3][0].nextMove();
                    this.collidingPins[n3][1].nextMove();
                }
            }
            if (!TrackRecorder.checkStanding(this.collidingPins[n3][0], this.collidingPins[n3][1], true)) {
                pinObject.setTranslation(this.collidingPins[n3][0].getNextTranslation(fArray));
                pinObject2.setTopTranslation(this.collidingPins[n3][1].getNextTranslation(fArray2));
            } else {
                this.collidingPins[n3][0].nextMove();
                this.collidingPins[n3][1].nextMove();
            }
            pinObject.getSwerveObject().setRenderingEnable(this.leftPins[n3] && this.collidingPins[n3][0].remains());
            boolean bl3 = this.lastFrameLeftPins[n3] = TrackRecorder.checkStanding(this.collidingPins[n3][0], this.collidingPins[n3][1], true) && this.leftPins[n3];
            if (this.lastFrameLeftPins[n3]) {
                ++this.throwResult;
            }
            boolean bl4 = bl2 = this.leftPins[n3] && this.collidingPins[n3][0].remains() && !this.lastFrameLeftPins[n3];
            if (this.firstPin == -1 && bl2 && this.game.gameMode == 5) {
                this.firstPin = n3;
            }
            if (bl2 && this.m_app.settings.soundOn && !this.playedCollide) {
                this.m_app.playSound(1, false);
                this.playedCollide = true;
            }
            if (Game.m_app.settings.vibOn && (this.collidingBall.isStrike() && this.game.firstThrow || this.game.lnkPhysics.getFirstPin() == this.game.precisionTarget && this.game.gameMode == 5) && bl2 && !this.wasVibration) {
                UserApp.vibrate(1500);
                this.wasVibration = true;
            }
            ++n3;
        }
        this.collidingPins[0][0].debug(false);
    }

    private void setPhysTranslation(PhysicObject physicObject, PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t2, boolean bl) {
        float[] fArray = new float[4];
        fArray[0] = GameMath.get_float(xaoc_vec3_t2.y);
        fArray[1] = GameMath.get_float(-xaoc_vec3_t2.x);
        fArray[2] = GameMath.get_float(xaoc_vec3_t2.z);
        if (bl) {
            physicObject.setOldTranslation(fArray);
        } else {
            physicObject.setTranslation(fArray);
        }
    }

    private void setPhysTopTranslation(PinObject pinObject, PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t2, boolean bl) {
        float[] fArray = new float[4];
        fArray[0] = GameMath.get_float(xaoc_vec3_t2.y);
        fArray[1] = GameMath.get_float(-xaoc_vec3_t2.x);
        fArray[2] = GameMath.get_float(xaoc_vec3_t2.z);
        if (bl) {
            pinObject.setOldTopTranslation(fArray);
        } else {
            pinObject.setTopTranslation(fArray);
        }
    }

    public void updateAll() {
        PhysicObject physicObject = this.game.getGameWorld().ballRootObj;
        int n = this.game.getGameWorld().getGameState();
        switch (n) {
            case 16: {
                if (physicObject.getTranslation()[1] + 1.0E-7f > -2.5f) {
                    this.game.getGameWorld().setGameState(17);
                    this.playedCollide = false;
                    this.resetTime();
                }
                if (!(physicObject.getTranslation()[1] + 1.0E-7f < -3.5f)) break;
                float[] fArray = physicObject.getTranslation();
                float[] fArray2 = physicObject.getOldTranslation();
                Physics physics = this;
                int n2 = physics.game.getApplicationTime();
                while (this.lastPhysicsTime < n2) {
                    fArray2[0] = fArray[0];
                    fArray2[1] = fArray[1];
                    fArray2[2] = fArray[2];
                    TrackRecorder trackRecorder = this.movingBall;
                    fArray = trackRecorder.getNextTranslation(fArray);
                    this.nSpin = trackRecorder.getSpin(this.nSpin);
                    if (this.holes != null) {
                        this.holes.preRotate((fArray2[1] - fArray[1]) * 200.0f, 1.0f, 0.0f, 0.0f);
                        this.holes.preRotate(this.nSpin * 300.0f, 0.0f, 1.0f, 0.0f);
                    }
                    if (fArray[1] + 1.0E-7f >= -3.5f) {
                        trackRecorder.fillStartTranslation(fArray);
                        trackRecorder.fillStartOldTranslation(fArray2);
                        break;
                    }
                    this.lastPhysicsTime += 10;
                }
                if (!(fArray[1] + 1.0E-7f <= -3.5f)) break;
                physicObject.setOldTranslation(fArray2);
                physicObject.setTranslation(fArray);
                physicObject.getSwerveObject().setRenderingEnable(true);
                this.lastTime = n2;
                this.collidingBall.calcCollidingTrackIter(this, this.collidingPins, false);
                this.collidingBall.calcCollidingTrackIter(this, this.collidingPins, false);
                this.collidingBall.calcCollidingTrackIter(this, this.collidingPins, false);
                this.collidingPins[0][0].debug(true);
                return;
            }
            case 17: {
                break;
            }
            default: {
                Physics physics = this;
                this.lastPhysicsTime = this.lastTime = physics.game.getApplicationTime();
                return;
            }
        }
        if (physicObject.getTranslation()[1] + 1.0E-7f >= -3.5f) {
            this.nSpin = -this.collidingBall.getSpin(this.nSpin);
            if (this.holes != null) {
                this.holes.preRotate((physicObject.getOldTranslation()[1] - physicObject.getTranslation()[1]) * 50.0f, 1.0f, 0.0f, 0.0f);
                this.holes.preRotate(this.nSpin * 300.0f, 0.0f, 1.0f, 0.0f);
            }
        }
        Physics physics = this;
        int n3 = physics.game.getApplicationTime();
        int n4 = 0;
        if (n3 >= this.lastPhysicsTime) {
            do {
                ++n4;
                this.lastPhysicsTime += 10;
            } while (this.lastPhysicsTime < n3);
        }
        this.lastTime = n3;
        if (!this.collidingBall.isFinished()) {
            this.collidingBall.calcCollidingTrackIter(this, this.collidingPins, true);
        }
        this.setPrecalcTranslationToObjects(n4, false);
        this.nSpin = -this.collidingBall.getSpin(this.nSpin);
        this.collidingPins[0][0].debug(true);
    }

    public void resetCurrentParams() {
        this.firstPin = -1;
        this.wasVibration = false;
        this.ballRadius = this.game.currentParams.ballRadius;
        this.pinRadius = this.game.currentParams.pinRadius;
        this.pinHeadRadius = this.game.currentParams.pinHeadRadius;
        this.pinHeight = this.game.currentParams.pinHeight;
        this.ballInGutter = false;
        this.nSpin = 0.0f;
    }

    public void reset(float[] fArray, float[] fArray2, boolean bl) {
        this.resetCurrentParams();
        fArray[0] = fArray[0] + this.nPlayerPos;
        float[] fArray3 = new float[4];
        fArray3[0] = fArray[0] - fArray2[0];
        fArray3[1] = fArray[1] - fArray2[1];
        fArray3[2] = fArray[2] - fArray2[2];
        PhysicObject physicObject = this.game.getGameWorld().ballRootObj;
        physicObject.setOldTranslation(fArray3);
        physicObject.setTranslation(fArray);
        this.ball.remains = true;
        this.setBallTranslation(fArray, false);
        this.setBallTranslation(fArray3, true);
        this.resetBallWeightAndRadius();
        int n = 0;
        for (int i = 9; i >= 0; --i) {
            if (bl) {
                this.resetPin(this.hashedPins[i], n);
                this.pins[n].remains = !this.pinRemoved[n];
                this.leftPins[n] = !this.pinRemoved[n];
                this.lastFrameLeftPins[n] = !this.pinRemoved[n];
                this.pins[n].remains = !this.pinRemoved[n];
                this.hashedPins[i].getSwerveObject().setRenderingEnable(true);
            } else {
                PinObject pinObject = this.hashedPins[i];
                PinObject pinObject2 = this.hashedPins[i];
                float[] fArray4 = pinObject.getTranslation();
                float[] fArray5 = pinObject.getOldTranslation();
                float[] fArray6 = pinObject2.getTopTranslation();
                float[] fArray7 = pinObject2.getOldTopTranslation();
                this.setPinTranslation(this.pins[n], fArray4, fArray6, false);
                this.setPinTranslation(this.pins[n], fArray5, fArray7, true);
                this.resetPinWeightAndRadius(this.pins[n]);
                this.leftPins[n] = this.lastFrameLeftPins[n];
                this.pins[n].remains = this.leftPins[n];
            }
            ++n;
        }
        this.throwResult = 0;
        this.ball.remains = true;
        Physics physics = this;
        this.lastPhysicsTime = this.lastTime = physics.game.getApplicationTime();
    }

    public void setBallTranslation(float[] fArray, boolean bl) {
        PhisicsVerlet.xaoc_set_vec3(bl ? this.ball.old_x : this.ball.x, GameMath.get_jfp(-fArray[1]), GameMath.get_jfp(fArray[0]), GameMath.get_jfp(fArray[2]), 1);
    }

    public void resetBallWeightAndRadius() {
        PhisicsVerlet.xaoc_fill_real(this.ball.m, this.game.currentParams.ballWeight, 1);
        PhisicsVerlet.xaoc_fill_real(this.ball.radius, this.ballRadius, 1);
    }

    private void setPinTranslation(PhisicsVerlet.xaoc_particle_system_3d_t xaoc_particle_system_3d_t2, float[] fArray, float[] fArray2, boolean bl) {
        int n = GameMath.get_jfp(-fArray[1]);
        int n2 = GameMath.get_jfp(fArray[0]);
        int n3 = GameMath.get_jfp(fArray[2]);
        int n4 = GameMath.get_jfp(-fArray2[1]);
        int n5 = GameMath.get_jfp(fArray2[0]);
        int n6 = GameMath.get_jfp(fArray2[2]);
        PhisicsVerlet.xaoc_set_vec3(bl ? xaoc_particle_system_3d_t2.old_x : xaoc_particle_system_3d_t2.x, n4, n5, n6, 1, 1);
        PhisicsVerlet.xaoc_set_vec3(bl ? xaoc_particle_system_3d_t2.old_x : xaoc_particle_system_3d_t2.x, n, n2, n3, 1);
    }

    private void resetPinWeightAndRadius(PhisicsVerlet.xaoc_particle_system_3d_t xaoc_particle_system_3d_t2) {
        PhisicsVerlet.xaoc_fill_real(xaoc_particle_system_3d_t2.m, this.game.currentParams.pinWeight, 1);
        PhisicsVerlet.xaoc_fill_real(xaoc_particle_system_3d_t2.m, this.game.currentParams.pinWeight >> 1, 1, 1);
        PhisicsVerlet.xaoc_fill_real(xaoc_particle_system_3d_t2.radius, this.pinHeadRadius, 1);
        PhisicsVerlet.xaoc_fill_real(xaoc_particle_system_3d_t2.radius, this.pinRadius, 1, 1);
    }

    public void resetPin(PinObject pinObject, int n) {
        if (n == 0) {
            // empty if block
        }
        float[] fArray = new float[4];
        float[] fArray2 = new float[4];
        fArray[0] = 0.745f + PINS_POSITIONS[(n << 1) + 1];
        fArray[1] = -0.938f - PINS_POSITIONS[n << 1];
        fArray[2] = this.game.currentParams.pinRadiusFloat;
        fArray2[0] = fArray[0];
        fArray2[1] = fArray[1];
        fArray2[2] = fArray[2] + this.game.currentParams.pinHeightFloat;
        if (pinObject != null) {
            pinObject.setOldTranslation(fArray);
            pinObject.setTranslation(fArray);
            pinObject.setOldTopTranslation(fArray2);
            pinObject.setTopTranslation(fArray2);
        }
        this.setPinTranslation(this.pins[n], fArray, fArray2, false);
        this.setPinTranslation(this.pins[n], fArray, fArray2, true);
        this.resetPinWeightAndRadius(this.pins[n]);
    }

    public void resetPins(boolean bl) {
        this.resetPins(bl, false);
    }

    public void resetPins(boolean bl, boolean bl2) {
        this.aiMove = false;
        int n = 0;
        for (int i = 9; i >= 0; --i) {
            if (bl) {
                this.resetPin(this.hashedPins[i], n);
                if (this.pinRemoved[n]) {
                    // empty if block
                }
                this.leftPins[n] = !this.pinRemoved[n];
                this.lastFrameLeftPins[n] = !this.pinRemoved[n];
                this.pins[n].remains = !this.pinRemoved[n];
                this.hashedPins[i].getSwerveObject().setRenderingEnable(!this.pinRemoved[n]);
            } else if (!bl2) {
                this.leftPins[n] = this.lastFrameLeftPins[n];
            }
            ++n;
        }
    }

    public void drawTests(Graphics2D graphics2D) {
        currentTest = 0;
        graphics2D.setFillMode(1);
        int n = UserApp.getWidth() / 7;
        int n2 = UserApp.getHeight() / 7;
        int n3 = n2 / 7;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                for (int k = 0; k < 7; ++k) {
                    int n4;
                    int n5 = 0;
                    float f = 100.0f * (float)(currentTest / 49 % 7) / 7.0f;
                    float f2 = 100.0f * (float)(currentTest / 7 % 7) / 7.0f;
                    float f3 = TrackRecorder.halfOfTrack(false) * 2.0f * (float)(currentTest % 7) / 7.0f + 0.745f - TrackRecorder.halfOfTrack(false);
                    this.findParams(f3, f2, f);
                    for (n4 = 1; n4 < 11; ++n4) {
                        for (int i2 = 0; i2 < AIThrowParams.LENGTHES[n4]; ++i2) {
                            if (AIThrowParams.THROWS[10 - n4][i2 * 4] != TrackRecorder.x || AIThrowParams.THROWS[10 - n4][i2 * 4 + 1] != TrackRecorder.dx || AIThrowParams.THROWS[10 - n4][i2 * 4 + 2] != TrackRecorder.dy) continue;
                            n5 = n4;
                            break;
                        }
                        if (n5 > 0) break;
                    }
                    n4 = 255 * n5 / 11;
                    graphics2D.setFillColor(ExpoInObject.RGB2Int(n4, n4, n4));
                    graphics2D.drawRect(i * n, j * n2 + k * n3, n, n3);
                    ++currentTest;
                }
            }
        }
    }

    public void Replay() {
        Debug.TRACE("porting: Physics::Replay currentTest=" + currentTest);
        if (testPhysics) {
            this.deinitRecorders();
            float f = 100.0f * (float)(currentTest / 49 % 7) / 7.0f;
            float f2 = 100.0f * (float)(currentTest / 7 % 7) / 7.0f;
            float f3 = TrackRecorder.halfOfTrack(false) * 2.0f * (float)(currentTest % 7) / 7.0f + 0.745f - TrackRecorder.halfOfTrack(false);
            this.resetBall(f, false);
            this.findParams(f3, f2, f);
            this.calcAllTracks(TrackRecorder.x, TrackRecorder.dx, TrackRecorder.dy);
            this.resetTime();
            this.resetPins(true);
            ++currentTest;
        } else {
            this.movingBall.setCurrentMove(0);
            PhysicObject physicObject = this.game.getGameWorld().ballRootObj;
            float[] fArray = physicObject.getTranslation();
            float[] fArray2 = physicObject.getOldTranslation();
            TrackRecorder trackRecorder = this.movingBall;
            fArray = trackRecorder.getNextTranslation(fArray);
            fArray2[0] = fArray[0];
            fArray2[1] = fArray[1];
            fArray2[2] = fArray[2];
            physicObject.setOldTranslation(fArray2);
            physicObject.setTranslation(fArray);
            OptimizationUtils.movingCameraType = 0;
            this.collidingBall.setCurrentMove(0);
            if (this.firstPin != -1) {
                this.pinRemoved[this.firstPin] = false;
                this.leftPins[this.firstPin] = true;
                this.lastFrameLeftPins[this.firstPin] = true;
                this.pins[this.firstPin].remains = true;
            }
            int n = 0;
            for (int i = 9; i >= 0; --i) {
                this.lastFrameLeftPins[n] = this.leftPins[n];
                this.resetPin(this.hashedPins[i], n);
                this.collidingPins[n][0].setCurrentMove(0);
                this.collidingPins[n][1].setCurrentMove(0);
                ++n;
            }
            this.resetTime();
            this.resetPins(false);
            this.throwResult = 0;
            this.firstPin = -1;
            this.resetTime();
            this.resetCurrentParams();
        }
        this.game.getGameWorld().setGameState(16);
    }

    public void SetPos(float f) {
        this.nPlayerPos = f;
    }

    public float GetPos() {
        return this.nPlayerPos;
    }

    public void SetSpin(float f) {
        this.nSpin = f;
    }

    public float getSpin() {
        return this.nSpin;
    }

    public int getThrowResult() {
        return this.throwResult;
    }

    public boolean GetBallInGutter() {
        return this.ballInGutter;
    }

    public void resetTime() {
        Physics physics = this;
        this.lastPhysicsTime = this.lastTime = physics.game.getApplicationTime();
    }

    public void CalcMovingTrack(float f, float[] fArray, float[] fArray2) {
        this.initRecorders();
        this.movingBall.calcMovingTrack(f, fArray, fArray2);
    }

    public void CalcCollidingTrack(float[] fArray, float[] fArray2) {
        this.collidingBall.calcCollidingTrack(this, this.collidingPins, fArray, fArray2);
    }

    public void resetBall(float f, boolean bl) {
        float[] fArray = new float[4];
        fArray[0] = 0.745f;
        fArray[1] = -17.2f;
        fArray[2] = this.game.currentParams.ballRadiusFloat;
        float[] fArray2 = new float[4];
        Random random = new Random(System.currentTimeMillis());
        int n = Math.abs(random.nextInt()) % 125;
        fArray2[0] = 0.0f;
        if (bl) {
            fArray2[0] = ((float)n - 127.5f) / 35000.0f;
            switch (this.m_app.records[this.game.getGameWorld().currentBowler].control) {
                case 1: {
                    fArray2[0] = fArray2[0] / 2.0f;
                    break;
                }
                case 2: {
                    fArray2[0] = fArray2[0] / 4.0f;
                    break;
                }
                case 3: {
                    fArray2[0] = 0.0f;
                }
            }
        }
        fArray2[1] = this.game.iniParams.minBallSpeed + (this.game.iniParams.maxBallSpeed - this.game.iniParams.minBallSpeed) * f / 1500.0f;
        fArray2[2] = 0.0f;
        this.reset(fArray, fArray2, this.game.firstThrow);
    }

    public void calcAllTracks(int n, int n2, int n3) {
        float[] fArray = new float[]{(float)n / 1000.0f, -3.5f, this.game.currentParams.ballRadiusFloat};
        float[] fArray2 = new float[]{(float)(n - n2) / 1000.0f, -3.5f - (float)n3 / 1000.0f, this.game.currentParams.ballRadiusFloat};
        this.CalcMovingTrack((float)(n - n2) / 1000.0f, fArray, fArray2);
        this.CalcCollidingTrack(fArray, fArray2);
    }

    public void findParams(float f, float f2, float f3) {
        float f4 = (f2 - 50.0f) * 1.05f * 0.35f / 100.0f;
        float f5 = (f3 * 0.75f + 70.0f) / 1000.0f;
        float f6 = f + (f4 *= f5);
        TrackRecorder.x = (int)(f6 * 1000.0f);
        TrackRecorder.dx = (int)(f4 * 1000.0f);
        TrackRecorder.dy = (int)(f5 * 1000.0f);
    }

    public float findDir() {
        return (float)(TrackRecorder.x - TrackRecorder.dx) / 1000.0f;
    }

    public float findSpin() {
        return (float)TrackRecorder.dx * 100.0f / (0.36749998f * (float)TrackRecorder.dy) + 50.0f;
    }

    public float findPower() {
        return TrackRecorder.dy - 70;
    }

    public float getAIBallSpeed() {
        return (float)TrackRecorder.dy / 1000.0f;
    }

    public void MoveAIBallToCamBorder() {
        if (this.aiMove && this.game.getGameWorld().ballRootObj != null) {
            PhysicObject physicObject = this.game.getGameWorld().ballRootObj;
            float[] fArray = physicObject.getTranslation();
            physicObject.setOldTranslation(this.movingBall.getLastOldTranslation());
            physicObject.setTranslation(this.movingBall.getLastTranslation());
        }
    }

    public int getFirstPin() {
        return this.firstPin;
    }

    public int getRemovedNum() {
        int n = 0;
        for (int i = 0; i < 10; ++i) {
            if (!this.pinRemoved[i]) continue;
            ++n;
        }
        return n;
    }

    public void resetRemovedPins() {
        for (int i = 0; i < 10; ++i) {
            this.pinRemoved[i] = false;
        }
    }

    void removePin(int n) {
        this.pinRemoved[n] = true;
    }

    private void impulse(PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t2, PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t3, PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t4, PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t5, int n, int n2, PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t6, PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t7) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = PhisicsVerlet.xaoc_vec3_distance(xaoc_vec3_t3, xaoc_vec3_t2);
        if (n7 != 0) {
            int n8 = GameMath.sqrtFP(GameMath.mul(xaoc_vec3_t3.x - xaoc_vec3_t2.x, xaoc_vec3_t3.x - xaoc_vec3_t2.x) + GameMath.mul(xaoc_vec3_t3.y - xaoc_vec3_t2.y, xaoc_vec3_t3.y - xaoc_vec3_t2.y));
            if (n8 != 0) {
                n6 = GameMath.div(xaoc_vec3_t3.x - xaoc_vec3_t2.x, n8);
                n5 = GameMath.div(xaoc_vec3_t3.y - xaoc_vec3_t2.y, n8);
                n4 = GameMath.div(-n8, n7);
                n3 = GameMath.div(xaoc_vec3_t3.z - xaoc_vec3_t2.z, n7);
            } else {
                n6 = GameMath.FP_1;
                n5 = 0;
                n4 = 0;
                n3 = GameMath.FP_1;
            }
        } else {
            n7 = GameMath.sqrtFP(GameMath.mul(xaoc_vec3_t2.x - xaoc_vec3_t3.x << GameMath.CORRECTION_SHIFT, xaoc_vec3_t2.x - xaoc_vec3_t3.x << GameMath.CORRECTION_SHIFT) + GameMath.mul(xaoc_vec3_t2.y - xaoc_vec3_t3.y << GameMath.CORRECTION_SHIFT, xaoc_vec3_t2.y - xaoc_vec3_t3.y << GameMath.CORRECTION_SHIFT) + GameMath.mul(xaoc_vec3_t2.z - xaoc_vec3_t3.z << GameMath.CORRECTION_SHIFT, xaoc_vec3_t2.z - xaoc_vec3_t3.z << GameMath.CORRECTION_SHIFT));
            if (n7 != 0) {
                int n9 = GameMath.sqrtFP(GameMath.mul(xaoc_vec3_t3.x - xaoc_vec3_t2.x << GameMath.CORRECTION_SHIFT, xaoc_vec3_t3.x - xaoc_vec3_t2.x << GameMath.CORRECTION_SHIFT) + GameMath.mul(xaoc_vec3_t3.y - xaoc_vec3_t2.y << GameMath.CORRECTION_SHIFT, xaoc_vec3_t3.y - xaoc_vec3_t2.y << GameMath.CORRECTION_SHIFT));
                if (n9 != 0) {
                    n6 = GameMath.div(xaoc_vec3_t3.x - xaoc_vec3_t2.x << GameMath.CORRECTION_SHIFT, n9);
                    n5 = GameMath.div(xaoc_vec3_t3.y - xaoc_vec3_t2.y << GameMath.CORRECTION_SHIFT, n9);
                    n4 = GameMath.div(-n9, n7);
                    n3 = GameMath.div(xaoc_vec3_t3.z - xaoc_vec3_t2.z << GameMath.CORRECTION_SHIFT, n7);
                } else {
                    n6 = GameMath.FP_1;
                    n5 = 0;
                    n4 = 0;
                    n3 = GameMath.FP_1;
                }
            } else {
                n6 = GameMath.FP_1;
                n5 = 0;
                n4 = GameMath.FP_1;
                n3 = 0;
            }
        }
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t8 = new PhisicsVerlet.xaoc_vec3_t(xaoc_vec3_t2.x - xaoc_vec3_t4.x, xaoc_vec3_t2.y - xaoc_vec3_t4.y, xaoc_vec3_t2.z - xaoc_vec3_t4.z);
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t9 = new PhisicsVerlet.xaoc_vec3_t(xaoc_vec3_t3.x - xaoc_vec3_t5.x, xaoc_vec3_t3.y - xaoc_vec3_t5.y, xaoc_vec3_t3.z - xaoc_vec3_t5.z);
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t10 = new PhisicsVerlet.xaoc_vec3_t(GameMath.mul(GameMath.mul(xaoc_vec3_t8.x, n6), n4) + GameMath.mul(GameMath.mul(xaoc_vec3_t8.y, n5), n4) - GameMath.mul(xaoc_vec3_t8.z, n3), -GameMath.mul(xaoc_vec3_t8.x, n5) + GameMath.mul(xaoc_vec3_t8.y, n6), GameMath.mul(GameMath.mul(xaoc_vec3_t8.x, n6), n3) + GameMath.mul(GameMath.mul(xaoc_vec3_t8.y, n5), n3) + GameMath.mul(xaoc_vec3_t8.z, n4));
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t11 = new PhisicsVerlet.xaoc_vec3_t(GameMath.mul(GameMath.mul(xaoc_vec3_t9.x, n6), n4) + GameMath.mul(GameMath.mul(xaoc_vec3_t9.y, n5), n4) - GameMath.mul(xaoc_vec3_t9.z, n3), -GameMath.mul(xaoc_vec3_t9.x, n5) + GameMath.mul(xaoc_vec3_t9.y, n6), GameMath.mul(GameMath.mul(xaoc_vec3_t9.x, n6), n3) + GameMath.mul(GameMath.mul(xaoc_vec3_t9.y, n5), n3) + GameMath.mul(xaoc_vec3_t9.z, n4));
        if (n == n2) {
            int n10 = xaoc_vec3_t10.x;
            xaoc_vec3_t10.x = xaoc_vec3_t11.x;
            xaoc_vec3_t11.x = n10;
        } else {
            int n11 = GameMath.div((GameMath.mul(n2, xaoc_vec3_t11.x) << 1) + GameMath.mul(n - n2, xaoc_vec3_t10.x), n + n2);
            int n12 = GameMath.div((GameMath.mul(n, xaoc_vec3_t10.x) << 1) + GameMath.mul(n2 - n, xaoc_vec3_t11.x), n + n2);
            xaoc_vec3_t10.x = n11;
            xaoc_vec3_t11.x = n12;
        }
        xaoc_vec3_t8.x = GameMath.mul(GameMath.mul(xaoc_vec3_t10.x, n6), n4) - GameMath.mul(xaoc_vec3_t10.y, n5) + GameMath.mul(GameMath.mul(xaoc_vec3_t10.z, n6), n3);
        xaoc_vec3_t8.y = GameMath.mul(GameMath.mul(xaoc_vec3_t10.x, n5), n4) + GameMath.mul(xaoc_vec3_t10.y, n6) + GameMath.mul(GameMath.mul(xaoc_vec3_t10.z, n5), n3);
        xaoc_vec3_t8.z = -GameMath.mul(xaoc_vec3_t10.x, n3) + GameMath.mul(xaoc_vec3_t10.z, n4);
        xaoc_vec3_t9.x = GameMath.mul(GameMath.mul(xaoc_vec3_t11.x, n6), n4) - GameMath.mul(xaoc_vec3_t11.y, n5) + GameMath.mul(GameMath.mul(xaoc_vec3_t11.z, n6), n3);
        xaoc_vec3_t9.y = GameMath.mul(GameMath.mul(xaoc_vec3_t11.x, n5), n4) + GameMath.mul(xaoc_vec3_t11.y, n6) + GameMath.mul(GameMath.mul(xaoc_vec3_t11.z, n5), n3);
        xaoc_vec3_t9.z = -GameMath.mul(xaoc_vec3_t11.x, n3) + GameMath.mul(xaoc_vec3_t11.z, n4);
        xaoc_vec3_t6.x = xaoc_vec3_t8.x - (xaoc_vec3_t2.x - xaoc_vec3_t4.x);
        xaoc_vec3_t6.y = xaoc_vec3_t8.y - (xaoc_vec3_t2.y - xaoc_vec3_t4.y);
        xaoc_vec3_t6.z = xaoc_vec3_t8.z - (xaoc_vec3_t2.z - xaoc_vec3_t4.z);
        xaoc_vec3_t7.x = xaoc_vec3_t9.x - (xaoc_vec3_t3.x - xaoc_vec3_t5.x);
        xaoc_vec3_t7.y = xaoc_vec3_t9.y - (xaoc_vec3_t3.y - xaoc_vec3_t5.y);
        xaoc_vec3_t7.z = xaoc_vec3_t9.z - (xaoc_vec3_t3.z - xaoc_vec3_t5.z);
    }

    private int PinsDistance(PhisicsVerlet.xaoc_particle_system_3d_t xaoc_particle_system_3d_t2, PhisicsVerlet.xaoc_particle_system_3d_t xaoc_particle_system_3d_t3, PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t2) {
        int n;
        int n2;
        int n3;
        int n4 = GameMath.mul(3 * xaoc_particle_system_3d_t2.radius[0], 3 * xaoc_particle_system_3d_t3.radius[0]);
        if (PhisicsVerlet.xaoc_vec3_square_distance(xaoc_particle_system_3d_t2.x[0], xaoc_particle_system_3d_t3.x[0]) > n4 && PhisicsVerlet.xaoc_vec3_square_distance(xaoc_particle_system_3d_t2.x[0], xaoc_particle_system_3d_t3.x[1]) > n4 && PhisicsVerlet.xaoc_vec3_square_distance(xaoc_particle_system_3d_t2.x[1], xaoc_particle_system_3d_t3.x[0]) > n4 && PhisicsVerlet.xaoc_vec3_square_distance(xaoc_particle_system_3d_t2.x[1], xaoc_particle_system_3d_t3.x[1]) > n4) {
            return GameMath.FP_MAX;
        }
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t3 = new PhisicsVerlet.xaoc_vec3_t(xaoc_particle_system_3d_t2.x[0].x + xaoc_particle_system_3d_t2.x[1].x >> 1, xaoc_particle_system_3d_t2.x[0].y + xaoc_particle_system_3d_t2.x[1].y >> 1, xaoc_particle_system_3d_t2.x[0].z + xaoc_particle_system_3d_t2.x[1].z >> 1);
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t4 = new PhisicsVerlet.xaoc_vec3_t(xaoc_particle_system_3d_t3.x[0].x + xaoc_particle_system_3d_t3.x[1].x >> 1, xaoc_particle_system_3d_t3.x[0].y + xaoc_particle_system_3d_t3.x[1].y >> 1, xaoc_particle_system_3d_t3.x[0].z + xaoc_particle_system_3d_t3.x[1].z >> 1);
        int n5 = PhisicsVerlet.xaoc_vec3_distance(xaoc_particle_system_3d_t2.x[0], xaoc_particle_system_3d_t2.x[1]);
        int n6 = PhisicsVerlet.xaoc_vec3_distance(xaoc_particle_system_3d_t3.x[0], xaoc_particle_system_3d_t3.x[1]);
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t5 = new PhisicsVerlet.xaoc_vec3_t(GameMath.div(xaoc_particle_system_3d_t2.x[1].x - xaoc_particle_system_3d_t2.x[0].x, n5), GameMath.div(xaoc_particle_system_3d_t2.x[1].y - xaoc_particle_system_3d_t2.x[0].y, n5), GameMath.div(xaoc_particle_system_3d_t2.x[1].z - xaoc_particle_system_3d_t2.x[0].z, n5));
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t6 = new PhisicsVerlet.xaoc_vec3_t(GameMath.div(xaoc_particle_system_3d_t3.x[1].x - xaoc_particle_system_3d_t3.x[0].x, n6), GameMath.div(xaoc_particle_system_3d_t3.x[1].y - xaoc_particle_system_3d_t3.x[0].y, n6), GameMath.div(xaoc_particle_system_3d_t3.x[1].z - xaoc_particle_system_3d_t3.x[0].z, n6));
        n5 >>= 1;
        n6 >>= 1;
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t7 = new PhisicsVerlet.xaoc_vec3_t(xaoc_vec3_t3.x - xaoc_vec3_t4.x, xaoc_vec3_t3.y - xaoc_vec3_t4.y, xaoc_vec3_t3.z - xaoc_vec3_t4.z);
        int n7 = -PhisicsVerlet.scalarMult(xaoc_vec3_t5, xaoc_vec3_t6);
        int n8 = PhisicsVerlet.scalarMult(xaoc_vec3_t7, xaoc_vec3_t5);
        int n9 = -PhisicsVerlet.scalarMult(xaoc_vec3_t7, xaoc_vec3_t6);
        int n10 = GameMath.mul(xaoc_vec3_t7.x, xaoc_vec3_t7.x) + GameMath.mul(xaoc_vec3_t7.y, xaoc_vec3_t7.y) + GameMath.mul(xaoc_vec3_t7.z, xaoc_vec3_t7.z);
        int n11 = GameMath.FP(1.0f) - GameMath.mul(n7, n7);
        if (n11 < 0) {
            n11 = -n11;
        }
        if (n11 > 0) {
            n3 = GameMath.mul(n7, n9) - n8;
            n2 = GameMath.mul(n7, n8) - n9;
            int n12 = GameMath.mul(n5, n11);
            int n13 = GameMath.mul(n6, n11);
            if (n3 >= -n12) {
                if (n3 <= n12) {
                    if (n2 >= -n13) {
                        if (n2 <= n13) {
                            int n14 = GameMath.div(GameMath.FP(1.0f), n11);
                            n3 = GameMath.mul(n3, n14);
                            n2 = GameMath.mul(n2, n14);
                            n = GameMath.mul(n3, n3 + GameMath.mul(n7, n2) + (n8 << 1)) + GameMath.mul(n2, GameMath.mul(n7, n3) + n2 + (n9 << 1)) + n10;
                        } else {
                            n2 = n6;
                            int n15 = -(GameMath.mul(n7, n2) + n8);
                            if (n15 < -n5) {
                                n3 = -n5;
                                n = GameMath.mul(n3, n3 - (n15 << 1)) + GameMath.mul(n2, n2 + (n9 << 1)) + n10;
                            } else if (n15 <= n5) {
                                n3 = n15;
                                n = -GameMath.mul(n3, n3) + GameMath.mul(n2, n2 + (n9 << 1)) + n10;
                            } else {
                                n3 = n5;
                                n = GameMath.mul(n3, n3 - (n15 << 1)) + GameMath.mul(n2, n2 + (n9 << 1)) + n10;
                            }
                        }
                    } else {
                        n2 = -n6;
                        int n16 = -(GameMath.mul(n7, n2) + n8);
                        if (n16 < -n5) {
                            n3 = -n5;
                            n = GameMath.mul(n3, n3 - (n16 << 1)) + GameMath.mul(n2, n2 + (n9 << 1)) + n10;
                        } else if (n16 <= n5) {
                            n3 = n16;
                            n = -GameMath.mul(n3, n3) + GameMath.mul(n2, n2 + (n9 << 1)) + n10;
                        } else {
                            n3 = n5;
                            n = GameMath.mul(n3, n3 - (n16 << 1)) + GameMath.mul(n2, n2 + (n9 << 1)) + n10;
                        }
                    }
                } else if (n2 >= -n13) {
                    if (n2 <= n13) {
                        n3 = n5;
                        int n17 = -(GameMath.mul(n7, n3) + n9);
                        if (n17 < -n6) {
                            n2 = -n6;
                            n = GameMath.mul(n2, n2 - (n17 << 1)) + GameMath.mul(n3, n3 + (n8 << 1)) + n10;
                        } else if (n17 <= n6) {
                            n2 = n17;
                            n = -GameMath.mul(n2, n2) + GameMath.mul(n3, n3 + (n8 << 1)) + n10;
                        } else {
                            n2 = n6;
                            n = GameMath.mul(n2, n2 - (n17 << 1)) + GameMath.mul(n3, n3 + (n8 << 1)) + n10;
                        }
                    } else {
                        n2 = n6;
                        int n18 = -(GameMath.mul(n7, n2) + n8);
                        if (n18 < -n5) {
                            n3 = -n5;
                            n = GameMath.mul(n3, n3 - (n18 << 1)) + GameMath.mul(n2, n2 + (n9 << 1)) + n10;
                        } else if (n18 <= n5) {
                            n3 = n18;
                            n = -GameMath.mul(n3, n3) + GameMath.mul(n2, n2 + (n9 << 1)) + n10;
                        } else {
                            n3 = n5;
                            int n19 = -(GameMath.mul(n7, n3) + n9);
                            if (n19 < -n6) {
                                n2 = -n6;
                                n = GameMath.mul(n2, n2 - (n19 << 1)) + GameMath.mul(n3, n3 + (n8 << 1)) + n10;
                            } else if (n19 <= n6) {
                                n2 = n19;
                                n = -GameMath.mul(n2, n2) + GameMath.mul(n3, n3 + (n8 << 1)) + n10;
                            } else {
                                n2 = n6;
                                n = GameMath.mul(n2, n2 - (n19 << 1)) + GameMath.mul(n3, n3 + (n8 << 1)) + n10;
                            }
                        }
                    }
                } else {
                    n2 = -n6;
                    int n20 = -(GameMath.mul(n7, n2) + n8);
                    if (n20 < -n5) {
                        n3 = -n5;
                        n = GameMath.mul(n3, n3 - (n20 << 1)) + GameMath.mul(n2, n2 + (n9 << 1)) + n10;
                    } else if (n20 <= n5) {
                        n3 = n20;
                        n = -GameMath.mul(n3, n3) + GameMath.mul(n2, n2 + (n9 << 1)) + n10;
                    } else {
                        n3 = n5;
                        int n21 = -(GameMath.mul(n7, n3) + n9);
                        if (n21 > n6) {
                            n2 = n6;
                            n = GameMath.mul(n2, n2 - (n21 << 1)) + GameMath.mul(n3, n3 + (n8 << 1)) + n10;
                        } else if (n21 >= -n6) {
                            n2 = n21;
                            n = -GameMath.mul(n2, n2) + GameMath.mul(n3, n3 + (n8 << 1)) + n10;
                        } else {
                            n2 = -n6;
                            n = GameMath.mul(n2, n2 - (n21 << 1)) + GameMath.mul(n3, n3 + (n8 << 1)) + n10;
                        }
                    }
                }
            } else if (n2 >= -n13) {
                if (n2 <= n13) {
                    n3 = -n5;
                    int n22 = -(GameMath.mul(n7, n3) + n9);
                    if (n22 < -n6) {
                        n2 = -n6;
                        n = GameMath.mul(n2, n2 - (n22 << 1)) + GameMath.mul(n3, n3 + (n8 << 1)) + n10;
                    } else if (n22 <= n6) {
                        n2 = n22;
                        n = -GameMath.mul(n2, n2) + GameMath.mul(n3, n3 + (n8 << 1)) + n10;
                    } else {
                        n2 = n6;
                        n = GameMath.mul(n2, n2 - (n22 << 1)) + GameMath.mul(n3, n3 + (n8 << 1)) + n10;
                    }
                } else {
                    n2 = n6;
                    int n23 = -(GameMath.mul(n7, n2) + n8);
                    if (n23 > n5) {
                        n3 = n5;
                        n = GameMath.mul(n3, n3 - (n23 << 1)) + GameMath.mul(n2, n2 + (n9 << 1)) + n10;
                    } else if (n23 >= -n5) {
                        n3 = n23;
                        n = -GameMath.mul(n3, n3) + GameMath.mul(n2, n2 + (n9 << 1)) + n10;
                    } else {
                        n3 = -n5;
                        int n24 = -(GameMath.mul(n7, n3) + n9);
                        if (n24 < -n6) {
                            n2 = -n6;
                            n = GameMath.mul(n2, n2 - (n24 << 1)) + GameMath.mul(n3, n3 + (n8 << 1)) + n10;
                        } else if (n24 <= n6) {
                            n2 = n24;
                            n = -GameMath.mul(n2, n2) + GameMath.mul(n3, n3 + (n8 << 1)) + n10;
                        } else {
                            n2 = n6;
                            n = GameMath.mul(n2, n2 - (n24 << 1)) + GameMath.mul(n3, n3 + (n8 << 1)) + n10;
                        }
                    }
                }
            } else {
                n2 = -n6;
                int n25 = -(GameMath.mul(n7, n2) + n8);
                if (n25 > n5) {
                    n3 = n5;
                    n = GameMath.mul(n3, n3 - (n25 << 1)) + GameMath.mul(n2, n2 + (n9 << 1)) + n10;
                } else if (n25 >= -n5) {
                    n3 = n25;
                    n = -GameMath.mul(n3, n3) + GameMath.mul(n2, n2 + (n9 << 1)) + n10;
                } else {
                    n3 = -n5;
                    int n26 = -(GameMath.mul(n7, n3) + n9);
                    if (n26 < -n6) {
                        n2 = -n6;
                        n = GameMath.mul(n2, n2 - (n26 << 1)) + GameMath.mul(n3, n3 + (n8 << 1)) + n10;
                    } else if (n26 <= n6) {
                        n2 = n26;
                        n = -GameMath.mul(n2, n2) + GameMath.mul(n3, n3 + (n8 << 1)) + n10;
                    } else {
                        n2 = n6;
                        n = GameMath.mul(n2, n2 - (n26 << 1)) + GameMath.mul(n3, n3 + (n8 << 1)) + n10;
                    }
                }
            }
        } else {
            int n27 = n5 + n6;
            int n28 = n7 > 0 ? GameMath.FP(-1.0f) : GameMath.FP(1.0f);
            int n29 = -n8;
            if (n29 < -n27) {
                n29 = -n27;
            } else if (n29 > n27) {
                n29 = n27;
            }
            n2 = GameMath.div(GameMath.mul(GameMath.mul(n28, n8), n6), n27);
            n3 = n29 + GameMath.mul(n28, n2);
            n = GameMath.mul(n29, n29 + (n8 << 1)) + n10;
        }
        xaoc_vec3_t2.x = GameMath.div(n3 + n5, n5 << 1);
        xaoc_vec3_t2.y = GameMath.div(n2 + n6, n6 << 1);
        if (n < 0) {
            return -n;
        }
        return n;
    }

    private int pinAndBallDistance(PhisicsVerlet.xaoc_particle_system_3d_t xaoc_particle_system_3d_t2, PhisicsVerlet.xaoc_particle_system_3d_t xaoc_particle_system_3d_t3) {
        int n = GameMath.mul(2 * xaoc_particle_system_3d_t2.radius[0] + xaoc_particle_system_3d_t3.radius[0], 2 * xaoc_particle_system_3d_t2.radius[0] + xaoc_particle_system_3d_t3.radius[0]);
        if (PhisicsVerlet.xaoc_vec3_square_distance(xaoc_particle_system_3d_t2.x[0], xaoc_particle_system_3d_t3.x[0]) > n && PhisicsVerlet.xaoc_vec3_square_distance(xaoc_particle_system_3d_t2.x[1], xaoc_particle_system_3d_t3.x[0]) > n) {
            return GameMath.FP_MAX;
        }
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t2 = new PhisicsVerlet.xaoc_vec3_t(xaoc_particle_system_3d_t2.x[1].x - xaoc_particle_system_3d_t2.x[0].x, xaoc_particle_system_3d_t2.x[1].y - xaoc_particle_system_3d_t2.x[0].y, xaoc_particle_system_3d_t2.x[1].z - xaoc_particle_system_3d_t2.x[0].z);
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t3 = new PhisicsVerlet.xaoc_vec3_t(xaoc_particle_system_3d_t3.x[0].x - xaoc_particle_system_3d_t2.x[0].x, xaoc_particle_system_3d_t3.x[0].y - xaoc_particle_system_3d_t2.x[0].y, xaoc_particle_system_3d_t3.x[0].z - xaoc_particle_system_3d_t2.x[0].z);
        int n2 = GameMath.div(PhisicsVerlet.scalarMult(xaoc_vec3_t2, xaoc_vec3_t3), PhisicsVerlet.scalarMult(xaoc_vec3_t2, xaoc_vec3_t2));
        if ((n2 /= 5) < 0) {
            n2 = 0;
        }
        if (n2 > GameMath.FP_1) {
            n2 = GameMath.FP_1;
        }
        return n2;
    }

    private void bowlingConstraints(PhisicsVerlet.xaoc_particle_system_3d_t xaoc_particle_system_3d_t2) {
        if (!xaoc_particle_system_3d_t2.remains) {
            return;
        }
        for (int i = 0; i < 1; ++i) {
            int n;
            for (n = 0; n < xaoc_particle_system_3d_t2.size; ++n) {
                if (xaoc_particle_system_3d_t2.x[n].y + xaoc_particle_system_3d_t2.radius[n] > WORLDBORDER) {
                    xaoc_particle_system_3d_t2.old_x[n].y = WORLDBORDER - xaoc_particle_system_3d_t2.radius[n] + (xaoc_particle_system_3d_t2.x[n].y - xaoc_particle_system_3d_t2.old_x[n].y >> 1);
                    xaoc_particle_system_3d_t2.x[n].y = WORLDBORDER - xaoc_particle_system_3d_t2.radius[n];
                }
                if (xaoc_particle_system_3d_t2.x[n].y - xaoc_particle_system_3d_t2.radius[n] < 0) {
                    xaoc_particle_system_3d_t2.old_x[n].y = xaoc_particle_system_3d_t2.radius[n] + (xaoc_particle_system_3d_t2.x[n].y - xaoc_particle_system_3d_t2.old_x[n].y >> 1);
                    xaoc_particle_system_3d_t2.x[n].y = xaoc_particle_system_3d_t2.radius[n];
                }
                if (xaoc_particle_system_3d_t2.x[n].z + xaoc_particle_system_3d_t2.radius[n] > WORLDBORDER / 3) {
                    xaoc_particle_system_3d_t2.old_x[n].z = WORLDBORDER - xaoc_particle_system_3d_t2.radius[n] + (xaoc_particle_system_3d_t2.x[n].z - xaoc_particle_system_3d_t2.old_x[n].z >> 1);
                    xaoc_particle_system_3d_t2.x[n].z = WORLDBORDER - xaoc_particle_system_3d_t2.radius[n];
                }
                if (xaoc_particle_system_3d_t2.x[n].z - xaoc_particle_system_3d_t2.radius[n] >= 0) continue;
                xaoc_particle_system_3d_t2.old_x[n].z = xaoc_particle_system_3d_t2.radius[n] + (xaoc_particle_system_3d_t2.x[n].z - xaoc_particle_system_3d_t2.old_x[n].z >> 1);
                xaoc_particle_system_3d_t2.x[n].z = xaoc_particle_system_3d_t2.radius[n];
                if (xaoc_particle_system_3d_t2.size != 2) continue;
                int n2 = xaoc_particle_system_3d_t2.x[n].x - xaoc_particle_system_3d_t2.old_x[n].x;
                int n3 = n2 >> 3;
                if (n3 == 0) {
                    n3 = n2;
                }
                xaoc_particle_system_3d_t2.old_x[n].x = xaoc_particle_system_3d_t2.x[n].x - (n2 - n3);
                n2 = xaoc_particle_system_3d_t2.x[n].y - xaoc_particle_system_3d_t2.old_x[n].y;
                n3 = n2 >> 3;
                if (n3 == 0) {
                    n3 = n2;
                }
                xaoc_particle_system_3d_t2.old_x[n].y = xaoc_particle_system_3d_t2.x[n].y - (n2 - n3);
            }
            if (xaoc_particle_system_3d_t2.size <= 1) continue;
            for (n = 0; n < xaoc_particle_system_3d_t2.size; ++n) {
                PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t2 = xaoc_particle_system_3d_t2.x[n];
                PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t3 = xaoc_particle_system_3d_t2.x[(n + 1) % xaoc_particle_system_3d_t2.size];
                PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t4 = new PhisicsVerlet.xaoc_vec3_t();
                xaoc_vec3_t4.x = xaoc_vec3_t3.x - xaoc_vec3_t2.x;
                xaoc_vec3_t4.y = xaoc_vec3_t3.y - xaoc_vec3_t2.y;
                xaoc_vec3_t4.z = xaoc_vec3_t3.z - xaoc_vec3_t2.z;
                int n4 = PhisicsVerlet.scalarMult(xaoc_vec3_t4, xaoc_vec3_t4);
                if (n4 == GameMath.mul(this.pinHeight, this.pinHeight)) continue;
                n4 = GameMath.sqrtFP(n4);
                int n5 = GameMath.div(n4 - this.pinHeight, n4);
                xaoc_vec3_t2.x += GameMath.mul(xaoc_vec3_t4.x, n5) >> 1;
                xaoc_vec3_t2.y += GameMath.mul(xaoc_vec3_t4.y, n5) >> 1;
                xaoc_vec3_t2.z += GameMath.mul(xaoc_vec3_t4.z, n5) >> 1;
                xaoc_vec3_t3.x -= GameMath.mul(xaoc_vec3_t4.x, n5) >> 1;
                xaoc_vec3_t3.y -= GameMath.mul(xaoc_vec3_t4.y, n5) >> 1;
                xaoc_vec3_t3.z -= GameMath.mul(xaoc_vec3_t4.z, n5) >> 1;
            }
        }
    }

    private void ballConstraints(PhisicsVerlet.xaoc_particle_system_3d_t xaoc_particle_system_3d_t2) {
        if (!xaoc_particle_system_3d_t2.remains) {
            return;
        }
        for (int i = 0; i < 1; ++i) {
            for (int j = 0; j < xaoc_particle_system_3d_t2.size; ++j) {
                if (xaoc_particle_system_3d_t2.x[j].y + xaoc_particle_system_3d_t2.radius[j] / 2 > WORLDBORDER - GUTTER_WIDTH / 2) {
                    xaoc_particle_system_3d_t2.x[j].y = xaoc_particle_system_3d_t2.old_x[j].y = WORLDBORDER - xaoc_particle_system_3d_t2.radius[j] + 0;
                    xaoc_particle_system_3d_t2.a[j].y = 0;
                }
                if (xaoc_particle_system_3d_t2.x[j].y - xaoc_particle_system_3d_t2.radius[j] / 2 < GUTTER_WIDTH / 2) {
                    xaoc_particle_system_3d_t2.x[j].y = xaoc_particle_system_3d_t2.old_x[j].y = xaoc_particle_system_3d_t2.radius[j] - 0;
                    xaoc_particle_system_3d_t2.a[j].y = 0;
                }
                if (xaoc_particle_system_3d_t2.x[j].z + xaoc_particle_system_3d_t2.radius[j] > WORLDBORDER / 3) {
                    xaoc_particle_system_3d_t2.old_x[j].z = WORLDBORDER - xaoc_particle_system_3d_t2.radius[j] + (xaoc_particle_system_3d_t2.x[j].z - xaoc_particle_system_3d_t2.old_x[j].z >> 1);
                    xaoc_particle_system_3d_t2.x[j].z = WORLDBORDER - xaoc_particle_system_3d_t2.radius[j];
                }
                if (xaoc_particle_system_3d_t2.x[j].z - xaoc_particle_system_3d_t2.radius[j] >= 0) continue;
                xaoc_particle_system_3d_t2.old_x[j].z = xaoc_particle_system_3d_t2.radius[j] + (xaoc_particle_system_3d_t2.x[j].z - xaoc_particle_system_3d_t2.old_x[j].z >> 1);
                xaoc_particle_system_3d_t2.x[j].z = xaoc_particle_system_3d_t2.radius[j];
            }
        }
    }

    private boolean pinBallCollision(PhisicsVerlet.xaoc_particle_system_3d_t xaoc_particle_system_3d_t2, PhisicsVerlet.xaoc_particle_system_3d_t xaoc_particle_system_3d_t3) {
        if (!xaoc_particle_system_3d_t2.remains || !xaoc_particle_system_3d_t3.remains) {
            return false;
        }
        if (xaoc_particle_system_3d_t2.size != 2 || xaoc_particle_system_3d_t3.size != 1) {
            return false;
        }
        int n = this.pinAndBallDistance(xaoc_particle_system_3d_t2, xaoc_particle_system_3d_t3);
        if (n == GameMath.FP_MAX) {
            return false;
        }
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t2 = new PhisicsVerlet.xaoc_vec3_t();
        PhisicsVerlet.xaoc_set_vec3(xaoc_vec3_t2, GameMath.mul(xaoc_particle_system_3d_t2.x[0].x, GameMath.FP_1 - n) + GameMath.mul(xaoc_particle_system_3d_t2.x[1].x, n), GameMath.mul(xaoc_particle_system_3d_t2.x[0].y, GameMath.FP_1 - n) + GameMath.mul(xaoc_particle_system_3d_t2.x[1].y, n), GameMath.mul(xaoc_particle_system_3d_t2.x[0].z, GameMath.FP_1 - n) + GameMath.mul(xaoc_particle_system_3d_t2.x[1].z, n), 1);
        int n2 = PhisicsVerlet.xaoc_vec3_distance(xaoc_vec3_t2, xaoc_particle_system_3d_t3.x[0]);
        if (n2 > xaoc_particle_system_3d_t2.radius[0] + xaoc_particle_system_3d_t3.radius[0]) {
            return false;
        }
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t3 = new PhisicsVerlet.xaoc_vec3_t();
        PhisicsVerlet.xaoc_set_vec3(xaoc_vec3_t3, GameMath.mul(xaoc_particle_system_3d_t2.old_x[0].x, GameMath.FP_1 - n) + GameMath.mul(xaoc_particle_system_3d_t2.old_x[1].x, n), GameMath.mul(xaoc_particle_system_3d_t2.old_x[0].y, GameMath.FP_1 - n) + GameMath.mul(xaoc_particle_system_3d_t2.old_x[1].y, n), GameMath.mul(xaoc_particle_system_3d_t2.old_x[0].z, GameMath.FP_1 - n) + GameMath.mul(xaoc_particle_system_3d_t2.old_x[1].z, n), 1);
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t4 = new PhisicsVerlet.xaoc_vec3_t();
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t5 = new PhisicsVerlet.xaoc_vec3_t();
        this.impulse(xaoc_vec3_t2, xaoc_particle_system_3d_t3.x[0], xaoc_vec3_t3, xaoc_particle_system_3d_t3.old_x[0], xaoc_particle_system_3d_t2.m[0] + xaoc_particle_system_3d_t2.m[1], xaoc_particle_system_3d_t3.m[0], xaoc_vec3_t4, xaoc_vec3_t5);
        xaoc_particle_system_3d_t2.old_x[0].x -= GameMath.mul(GameMath.FP_1 - n, xaoc_vec3_t4.x);
        xaoc_particle_system_3d_t2.old_x[0].y -= GameMath.mul(GameMath.FP_1 - n, xaoc_vec3_t4.y);
        xaoc_particle_system_3d_t2.old_x[0].z -= GameMath.mul(GameMath.FP_1 - n, xaoc_vec3_t4.z);
        xaoc_particle_system_3d_t2.old_x[1].x -= GameMath.mul(n, xaoc_vec3_t4.x);
        xaoc_particle_system_3d_t2.old_x[1].y -= GameMath.mul(n, xaoc_vec3_t4.y);
        xaoc_particle_system_3d_t2.old_x[1].z -= GameMath.mul(n, xaoc_vec3_t4.z);
        xaoc_particle_system_3d_t3.old_x[0].x -= xaoc_vec3_t5.x;
        xaoc_particle_system_3d_t3.old_x[0].y -= xaoc_vec3_t5.y;
        xaoc_particle_system_3d_t3.old_x[0].z -= xaoc_vec3_t5.z;
        if (n2 <= xaoc_particle_system_3d_t2.radius[0] + xaoc_particle_system_3d_t3.radius[0]) {
            PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t6 = new PhisicsVerlet.xaoc_vec3_t();
            PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t7 = new PhisicsVerlet.xaoc_vec3_t();
            xaoc_vec3_t6.x = xaoc_particle_system_3d_t3.x[0].x - xaoc_vec3_t2.x;
            xaoc_vec3_t6.y = xaoc_particle_system_3d_t3.x[0].y - xaoc_vec3_t2.y;
            xaoc_vec3_t6.z = xaoc_particle_system_3d_t3.x[0].z - xaoc_vec3_t2.z;
            int n3 = 0;
            int n4 = GameMath.div(GameMath.FP(1.0f), xaoc_particle_system_3d_t2.m[0] + xaoc_particle_system_3d_t2.m[1]);
            int n5 = GameMath.div(GameMath.FP(1.0f), xaoc_particle_system_3d_t3.m[0]);
            if (n2 > 0) {
                n3 = GameMath.div(n2 - (this.pinRadius + this.ballRadius), GameMath.mul(n2, n4 + n5));
            } else {
                n2 = GameMath.sqrtFP(GameMath.mul(xaoc_vec3_t6.x << GameMath.CORRECTION_SHIFT, xaoc_vec3_t6.x << GameMath.CORRECTION_SHIFT) + GameMath.mul(xaoc_vec3_t6.y << GameMath.CORRECTION_SHIFT, xaoc_vec3_t6.y << GameMath.CORRECTION_SHIFT) + GameMath.mul(xaoc_vec3_t6.z << GameMath.CORRECTION_SHIFT, xaoc_vec3_t6.z << GameMath.CORRECTION_SHIFT));
                GameMath.div(n2 - (this.pinRadius + this.ballRadius << GameMath.CORRECTION_SHIFT), GameMath.mul(n2, n4 + n5));
            }
            xaoc_vec3_t7.x = GameMath.mul(n4, GameMath.mul(xaoc_vec3_t6.x, n3)) >> 1;
            xaoc_vec3_t7.y = GameMath.mul(n4, GameMath.mul(xaoc_vec3_t6.y, n3)) >> 1;
            xaoc_vec3_t7.z = GameMath.mul(n4, GameMath.mul(xaoc_vec3_t6.z, n3)) >> 1;
            xaoc_particle_system_3d_t2.x[0].x = (int)((float)xaoc_particle_system_3d_t2.x[0].x + 0.1f * (float)GameMath.mul(xaoc_vec3_t7.x, GameMath.FP_1 - n));
            xaoc_particle_system_3d_t2.x[1].x = (int)((float)xaoc_particle_system_3d_t2.x[1].x + 0.1f * (float)GameMath.mul(xaoc_vec3_t7.x, n));
            xaoc_particle_system_3d_t2.x[0].y = (int)((float)xaoc_particle_system_3d_t2.x[0].y + 0.1f * (float)GameMath.mul(xaoc_vec3_t7.y, GameMath.FP_1 - n));
            xaoc_particle_system_3d_t2.x[1].y = (int)((float)xaoc_particle_system_3d_t2.x[1].y + 0.1f * (float)GameMath.mul(xaoc_vec3_t7.y, n));
            xaoc_particle_system_3d_t2.x[0].z = (int)((float)xaoc_particle_system_3d_t2.x[0].z + 0.1f * (float)GameMath.mul(xaoc_vec3_t7.z, GameMath.FP_1 - n));
            xaoc_particle_system_3d_t2.x[1].z = (int)((float)xaoc_particle_system_3d_t2.x[1].z + 0.1f * (float)GameMath.mul(xaoc_vec3_t7.z, n));
            xaoc_vec3_t7.x = GameMath.mul(n5, GameMath.mul(xaoc_vec3_t6.x, n3) >> 1);
            xaoc_vec3_t7.y = GameMath.mul(n5, GameMath.mul(xaoc_vec3_t6.y, n3) >> 1);
            xaoc_vec3_t7.z = GameMath.mul(n5, GameMath.mul(xaoc_vec3_t6.z, n3) >> 1);
            xaoc_particle_system_3d_t3.x[0].x = (int)((float)xaoc_particle_system_3d_t3.x[0].x - 0.1f * (float)xaoc_vec3_t7.x);
            xaoc_particle_system_3d_t3.x[0].y = (int)((float)xaoc_particle_system_3d_t3.x[0].y - 0.1f * (float)xaoc_vec3_t7.y);
            xaoc_particle_system_3d_t3.x[0].z = (int)((float)xaoc_particle_system_3d_t3.x[0].z - 0.1f * (float)xaoc_vec3_t7.z);
        }
        return true;
    }

    private void pinsCollision(PhisicsVerlet.xaoc_particle_system_3d_t xaoc_particle_system_3d_t2, PhisicsVerlet.xaoc_particle_system_3d_t xaoc_particle_system_3d_t3) {
        int n = 0;
        int n2 = 0;
        if (!xaoc_particle_system_3d_t2.remains || !xaoc_particle_system_3d_t3.remains) {
            return;
        }
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t2 = new PhisicsVerlet.xaoc_vec3_t();
        if (this.PinsDistance(xaoc_particle_system_3d_t2, xaoc_particle_system_3d_t3, xaoc_vec3_t2) == GameMath.FP_MAX) {
            return;
        }
        int n3 = xaoc_vec3_t2.x;
        int n4 = xaoc_vec3_t2.y;
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t3 = new PhisicsVerlet.xaoc_vec3_t();
        PhisicsVerlet.xaoc_set_vec3(xaoc_vec3_t3, GameMath.mul(xaoc_particle_system_3d_t2.x[0].x, GameMath.FP_1 - n3) + GameMath.mul(xaoc_particle_system_3d_t2.x[1].x, n3), GameMath.mul(xaoc_particle_system_3d_t2.x[0].y, GameMath.FP_1 - n3) + GameMath.mul(xaoc_particle_system_3d_t2.x[1].y, n3), GameMath.mul(xaoc_particle_system_3d_t2.x[0].z, GameMath.FP_1 - n3) + GameMath.mul(xaoc_particle_system_3d_t2.x[1].z, n3), 1);
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t4 = new PhisicsVerlet.xaoc_vec3_t();
        PhisicsVerlet.xaoc_set_vec3(xaoc_vec3_t4, GameMath.mul(xaoc_particle_system_3d_t3.x[0].x, GameMath.FP_1 - n4) + GameMath.mul(xaoc_particle_system_3d_t3.x[1].x, n4), GameMath.mul(xaoc_particle_system_3d_t3.x[0].y, GameMath.FP_1 - n4) + GameMath.mul(xaoc_particle_system_3d_t3.x[1].y, n4), GameMath.mul(xaoc_particle_system_3d_t3.x[0].z, GameMath.FP_1 - n4) + GameMath.mul(xaoc_particle_system_3d_t3.x[1].z, n4), 1);
        int n5 = PhisicsVerlet.xaoc_vec3_distance(xaoc_vec3_t4, xaoc_vec3_t3);
        if (n5 > xaoc_particle_system_3d_t2.radius[0] + xaoc_particle_system_3d_t3.radius[0]) {
            return;
        }
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t5 = new PhisicsVerlet.xaoc_vec3_t();
        PhisicsVerlet.xaoc_set_vec3(xaoc_vec3_t5, GameMath.mul(xaoc_particle_system_3d_t2.old_x[0].x, GameMath.FP_1 - n3) + GameMath.mul(xaoc_particle_system_3d_t2.old_x[1].x, n3), GameMath.mul(xaoc_particle_system_3d_t2.old_x[0].y, GameMath.FP_1 - n3) + GameMath.mul(xaoc_particle_system_3d_t2.old_x[1].y, n3), GameMath.mul(xaoc_particle_system_3d_t2.old_x[0].z, GameMath.FP_1 - n3) + GameMath.mul(xaoc_particle_system_3d_t2.old_x[1].z, n3), 1);
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t6 = new PhisicsVerlet.xaoc_vec3_t();
        PhisicsVerlet.xaoc_set_vec3(xaoc_vec3_t6, GameMath.mul(xaoc_particle_system_3d_t3.old_x[0].x, GameMath.FP_1 - n4) + GameMath.mul(xaoc_particle_system_3d_t3.x[1].x, n4), GameMath.mul(xaoc_particle_system_3d_t3.old_x[0].y, GameMath.FP_1 - n4) + GameMath.mul(xaoc_particle_system_3d_t3.x[1].y, n4), GameMath.mul(xaoc_particle_system_3d_t3.old_x[0].z, GameMath.FP_1 - n4) + GameMath.mul(xaoc_particle_system_3d_t3.x[1].z, n4), 1);
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t7 = new PhisicsVerlet.xaoc_vec3_t();
        PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t8 = new PhisicsVerlet.xaoc_vec3_t();
        this.impulse(xaoc_vec3_t3, xaoc_vec3_t4, xaoc_vec3_t5, xaoc_vec3_t6, xaoc_particle_system_3d_t2.m[0] + xaoc_particle_system_3d_t2.m[1], xaoc_particle_system_3d_t3.m[0] + xaoc_particle_system_3d_t3.m[1], xaoc_vec3_t7, xaoc_vec3_t8);
        if (this.checkStanding(xaoc_particle_system_3d_t2)) {
            if (PhisicsVerlet.xaoc_vec3_square_length(xaoc_vec3_t7) < THRESHOLD_OF_FALLING_2) {
                xaoc_vec3_t8.x -= xaoc_vec3_t7.x;
                xaoc_vec3_t7.x = 0;
                xaoc_vec3_t8.y -= xaoc_vec3_t7.y;
                xaoc_vec3_t7.y = 0;
                xaoc_vec3_t8.z -= xaoc_vec3_t7.z;
                xaoc_vec3_t7.z = 0;
                n = 1;
            } else {
                n2 = 2;
            }
        } else if (this.checkStanding(xaoc_particle_system_3d_t3)) {
            if (PhisicsVerlet.xaoc_vec3_square_length(xaoc_vec3_t8) < THRESHOLD_OF_FALLING_2) {
                xaoc_vec3_t7.x -= xaoc_vec3_t8.x;
                xaoc_vec3_t8.x = 0;
                xaoc_vec3_t7.y -= xaoc_vec3_t8.y;
                xaoc_vec3_t8.y = 0;
                xaoc_vec3_t7.z -= xaoc_vec3_t8.z;
                xaoc_vec3_t8.z = 0;
                n2 = 1;
            } else {
                n = 2;
            }
        }
        xaoc_particle_system_3d_t2.old_x[0].x -= GameMath.mul(GameMath.FP_1 - n3, xaoc_vec3_t7.x);
        xaoc_particle_system_3d_t2.old_x[0].y -= GameMath.mul(GameMath.FP_1 - n3, xaoc_vec3_t7.y);
        xaoc_particle_system_3d_t2.old_x[0].z -= GameMath.mul(GameMath.FP_1 - n3, xaoc_vec3_t7.z);
        xaoc_particle_system_3d_t2.old_x[1].x -= GameMath.mul(n3, xaoc_vec3_t7.x);
        xaoc_particle_system_3d_t2.old_x[1].y -= GameMath.mul(n3, xaoc_vec3_t7.y);
        xaoc_particle_system_3d_t2.old_x[1].z -= GameMath.mul(n3, xaoc_vec3_t7.z);
        xaoc_particle_system_3d_t3.old_x[0].x -= GameMath.mul(GameMath.FP_1 - n4, xaoc_vec3_t8.x);
        xaoc_particle_system_3d_t3.old_x[0].y -= GameMath.mul(GameMath.FP_1 - n4, xaoc_vec3_t8.y);
        xaoc_particle_system_3d_t3.old_x[0].z -= GameMath.mul(GameMath.FP_1 - n4, xaoc_vec3_t8.z);
        xaoc_particle_system_3d_t3.old_x[1].x -= GameMath.mul(n4, xaoc_vec3_t8.x);
        xaoc_particle_system_3d_t3.old_x[1].y -= GameMath.mul(n4, xaoc_vec3_t8.y);
        xaoc_particle_system_3d_t3.old_x[1].z -= GameMath.mul(n4, xaoc_vec3_t8.z);
        if (n5 <= xaoc_particle_system_3d_t2.radius[0] + xaoc_particle_system_3d_t3.radius[0]) {
            int n6;
            PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t9 = new PhisicsVerlet.xaoc_vec3_t();
            PhisicsVerlet.xaoc_vec3_t xaoc_vec3_t10 = new PhisicsVerlet.xaoc_vec3_t();
            xaoc_vec3_t9.x = xaoc_vec3_t4.x - xaoc_vec3_t3.x;
            xaoc_vec3_t9.y = xaoc_vec3_t4.y - xaoc_vec3_t3.y;
            xaoc_vec3_t9.z = xaoc_vec3_t4.z - xaoc_vec3_t3.z;
            if (n5 > 0) {
                n6 = GameMath.div(n5 - (this.pinRadius << 1), n5);
            } else {
                n5 = GameMath.sqrtFP(GameMath.mul(xaoc_vec3_t9.x << GameMath.CORRECTION_SHIFT, xaoc_vec3_t9.x << GameMath.CORRECTION_SHIFT) + GameMath.mul(xaoc_vec3_t9.y << GameMath.CORRECTION_SHIFT, xaoc_vec3_t9.y << GameMath.CORRECTION_SHIFT) + GameMath.mul(xaoc_vec3_t9.z << GameMath.CORRECTION_SHIFT, xaoc_vec3_t9.z << GameMath.CORRECTION_SHIFT));
                n6 = GameMath.div(n5 - (this.pinRadius << 1 << GameMath.CORRECTION_SHIFT), n5);
            }
            xaoc_vec3_t10.x = GameMath.mul(xaoc_vec3_t9.x, n6) >> 1;
            xaoc_vec3_t10.y = GameMath.mul(xaoc_vec3_t9.y, n6) >> 1;
            xaoc_vec3_t10.z = GameMath.mul(xaoc_vec3_t9.z, n6) >> 1;
            if (n != 1) {
                xaoc_particle_system_3d_t2.x[0].x = (int)((float)xaoc_particle_system_3d_t2.x[0].x + 0.1f * (float)GameMath.mul(xaoc_vec3_t10.x, GameMath.FP_1 - n3));
                xaoc_particle_system_3d_t2.x[1].x += GameMath.mul(xaoc_vec3_t10.x, n3);
                xaoc_particle_system_3d_t2.x[0].y = (int)((float)xaoc_particle_system_3d_t2.x[0].y + 0.1f * (float)GameMath.mul(xaoc_vec3_t10.y, GameMath.FP_1 - n3));
                xaoc_particle_system_3d_t2.x[1].y += GameMath.mul(xaoc_vec3_t10.y, n3);
                xaoc_particle_system_3d_t2.x[0].z = (int)((float)xaoc_particle_system_3d_t2.x[0].z + 0.1f * (float)GameMath.mul(xaoc_vec3_t10.z, GameMath.FP_1 - n3));
                xaoc_particle_system_3d_t2.x[1].z += GameMath.mul(xaoc_vec3_t10.z, n3);
            }
            if (n2 != 1) {
                xaoc_particle_system_3d_t3.x[0].x = (int)((float)xaoc_particle_system_3d_t3.x[0].x - 0.1f * (float)GameMath.mul(xaoc_vec3_t10.x, GameMath.FP_1 - n4));
                xaoc_particle_system_3d_t3.x[1].x -= GameMath.mul(xaoc_vec3_t10.x, n4);
                xaoc_particle_system_3d_t3.x[0].y = (int)((float)xaoc_particle_system_3d_t3.x[0].y - 0.1f * (float)GameMath.mul(xaoc_vec3_t10.y, GameMath.FP_1 - n4));
                xaoc_particle_system_3d_t3.x[1].y -= GameMath.mul(xaoc_vec3_t10.y, n4);
                xaoc_particle_system_3d_t3.x[0].z = (int)((float)xaoc_particle_system_3d_t3.x[0].z - 0.1f * (float)GameMath.mul(xaoc_vec3_t10.z, GameMath.FP_1 - n4));
                xaoc_particle_system_3d_t3.x[1].z -= GameMath.mul(xaoc_vec3_t10.z, n4);
            }
        }
    }

    private void checkRemaining(PhisicsVerlet.xaoc_particle_system_3d_t xaoc_particle_system_3d_t2) {
        if (!xaoc_particle_system_3d_t2.remains) {
            return;
        }
        boolean bl = true;
        for (int i = 0; i < xaoc_particle_system_3d_t2.size; ++i) {
            if (!((float)xaoc_particle_system_3d_t2.x[i].x > (float)(-xaoc_particle_system_3d_t2.radius[i]) - 20480.0f)) continue;
            bl = false;
            break;
        }
        if (bl) {
            xaoc_particle_system_3d_t2.remains = false;
        }
    }

    private void checkIsDown(PhisicsVerlet.xaoc_particle_system_3d_t xaoc_particle_system_3d_t2) {
        if (!xaoc_particle_system_3d_t2.remains) {
            return;
        }
        for (int i = 0; i < xaoc_particle_system_3d_t2.size; ++i) {
            if (xaoc_particle_system_3d_t2.x[i].z <= xaoc_particle_system_3d_t2.radius[i]) continue;
            return;
        }
        xaoc_particle_system_3d_t2.remains = false;
    }

    private void bowlingApplyGravity() {
        this.ball.a[0].z = GRAVITY;
        for (int i = 0; i < 10; ++i) {
            if (this.checkStanding(i)) {
                this.pins[i].a[0].z = GRAVITY;
                this.pins[i].a[1].z = GRAVITY;
                continue;
            }
            this.pins[i].a[0].z = GRAVITY;
            this.pins[i].a[1].z = GRAVITY;
        }
    }

    public void singleUpdate(float f) {
        int n;
        this.bowlingApplyGravity();
        PhisicsVerlet.xaoc_verlet_3d(this.ball, (int)f);
        for (n = 0; n < 10; ++n) {
            PhisicsVerlet.xaoc_verlet_3d(this.pins[n], (int)f);
        }
        for (n = 0; n < 10; ++n) {
            this.pins[n].a[1].y = 0;
            this.pins[n].a[1].x = 0;
            this.pins[n].a[0].y = 0;
            this.pins[n].a[0].x = 0;
        }
        this.checkRemaining(this.ball);
        for (n = 0; n < 10; ++n) {
            this.checkRemaining(this.pins[n]);
        }
        for (n = 0; n < 10; ++n) {
            if (!this.pinBallCollision(this.pins[n], this.ball) || this.firstPin != -1 || !this.pins[n].remains) continue;
            this.firstPin = n;
        }
        for (n = 0; n < 10; ++n) {
            for (int i = n; i < 10; ++i) {
                if (n == i) continue;
                this.pinsCollision(this.pins[n], this.pins[i]);
            }
        }
        this.ballConstraints(this.ball);
        for (n = 0; n < 10; ++n) {
            this.bowlingConstraints(this.pins[n]);
        }
    }

    private boolean checkStanding(int n) {
        return this.checkStanding(this.pins[n]);
    }

    private boolean checkStanding(PhisicsVerlet.xaoc_particle_system_3d_t xaoc_particle_system_3d_t2) {
        return xaoc_particle_system_3d_t2.size == 2 && xaoc_particle_system_3d_t2.remains && xaoc_particle_system_3d_t2.x[0].x == xaoc_particle_system_3d_t2.x[1].x && xaoc_particle_system_3d_t2.x[0].y == xaoc_particle_system_3d_t2.x[1].y;
    }

    private float checkBallX(float f) {
        if (!this.ballInGutter && (f < 0.22f || f > 1.27f)) {
            this.ballInGutter = true;
        }
        if (this.ballInGutter) {
            f = f < 0.745f ? 0.11f : 1.38f;
        }
        return f;
    }

    public int getRandomTarget() {
        byte[] byArray = null;
        switch (this.game.precisionSequence) {
            case 0: {
                byArray = this.sequence1;
                break;
            }
            case 1: {
                byArray = this.sequence2;
                break;
            }
            case 2: {
                byArray = this.sequence3;
                break;
            }
            case 3: {
                byArray = this.sequence4;
                break;
            }
            case 4: {
                byArray = this.sequence5;
            }
        }
        for (int i = 0; i < 10; ++i) {
            if (this.pinRemoved[byArray[i]]) continue;
            return byArray[i];
        }
        return 0;
    }

    public void setAiMove(boolean bl) {
        this.aiMove = bl;
    }

    public boolean isFinished() {
        return this.collidingBall.isFinished();
    }

    public boolean isFinishedVisualization() {
        return !this.collidingBall.isNextMove();
    }

    public void finishVisualization() {
        if (!this.isFinishedVisualization()) {
            this.setPrecalcTranslationToObjects(1, true);
        }
    }

    public static class TimeFactor {
        int timeScaleFactor;
        int timeMultFactor;
    }
}

