/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.World;
import portinglib.Debug;
import portinglib.Graphics2D;
import portinglib.ResourceManager;
import portinglib.SoundManager;
import portinglib.StringTable;
import userapp.Device;
import userapp.Game;
import userapp.MenuBaseChoosePlayer;
import userapp.MenuDialogMainMenu;
import userapp.OptimizationUtils;
import userapp.PortingParser;
import userapp.PortingUtils;
import userapp.UserApp;

class MenuBaseSinglePlate {
    protected Node effectsNode;
    protected Node allNode;
    protected int m_itemCurr;
    protected int m_itemNext;
    protected boolean m_lArrowIsHidden;
    protected boolean m_rArrowIsHidden;
    protected int m_text;
    protected int m_text2;
    protected String m_textString;
    protected boolean isExitFlag;
    protected int[] m_itemList;
    protected int m_itemNum;
    protected int m_header;
    private int m_laneTextOffset;
    private int m_itemScrollStartTime;
    private int m_itemScrollDirection;
    protected static Group group;
    protected static Camera camera;
    protected Game game;
    protected static int oldTime;
    protected static int realOldTime;
    protected static int ITEM_SCROLL_SPEED_PIXEL_IN_MS;
    protected static int ITEM_SCROLL_ITEMS_DISTANCE;
    protected boolean promoteGames = false;
    protected int promoteSplashNum = 0;
    public static boolean demoEnabled;
    public static boolean upsellEnabled;
    public static boolean doDemoScreen;
    public static boolean demoSoftkey;
    public static boolean demoEndShowed;
    public static byte whichDemoScreen;
    private int padlocksOffsetX = 10;
    protected boolean showEndScreen = false;
    protected boolean canPlay = false;
    protected boolean graySoftkey = false;
    public static boolean allFramesPlayed;
    protected long demoScreenTime;
    protected int[] blockedList = new int[4];
    private static final boolean DEBUG = false;

    public MenuBaseSinglePlate(int[] nArray, int n, int n2, int n3) {
        this.m_itemList = nArray;
        this.m_itemNum = n;
        this.m_text = n3;
        this.m_text2 = -1;
        this.m_header = n2;
        this.m_itemNext = -1;
        this.m_lArrowIsHidden = true;
        this.m_rArrowIsHidden = true;
        this.m_textString = null;
        if (demoEnabled) {
            this.blockedList[0] = 45;
            this.blockedList[1] = 152;
            this.blockedList[2] = UserApp.gamesPlayed >= 3 ? 337 : -1;
            this.blockedList[3] = 125;
        }
    }

    public MenuBaseSinglePlate(int[] nArray, int n, int n2, String string) {
        this.m_itemList = nArray;
        this.m_itemNum = n;
        this.m_text = -1;
        this.m_text2 = -1;
        this.m_header = n2;
        this.m_itemNext = -1;
        this.m_lArrowIsHidden = true;
        if (demoEnabled) {
            this.blockedList[0] = 45;
            this.blockedList[1] = 152;
            this.blockedList[2] = UserApp.gamesPlayed >= 3 ? 337 : -1;
            this.blockedList[3] = 125;
        }
        this.m_rArrowIsHidden = true;
        this.m_textString = string;
    }

    public void tune(int[] nArray, int n) {
        this.m_itemList = nArray;
        this.m_itemNum = nArray.length;
        this.m_text = -1;
        this.m_text2 = -1;
        this.m_header = n;
        this.m_itemNext = -1;
        this.m_lArrowIsHidden = true;
        this.m_rArrowIsHidden = true;
        this.m_textString = null;
    }

    public void tune(int[] nArray, int n, int n2) {
        this.m_itemList = nArray;
        this.m_itemNum = nArray.length;
        this.m_text = -1;
        this.m_text2 = -1;
        this.m_header = n;
        this.m_itemNext = n2;
        this.m_lArrowIsHidden = true;
        this.m_rArrowIsHidden = true;
        this.m_textString = null;
    }

    public void loadGroup() {
        if (group == null) {
            try {
                System.gc();
                Thread.sleep(50L);
                group = (Group)ResourceManager.getM3GResource(86);
                this.effectsNode = (Node)group.find(395190240);
                this.allNode = (Node)group.find(233322159);
                PortingParser.printObjectTree((Object3D)group);
                camera = ((World)group).getActiveCamera();
                OptimizationUtils.setupProjection(camera, true);
                this.clearBack();
                Thread.sleep(50L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void onStart() {
        if (demoEnabled) {
            this.blockedList[0] = 45;
            this.blockedList[1] = 152;
            this.blockedList[2] = UserApp.gamesPlayed >= 3 ? 337 : -1;
            this.blockedList[3] = 125;
        }
        this.m_text2 = -1;
        this.m_laneTextOffset = 0;
        if (!SoundManager.isPlaying(4)) {
            SoundManager.stopAllSounds();
        }
        this.loadGroup();
        Game.m_app.playMenuSound();
    }

    public void onShow() {
    }

    public void onHide() {
        SoundManager.stopSound(4);
        Graphics2D.deallocate(59);
        Graphics2D.deallocate(38);
        Graphics2D.deallocate(39);
        Graphics2D.deallocate(40);
        Graphics2D.deallocate(41);
        Graphics2D.deallocate(42);
        Graphics2D.deallocate(43);
        Graphics2D.deallocate(44);
        Graphics2D.deallocate(45);
        Graphics2D.deallocate(50);
        Graphics2D.deallocate(51);
        Graphics2D.deallocate(52);
        System.gc();
    }

    public void update(int n) {
        if (Game.m_app.m_continueScreenIsActive) {
            return;
        }
        if (realOldTime == 0 || oldTime == 0) {
            realOldTime = n;
            oldTime = n;
        }
        int n2 = 0;
        if (realOldTime != 0) {
            n2 = (int)((float)(n - realOldTime) * 1.0f);
        }
        MenuBaseSinglePlate menuBaseSinglePlate = this;
        Game.setApplicationTime(menuBaseSinglePlate.game.getApplicationTime() + n2);
        oldTime += n2;
        realOldTime = n;
        ++this.m_laneTextOffset;
        if (this.isMostLeft() != this.m_lArrowIsHidden) {
            this.updateArrows(true);
        }
        if (this.isMostRight() != this.m_rArrowIsHidden) {
            this.updateArrows(false);
        }
    }

    public void clearBack() {
        Background background = new Background();
        background.setColorClearEnable(false);
        ((World)group).setBackground(background);
        background = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render3DLayer(Graphics2D graphics2D, boolean bl) {
        Graphics3D graphics3D = Graphics3D.getInstance();
        graphics3D.bindTarget((Object)graphics2D.getGraphics());
        try {
            if (this.effectsNode != null && this.allNode != null) {
                if (bl) {
                    this.effectsNode.setRenderingEnable(false);
                    this.allNode.setRenderingEnable(true);
                } else {
                    this.effectsNode.setRenderingEnable(true);
                    this.allNode.setRenderingEnable(false);
                }
            }
            graphics3D.render((World)group);
            if (this.effectsNode != null && this.allNode != null) {
                this.effectsNode.setRenderingEnable(true);
                this.allNode.setRenderingEnable(true);
            }
        }
        catch (IllegalStateException illegalStateException) {
            Debug.TRACE("porting: GameWorld::render3D failed:");
            Debug.TRACE(illegalStateException.toString());
        }
        finally {
            graphics3D.releaseTarget();
        }
    }

    public void render3D(Graphics2D graphics2D) {
        PortingUtils.beginProf("renderMenu3D");
        graphics2D.drawImage(38, UserApp.getWidth() / 2, UserApp.getHeight() / 2, 3);
        if (group == null) {
            return;
        }
        if (!PortingParser.PARSE1) {
            this.render3DLayer(graphics2D, true);
            if (this.effectsNode != null && this.allNode != null && this instanceof MenuDialogMainMenu) {
                this.render3DLayer(graphics2D, false);
            }
            if (this instanceof MenuDialogMainMenu) {
                graphics2D.drawImage(59, UserApp.getWidth() / 2, UserApp.getHeight() / 3, 3);
            }
        } else {
            PortingParser.drawObjectTree((Object3D)((World)group), graphics2D.getGraphics(), UserApp.getWidth(), UserApp.getHeight());
        }
        PortingUtils.endProf();
        if (demoEnabled) {
            graphics2D.drawString(StringTable.get(341), 120, 5, 17);
        }
    }

    protected int getTextOffset(String string, Graphics2D graphics2D) {
        int n = Graphics2D.charsWidth(2, string.toCharArray(), 0, string.length());
        int n2 = Graphics2D.getWidth(44) - 40;
        int n3 = (UserApp.getWidth() - n2) / 2;
        if (n > n2) {
            graphics2D.setClip(n3, 0, n2, UserApp.getHeight());
            if (n - this.m_laneTextOffset + 6 <= n2) {
                this.m_laneTextOffset = -4;
            }
        } else {
            return UserApp.getWidth() / 2;
        }
        return n3 - this.m_laneTextOffset + n / 2;
    }

    private void drawPadlocks(Graphics2D graphics2D, int n, int n2, int n3) {
        graphics2D.drawImage(57, n, this.getTextCenter(), 3);
        graphics2D.drawImage(57, n2, this.getTextCenter(), 3);
    }

    private boolean isBlocked(int n) {
        for (int i = 0; i < this.blockedList.length; ++i) {
            if (this.blockedList[i] != n) continue;
            return true;
        }
        return false;
    }

    public void render2D(Graphics2D graphics2D) {
        if (PortingParser.PARSE1) {
            return;
        }
        PortingUtils.beginProf("renderMenu2D");
        int n = UserApp.getWidth() / 2;
        graphics2D.setFont(2);
        if (doDemoScreen) {
            UserApp.whatToShow(false, graphics2D);
            if (allFramesPlayed) {
                whichDemoScreen = (byte)2;
            }
            demoEndShowed = false;
        } else {
            int n2;
            String string;
            int n3;
            if (this.m_header >= 0 && !allFramesPlayed) {
                n3 = this.getHeaderTop();
                if (!UserApp.useSystemFont()) {
                    graphics2D.drawString(StringTable.get(this.m_header), 11, n3, 20);
                } else {
                    graphics2D.setFont(0);
                    graphics2D.drawString(StringTable.get(this.m_header), 11, n3, 20);
                    graphics2D.setFont(2);
                }
                graphics2D.drawString(StringTable.get(this.m_header), 10, n3 - 1, 20);
            }
            graphics2D.setClip(n - Device.SCREEN_MENU_PLATE_TEXT_WIDTH / 2, 0, Device.SCREEN_MENU_PLATE_TEXT_WIDTH, UserApp.getHeight());
            n3 = 0;
            if (this.m_itemNext >= 0) {
                MenuBaseSinglePlate menuBaseSinglePlate = this;
                n3 = (menuBaseSinglePlate.game.getApplicationTime() - this.m_itemScrollStartTime) * ITEM_SCROLL_SPEED_PIXEL_IN_MS / 1000;
                if (n3 >= ITEM_SCROLL_ITEMS_DISTANCE) {
                    this.m_itemCurr = this.m_itemNext;
                    this.m_itemNext = -1;
                    n3 = 0;
                } else {
                    n3 *= this.m_itemScrollDirection;
                    this.graySoftkey = false;
                    if (this.isBlocked(this.m_itemList[this.m_itemNext])) {
                        int n4 = Graphics2D.charsWidth(2, StringTable.get(this.m_itemList[this.m_itemNext]).toCharArray(), 0, StringTable.get(this.m_itemList[this.m_itemNext]).length());
                        if (this.m_itemList[this.m_itemNext] != 125) {
                            this.graySoftkey = true;
                        }
                        this.drawPadlocks(graphics2D, n - this.m_itemScrollDirection * ITEM_SCROLL_ITEMS_DISTANCE + n3 - ((n4 /= 2) + this.padlocksOffsetX), n - this.m_itemScrollDirection * ITEM_SCROLL_ITEMS_DISTANCE + n3 + (n4 + this.padlocksOffsetX), this.getTextCenter());
                        graphics2D.setFont(2);
                    }
                    graphics2D.drawString(StringTable.get(this.m_itemList[this.m_itemNext]), n - this.m_itemScrollDirection * ITEM_SCROLL_ITEMS_DISTANCE + n3, this.getTextCenter(), 3);
                    graphics2D.setFont(2);
                }
            }
            if (this.m_text > 0) {
                string = StringTable.get(this.m_text);
                graphics2D.drawString(string, this.m_itemNext < 0 ? this.getTextOffset(string, graphics2D) : n + n3, this.getTextCenter() + 0, 3);
            } else {
                String string2 = string = this.m_textString != null ? this.m_textString : StringTable.get(this.m_itemList[this.m_itemCurr]);
                if (this.isBlocked(this.m_itemList[this.m_itemCurr])) {
                    graphics2D.setFont(2);
                    int n5 = Graphics2D.charsWidth(2, string.toCharArray(), 0, string.length());
                    n5 /= 2;
                    this.graySoftkey = true;
                    int n6 = graphics2D.getClipX();
                    int n7 = graphics2D.getClipY();
                    int n8 = graphics2D.getClipWidth();
                    int n9 = graphics2D.getClipHeight();
                    graphics2D.setClip(0, 0, 320, 320);
                    n2 = n - (Graphics2D.getWidth(44) - 40) / 2 - this.padlocksOffsetX;
                    int n10 = n + (Graphics2D.getWidth(44) - 40) / 2 + this.padlocksOffsetX;
                    this.drawPadlocks(graphics2D, n2, n10, this.getTextCenter());
                    graphics2D.setClip(n6, n7, n8, n9);
                } else {
                    this.graySoftkey = false;
                }
                if (this.isBlocked(this.m_itemList[this.m_itemCurr])) {
                    this.getTextOffset(string, graphics2D);
                    graphics2D.drawString(string, this.m_itemNext < 0 ? this.getTextOffset(string + "AA", graphics2D) : n + n3, this.getTextCenter() + 0, 3);
                } else {
                    graphics2D.drawString(string, this.m_itemNext < 0 ? this.getTextOffset(string, graphics2D) : n + n3, this.getTextCenter() + 0, 3);
                }
                graphics2D.setFont(2);
            }
            if (this.m_text2 > 0) {
                graphics2D.drawString(StringTable.get(this.m_text2), this.getTextOffset(StringTable.get(this.m_text2), graphics2D), this.getText2Center() + 0, 3);
            }
            graphics2D.setClip(0, 0, UserApp.getWidth(), UserApp.getHeight());
            int n11 = this.getArrowsOffset();
            n2 = this.getTextCenter();
            if (!allFramesPlayed) {
                if (UserApp.useSystemFont()) {
                    graphics2D.setFont(1);
                }
                if (!this.m_lArrowIsHidden && this.m_itemNum > 1) {
                    graphics2D.drawString("<", n11, n2, 6);
                }
                n11 = UserApp.getWidth() - Graphics2D.charWidth(UserApp.useSystemFont() ? 1 : 2, '<') + 2 - this.getArrowsOffset();
                if (!this.m_rArrowIsHidden && this.m_itemNum > 1) {
                    graphics2D.drawString(">", n11, n2, 6);
                }
                if (UserApp.useSystemFont()) {
                    graphics2D.setFont(2);
                }
            }
            graphics2D.drawImage(40, n, UserApp.getHeight() - Graphics2D.getHeight(40), 17);
            if (this.drawBack()) {
                this.drawSoftKey(graphics2D, StringTable.get(141), 0, false);
            }
            if (this.drawSelect()) {
                this.drawSoftKey(graphics2D, StringTable.get(318), 0, true);
            }
            if (this.graySoftkey) {
                graphics2D.setFont(2);
            }
            if (this.drawExit()) {
                if (allFramesPlayed) {
                    if (this.m_itemCurr != 2) {
                        this.drawSoftKey(graphics2D, "Next", -7, false);
                    } else {
                        this.drawSoftKey(graphics2D, "Exit", -7, false);
                    }
                } else {
                    this.drawSoftKey(graphics2D, StringTable.get(33), 0, false);
                }
            }
            PortingUtils.endProf();
        }
    }

    protected void drawSoftKey(Graphics2D graphics2D, String string, int n, boolean bl) {
        if (bl) {
            graphics2D.drawString(string, UserApp.getWidth() * 5 / 100 + n + 0, UserApp.getHeight() - Graphics2D.getHeight(40) / 2, 6);
        } else {
            graphics2D.drawString(string, UserApp.getWidth() * 95 / 100 + n + 0, UserApp.getHeight() - Graphics2D.getHeight(40) / 2, 10);
        }
    }

    protected boolean drawExit() {
        return false;
    }

    protected boolean drawBack() {
        return false;
    }

    protected boolean drawSelect() {
        return false;
    }

    protected void setHeader(int n) {
        this.m_header = n;
    }

    protected void setTextString(String string) {
        this.m_textString = string;
    }

    protected void setText(int n) {
        this.m_text = n;
    }

    protected void setText2(int n) {
        this.m_text2 = n;
    }

    protected int getHeaderTop() {
        return UserApp.getHeight() - Device.SCREEN_MENU_PLATE_HEIGHT - Graphics2D.getHeight(40) - Device.SCREEN_MENU_PLATE_HEADER_OFFSET_Y;
    }

    protected int getText2Center() {
        return 0;
    }

    protected int getTextCenter() {
        return UserApp.getHeight() - Device.SCREEN_MENU_PLATE_HEIGHT / 2 - Graphics2D.getHeight(40);
    }

    protected int getArrowsOffset() {
        return 0;
    }

    public boolean onKeyPressed(int n) {
        switch (n) {
            case -2: 
            case 52: {
                if (this.showEndScreen && !MenuDialogMainMenu.isPaused) {
                    return true;
                }
                if (allFramesPlayed && !this.promoteGames) {
                    return true;
                }
                if (this.promoteGames) {
                    --this.promoteSplashNum;
                    if (this.promoteSplashNum < 0) {
                        this.promoteSplashNum = 3;
                    }
                    return true;
                }
                if (this.m_itemNext >= 0) {
                    this.m_itemCurr = this.m_itemNext;
                }
                this.m_itemNext = this.m_itemCurr - 1;
                MenuBaseSinglePlate menuBaseSinglePlate = this;
                this.m_itemScrollStartTime = menuBaseSinglePlate.game.getApplicationTime();
                this.m_itemScrollDirection = 1;
                this.onItemChange(this.m_itemNext);
                return true;
            }
            case -5: 
            case 54: {
                if (this.showEndScreen && !MenuDialogMainMenu.isPaused) {
                    return true;
                }
                if (allFramesPlayed && !this.promoteGames) {
                    return true;
                }
                if (this.promoteGames) {
                    ++this.promoteSplashNum;
                    if (this.promoteSplashNum == 4) {
                        this.promoteSplashNum = 0;
                    }
                    return true;
                }
                if (this.m_itemNext >= 0) {
                    this.m_itemCurr = this.m_itemNext;
                }
                this.m_itemNext = this.m_itemCurr + 1;
                if (this.m_itemNext >= this.m_itemNum) {
                    this.m_itemNext = -1;
                }
                MenuBaseSinglePlate menuBaseSinglePlate = this;
                this.m_itemScrollStartTime = menuBaseSinglePlate.game.getApplicationTime();
                this.m_itemScrollDirection = -1;
                this.onItemChange(this.m_itemNext);
                return true;
            }
            case -21: 
            case -20: 
            case 53: {
                if (this.showEndScreen && !MenuDialogMainMenu.isPaused) {
                    this.m_itemCurr = 1;
                    this.showEndScreen = false;
                    if (this instanceof MenuBaseChoosePlayer) {
                        this.canPlay = true;
                        this.onItemSelect(0);
                    }
                    return true;
                }
                if (n == -21 && !allFramesPlayed && this.m_itemList[this.m_itemCurr] == 125) {
                    Game.m_app.getTheGame(0);
                    break;
                }
                if ((n == -20 || n == -21 || n == 53) && (this.isBlocked(this.m_itemList[this.m_itemCurr]) || UserApp.gamesPlayed >= 3 && this.m_itemList[this.m_itemCurr] == 337)) break;
                if (n == -21 && allFramesPlayed && this.m_itemList[this.m_itemCurr] == 27) {
                    Game.m_app.getTheGame(0);
                    return true;
                }
                if (this.m_itemNext >= 0) {
                    this.m_itemCurr = this.m_itemNext;
                    this.m_itemNext = -1;
                }
                this.onItemSelect(this.m_itemCurr);
                return !this.isExitFlag;
            }
        }
        return false;
    }

    public boolean onKeyReleased(int n) {
        return false;
    }

    public int getCurrentItemName() {
        return this.m_itemList[this.m_itemCurr];
    }

    public boolean isMostLeft() {
        return this.m_itemNext == -1 ? this.m_itemCurr == 0 : this.m_itemNext == 0;
    }

    public boolean isMostRight() {
        return this.m_itemNext == -1 ? this.m_itemCurr == this.m_itemNum - 1 : this.m_itemNext == this.m_itemNum - 1;
    }

    public void updateArrows(boolean bl) {
        if (bl) {
            this.m_lArrowIsHidden = this.isMostLeft();
        }
        if (!bl) {
            this.m_rArrowIsHidden = this.isMostRight();
        }
    }

    public void hideArrows() {
    }

    public void setItemCur(int n) {
        this.m_itemCurr = n;
    }

    protected void onItemSelect(int n) {
    }

    protected void onItemChange(int n) {
    }

    static {
        ITEM_SCROLL_SPEED_PIXEL_IN_MS = 400;
        ITEM_SCROLL_ITEMS_DISTANCE = 130;
        demoEnabled = false;
        upsellEnabled = false;
        doDemoScreen = false;
        demoSoftkey = false;
        demoEndShowed = true;
        whichDemoScreen = 1;
        allFramesPlayed = false;
    }
}

