/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import portinglib.Graphics2D;
import portinglib.StringTable;
import userapp.PortingUtils;
import userapp.UserApp;

class LoaderBar {
    protected UserApp m_pApp;
    protected int m_currState;
    protected int m_numStates;
    protected int m_imageId;
    protected int m_bgId;
    private boolean barVisible = true;

    public LoaderBar(UserApp userApp) {
        this.m_pApp = userApp;
        this.m_currState = 0;
        this.m_numStates = 0;
        this.m_imageId = 31;
        this.m_bgId = 38;
    }

    public void start(int n) {
        this.m_currState = 0;
        this.m_numStates = n;
    }

    public void stop() {
        UserApp.restoreBufferClip();
        this.m_numStates = 0;
        this.unloadImages();
    }

    public void nextState() {
        ++this.m_currState;
    }

    public void unloadImages() {
    }

    public void setState(int n) {
        this.m_currState = n;
    }

    public int getState() {
        return this.m_currState;
    }

    public void setBarVisible(boolean bl) {
        this.barVisible = bl;
    }

    public void render2D(Graphics2D graphics2D) {
        PortingUtils.beginProf("renderLoaderBar");
        if (this.m_numStates == 0 || graphics2D == null) {
            PortingUtils.endProf();
            return;
        }
        if (this.m_currState >= this.m_numStates) {
            this.m_currState = this.m_numStates - 1;
        }
        int n = UserApp.getWidth() / 2;
        int n2 = UserApp.getHeight() / 2;
        int n3 = Graphics2D.getWidth(this.m_imageId);
        int n4 = Graphics2D.getHeight(this.m_imageId);
        graphics2D.drawImage(this.m_bgId, n, n2, 3);
        System.gc();
        UserApp.restoreBufferClip();
        graphics2D.setFillColor(0x444444);
        graphics2D.setFillMode(1);
        graphics2D.drawRect(0, n2 - Graphics2D.getFontHeight(2) * 3 / 2, UserApp.getWidth(), Graphics2D.getFontHeight(2) * 5 / 4);
        graphics2D.drawString(StringTable.get(7), n + 0, n2 - Graphics2D.getFontHeight(2) / 2 + 1, 33);
        if (this.barVisible) {
            graphics2D.setClip(n - n3 / 2, n2, n3 * (this.m_currState + 1) / this.m_numStates, n4);
            graphics2D.drawImage(this.m_imageId, n, n2, 17);
        }
        if (this.m_currState == this.m_numStates - 1) {
            this.unloadImages();
            this.m_numStates = 0;
        }
        PortingUtils.endProf();
    }
}

