/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import java.util.Random;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.World;
import portinglib.Debug;
import portinglib.StringTable;
import userapp.AIThrowParams;
import userapp.AnimationObject;
import userapp.Animator;
import userapp.CameraObject;
import userapp.Consts;
import userapp.ExpoInObject;
import userapp.FrameResultObject;
import userapp.Game;
import userapp.NodeObject;
import userapp.OnePlayer;
import userapp.OptimizationUtils;
import userapp.PhysicObject;
import userapp.Physics;
import userapp.PinObject;
import userapp.PortingUtils;
import userapp.PowerMeterObject;
import userapp.SimpleGuiObject;
import userapp.ThrowResultObject;
import userapp.Tools;
import userapp.TrackRecorder;
import userapp.TriangleObject;
import userapp.UserApp;

class GameWorld {
    final int[] streak_ids = new int[]{10, 0, 826002820, 851980864, 83815449, 37525240, 771163095, 361569235, 549619666, 285003722, 311277640, 1021247750, 235038929, 915478649, 872587226, 880080034, 28, 534019060, 96385214, 381487117, 422178568, 1052245645, 26096671, 626368840, 24, 146801953, 28, 0, 28, 0, 19, 20, 21, 2, 3, 4, 0};
    final int[] kitti_ids = new int[]{11, 0, 826002820, 498271864, 694545471, 46837072, 990334783, 142397547, 776982938, 315892570, 922028340, 187557922, 657786633, 207876945, 232824714, 446338442, 23, 347317808, 667648058, 591922431, 608879820, 601554697, 26096671, 626368840, 25, 146801953, 28, 0, 28, 0, 22, 23, 24, 0, 1, 5, 1};
    final int[] dazzl_ids = new int[]{13, 0, 503643708, 811342720, 102313945, 641960904, 863780457, 150970861, 54745330, 1038130178, 570524124, 328292678, 64450975, 514360663, 232824714, 1051554708, 5, 825935800, 247022210, 204936985, 130261828, 914625553, 26096671, 626368840, 26, 146801953, 28, 0, 28, 0, 25, 26, 27, 0, 1, 7, 1};
    final int[] lilzee_ids = new int[]{12, 0, 528299617, 407530744, 1029318847, 51125968, 1013425855, 119306475, 174972114, 885865622, 69137064, 1009169314, 344823399, 689021690, 872587226, 149202778, 25, 71475268, 359388486, 249384957, 884722360, 295447075, 26096671, 626368840, 27, 146801953, 28, 0, 28, 0, 28, 29, 30, 2, 3, 6, 0};
    public static final int[][] PLAYERS = new int[][]{{0, 1, 2, 3}, {1, 0, 2, 3}, {2, 0, 1, 3}, {3, 0, 1, 2}};
    public static final int BOWLER_M3G_INDEX = 0;
    public static final int BOWLER_FX_DIR_INDEX = 1;
    public static final int BOWLER_TRANSFORM_INDEX = 2;
    public static final int BALL_TRANSFORM_INDEX = 3;
    public static final int BALL_GLOW_TRANSFORM_INDEX = 4;
    public static final int BALL_REF_TRANSFORM_INDEX = 5;
    public static final int MBLUR_R_TRANSFORM_INDEX = 6;
    public static final int MBLUR_L_TRANSFORM_INDEX = 7;
    public static final int BALLGLOW_ANIM_INDEX = 8;
    public static final int MBLUR_R_INDEX = 9;
    public static final int MBLUR_L_INDEX = 10;
    public static final int BALL_GIFT_TRANSFORM_INDEX = 11;
    public static final int BALL_GIFT_ANIM_INDEX = 12;
    public static final int BOWLER_ANIM_INDEX = 13;
    public static final int CAM_SIGNATURE_TRANSFORM_INDEX = 14;
    public static final int ANIM_SIGNATURE_INDEX = 15;
    public static final int BOWLER_ANIM_SPECIAL_THROW_INDEX = 16;
    public static final int BOWLER_FX_POWER_ANIM_INDEX = 17;
    public static final int BOWLER_FX_POWER_INDEX = 18;
    public static final int HEADGLOW_FX_INDEX = 19;
    public static final int HEADGLOW_ANIM_INDEX = 20;
    public static final int POWERMETER_CIRCLE_INDEX = 21;
    public static final int BALL_GOLDEN_TRANSFORM_INDEX = 22;
    public static final int BALL_GOLDEN_ANIM_INDEX = 23;
    public static final int BALL_TEXTURE_INDEX = 24;
    public static final int BALL_LANE_TEXTURE_INDEX = 25;
    public static final int BALL_NORMAL_M3G_INDEX = 26;
    public static final int BALL_GIFT_M3G_INDEX = 27;
    public static final int BALL_GOLDEN_M3G_INDEX = 28;
    public static final int FACE_M3G_INDEX = 29;
    public static final int EMOTION_DEF_INDEX = 30;
    public static final int EMOTION_JOY_INDEX = 31;
    public static final int EMOTION_SAD_INDEX = 32;
    public static final int SAR_PART1_INDEX = 33;
    public static final int SAR_PART2_INDEX = 34;
    public static final int SAR_SPECIAL_INDEX = 35;
    public static final int BONES_ARRAY_INDEX = 36;
    private static UserApp m_app;
    public static Animator pAnim;
    private static Game game;
    private boolean playerLaneSelection;
    private boolean specialThrow;
    private boolean justSwitchedState;
    public boolean wasFault;
    public int power;
    public int fadeStart;
    public World world;
    public NodeObject sunObj;
    public World sunWorld;
    private float hashedX;
    public NodeObject worldObj;
    public NodeObject laneObj;
    public NodeObject laneEnv;
    public PhysicObject ballRootObj;
    public NodeObject arrowsObj;
    public NodeObject headGlowId;
    public int playerBowlerId;
    public int opponentBowlerId;
    public int currentLaneId;
    public int currentBowler;
    public int positionMeterId;
    public int oldState;
    public int state;
    public int nextState;
    public SavedPauseState pauseState;
    public AnimationObject ballSparksRightBeginAnimObj;
    public AnimationObject ballSparksRightAnimObj;
    public AnimationObject ballSparksRightEndAnimObj;
    public AnimationObject ballSparksLeftBeginAnimObj;
    public AnimationObject ballSparksLeftAnimObj;
    public AnimationObject ballSparksLeftEndAnimObj;
    public AnimationObject ballFloorGlowAnimObj;
    public AnimationObject fxPowerAnimObj;
    public AnimationObject fxPowerAnimObjRing;
    public AnimationObject fxPowerAnimObjRing2;
    public AnimationObject pmInitAnimObj;
    public AnimationObject fxPowerAnimObjCollapse;
    public Group powerMeterDummy;
    public Group powerMeterGroup;
    public Group floorGlowGroup;
    public Group sparksRGroup;
    public Group sparksLGroup;
    public Node shadowNode;
    private CameraObject activeCamObj;
    public CameraObject startCamObj;
    public CameraObject idleCamObj;
    public CameraObject powerCamObj;
    public CameraObject faultCamObj;
    public AnimationObject tCameraAnimObj1;
    public AnimationObject tCameraAnimObj2;
    public AnimationObject tCameraAnimObj3;
    public NodeObject[] hashedLanes = new NodeObject[6];
    public NodeObject[] hashedModels = new NodeObject[4];
    public NodeObject[] hashedBallTex = new NodeObject[4];
    public NodeObject hashedNormalBall;
    public PowerMeterObject powerMeterObj;
    public PowerMeterObject spinMeterObj;
    public ExpoInObject expoInObj;
    public SimpleGuiObject guiObj;
    public TriangleObject triangleObj;
    public ThrowResultObject throwResultObj;
    public boolean[] pinVisible = new boolean[10];
    public int stateStartTime;
    public int lastMainStateStartTime;
    public boolean m_wasTurkey;
    public boolean m_wasDoubleTurkey;
    public boolean m_resLoading;
    public int m_resLoadingPlayerId;
    BowlerCreationParams[] bowlerParams = new BowlerCreationParams[4];
    public OnePlayer[] players = new OnePlayer[2];
    private long delayTimer;
    private static final boolean DEBUG = false;

    GameWorld() {
    }

    public void animationFinished(AnimationObject animationObject) {
        if (animationObject.equals(this.tCameraAnimObj1)) {
            this.setGameState(9);
        } else if (animationObject.equals(this.players[this.currentBowler].bowlerThrowStart)) {
            this.fadeStart = game.getApplicationTime();
            OptimizationUtils.timeCoef = 0.4f;
            pAnim.StartAnimation(this.players[this.currentBowler].bowlerThrowPower, true);
            this.power = game.getApplicationTime();
            pAnim.StartAnimation(this.fxPowerAnimObjRing, true);
            this.setRingRendering(true);
            pAnim.StartAnimation(this.fxPowerAnimObjRing2, true);
            this.powerMeterObj.setStartTime(game.getApplicationTime());
            this.powerMeterObj.SetCycleTime(this.players[this.currentBowler].bowlerThrowPower.GetDuration());
        } else if (animationObject.equals(this.players[this.currentBowler].bowlerThrowPower)) {
            if (this.state != 11 && this.state != 10 && this.state != 16) {
                return;
            }
            this.fadeStart = 0;
            OptimizationUtils.timeCoef = 0.75f;
            this.setRingRendering(false);
            this.powerMeterGroup.setRenderingEnable(false);
            this.powerMeterObj.setStartTime(0);
            this.powerMeterObj.SetCycleTime(0);
            if (this.powerMeterObj.getDX() < 86.0f && (GameWorld.game.gameMode == 1 || this.currentBowler == 0) || !GameWorld.game.AIWasFault && GameWorld.game.gameMode != 1 && this.currentBowler != 0) {
                if (GameWorld.game.gameMode != 3 && (GameWorld.m_app.specialAnimCheatEnabled || this.powerMeterObj.getDX() > 77.0f && (GameWorld.game.gameMode == 1 || this.currentBowler == 0) || GameWorld.game.firstThrow && Game.aiResult == 0 && GameWorld.game.gameMode != 1 && this.currentBowler != 0)) {
                    float[] fArray = new float[4];
                    this.players[this.currentBowler].bowlerObj.getSwerveObject().getTranslation(fArray);
                    this.hashedX = fArray[0];
                    this.players[this.currentBowler].bowlerObj.setInPlace(this.world, 826002820);
                    this.setActiveCamera(this.players[this.currentBowler].camSignatureObj);
                    pAnim.StartAnimation(this.players[this.currentBowler].bowlerSpecThrow, true);
                    this.laneObj.SetRenderingEnable(false);
                    this.laneEnv.getSwerveObject().setRenderingEnable(false);
                    this.triangleObj.setVisible(false);
                    this.sunWorld = (World)this.sunObj.getSwerveObject();
                    this.players[this.currentBowler].currntPsycheStatus = 0;
                    this.players[this.currentBowler].bowlerIsSpecThrow = true;
                    m_app.playSound(3, false);
                } else {
                    this.wasFault = false;
                    pAnim.StartAnimation(this.players[this.currentBowler].bowlerDefThrow, true);
                }
            } else {
                this.wasFault = true;
                pAnim.StartAnimation(this.players[this.currentBowler].bowlerFaultThrow, true);
            }
        } else if (animationObject.equals(this.players[this.currentBowler].bowlerStepLeftAnimObj)) {
            if (game.getKeyMask() == 0) {
                game.makeStep(false);
                this.setGameState(4);
            } else {
                game.makeStep(false);
                if (game.canMakeStep()) {
                    game.makeStep(true);
                    if (this.state == 5) {
                        pAnim.StartAnimation(animationObject, true);
                    } else {
                        pAnim.StartAnimation(animationObject, true, false);
                    }
                } else {
                    this.setGameState(4);
                }
            }
        } else if (animationObject.equals(this.players[this.currentBowler].bowlerSpecThrow) || animationObject.equals(this.players[this.currentBowler].bowlerDefThrow) || animationObject.equals(this.players[this.currentBowler].bowlerFaultThrow)) {
            this.triangleObj.setVisible(true);
            if (animationObject.equals(this.players[this.currentBowler].bowlerFaultThrow)) {
                this.setGameState(13);
            } else {
                Object object;
                GameWorld.game.lnkPhysics.resetBall(this.power, !animationObject.equals(this.players[this.currentBowler].bowlerSpecThrow));
                if (animationObject.equals(this.players[this.currentBowler].bowlerSpecThrow)) {
                    this.players[this.currentBowler].bowlerObj.setInPlace(this.world, this.bowlerParams[this.players[this.currentBowler].playerId].ids[2]);
                    object = new float[4];
                    this.players[this.currentBowler].bowlerObj.getSwerveObject().getTranslation((float[])object);
                    this.players[this.currentBowler].bowlerObj.getSwerveObject().setTranslation(this.hashedX, (float)object[1], (float)object[2]);
                    this.laneObj.SetRenderingEnable(true);
                    this.laneEnv.getSwerveObject().setRenderingEnable(true);
                    this.sunWorld = null;
                }
                if (GameWorld.game.gameMode == 1 || this.currentBowler == 0) {
                    if (GameWorld.m_app.specialAnimCheatEnabled) {
                        object = new Random();
                        int n = Math.abs(((Random)object).nextInt());
                        n %= AIThrowParams.LENGTHES[10];
                        n = 3;
                        TrackRecorder.x = AIThrowParams.PARAMS10[n * 4];
                        TrackRecorder.dx = AIThrowParams.PARAMS10[n * 4 + 1];
                        TrackRecorder.dy = AIThrowParams.PARAMS10[n * 4 + 2];
                        TrackRecorder.iterLimit = AIThrowParams.PARAMS10[n * 4 + 3];
                    } else {
                        float f = this.powerMeterObj.getDX();
                        float f2 = this.spinMeterObj.getDX();
                        float[] fArray = new float[4];
                        this.players[this.currentBowler].bowlerObj.getSwerveObject().getTranslation(fArray);
                        float f3 = fArray[0];
                        GameWorld.game.lnkPhysics.findParams(f3, f2, f);
                        TrackRecorder.iterLimit = -1;
                    }
                }
                GameWorld.game.lnkPhysics.calcAllTracks(TrackRecorder.x, TrackRecorder.dx, TrackRecorder.dy);
                OptimizationUtils.movingCameraType = 1;
                this.setGameState(16);
            }
        } else if (animationObject.equals(this.players[this.currentBowler].bowlerIdleToPowerAnimObj)) {
            pAnim.StartAnimation(this.players[this.currentBowler].bowlerIdlePowerAnimObj, true);
        } else if (animationObject.equals(this.ballSparksRightBeginAnimObj)) {
            pAnim.StartAnimation(this.ballSparksRightAnimObj, true);
        } else if (animationObject.equals(this.ballSparksLeftBeginAnimObj)) {
            pAnim.StartAnimation(this.ballSparksLeftAnimObj, true);
        }
    }

    void setReadyText(String string) {
        if (GameWorld.game.gameMode == 1) {
            if (string == StringTable.get(335)) {
                this.guiObj.setMessageType(true);
            } else {
                this.guiObj.setMessageType(false);
            }
            this.guiObj.msgSet(StringTable.get(GameWorld.game.currentPlayer == 0 ? 2 : 3) + " " + string);
        } else {
            this.guiObj.setMessageType(false);
            this.guiObj.msgSet(string);
        }
    }

    void setGameState(int n) {
        if (n == 11) {
            if (this.fxPowerAnimObjRing.isPlaying()) {
                m_app.playSound(0, false);
                pAnim.quickStopAnimation(this.fxPowerAnimObjRing);
                pAnim.quickStopAnimation(this.fxPowerAnimObjRing2);
            }
            if (this.players[this.currentBowler].bowlerThrowStart.isPlaying()) {
                return;
            }
        }
        if (n != 4 && n != 5 && n != 6 || this.state != 4 && this.state != 5 && this.state != 6) {
            game.resetKeys();
        }
        if (this.nextState == 13 && n == 11) {
            return;
        }
        this.oldState = this.state;
        this.state = n;
        this.nextState = n;
        this.stateStartTime = game.getApplicationTime();
        this.justSwitchedState = true;
        if (n != 11) {
            pAnim.stopAllAnim();
        }
        this.currentBowler = GameWorld.game.currentPlayer;
        m_app.regularRunStr(-1);
        if (!this.expoInObj.contextActive()) {
            this.expoInObj.setVisible(false);
        }
        switch (n) {
            case 1: {
                game.blockKeys(450);
                this.cacheModel(this.currentBowler, -1);
                for (int i = 0; i < GameWorld.game.playersNum; ++i) {
                    this.players[i].powerTimeScore = 0;
                    this.players[i].directionTimeScore = 0;
                }
                this.triangleObj.setVisible(true);
                this.delayTimer = System.currentTimeMillis();
                this.setReadyText(StringTable.get(16));
                this.throwResultObj.setVisible(false);
                this.setShowFrameResults(false);
                this.setActiveCamera(this.startCamObj);
                this.rotateBowler(true);
                pAnim.StartAnimation(this.players[this.currentBowler].bowlerIdleReadyAnimObj, false);
                m_app.playSound(2, true);
                break;
            }
            case 2: {
                this.rotateBowler(false);
                if (GameWorld.game.gameMode == 5) {
                    this.setGameState(23);
                    break;
                }
                this.setGameState(4);
                break;
            }
            case 3: {
                this.cacheModel(this.currentBowler, -1);
                this.throwResultObj.setVisible(false);
                this.setShowFrameResults(false);
                this.players[this.currentBowler].bowlerIsSpecThrow = false;
                if (GameWorld.game.gameMode == 5) {
                    this.setGameState(23);
                    break;
                }
                this.setGameState(4);
                break;
            }
            case 23: 
            case 24: {
                if (GameWorld.game.gameMode == 4 && GameWorld.game.playersNum > 1) {
                    this.cacheModel(-1, 1);
                    int n2 = this.players[0].playerId;
                    int n3 = this.bowlerParams[this.players[1].playerId].ids[GameWorld.game.playerWon ? 32 : 30];
                    this.expoInObj.setEmotion(n3);
                    if (n == 23) {
                        this.expoInObj.setText(169 + game.getOpponentsExpositionReply(n2, GameWorld.m_app.records[n2].nextMatch));
                    } else if (GameWorld.game.playerWon) {
                        this.expoInObj.setText(199 + game.getOpponentsExpositionReply(n2, GameWorld.m_app.records[n2].nextMatch - 1));
                    } else {
                        this.expoInObj.setText(229 + game.getOpponentsExpositionReply(n2, GameWorld.m_app.records[n2].nextMatch));
                    }
                    this.setShowFrameResults(false);
                    this.triangleObj.setVisible(false);
                    if (!UserApp.precacheState) {
                        this.expoInObj.setVisible(true);
                    }
                    this.setActiveCamera(this.idleCamObj);
                    this.rotateBowler(true);
                    this.setActiveCamera(this.startCamObj);
                    break;
                }
                if (GameWorld.game.gameMode == 5) {
                    this.setActiveCamera(this.startCamObj);
                    this.startBowlerIdleAnimation(this.players[this.currentBowler].bowlerIdleAnimObj);
                    this.throwResultObj.resetPins(-1);
                    this.throwResultObj.setVisible(true);
                    break;
                }
                this.setActiveCamera(this.startCamObj);
                game.finishGame();
                break;
            }
            case 4: {
                game.blockKeys(450);
                this.setActiveCamera(this.startCamObj);
                m_app.regularRunStr(7000);
                m_app.setRunStr(163);
                if (this.oldState != 5 && this.oldState != 6) {
                    m_app.stopSound(2);
                    this.lastMainStateStartTime = game.getApplicationTime();
                }
                this.throwResultObj.setVisible(false);
                this.triangleObj.setVisible(true);
                this.startBowlerIdleAnimation(this.players[this.currentBowler].bowlerIdleAnimObj);
                if (GameWorld.game.gameMode == 1 || this.currentBowler == 0) break;
                float[] fArray = new float[4];
                this.players[this.currentBowler].bowlerObj.getSwerveObject().getTranslation(fArray);
                float f = GameWorld.game.lnkPhysics.findDir() - fArray[0];
                float[] fArray2 = new float[]{f};
                game.moveBowler(fArray2, true);
                this.moveBowler(fArray2[0]);
                break;
            }
            case 5: {
                if (this.oldState == n) break;
                if (game.canMakeStep()) {
                    game.makeStep(true);
                    pAnim.StartAnimation(this.players[this.currentBowler].bowlerStepLeftAnimObj, true);
                    break;
                }
                this.setGameState(4);
                break;
            }
            case 6: {
                if (this.oldState == n) break;
                if (game.canMakeStep()) {
                    game.makeStep(true);
                    pAnim.StartAnimation(this.players[this.currentBowler].bowlerStepLeftAnimObj, true, false);
                    break;
                }
                this.setGameState(4);
                break;
            }
            case 25: {
                float[] fArray = new float[4];
                float[] fArray3 = new float[4];
                float[] fArray4 = new float[4];
                this.players[this.currentBowler].bowlerObj.getSwerveObject().getTranslation(fArray3);
                ((Node)this.world.find(516177007)).getTranslation(fArray);
                fArray4[0] = fArray3[0];
                fArray4[1] = fArray[1] + -4.0f;
                fArray4[2] = fArray[2] + GameWorld.game.iniParams.normalParams.ballRadiusFloat * 4.0f;
                this.moveShadow(-GameWorld.game.currentParams.ballRadiusFloat * 3.5f);
                this.ballRootObj.setTranslation(fArray4);
                this.setBowlerRendering(this.currentBowler, false);
                m_app.regularRunStr(7000);
                m_app.setRunStr(163);
                this.spinMeterObj.setVisible(true);
                m_app.playSound(0, false);
                if (GameWorld.game.gameMode != 1 && this.currentBowler != 0) {
                    this.spinMeterObj.setDX(GameWorld.game.lnkPhysics.findSpin());
                } else {
                    this.spinMeterObj.setDX(50.0f);
                }
                this.setBowlerRendering(this.getCurrentBowler(), false);
                m_app.regularRunStr(7000);
                m_app.setRunStr(163);
                break;
            }
            case 8: {
                this.moveShadow(-GameWorld.game.currentParams.ballRadiusFloat + 0.005f);
                this.players[this.currentBowler].directionTimeScore += game.getApplicationTime() - this.lastMainStateStartTime;
                this.setActiveCamera(this.idleCamObj);
                pAnim.StartAnimation(this.tCameraAnimObj1, true);
                pAnim.StartAnimation(this.pmInitAnimObj, true);
                m_app.playSound(0, false);
                break;
            }
            case 9: {
                m_app.regularRunStr(7000);
                m_app.setRunStr(163);
                this.lastMainStateStartTime = game.getApplicationTime();
                pAnim.StartAnimation(this.pmInitAnimObj, true);
                pAnim.StartAnimation(this.players[this.currentBowler].bowlerIdlePowerAnimObj, true);
                this.setActiveCamera(this.idleCamObj);
                this.power = 0;
                this.serBlinkRendering(false);
                if (this.currentBowler <= 0 || GameWorld.game.gameMode == 1) break;
                this.setGameState(10);
                break;
            }
            case 10: {
                m_app.playSound(0, false);
                this.triangleObj.setVisible(false);
                this.fadeStart = game.getApplicationTime();
                this.setActiveCamera(this.powerCamObj);
                pAnim.StartAnimation(this.tCameraAnimObj3, true);
                pAnim.StartAnimation(this.fxPowerAnimObj, true);
                pAnim.StartAnimation(this.players[this.currentBowler].bowlerThrowStart, true);
                break;
            }
            case 11: {
                if (this.currentBowler > 0 && GameWorld.game.gameMode != 1) {
                    float f = 1500.0f * (GameWorld.game.lnkPhysics.getAIBallSpeed() - GameWorld.game.iniParams.minBallSpeed) / (GameWorld.game.iniParams.maxBallSpeed - GameWorld.game.iniParams.minBallSpeed);
                    this.power = (int)f;
                } else {
                    int n4 = game.getApplicationTime() - this.power;
                    int n5 = this.players[this.currentBowler].bowlerThrowPower.GetDuration();
                    this.power = n4 * 1500 / n5;
                }
                this.players[this.currentBowler].powerTimeScore += game.getApplicationTime() - this.lastMainStateStartTime;
                this.serBlinkRendering(true);
                this.powerMeterObj.setVisible(false);
                pAnim.StartAnimation(this.fxPowerAnimObjCollapse, true);
                break;
            }
            case 13: {
                System.gc();
                this.powerMeterObj.setVisible(false);
                this.triangleObj.setVisible(false);
                this.wasFault = true;
                this.setActiveCamera(this.faultCamObj);
                this.powerMeterObj.setVisible(false);
                this.setRingRendering(false);
                this.powerMeterGroup.setRenderingEnable(false);
                this.setBowlerRendering(this.getCurrentBowler(), true);
                if (this.players[this.currentBowler].BallInHands != null) {
                    this.players[this.currentBowler].BallInHands.setRenderingEnable(false);
                }
                GameWorld.game.scores[GameWorld.game.currentPlayer].strikesInARow = 0;
                break;
            }
            case 16: {
                this.triangleObj.setVisible(false);
                this.setActiveCamera(this.startCamObj);
                this.wasFault = false;
                this.startBowlerIdleAnimation(this.players[this.currentBowler].bowlerIdleAnimObj);
                this.moveCamera(1);
                break;
            }
            case 17: {
                this.triangleObj.setVisible(true);
                this.throwResultObj.setVisible(false);
                this.setShowFrameResults(false);
                this.updateSpinPhaseBall(true);
                this.players[this.currentBowler].ballObject.SetRenderingEnable(false);
                pAnim.StartAnimation(this.ballSparksRightEndAnimObj, true);
                pAnim.StartAnimation(this.ballSparksLeftEndAnimObj, true);
                GameWorld.game.lnkPhysics.resetTime();
                this.alignObjects();
                break;
            }
            case 18: {
                this.triangleObj.setVisible(false);
                int n6 = this.bowlerParams[this.players[this.currentBowler].playerId].ids[30];
                if (GameWorld.game.gameMode == 5) {
                    if (GameWorld.game.lnkPhysics.getFirstPin() == GameWorld.game.precisionTarget) {
                        m_app.playSound(3, false);
                    }
                } else {
                    int n7;
                    int n8 = n7 = 10 - GameWorld.game.throwResult;
                    if (!GameWorld.game.firstThrow) {
                        n8 -= GameWorld.game.scores[GameWorld.game.currentPlayer].playerThrows[GameWorld.game.scores[GameWorld.game.currentPlayer].currentThrow - 1];
                    }
                    n6 = this.bowlerParams[this.players[this.currentBowler].playerId].ids[30];
                    if (n8 >= 7 || n7 == 10) {
                        n6 = this.bowlerParams[this.players[this.currentBowler].playerId].ids[31];
                        m_app.playSound(3, false);
                    } else if (n8 <= 2) {
                        n6 = this.bowlerParams[this.players[this.currentBowler].playerId].ids[32];
                    }
                }
                this.updateSpinPhaseBall(false);
                if (GameWorld.game.gameMode == 5) {
                    if (GameWorld.game.lnkPhysics.getFirstPin() == GameWorld.game.precisionTarget && GameWorld.game.throwResult != -1) {
                        GameWorld.game.lnkPhysics.removePin(GameWorld.game.lnkPhysics.getFirstPin());
                    }
                    GameWorld.game.lnkPhysics.resetPins(true);
                } else {
                    GameWorld.game.lnkPhysics.resetPins(false, true);
                }
                this.throwResultObj.setVisible(true);
                if (!GameWorld.game.scores[this.currentBowler].updated) {
                    this.throwResultObj.resetPins(n6);
                }
                if ((GameWorld.game.scores[this.currentBowler].strikesInARow == 2 || GameWorld.game.scores[this.currentBowler].strikesInARow == 5) && GameWorld.game.throwResult == 0) {
                    this.m_wasTurkey = true;
                    if (GameWorld.game.scores[this.currentBowler].strikesInARow == 5) {
                        this.m_wasDoubleTurkey = true;
                    }
                } else {
                    this.m_wasTurkey = false;
                    this.m_wasDoubleTurkey = false;
                }
                game.blockKeys(150);
                break;
            }
            case 19: {
                this.triangleObj.setVisible(true);
                this.throwResultObj.setVisible(false);
                this.setShowFrameResults(true);
                break;
            }
            case 21: {
                if (this.currentBowler == 0 && (GameWorld.game.gameMode == 4 || GameWorld.game.gameMode == 1)) {
                    int n9 = GameWorld.game.scores[0].playerScore[GameWorld.game.scores[0].lastClosedFrame];
                    int n10 = GameWorld.game.scores[1].playerScore[GameWorld.game.scores[1].lastClosedFrame];
                    if (n9 > n10 || n9 == n10 && this.getTotalTimeScore(0) < this.getTotalTimeScore(1)) {
                        GameWorld.game.playerWon = true;
                        if (GameWorld.game.gameMode == 4 && GameWorld.game.playersNum > 1) {
                            GameWorld.m_app.records[this.playerBowlerId].nextMatch = (byte)(GameWorld.m_app.records[this.playerBowlerId].nextMatch + 1);
                            GameWorld.m_app.records[this.playerBowlerId].localMatches = (short)(GameWorld.m_app.records[this.playerBowlerId].localMatches + 1);
                            GameWorld.m_app.records[this.playerBowlerId].localScore = (short)(GameWorld.m_app.records[this.playerBowlerId].localScore + n9);
                            if (n9 > GameWorld.m_app.records[this.playerBowlerId].localMatchRecord) {
                                GameWorld.m_app.records[this.playerBowlerId].localMatchRecord = (short)n9;
                            }
                            if (GameWorld.m_app.records[this.playerBowlerId].nextMatch == (GameWorld.m_app.records[this.playerBowlerId].tournamentsUnlocked + 1) * 3) {
                                GameWorld.m_app.records[this.playerBowlerId].tournamentsUnlocked = (byte)(GameWorld.m_app.records[this.playerBowlerId].tournamentsUnlocked + 1);
                            }
                        }
                        GameWorld.game.currentPlayer = 1;
                    } else {
                        GameWorld.game.currentPlayer = 0;
                    }
                }
                this.setGameState(24);
            }
        }
        Game.setApplicationTime(game.getApplicationTime() + 1);
        OptimizationUtils.makeSnapShot(UserApp.getWidth(), UserApp.getHeight(), game);
        pAnim.update(0);
    }

    public void setInFaultPlace() {
        float[] fArray = new float[4];
        float[] fArray2 = new float[4];
        ((Group)this.world.find(this.bowlerParams[this.players[this.currentBowler].playerId].ids[2])).getTranslation(fArray2);
        this.players[this.currentBowler].bowlerObj.getSwerveObject().getTranslation(fArray);
        fArray[1] = fArray2[1] + 2.0f;
        this.players[this.currentBowler].bowlerObj.getSwerveObject().setTranslation(fArray[0], fArray[1], fArray[2]);
        pAnim.StartAnimation(this.players[this.currentBowler].bowlerFaultThrow, true);
        pAnim.update(0);
        this.setBowlerRendering(this.currentBowler, true);
    }

    void setGameNextState(int n) {
        this.nextState = n;
    }

    int getGameState() {
        return this.state;
    }

    int getOldGameState() {
        return this.oldState;
    }

    public void init(Game game) {
        int n;
        GameWorld.game = game;
        m_app = Game.m_app;
        for (n = 0; n < 4; ++n) {
            this.bowlerParams[n] = new BowlerCreationParams();
            if (n == 0) {
                this.bowlerParams[n].ids = this.streak_ids;
            }
            if (n == 1) {
                this.bowlerParams[n].ids = this.kitti_ids;
            }
            if (n == 3) {
                this.bowlerParams[n].ids = this.dazzl_ids;
            }
            if (n != 2) continue;
            this.bowlerParams[n].ids = this.lilzee_ids;
        }
        pAnim = game.lnkAnimator;
        this.state = -1;
        this.playerBowlerId = -1;
        for (n = 0; n < 2; ++n) {
            this.players[n] = new OnePlayer();
            this.players[n].isLoaded = false;
        }
        this.m_resLoading = false;
    }

    public boolean isLoading() {
        return this.m_resLoading;
    }

    public void startBowlerIdleAnimation(AnimationObject animationObject) {
        pAnim.stopAnimation(this.players[this.currentBowler].bowlerIdleAnimObj);
        pAnim.StartAnimation(this.players[this.currentBowler].bowlerIdleAnimObj, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateState() {
        if (this.m_resLoading) {
            this.createLane(this.m_resLoadingPlayerId, this.currentLaneId);
            return;
        }
        if (this.nextState != this.state) {
            this.setGameState(this.nextState);
            return;
        }
        if (this.state == 13) {
            if (game.getApplicationTime() - this.stateStartTime > 2000) {
                GameWorld.game.throwResult = -1;
                game.updateScore();
                ++GameWorld.game.scores[GameWorld.game.currentPlayer].currentThrow;
                game.processGameOver();
                return;
            }
        }
        if (this.state == 18) {
            if (game.getApplicationTime() - this.stateStartTime >= 700 && this.m_wasTurkey) {
                this.throwResultObj.setVisible(true);
            }
            if (!this.m_wasDoubleTurkey) return;
            this.m_wasDoubleTurkey = false;
            return;
        }
        if (this.state == 17) {
            if (game.getApplicationTime() - this.stateStartTime <= (Physics.testPhysics ? 10 : 1000)) return;
            GameWorld.game.lnkPhysics.updateAll();
            GameWorld.game.lnkPhysics.finishVisualization();
            if (!GameWorld.game.scores[GameWorld.game.currentPlayer].updated) {
                GameWorld.game.throwResult = GameWorld.game.lnkPhysics.getThrowResult();
            }
            this.setGameState(18);
            if (!Physics.testPhysics) return;
            GameWorld.game.lnkPhysics.Replay();
            return;
        }
        if (GameWorld.game.gameMode != 1 && this.currentBowler > 0 && this.state == 4) {
            if (game.getApplicationTime() - this.stateStartTime > 2000) {
                this.setGameState(25);
                return;
            }
        }
        if (GameWorld.game.gameMode != 1 && this.currentBowler > 0 && this.state == 25) {
            if (game.getApplicationTime() - this.stateStartTime > 2000) {
                this.setGameState(8);
                return;
            }
        }
        if (this.state != 1) return;
        if (System.currentTimeMillis() - this.delayTimer <= 2000L) return;
        this.setReadyText(StringTable.get(335));
        this.delayTimer = Long.MAX_VALUE;
    }

    public void loadModels(World world, boolean bl) {
        for (int i = 0; i < 4; ++i) {
            this.hashedModels[i] = this.loadModel(i, world, bl);
            this.setBallInHandsTexture(i);
        }
    }

    public NodeObject loadModel(int n, World world, boolean bl) {
        int n2;
        int n3 = n;
        int n4 = n2 = bl ? this.bowlerParams[n3].ids[2] : 357463037;
        if (this.hashedModels[n3] == null) {
            this.hashedModels[n3] = new NodeObject(game, this.bowlerParams[n3].ids[0], world, n2);
            this.hashedBallTex[n3] = new NodeObject(game, this.bowlerParams[n3].ids[24]);
        } else {
            this.hashedModels[n3].setInPlace(world, n2);
        }
        if (bl) {
            this.hashedModels[n3].getSwerveObject().setScale(1.0f, 1.0f, 1.0f);
        }
        this.hashedModels[n3].SetRenderingEnable(bl);
        return this.hashedModels[n3];
    }

    public NodeObject loadLane(int n, World world) {
        if (this.hashedLanes[n] == null) {
            boolean bl = false;
            this.hashedLanes[n] = new NodeObject(game, 4 + n, world, 745822216, bl);
        } else {
            this.hashedLanes[n].setInPlace(this.world, 745822216);
        }
        return this.hashedLanes[n];
    }

    public void createLane(int n, int n2) {
        PortingUtils.beginProf("createLane");
        if (!this.m_resLoading) {
            this.m_resLoading = true;
            GameWorld.m_app.m_pLoaderBar.start(10);
            if (this.world != null && this.laneEnv != null) {
                GameWorld.m_app.m_pLoaderBar.setState(5);
                for (int i = 0; i < 10; ++i) {
                    GameWorld.game.lnkPhysics.hashedPins[i].RemoveDuckPin();
                }
            }
            if (this.world != null && this.laneEnv == null) {
                GameWorld.m_app.m_pLoaderBar.setState(3);
            }
            this.currentBowler = 0;
            this.wasFault = false;
            this.m_resLoadingPlayerId = n;
            if (n2 == -1) {
                n2 = this.getTournamentLaneId(n);
            }
            this.currentLaneId = n2;
            PortingUtils.endProf();
            return;
        }
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (GameWorld.m_app.m_pLoaderBar.getState()) {
            case 0: {
                PortingUtils.fixMemory();
                this.worldObj = new NodeObject(game, 1);
                this.world = (World)this.worldObj.getSwerveObject();
                Background background = new Background();
                background.setColorClearEnable(false);
                this.world.setBackground(background);
                this.sunObj = new NodeObject(game, 29);
                break;
            }
            case 1: {
                boolean bl = false;
                this.ballRootObj = new PhysicObject(game, 2, this.world, 516177007, bl);
                this.hashedNormalBall = new NodeObject(game, 28, this.ballRootObj.getSwerveObject(), false);
                NodeObject.addShadow(this.world);
                this.powerMeterObj = new PowerMeterObject(game, 0);
                this.spinMeterObj = new PowerMeterObject(game, 1);
                this.guiObj = new SimpleGuiObject(game);
                this.triangleObj = new TriangleObject(game);
                this.throwResultObj = new ThrowResultObject(game);
                break;
            }
            case 2: {
                this.arrowsObj = new NodeObject(game, 3, this.world, this.bowlerParams[0].ids[2]);
                this.powerMeterDummy = (Group)((Node)this.arrowsObj.getSwerveObject().find(GameWorld.USERID("PmeterTransform")));
                this.powerMeterGroup = (Group)((Node)this.arrowsObj.getSwerveObject().find(GameWorld.USERID("D_pm1Transform")));
                this.fxPowerAnimObj = new AnimationObject(game, this.arrowsObj, GameWorld.USERID("pm_power"));
                this.fxPowerAnimObj.setName("fxPowerAnimObj");
                this.pmInitAnimObj = new AnimationObject(game, this.arrowsObj, GameWorld.USERID("pm_init"));
                this.pmInitAnimObj.setName("pmInitAnimObj");
                this.fxPowerAnimObjRing = new AnimationObject(game, this.arrowsObj, GameWorld.USERID("pm_mark"));
                this.fxPowerAnimObjRing.setName("fxPowerAnimObjRing");
                this.fxPowerAnimObjRing2 = new AnimationObject(game, this.arrowsObj, GameWorld.USERID("pm_mark_2"));
                this.fxPowerAnimObjRing2.setName("fxPowerAnimObjRing2");
                this.fxPowerAnimObjCollapse = new AnimationObject(game, this.arrowsObj, GameWorld.USERID("pm_blink"));
                float[] fArray = new float[4];
                Group group = (Group)this.world.find(1002303230);
                group.getTranslation(fArray);
                fArray[1] = fArray[1] + 0.5f;
                group.setTranslation(fArray[0], fArray[1], fArray[2]);
                this.idleCamObj = new CameraObject(game, (Group)this.world, 844713584);
                this.powerCamObj = new CameraObject(game, (Group)this.world, 730510549);
                this.faultCamObj = new CameraObject(game, (Group)this.world, 1002303230);
                this.tCameraAnimObj1 = new AnimationObject(game, this.arrowsObj, 497224808);
                this.tCameraAnimObj1.setName("tCameraAnimObj1");
                this.tCameraAnimObj2 = new AnimationObject(game, this.arrowsObj, 714765241);
                this.tCameraAnimObj2.setName("tCameraAnimObj2");
                this.tCameraAnimObj3 = new AnimationObject(game, this.arrowsObj, 1045444725);
                this.tCameraAnimObj3.setName("tCameraAnimObj3");
                this.startCamObj = new CameraObject(game, (Group)this.world, 40559148);
                this.ballSparksRightBeginAnimObj = new AnimationObject(game, this.ballRootObj, GameWorld.USERID("fx_sparks_r"), 13, false);
                this.ballSparksRightAnimObj = new AnimationObject(game, this.ballRootObj, GameWorld.USERID("fx_sparks_r"), 14, true);
                this.ballSparksRightEndAnimObj = new AnimationObject(game, this.ballRootObj, GameWorld.USERID("fx_sparks_r"), 15, false);
                this.ballSparksLeftBeginAnimObj = new AnimationObject(game, this.ballRootObj, GameWorld.USERID("fx_sparks_l"), 13, false);
                this.ballSparksLeftAnimObj = new AnimationObject(game, this.ballRootObj, GameWorld.USERID("fx_sparks_l"), 14, true);
                this.ballSparksLeftEndAnimObj = new AnimationObject(game, this.ballRootObj, GameWorld.USERID("fx_sparks_l"), 15, false);
                this.ballFloorGlowAnimObj = new AnimationObject(game, this.ballRootObj, GameWorld.USERID("fx_floor_glow"), -1, true);
                break;
            }
            case 3: {
                Group group = (Group)this.world.find(745822216);
                group.setTranslation(0.0f, 0.0f, 0.0f);
                this.laneEnv = new NodeObject(game, 22, this.world, 745822216);
                break;
            }
            case 4: {
                PinObject pinObject = new PinObject(game, 23, this.world, GameWorld.USERID("D_all pinsTransform"));
                for (int i = 0; i < 10; ++i) {
                    PinObject pinObject2 = new PinObject(game);
                    pinObject2.Duplicate(pinObject, this.world);
                    GameWorld.game.lnkPhysics.hashedPins[i] = pinObject2;
                    this.pinVisible[i] = true;
                }
                pinObject.SetRenderingEnable(false);
                break;
            }
            case 5: {
                this.removeAllLanes();
                for (int i = 0; i < 4; ++i) {
                    this.destroyModel(i);
                }
                System.gc();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.laneObj = this.loadLane(n2, this.world);
                break;
            }
            case 6: {
                this.players[0].playerId = n;
                if (this.players[0].frameResultsObj != null) {
                    this.players[0].frameResultsObj.deInit();
                    this.players[0].frameResultsObj = null;
                    System.gc();
                }
                this.players[0].frameResultsObj = new FrameResultObject(game, 0);
                this.players[0].currntPsycheStatus = 0;
                if (GameWorld.game.playersNum > 1) {
                    if (GameWorld.game.gameMode == 4) {
                        this.players[1].playerId = this.getOpponentId(n);
                    }
                    if (GameWorld.game.gameMode == 1) {
                        this.players[1].playerId = this.playerBowlerId;
                    }
                    if (this.players[1].frameResultsObj != null) {
                        this.players[1].frameResultsObj.deInit();
                        this.players[1].frameResultsObj = null;
                        System.gc();
                    }
                    this.players[1].frameResultsObj = new FrameResultObject(game, 1);
                    this.players[1].currntPsycheStatus = 0;
                }
                if (GameWorld.game.gameMode != 4) break;
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                game.ResetMatch();
                break;
            }
            case 10: {
                pAnim.forceStopAllAnim();
                GameWorld.m_app.m_pLoaderBar.stop();
                this.m_resLoading = false;
                PortingUtils.endProf();
                return;
            }
        }
        GameWorld.m_app.m_pLoaderBar.nextState();
        PortingUtils.endProf();
    }

    private void setBallTexture(NodeObject nodeObject, Appearance appearance) {
        if (nodeObject != null) {
            Appearance appearance2 = (Appearance)nodeObject.getSwerveObject().find(GameWorld.USERID("ball"));
            Texture2D texture2D = appearance2.getTexture(0);
            appearance.getTexture(0).setImage(texture2D.getImage());
        }
    }

    public void setBallInHandsTexture(int n) {
        Node node = (Node)this.hashedModels[n].getSwerveObject().find(GameWorld.USERID("ball_new"));
        if (node != null) {
            Appearance appearance = (Appearance)node.find(GameWorld.USERID("ball"));
            this.setBallTexture(this.hashedBallTex[n], appearance);
        }
    }

    public void setBallOnLaneTexture(int n) {
        Node node = (Node)this.hashedNormalBall.getSwerveObject().find(329654416);
        if (node != null) {
            Appearance appearance = (Appearance)this.hashedNormalBall.getSwerveObject().find(this.bowlerParams[n].ids[25]);
            this.setBallTexture(this.hashedBallTex[n], appearance);
        }
    }

    void createBowlerBall(int n, int n2) {
        Node node;
        PhysicObject physicObject = this.ballRootObj;
        NodeObject nodeObject = null;
        NodeObject nodeObject2 = this.players[n].bowlerObj;
        this.players[n].ballObject = nodeObject = this.hashedNormalBall;
        this.players[n].BallOnLane = nodeObject.getSwerveObject();
        GameWorld.game.lnkPhysics.holes = (Node)nodeObject.getSwerveObject().find(875929390);
        if (GameWorld.game.gameMode == 3 && GameWorld.game.lnkPhysics.holes != null) {
            GameWorld.game.lnkPhysics.holes.setRenderingEnable(false);
        }
        nodeObject.getSwerveObject().setRenderingEnable(false);
        nodeObject.getSwerveObject().setAlignment(null, 145, null, 144);
        Group group = (Group)nodeObject.getSwerveObject().find(329654416);
        if (group != null) {
            group.setRenderingEnable(true);
        }
        if ((group = (Group)nodeObject.getSwerveObject().find(411139405)) != null) {
            group.setRenderingEnable(true);
        }
        if ((group = (Group)nodeObject.getSwerveObject().find(651805727)) != null) {
            group.setRenderingEnable(true);
        }
        if ((group = (Group)nodeObject.getSwerveObject().find(362945591)) != null) {
            group.setRenderingEnable(true);
        }
        if (this.hashedBallTex[n2] != null) {
            this.players[n].ballTextureObj = this.hashedBallTex[n2];
            this.setBallInHandsTexture(n2);
            this.setBallOnLaneTexture(n2);
        }
        this.players[n].ballGlowAnimObj = new AnimationObject(game, this.ballRootObj, 543611767, -1, true);
        this.players[n].ballAnimObj = new AnimationObject(game, this.ballRootObj, 806477142, -1, true);
        this.players[n].ballFxAnimObj = new AnimationObject(game, this.ballRootObj, 1009872005, -1, true);
        this.players[n].ballGlowObj = (Node)nodeObject.getSwerveObject().find(411139405);
        this.players[n].ball2dObj = (Node)nodeObject.getSwerveObject().find(329654416);
        this.players[n].ballHolesObj = (Node)nodeObject.getSwerveObject().find(875929390);
        if (this.players[n].BallOnLane != null) {
            this.players[n].BallOnLane.setRenderingEnable(false);
        }
        if (this.players[n].BallInHands != null) {
            this.players[n].BallInHands.setAlignment(null, 145, (Node)this.world, 148);
        }
        float f = GameWorld.game.currentParams.ballRadiusFloat / GameWorld.game.iniParams.normalParams.ballRadiusFloat;
        if (this.players[this.currentBowler].BallInHands != null) {
            this.players[n].BallInHands.setScale(f, f, f);
        }
        this.players[n].BallOnLane.setScale(f, f, f);
        this.shadowNode = (Node)this.ballRootObj.getSwerveObject().find(887133536);
        this.floorGlowGroup = (Group)this.ballRootObj.getSwerveObject().find(GameWorld.USERID("floor_glow_2Transform"));
        this.sparksRGroup = (Group)this.ballRootObj.getSwerveObject().find(GameWorld.USERID("sparks_rTransform"));
        this.sparksLGroup = (Group)this.ballRootObj.getSwerveObject().find(GameWorld.USERID("sparks_lTransform"));
        this.moveShadow(-GameWorld.game.currentParams.ballRadiusFloat + 0.005f);
        if (this.shadowNode != null) {
            this.shadowNode.setScale(f, f, f);
        }
        if ((node = (Node)this.players[this.currentBowler].BallOnLane.find(GameWorld.USERID("BallTransform"))) != null) {
            node.setAlignment(null, 145, null, 144);
        }
    }

    public void initSkeleton(int n) {
        if (this.hashedModels[n] != null) {
            pAnim.initSkeleton(this.hashedModels[n], this.bowlerParams[n]);
        }
    }

    public void CreateBowler(int n, int n2) {
        System.gc();
        int n3 = (int)Runtime.getRuntime().freeMemory();
        NodeObject nodeObject = this.loadModel(n2, this.world, true);
        if (nodeObject == null) {
            return;
        }
        nodeObject.setInPlace(this.world, this.bowlerParams[n2].ids[2]);
        nodeObject.getSwerveObject().setScale(1.0f, 1.0f, 1.0f);
        this.players[n].bowlerObj = nodeObject;
        this.players[n].bowlerIsSpecThrow = false;
        this.players[n].BallInHands = (Group)nodeObject.getSwerveObject().find(821176503);
        this.players[n].shadowDummy = (Group)nodeObject.getSwerveObject().find(GameWorld.USERID("Player01_PelvisTransform"));
        this.players[n].powermeterDummy = (Group)nodeObject.getSwerveObject().find(GameWorld.USERID("D_pm2Transform"));
        this.createBowlerBall(n, n2);
        this.players[n].bowlerIdleReadyAnimObj = new AnimationObject(game, this.players[n].bowlerObj, this.bowlerParams[n2].ids[13], 22, true);
        this.players[n].bowlerIdleStartAnimObj = new AnimationObject(game, this.players[n].bowlerObj, this.bowlerParams[n2].ids[13], 20);
        this.players[n].bowlerIdleAnimObj = new AnimationObject(game, this.players[n].bowlerObj, this.bowlerParams[n2].ids[13], 7, true);
        this.players[n].bowlerStepLeftAnimObj = new AnimationObject(game, this.players[n].bowlerObj, this.bowlerParams[n2].ids[13], 8, false, 2.0f);
        this.players[n].bowlerIdleToPowerAnimObj = new AnimationObject(game, this.players[n].bowlerObj, this.bowlerParams[n2].ids[13], 11);
        this.players[n].bowlerIdlePowerAnimObj = new AnimationObject(game, this.players[n].bowlerObj, this.bowlerParams[n2].ids[13], 12, true);
        this.players[n].bowlerThrowStart = new AnimationObject(game, this.players[n].bowlerObj, this.bowlerParams[n2].ids[13], 0);
        this.players[n].bowlerThrowReturn = new AnimationObject(game, this.players[n].bowlerObj, this.bowlerParams[n2].ids[13], 1);
        this.players[n].bowlerThrowPower = new AnimationObject(game, this.players[n].bowlerObj, this.bowlerParams[n2].ids[13], 2);
        this.players[n].bowlerDefThrow = new AnimationObject(game, this.players[n].bowlerObj, this.bowlerParams[n2].ids[13], 3);
        this.players[n].bowlerFaultThrow = new AnimationObject(game, this.players[n].bowlerObj, this.bowlerParams[n2].ids[13], 4);
        this.players[n].bowlerSpecThrow = new AnimationObject(game, this.players[n].bowlerObj, this.bowlerParams[n2].ids[13], this.bowlerParams[n2].ids[16]);
        this.players[n].bowlerEndGameAnimObj = n2 == 1 ? new AnimationObject(game, this.players[n].bowlerObj, this.bowlerParams[n2].ids[13], 21, true) : new AnimationObject(game, this.players[n].bowlerObj, this.bowlerParams[n2].ids[13], 6, true);
        this.players[n].camSignatureObj = new CameraObject(game, this.players[n].bowlerObj.getSwerveObject(), this.bowlerParams[n2].ids[14]);
        this.initSkeleton(n2);
        this.players[n].isLoaded = true;
        NodeObject.moveShadow((Node)this.players[n].shadowDummy, this.world);
    }

    void cacheModel(int n, int n2) {
        if (n != -1 && GameWorld.game.lastStepPos != 0.0f) {
            if (this.hashedModels[this.players[n].playerId] != null) {
                this.hashedModels[this.players[n].playerId].setInPlace(this.world, this.bowlerParams[this.players[n].playerId].ids[2]);
            }
            GameWorld.game.lastStepPos = 0.0f;
            GameWorld.game.lnkPhysics.SetPos(0.0f);
            this.moveArrows();
        }
        this.removeAllBowlersModels();
        if (n != -1 && !this.players[n].isLoaded) {
            this.CreateBowler(n, this.players[n].playerId);
        }
    }

    public CameraObject getActiveCamera() {
        return this.activeCamObj;
    }

    void setActiveCamera(CameraObject cameraObject) {
        try {
            Camera camera = (Camera)cameraObject.getSwerveObject().getChild(0);
            this.world.setActiveCamera(camera);
            this.activeCamObj = cameraObject;
            this.moveCamera(1);
            PortingUtils.setFreeCamera(this.world);
        }
        catch (Exception exception) {
            Debug.TRACE("cannot set camera:");
            exception.printStackTrace();
        }
    }

    void moveCamera(int n) {
        switch (this.state) {
            case 16: {
                if (OptimizationUtils.movingCameraType != 1) break;
                Transform transform = new Transform();
                float[] fArray = new float[16];
                this.ballRootObj.getSwerveObject().getCompositeTransform(transform);
                transform.get(fArray);
                float[] fArray2 = new float[4];
                this.arrowsObj.getSwerveObject().getTranslation(fArray2);
                float[] fArray3 = new float[]{0.495f, fArray[7] - fArray2[1], fArray[11]};
                OptimizationUtils.follow(fArray3);
                NodeObject.moveShadow((Node)this.players[this.currentBowler].shadowDummy, this.world);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                Object object;
                if (this.players[this.currentBowler].bowlerFaultThrow.isPlaying()) {
                    object = new float[4];
                    this.players[this.currentBowler].bowlerObj.getSwerveObject().getTranslation(object);
                    object[1] = object[1] + 0.05f;
                    this.players[this.currentBowler].bowlerObj.getSwerveObject().setTranslation(object[0], object[1], object[2]);
                }
                if (this.players[this.currentBowler].powermeterDummy == null) break;
                object = new Transform();
                float[] fArray = new float[16];
                float[] fArray4 = new float[4];
                float[] fArray5 = new float[4];
                this.players[this.currentBowler].powermeterDummy.getTransformTo((Node)this.world, (Transform)object);
                object.get(fArray);
                this.arrowsObj.getSwerveObject().getTranslation(fArray5);
                float f = 0.0f;
                if (this.players[this.currentBowler].bowlerFaultThrow.isPlaying() || this.players[this.currentBowler].bowlerDefThrow.isPlaying() || this.players[this.currentBowler].bowlerThrowPower.isPlaying()) {
                    f = 1.0f;
                }
                this.powerMeterDummy.getChild(0).setScale(f, f, f);
                this.powerMeterDummy.getTranslation(fArray4);
                fArray4[1] = fArray[7] - fArray5[1] - 0.5f;
                fArray4[2] = fArray[11];
                this.powerMeterDummy.setTranslation(fArray4[0], fArray4[1], fArray4[2]);
                this.setBowlerRendering(this.currentBowler, true);
                NodeObject.moveShadow((Node)this.players[this.currentBowler].shadowDummy, this.world);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 23: 
            case 24: {
                NodeObject.moveShadow((Node)this.players[this.currentBowler].shadowDummy, this.world);
            }
        }
        this.justSwitchedState = false;
    }

    public void rotateBowler(boolean bl) {
        if (bl != this.bowlerParams[this.players[this.currentBowler].playerId].m_rotated && this.players[this.currentBowler].isLoaded) {
            this.bowlerParams[this.players[this.currentBowler].playerId].m_rotated = bl;
            float[] fArray = new float[]{180.0f, 0.0f, 0.0f, 1.0f};
            this.players[this.currentBowler].bowlerObj.getSwerveObject().preRotate(fArray[0], fArray[1], fArray[2], fArray[3]);
        }
    }

    public void moveArrows() {
        float[] fArray = new float[4];
        float[] fArray2 = new float[4];
        Group group = (Group)this.world.find(this.bowlerParams[this.players[this.currentBowler].playerId].ids[2]);
        group.getTranslation(fArray2);
        this.arrowsObj.getSwerveObject().getTranslation(fArray);
        float f = fArray[0];
        fArray[0] = GameWorld.game.lastStepPos + game.getPosInterpolationAdd() + fArray2[0];
        f = fArray[0] - f;
        this.arrowsObj.getSwerveObject().setTranslation(fArray[0], fArray[1], fArray[2]);
        float f2 = game.getArrowScale(true);
        float f3 = game.getArrowScale(false);
        ((Node)this.arrowsObj.getSwerveObject().find(233279924)).setScale(f3, f3, f3);
        ((Node)this.arrowsObj.getSwerveObject().find(433767318)).setScale(f2, f2, f2);
    }

    public void moveBowler(float f) {
        if (this.state == 4 || this.state == 5 || this.state == 6) {
            NodeObject nodeObject = this.players[this.currentBowler].bowlerObj;
            float[] fArray = new float[4];
            nodeObject.getSwerveObject().getTranslation(fArray);
            fArray[0] = fArray[0] + f;
            nodeObject.getSwerveObject().setTranslation(fArray[0], fArray[1], fArray[2]);
            this.moveArrows();
        }
    }

    void alignObjects() {
        if (this.m_resLoading) {
            return;
        }
        try {
            switch (this.state) {
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    if (this.players[this.currentBowler].BallInHands == null) break;
                    this.players[this.currentBowler].BallInHands.align((Node)this.world.getActiveCamera());
                    break;
                }
                case 25: {
                    return;
                }
                case 16: 
                case 17: {
                    Node node = (Node)this.players[this.currentBowler].BallOnLane.find(GameWorld.USERID("BallTransform"));
                    node.align((Node)this.world.getActiveCamera());
                }
            }
            if (this.state != 16 && this.state != 17 && this.state != 18 && this.state != 19 && this.state != 11 && this.state != 13 && this.players[this.currentBowler].isLoaded && this.players[this.currentBowler].BallInHands != null && this.world.getActiveCamera() != null) {
                this.players[this.currentBowler].BallInHands.align((Node)this.world.getActiveCamera());
                this.players[this.currentBowler].BallInHands.setTranslation(Consts.BALL_IN_HANDS_POS[0], GameWorld.game.gameMode == 3 ? 0.05f : Consts.BALL_IN_HANDS_POS[1], Consts.BALL_IN_HANDS_POS[2]);
            }
        }
        catch (Exception exception) {
            Debug.TRACE("alignObjects failed:");
            exception.printStackTrace();
        }
    }

    void delinkObject(NodeObject nodeObject) {
        Group group = nodeObject.getSwerveObject();
        Group group2 = (Group)group.getParent();
        if (group2 != null) {
            group2.getParent();
            group2.removeChild((Node)group);
        }
    }

    void destroyModel(int n) {
        if (this.hashedModels[n] != null) {
            if (this.hashedBallTex[n] != null) {
                this.hashedBallTex[n].removeChunk();
            }
            this.hashedBallTex[n] = null;
            this.hashedModels[n].Relink(null, true);
            this.hashedModels[n] = null;
            pAnim.destroySkeleton(this.bowlerParams[n]);
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void destroyBowler(int n) {
        if (!this.players[n].isLoaded) {
            return;
        }
        System.gc();
        int n2 = (int)Runtime.getRuntime().freeMemory();
        this.rotateBowler(false);
        if (this.players[n].ballTextureObj != null) {
            this.delinkObject(this.players[n].ballTextureObj);
        }
        System.gc();
        this.players[n].powermeterDummy = null;
        this.players[n].shadowDummy = null;
        System.gc();
        this.players[n].ballBlurLeftEndAnimObj = null;
        this.players[n].ballBlurLeftAnimObj = null;
        this.players[n].ballBlurLeftBeginAnimObj = null;
        this.players[n].ballBlurRightEndAnimObj = null;
        this.players[n].ballBlurRightAnimObj = null;
        this.players[n].ballBlurRightBeginAnimObj = null;
        System.gc();
        this.players[n].tCameraAnimObj4 = null;
        this.players[n].camSignatureObj = null;
        this.players[n].bowlerEndGameAnimObj = null;
        this.players[n].bowlerSpecThrow = null;
        this.players[n].bowlerFaultThrow = null;
        this.players[n].bowlerDefThrow = null;
        this.players[n].bowlerThrowPower = null;
        this.players[n].bowlerThrowReturn = null;
        this.players[n].bowlerThrowStart = null;
        this.players[n].bowlerIdlePowerAnimObj = null;
        this.players[n].bowlerIdleToPowerAnimObj = null;
        this.players[n].bowlerStepLeftAnimObj = null;
        this.players[n].bowlerIdleAnimObj = null;
        this.players[n].bowlerIdleStartAnimObj = null;
        this.players[n].bowlerIdleReadyAnimObj = null;
        System.gc();
        this.players[n].ballHolesObj = null;
        this.players[n].ball2dObj = null;
        this.players[n].ballGlowObj = null;
        this.players[n].ballFxAnimObj = null;
        this.players[n].ballAnimObj = null;
        this.players[n].ballGlowAnimObj = null;
        this.players[n].ballTextureObj = null;
        this.players[n].BallOnLane = null;
        this.players[n].ballObject = null;
        System.gc();
        this.players[n].BallInHands = null;
        System.gc();
        this.players[n].bowlerObj = null;
        System.gc();
        this.players[n].isLoaded = false;
        System.gc();
        this.destroyModel(this.players[n].playerId);
    }

    void deInit() {
        GameWorld.game.lnkPhysics.deinitRecorders();
        pAnim.stopAllAnim(false);
        OptimizationUtils.unloadSnapShot();
        this.throwResultObj.setVisible(false);
        this.expoInObj.setText(-1);
        GameWorld.m_app.m_pLoaderBar.stop();
        this.removeAllBowlersModels();
        this.removeAllLanes();
        for (int i = 0; i < 2; ++i) {
            this.players[i].BallInHands = null;
            this.players[i].BallOnLane = null;
            this.players[i].powermeterDummy = null;
            this.players[i].shadowDummy = null;
            this.players[i].isLoaded = false;
        }
        this.state = -1;
        this.nextState = -1;
        this.m_resLoading = false;
    }

    void removeAllLanes() {
        System.gc();
        for (int i = 0; i < 6; ++i) {
            if (this.hashedLanes[i] == null) continue;
            this.hashedLanes[i].Relink(null, true);
            this.hashedLanes[i] = null;
            System.gc();
        }
        this.laneObj = null;
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void removeAllBowlersModels() {
        for (int i = GameWorld.game.playersNum - 1; i >= 0; --i) {
            this.destroyBowler(i);
        }
    }

    public void setEffectVisibility(int n, boolean bl) {
        Group group = (Group)this.world.find(n);
        if (group != null) {
            group.setRenderingEnable(bl);
        }
    }

    void setBallEffectVisibility(int n, boolean bl) {
        if (this.players[this.currentBowler] == null || this.players[this.currentBowler].BallOnLane == null) {
            return;
        }
        Group group = (Group)this.ballRootObj.getSwerveObject().find(n);
        if (group != null) {
            group.setRenderingEnable(bl);
        }
    }

    public void setBallShadowRendering(boolean bl) {
        if (this.shadowNode != null) {
            this.shadowNode.setRenderingEnable(bl);
        }
    }

    public void updateSpinPhaseBall(boolean bl) {
        this.ballRootObj.SetRenderingEnable(bl);
        int n = this.players[this.currentBowler].playerId;
        if (this.players[this.currentBowler].isLoaded) {
            this.players[this.currentBowler].BallOnLane.setRenderingEnable(bl);
            if (this.players[this.currentBowler].BallInHands != null) {
                this.players[this.currentBowler].BallInHands.setRenderingEnable(!bl);
            }
        }
    }

    public void setBowlerRendering(int n, boolean bl) {
        for (int i = 0; i < 4; ++i) {
            if (this.hashedModels[i] == null) continue;
            this.hashedModels[i].SetRenderingEnable(false);
        }
        if (this.players[n].isLoaded) {
            this.players[n].bowlerObj.SetRenderingEnable(bl);
        }
    }

    public void setModelRendering(int n, boolean bl) {
        for (int i = 0; i < 4; ++i) {
            if (this.hashedModels[i] == null) continue;
            this.hashedModels[i].SetRenderingEnable(false);
        }
        if (this.hashedModels[n] != null) {
            this.hashedModels[n].SetRenderingEnable(bl);
        }
    }

    public void setPhysicsBackRendering(boolean bl) {
        Group group = (Group)this.world.find(527637927);
        if (group != null) {
            group.setRenderingEnable(bl);
        }
    }

    public void setArrowsVisible(boolean bl) {
        if (this.arrowsObj != null) {
            ((Node)this.arrowsObj.getSwerveObject().find(433767318)).setRenderingEnable(bl);
            ((Node)this.arrowsObj.getSwerveObject().find(233279924)).setRenderingEnable(bl);
        }
    }

    public void serBlinkRendering(boolean bl) {
        ((Node)this.powerMeterDummy.find(811119510)).setRenderingEnable(bl);
    }

    public void setRingRendering(boolean bl) {
        for (int i = 0; i < 4; ++i) {
            ((Node)this.powerMeterDummy.find(this.bowlerParams[i].ids[21])).setRenderingEnable(false);
        }
        ((Node)this.powerMeterDummy.find(this.bowlerParams[this.players[this.currentBowler].playerId].ids[21])).setRenderingEnable(bl);
        ((Node)this.powerMeterDummy.find(968190686)).setRenderingEnable(false);
    }

    public void setShowFrameResults(boolean bl) {
        int n;
        if (GameWorld.game.gameMode == 2 && this.state == 23) {
            if (this.players[0].frameResultsObj != null) {
                this.players[0].frameResultsObj.setVisible(bl);
            }
            return;
        }
        int n2 = 0;
        for (n = 0; n < game.getPlayersNum(); ++n) {
            if (this.players[n].frameResultsObj != null) {
                this.players[n].frameResultsObj.setVisible(bl);
            }
            if (n2 >= GameWorld.game.scores[n].currentFrame) continue;
            n2 = GameWorld.game.scores[n].currentFrame;
        }
        if (bl) {
            for (n = 0; n < game.getPlayersNum(); ++n) {
                if (this.players[n].frameResultsObj == null) continue;
                this.players[n].frameResultsObj.setCurrentFrameNum(n2);
            }
        }
    }

    public void scrollFrameResults(int n) {
        for (int i = 0; i < GameWorld.game.playersNum; ++i) {
            if (this.players[i].frameResultsObj == null) continue;
            this.players[i].frameResultsObj.scrollH(n);
        }
    }

    public int getCurrentBowler() {
        return this.currentBowler;
    }

    public static int USERID(String string) {
        return Tools.getHashCode(string);
    }

    int getTournamentLaneId(int n) {
        int n2 = 0;
        switch (GameWorld.m_app.records[n].nextMatch) {
            case 0: 
            case 4: {
                n2 = PLAYERS[n][2];
                break;
            }
            case 1: 
            case 6: {
                n2 = PLAYERS[n][3];
                break;
            }
            case 2: 
            case 3: {
                n2 = PLAYERS[n][1];
                break;
            }
            case 7: {
                n2 = PLAYERS[n][0];
                break;
            }
            case 5: 
            case 8: {
                n2 = 4;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                n2 = 5;
            }
        }
        return n2;
    }

    public int getOpponentId(int n) {
        int n2 = 0;
        if (GameWorld.game.gameMode == 4) {
            switch (GameWorld.m_app.records[n].nextMatch) {
                case 0: 
                case 5: 
                case 7: 
                case 10: {
                    n2 = PLAYERS[n][2];
                    break;
                }
                case 1: 
                case 3: 
                case 8: 
                case 9: {
                    n2 = PLAYERS[n][1];
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 11: {
                    n2 = PLAYERS[n][3];
                }
            }
        } else if (GameWorld.game.gameMode == 1) {
            n2 = this.playerBowlerId;
        } else {
            n2 = game.getApplicationTime() % 3;
            if (n2 >= n) {
                ++n2;
            }
        }
        return n2;
    }

    public int getTotalTimeScore(int n) {
        return this.players[n].powerTimeScore + this.players[n].directionTimeScore;
    }

    public int getPowerTimeScore(int n) {
        return this.players[n].powerTimeScore;
    }

    public int getDirectionTimeScore(int n) {
        return this.players[n].directionTimeScore;
    }

    public String getPlayerName(int n) {
        return this.players[n].playerName;
    }

    public int getCurrentPlayerId() {
        return this.players[this.currentBowler].playerId;
    }

    public int getPlayerId() {
        return this.players[0].playerId;
    }

    public int getOpponentId() {
        return this.players[1].playerId;
    }

    void getStandingPinTranslation(float[] fArray) {
        for (int i = 9; i >= 0; --i) {
            PinObject pinObject = GameWorld.game.lnkPhysics.hashedPins[i];
            if (!pinObject.getSwerveObject().isRenderingEnabled()) continue;
            fArray = pinObject.getTranslation();
            return;
        }
    }

    void moveShadow(float f) {
        if (this.shadowNode == null) {
            return;
        }
        float[] fArray = new float[4];
        this.shadowNode.getTranslation(fArray);
        this.shadowNode.setTranslation(fArray[0], fArray[1], f);
    }

    public void updateMeters() {
        if (this.m_resLoading) {
            return;
        }
        if (this.state != 8 && this.state != 9 && this.state != 10 && this.state != 11) {
            return;
        }
        PowerMeterObject powerMeterObject = this.powerMeterObj;
        if (this.power > 0) {
            float f;
            int n = (game.getApplicationTime() - this.power) * 1500 / this.players[this.currentBowler].bowlerThrowPower.GetDuration();
            if (this.currentBowler > 0 && GameWorld.game.gameMode != 1 && (f = GameWorld.game.iniParams.minBallSpeed + (GameWorld.game.iniParams.maxBallSpeed - GameWorld.game.iniParams.minBallSpeed) * (float)n / 1500.0f) > GameWorld.game.lnkPhysics.getAIBallSpeed() && !GameWorld.game.AIWasFault) {
                this.nextState = 11;
            }
        }
    }

    public class BowlerCreationParams {
        int[] ids;
        boolean m_rotated;
    }

    class SavedPauseState {
        int oldState;
        int oldFxId;
        int oldRenderState;
        int oldAppTime;
        int activeCamObj;

        SavedPauseState() {
        }
    }
}

