/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import javax.microedition.m3g.AnimationController;
import javax.microedition.m3g.Object3D;
import portinglib.Debug;
import userapp.Game;
import userapp.GameObject;
import userapp.NodeObject;

class AnimationObject
extends GameObject {
    public static final int[] ANIMATION_LENS = new int[]{967, 1800, 933, 299, 1033, 7067, 2467, 1667, 600, 733, 133, 667, 1000, 533, 600, 533, 267, 467, 267, 356, 10, 1800, 22000, 6067, 8066, 6267, 7867, 1000, 4500, 134, 134, 134};
    private static final int[] ANIMATION_STARTS = new int[]{0, 28200, 967, 1900, 1900, 6266, 14667, 21333, 24667, 33267, 1800, 19000, 38333, 0, 533, 1133, 0, 267, 733, 0, 21333, 14667, 43333, 4667, 5066, 5066, 5066, 0, 4587, 0, 134, 268};
    private static final String[] ANIMATION_NAMES = new String[]{"ANIM_BOWLER_THROW_START", "ANIM_BOWLER_THROW_RETURN", "ANIM_BOWLER_THROW_POWER", "ANIM_NORMAL_THROW", "ANIM_FAULT_THROW", "ANIM_SPECIAL_THROW", "ANIM_BOWLER_IDLE_MENU", "ANIM_BOWLER_IDLE", "ANIM_BOWLER_STEP_LEFT", "ANIM_SPECIAL_THROW_MIDDLE", "ANIM_SPECIAL_THROW_START", "ANIM_BOWLER_IDLE_TO_POWER", "ANIM_BOWLER_IDLE_POWER", "ANIM_FX_SPARKS_START", "ANIM_FX_SPARKS", "ANIM_FX_SPARKS_END", "ANIM_FX_BLUR_START", "ANIM_FX_BLUR", "ANIM_FX_BLUR_END", "ANIM_BALL_CENTER", "ANIM_BOWLER_IDLE_START", "ANIM_KITTY_IDLE_MENU", "ANIM_DAZZL_IDLE_SELECT", "ANIM_KITTI_SPECIAL_THROW", "ANIM_BODGER_SPECIAL_THROW", "ANIM_LILZEE_SPECIAL_THROW", "ANIM_SOLID_SPECIAL_THROW", "ANIM_HEADGLOW_1", "ANIM_STREAK_SPECIAL_THROW", "ANIM_SETUP_BALL_NORMAL", "ANIM_SETUP_BALL_GIFT", "ANIM_SETUP_BALL_GOLD"};
    private AnimationController animationController;
    private int duration;
    private float realDuration;
    private boolean isPlaying;
    private int startTime;
    private int animStartTime;
    private float speed;
    private boolean looped;
    private boolean forward;
    private boolean integer;
    private String debugName = new String();

    private void build(Game game, NodeObject nodeObject, int n, int n2, boolean bl, float f) {
        this.integer = false;
        try {
            Object3D object3D = nodeObject.getSwerveObject().find(n);
            this.animationController = (AnimationController)object3D;
            if (n2 == -1) {
                this.animStartTime = 0;
                this.realDuration = (float)this.animationController.getActiveIntervalEnd() - (float)this.animationController.getActiveIntervalStart();
                this.duration = (int)(this.realDuration / f);
            } else {
                this.animStartTime = ANIMATION_STARTS[n2];
                this.duration = ANIMATION_LENS[n2];
                this.debugName = ANIMATION_NAMES[n2];
                this.realDuration = (float)this.duration * f;
                if (object3D == null) {
                    this.integer = true;
                    if (bl) {
                        this.duration -= 550;
                        this.duration *= 2;
                    }
                }
            }
            this.speed = f;
            boolean bl2 = this.forward = f > 0.0f;
            if (!this.integer) {
                this.animationController.setActiveInterval(0, 0);
                this.animationController.setWeight(0.0f);
            }
            this.looped = bl;
        }
        catch (Exception exception) {
            Debug.TRACE("cannot create animation " + n + ":");
            exception.printStackTrace();
        }
    }

    public AnimationObject(Game game, NodeObject nodeObject, int n, int n2, boolean bl, float f) {
        super(game);
        this.build(game, nodeObject, n, n2, bl, f);
    }

    public AnimationObject(Game game, NodeObject nodeObject, int n, int n2, boolean bl) {
        super(game);
        this.build(game, nodeObject, n, n2, bl, 1.0f);
    }

    public AnimationObject(Game game, NodeObject nodeObject, int n, int n2) {
        super(game);
        this.build(game, nodeObject, n, n2, false, 1.0f);
    }

    public AnimationObject(Game game, NodeObject nodeObject, int n) {
        super(game);
        this.build(game, nodeObject, n, -1, false, 1.0f);
    }

    public AnimationController getSwerveObject() {
        return this.animationController;
    }

    public void SetStartTime(int n) {
        this.startTime = n;
    }

    public int GetStartTime() {
        return this.startTime;
    }

    public int GetAnimStartTime() {
        return this.animStartTime;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void SetPlaying(boolean bl) {
        this.isPlaying = bl;
    }

    public void setDuration(int n) {
        this.duration = n;
    }

    public int GetDuration() {
        return this.duration;
    }

    public float GetSpeed() {
        return this.speed;
    }

    public void SetSpeed(float f) {
        this.speed = f;
        this.duration = (int)(this.realDuration / f);
    }

    public boolean IsLooped() {
        return this.looped;
    }

    public boolean isForward() {
        return this.forward;
    }

    public void SetForward(boolean bl) {
        if (this.forward != bl) {
            this.speed = -this.speed;
        }
        this.forward = bl;
    }

    public void setName(String string) {
        this.debugName = string;
    }

    public String getName() {
        return this.debugName;
    }

    public boolean isInteger() {
        return this.integer;
    }
}

