/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import javax.microedition.m3g.Node;
import userapp.SkeletalAnimation;

class Skeleton {
    static String debugString = new String();
    private String[] m_names;
    private Node[] m_bones;
    private int m_boneCount;

    public Skeleton(Node[] nodeArray, String[] stringArray, int n) {
        this.m_boneCount = n;
        this.m_bones = new Node[this.m_boneCount];
        this.m_names = new String[this.m_boneCount];
        for (int i = 0; i < n; ++i) {
            this.m_bones[i] = nodeArray[i];
            this.m_names[i] = stringArray[i];
        }
    }

    void update(SkeletalAnimation skeletalAnimation, int n) {
        int n2 = Math.min(this.m_boneCount, skeletalAnimation.getBoneCount());
        while (--n2 >= 0) {
            if (this.m_bones[n2] == null) continue;
            float[] fArray = new float[4];
            if (skeletalAnimation.getPosition(n2, this.m_names[n2], n, fArray)) {
                this.m_bones[n2].setTranslation(fArray[0], fArray[1], fArray[2]);
            }
            fArray = null;
            float[] fArray2 = new float[4];
            if (skeletalAnimation.getOrientation(n2, this.m_names[n2], n, fArray2)) {
                if (fArray2[1] != 0.0f || fArray2[2] != 0.0f || fArray2[3] != 0.0f || fArray2[0] == 0.0f) {
                    this.m_bones[n2].setOrientation(fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
                } else {
                    debugString = this.m_names[n2] + " " + (int)fArray2[0] + "," + fArray2[1] + "," + fArray2[2] + "," + fArray2[3];
                }
            }
            fArray2 = null;
        }
    }

    public Node[] getBones() {
        return this.m_bones;
    }

    public int getBoneCount() {
        return this.m_boneCount;
    }
}

