/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.World;
import portinglib.Graphics2D;
import userapp.PortingParser;
import userapp.ProfileItem;

class PortingUtils {
    private static int lastKey = -1;
    private static boolean moveMode = true;
    private static Camera oldCam;
    private static float deltaX;
    private static float alphaX;
    private static float deltaY;
    private static float alphaY;
    private static float deltaZ;
    private static float alphaZ;
    private static ProfileItem curFunc;
    private static boolean global;
    static Vector functions;
    private static boolean FREE_CAM;
    public static boolean PROFILE;
    private static Vector chuncks;
    private static int freeMemorybeforeChunkCreation;
    private static int freeMemorybeforeStart;
    private static int currentChunkBufSize;
    private static final boolean DEBUG = false;

    PortingUtils() {
    }

    public static void fixMemory() {
        System.gc();
        chuncks.removeAllElements();
        freeMemorybeforeStart = (int)Runtime.getRuntime().freeMemory();
    }

    private static void allocChunk() {
        System.gc();
        new MemoryChunck(currentChunkBufSize);
    }

    private static void freeChunk() {
        if (chuncks.size() > 0) {
            chuncks.removeElementAt(chuncks.size() - 1);
        }
        System.gc();
    }

    private static void incChunkBufSize() {
        currentChunkBufSize *= 2;
    }

    private static void decChunkBufSize() {
        currentChunkBufSize /= 2;
    }

    public static void setFreeCamera(World world) {
        if (FREE_CAM && world != null) {
            Camera camera = world.getActiveCamera();
            if (camera == null) {
                return;
            }
            if (!camera.equals(oldCam)) {
                oldCam = camera;
                PortingUtils.updateDeltas();
            }
            camera.getParent().setTranslation(deltaX, deltaY, deltaZ);
        }
    }

    public static void updateDeltas() {
        if (FREE_CAM) {
            float[] fArray = new float[4];
            oldCam.getParent().getTranslation(fArray);
            deltaX = fArray[0];
            deltaY = fArray[1];
            deltaZ = fArray[2];
        }
    }

    public static void onKeyPressed(int n) {
        if (n == 49) {
            // empty if block
        }
        if (n == 35) {
            boolean bl = FREE_CAM = !FREE_CAM;
        }
        if (FREE_CAM && !PortingParser.PARSE1) {
            lastKey = n;
            if (n == 49) {
                boolean bl = moveMode = !moveMode;
            }
        }
        if (n == 55) {
            global = false;
            boolean bl = PROFILE = !PROFILE;
        }
        if (PROFILE) {
            switch (n) {
                case 52: {
                    PortingUtils.freeChunk();
                    break;
                }
                case 54: {
                    PortingUtils.allocChunk();
                    break;
                }
                case 56: {
                    PortingUtils.decChunkBufSize();
                    break;
                }
                case 50: {
                    PortingUtils.incChunkBufSize();
                }
            }
            return;
        }
        if (!PortingParser.PARSE1 && n == 57) {
            PortingParser.PARSE1 = true;
        } else if (PortingParser.PARSE1 && n == 57) {
            PortingParser.PARSE1 = false;
        }
        if (PortingParser.PARSE1) {
            switch (n) {
                case 52: {
                    PortingParser.selectPredBrother();
                    break;
                }
                case 54: {
                    PortingParser.selectNextBrother();
                    break;
                }
                case 56: {
                    PortingParser.selectFirstChild();
                    break;
                }
                case 50: {
                    PortingParser.selectParent();
                    break;
                }
                case 48: {
                    PortingParser.hide();
                }
            }
        }
    }

    public static void onKeyReleased(int n) {
        if (FREE_CAM && !PortingParser.PARSE1) {
            lastKey = -1;
        }
    }

    public static void updateCamera() {
        if (PROFILE || lastKey == -1) {
            return;
        }
        if (moveMode) {
            switch (lastKey) {
                case 52: {
                    deltaX -= 0.1f;
                    break;
                }
                case 54: {
                    deltaX += 0.1f;
                    break;
                }
                case 56: {
                    deltaY -= 0.1f;
                    break;
                }
                case 50: {
                    deltaY += 0.1f;
                    break;
                }
                case 48: {
                    deltaZ += 0.1f;
                    break;
                }
                case 53: {
                    deltaZ -= 0.1f;
                }
            }
        } else {
            switch (lastKey) {
                case 52: {
                    alphaX -= 1.0f;
                    break;
                }
                case 54: {
                    alphaX += 1.0f;
                    break;
                }
                case 56: {
                    alphaY -= 1.0f;
                    break;
                }
                case 50: {
                    alphaY += 1.0f;
                    break;
                }
                case 48: {
                    alphaZ += 1.0f;
                    break;
                }
                case 53: {
                    alphaZ -= 1.0f;
                }
            }
        }
    }

    public static void paintProfiling(Graphics2D graphics2D) {
        MemoryChunck memoryChunck;
        int n;
        int n2;
        Graphics graphics = graphics2D.getGraphics();
        PortingUtils.beginProf("paintProfiling");
        graphics.setColor(-1);
        int n3 = 0;
        for (n2 = 0; n2 < functions.size(); ++n2) {
            ProfileItem profileItem = (ProfileItem)functions.elementAt(n2);
            if (profileItem.fpsChar > 5) {
                graphics.setColor(-65536);
            } else {
                graphics.setColor(-1);
            }
            n3 += profileItem.fpsChar * profileItem.calls;
            graphics.drawString(profileItem.calls + " " + profileItem.name + ": " + profileItem.fpsChar * profileItem.calls + "ms " + profileItem.fpsCount, 0, n2 * 15, 0);
        }
        System.gc();
        graphics.drawString("total=" + n3 + "ms", 0, functions.size() * 15, 0);
        n2 = (int)Runtime.getRuntime().freeMemory();
        int n4 = (int)Runtime.getRuntime().totalMemory();
        int n5 = functions.size() * 15 + 15;
        graphics.drawString("all " + n4, 0, n5, 0);
        graphics.drawString("free " + n2, 0, n5 + 15, 0);
        n5 += 30;
        graphics.setColor(-65536);
        int n6 = 0;
        int n7 = 0;
        if (chuncks.size() > 0) {
            MemoryChunck memoryChunck2 = (MemoryChunck)chuncks.elementAt(n6);
            n7 = (n4 - freeMemorybeforeStart) / 1024 + memoryChunck2.buf[2] * 128 + memoryChunck2.buf[3];
        }
        for (n = 0; n < n4 / 1024; ++n) {
            if (n > (n4 - freeMemorybeforeStart) / 1024) {
                graphics.setColor(0xAAAAAA);
                if (n == n7) {
                    graphics.setColor(65535);
                    if (n6 < chuncks.size() - 1) {
                        memoryChunck = (MemoryChunck)chuncks.elementAt(++n6);
                        n7 += memoryChunck.buf[2] * 128 + memoryChunck.buf[3];
                    }
                }
            }
            if (n > (n4 - n2) / 1024) {
                graphics.setColor(0xFFFFFF);
            }
            int n8 = n % 50 * 2 + 2;
            if (n % 50 == 0) {
                n5 += 2;
            }
            graphics.fillRect(n8, n5, 2, 2);
        }
        for (n = 0; n < chuncks.size(); ++n) {
            memoryChunck = (MemoryChunck)chuncks.elementAt(n);
            graphics.drawString("chunk " + n + "/" + chuncks.size() + " " + memoryChunck.buf[0] + " " + (memoryChunck.buf[2] * 128 + memoryChunck.buf[3]) + "kb ", 0, n5 + 5 + n * 12, 0);
        }
        PortingUtils.endProf();
    }

    public static void beginProf(String string, boolean bl) {
        if (global != bl) {
            return;
        }
        curFunc = new ProfileItem();
        PortingUtils.curFunc.time = (int)System.currentTimeMillis();
        PortingUtils.curFunc.name = new String(string);
        PortingUtils.curFunc.calls = 1;
    }

    public static void endProf(boolean bl) {
        ProfileItem profileItem;
        int n;
        if (global != bl) {
            return;
        }
        if (curFunc == null) {
            return;
        }
        PortingUtils.curFunc.time = (int)System.currentTimeMillis() - PortingUtils.curFunc.time;
        boolean bl2 = false;
        boolean bl3 = false;
        for (n = 0; n < functions.size(); ++n) {
            profileItem = (ProfileItem)functions.elementAt(n);
            if (!profileItem.name.equals(PortingUtils.curFunc.name)) continue;
            bl2 = true;
            profileItem.time += PortingUtils.curFunc.time;
            ++profileItem.fpsCount;
            if (profileItem.fpsCount != 10) continue;
            bl3 = true;
        }
        if (bl3) {
            for (n = 0; n < functions.size(); ++n) {
                profileItem = (ProfileItem)functions.elementAt(n);
                if (profileItem.fpsCount > 0) {
                    profileItem.fpsChar = profileItem.time / profileItem.fpsCount;
                    profileItem.time = 0;
                    profileItem.fpsCount = 0;
                    continue;
                }
                functions.removeElement(profileItem);
            }
        }
        if (!bl2) {
            functions.addElement(curFunc);
        }
        curFunc = null;
    }

    public static void beginProf(String string) {
        if (!PROFILE) {
            PortingUtils.beginProf(string, false);
        }
    }

    public static void endProf() {
        if (!PROFILE) {
            PortingUtils.endProf(false);
        }
    }

    static {
        global = false;
        functions = new Vector();
        FREE_CAM = false;
        PROFILE = false;
        chuncks = new Vector();
        currentChunkBufSize = 16384;
    }

    static class MemoryChunck {
        public byte[] buf;

        public MemoryChunck() {
            freeMemorybeforeChunkCreation = (int)Runtime.getRuntime().freeMemory();
            this.buf = new byte[4];
            this.buf[0] = 0;
            this.buf[1] = 0;
        }

        public void finishChunkCreation() {
            int n = freeMemorybeforeChunkCreation - (int)Runtime.getRuntime().freeMemory();
            this.buf[2] = (byte)(n / 1024 / 128);
            this.buf[3] = (byte)(n / 1024 % 128);
            chuncks.addElement(this);
        }

        public MemoryChunck(int n) {
            freeMemorybeforeChunkCreation = (int)Runtime.getRuntime().freeMemory();
            this.buf = new byte[n];
            this.buf[0] = (byte)(n / 1024 / 128);
            this.buf[1] = (byte)(n / 1024 % 128);
            this.finishChunkCreation();
        }

        public void removeChunk() {
            chuncks.removeElement(this);
        }
    }
}

