/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.World;
import portinglib.Debug;
import portinglib.Graphics2D;
import portinglib.StringTable;
import userapp.AnimationObject;
import userapp.Consts;
import userapp.Device;
import userapp.Game;
import userapp.GameWorld;
import userapp.MenuBaseSinglePlate;
import userapp.MenuDialogGameResults;
import userapp.MenuDialogWinnerResults;
import userapp.NodeObject;
import userapp.PortingParser;
import userapp.UserApp;

class MenuBaseChoosePlayer
extends MenuBaseSinglePlate {
    protected boolean m_selectedItemCharacter;
    private static final int[] EMPTY_LIST = new int[0];
    public static final int[] OVERALL_CHARACTER_LIST = new int[]{126, 57, 58, 59, 60};
    public static final int[] CHARACTER_LIST = new int[]{57, 58, 59, 60};
    private static final int[] LANE_LIST = new int[]{79, 80, 81, 82, 83, 84, 85};
    private static final int[] LANE_IMAGE_LIST = new int[]{32, 33, 34, 35, 36, 37};
    protected static Group ballInHands;
    boolean m_chooseJustPlayer;
    public static boolean characterSelected;
    public static int lastSelectedCharacter;
    protected static int animatedCharacter;
    protected static int m_laneCurr;
    protected static int m_characterCurr;
    protected static int m_firstPlayer;
    protected static int m_secondPlayer;
    protected int m_characterNext;
    public static boolean unlockCheatEnabled;

    public MenuBaseChoosePlayer(Game game, boolean bl) {
        super(bl ? CHARACTER_LIST : LANE_LIST, bl ? 4 : 6, bl ? 67 : 68, -1);
        this.game = game;
        this.m_selectedItemCharacter = bl;
        m_laneCurr = 0;
    }

    public MenuBaseChoosePlayer(Game game) {
        super(EMPTY_LIST, 0, 140, -1);
        this.game = game;
        this.m_selectedItemCharacter = true;
        m_laneCurr = 0;
    }

    public void onStart() {
        super.onStart();
        this.canPlay = false;
        if (group != null) {
            for (int i = 0; i < group.getChildCount(); ++i) {
                group.getChild(i).setRenderingEnable(false);
            }
        }
        if (this.m_selectedItemCharacter) {
            this.game.getGameWorld().loadModels((World)group, false);
            animatedCharacter = -1;
            m_firstPlayer = -1;
            m_secondPlayer = -1;
            characterSelected = false;
            if (this.showHighScore()) {
                this.onItemChange(0);
                this.setItemCur(0);
            } else {
                m_characterCurr = lastSelectedCharacter;
                this.onItemChange(m_characterCurr);
                this.setItemCur(m_characterCurr);
            }
        }
        if (demoEnabled) {
            m_characterCurr = 0;
            m_laneCurr = 0;
            this.m_itemCurr = 0;
        }
    }

    public void onHide() {
        for (int i = 0; i < 4; ++i) {
            this.game.getGameWorld().destroyModel(i);
        }
        ((World)group).setActiveCamera(camera);
        Game.setApplicationTime(0);
        this.game.getGameWorld().expoInObj.setText(-1);
        oldTime = 0;
    }

    protected int getHeaderTop() {
        return Device.SCREEN_MENU_ONLY_HEADER_TOP;
    }

    protected boolean showHighScore() {
        return this.m_itemNum == 5;
    }

    protected boolean showOverall() {
        return this.showHighScore() && this.m_itemCurr == 0;
    }

    protected int getTextCenter(boolean bl) {
        if (this.onePlate()) {
            bl = !bl;
        }
        float f = bl ? 0.5f : 0.8f;
        int n = Graphics2D.getHeight(42) + Graphics2D.getHeight(43);
        int n2 = UserApp.getHeight() - n - Graphics2D.getHeight(40);
        return n + (int)((float)n2 * f);
    }

    protected int getTextCenter() {
        return this.getTextCenter(this.m_selectedItemCharacter);
    }

    protected int getText2Center() {
        return this.getTextCenter(!this.m_selectedItemCharacter);
    }

    protected int getArrowsOffset() {
        return UserApp.getWidth() / 2 - Graphics2D.getWidth(44) * 48 / 100;
    }

    protected boolean resultScreen() {
        return this instanceof MenuDialogGameResults || this instanceof MenuDialogWinnerResults;
    }

    protected boolean onePlate() {
        return Game.m_app.mainMenu.getLastSelectedItem() == 36 || this.resultScreen() || this.showHighScore();
    }

    public void render2D(Graphics2D graphics2D) {
        if (PortingParser.PARSE1) {
            return;
        }
        int n = UserApp.getWidth() / 2;
        if (this.showEndScreen) {
            if (System.currentTimeMillis() - this.demoScreenTime < 10000L) {
                graphics2D.drawImage(38, UserApp.getWidth() / 2, UserApp.getHeight() / 2, 3);
                UserApp.whatToShow(false, graphics2D);
            } else {
                graphics2D.drawImage(38, UserApp.getWidth() / 2, UserApp.getHeight() / 2, 3);
                UserApp.whatToShow(false, graphics2D);
                this.showEndScreen = false;
                this.canPlay = true;
                this.onItemSelect(0);
            }
            return;
        }
        if (doDemoScreen) {
            UserApp.whatToShow(false, graphics2D);
        }
        if (!this.showOverall()) {
            graphics2D.drawImage(42, 0, 0, 20);
            graphics2D.drawImage(43, 0, Graphics2D.getHeight(42), 20);
            if (m_characterCurr == m_firstPlayer || m_characterCurr == m_secondPlayer) {
                graphics2D.drawString(StringTable.get(m_characterCurr == m_firstPlayer ? 2 : 3), (UserApp.getWidth() + Graphics2D.getWidth(43)) / 2, Graphics2D.getHeight(42) + Graphics2D.getHeight(43) / 2 - 5, 3);
            }
            if (!(Game.m_app.records[MenuBaseChoosePlayer.m_characterCurr].unlocked || this.resultScreen() || unlockCheatEnabled)) {
                graphics2D.drawString(StringTable.get(131), (UserApp.getWidth() + Graphics2D.getWidth(43)) / 2, Graphics2D.getHeight(42) + Graphics2D.getHeight(43) / 2 - 5, 3);
            }
        }
        graphics2D.drawImage(44, n, this.getTextCenter(true), 3);
        if (!this.onePlate()) {
            graphics2D.drawImage(44, n, this.getTextCenter(false), 3);
        }
        if (!this.resultScreen() && !this.showOverall()) {
            if (this.m_selectedItemCharacter) {
                this.drawStats(graphics2D);
                if (Game.m_app.mainMenu.getLastSelectedItem() != 36) {
                    this.setText2(LANE_LIST[m_laneCurr]);
                }
                if (this.showHighScore()) {
                    this.setText2(-1);
                }
            } else {
                this.drawLane(graphics2D);
                this.setText2(CHARACTER_LIST[m_characterCurr]);
            }
        }
        super.render2D(graphics2D);
    }

    protected void drawStats(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        if (this.showOverall()) {
            return;
        }
        int n4 = Graphics2D.getFontHeight(2);
        int n5 = this.showHighScore() ? 3 : 2;
        int n6 = (Graphics2D.getHeight(43) - n4) / n5;
        int[] nArray = new int[n5];
        nArray[0] = Graphics2D.getHeight(42) + (int)(0.5f * (float)n4);
        for (n3 = 1; n3 < n5; ++n3) {
            nArray[n3] = nArray[n3 - 1] + n6;
        }
        n3 = Graphics2D.getWidth(43) / 2;
        for (n2 = 0; n2 < n5; ++n2) {
            graphics2D.drawImage(41, n3, nArray[n2] + n4, 17);
        }
        n2 = 2;
        int n7 = (Graphics2D.getWidth(41) - n2 * 2) / 4;
        if (this.showHighScore()) {
            graphics2D.drawString(StringTable.get(29), Device.SCREEN_MENU_CHOOSE_PLAYER_HEADER_X, Graphics2D.getHeight(42) - n4, 20);
            n = Game.m_app.records[MenuBaseChoosePlayer.m_characterCurr].nextMatch * 100 / 12;
            graphics2D.drawString("" + n + "% ", UserApp.getWidth(), Graphics2D.getHeight(42) - n4, 24);
        } else {
            int[] nArray2 = new int[n5];
            nArray2[0] = Game.m_app.records[MenuBaseChoosePlayer.m_characterCurr].control;
            nArray2[1] = Game.m_app.records[MenuBaseChoosePlayer.m_characterCurr].power;
            if (n5 > 2) {
                nArray2[2] = 0;
            }
            int[] nArray3 = new int[n5];
            nArray3[0] = Game.m_app.defaultCharParams[MenuBaseChoosePlayer.m_characterCurr].control;
            nArray3[1] = Game.m_app.defaultCharParams[MenuBaseChoosePlayer.m_characterCurr].power;
            if (n5 > 2) {
                nArray3[2] = 0;
            }
            int n8 = n3 - Graphics2D.getWidth(41) / 2;
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < n5; ++j) {
                    int n9 = 46;
                    if (i < nArray2[j]) {
                        n9 = Game.m_app.records[MenuBaseChoosePlayer.m_characterCurr].unlocked || unlockCheatEnabled ? (i >= nArray3[j] ? 48 : 47) : 49;
                    }
                    graphics2D.drawImage(n9, n8 + n2 + i * n7, nArray[j] + n4 + Graphics2D.getHeight(41) / 2, 6);
                }
            }
        }
        graphics2D.setFont(2);
        if (this.showHighScore()) {
            graphics2D.drawString(StringTable.get(124), Device.SCREEN_MENU_CHOOSE_PLAYER_HEADER_X, nArray[0] + 0, 20);
        } else {
            graphics2D.drawString(StringTable.get(69), Device.SCREEN_MENU_CHOOSE_PLAYER_HEADER_X, nArray[0], 20);
        }
        if (this.showHighScore()) {
            graphics2D.drawString(StringTable.get(145), Device.SCREEN_MENU_CHOOSE_PLAYER_HEADER_X, nArray[1] + 0, 20);
        } else {
            graphics2D.drawString(StringTable.get(70), Device.SCREEN_MENU_CHOOSE_PLAYER_HEADER_X, nArray[1], 20);
        }
        if (n5 > 2) {
            graphics2D.drawString(StringTable.get(this.showHighScore() ? 64 : 71), Device.SCREEN_MENU_CHOOSE_PLAYER_HEADER_X, nArray[2] + 0, 20);
        }
        if (this.showHighScore()) {
            n = 0;
            while (n < n5) {
                int n10 = n++;
                nArray[n10] = nArray[n10] + (n4 + Graphics2D.getHeight(41) / 2);
            }
            n = (Graphics2D.getWidth(43) + Graphics2D.getWidth(41)) / 2 - 2;
            short s = Game.m_app.records[MenuBaseChoosePlayer.m_characterCurr].localMatchRecord;
            graphics2D.drawString("" + s, n, nArray[0] + 0, 10);
            s = Game.m_app.records[MenuBaseChoosePlayer.m_characterCurr].localTournRecord;
            graphics2D.drawString("" + s, n, nArray[1] + 0, 10);
            s = Game.m_app.records[MenuBaseChoosePlayer.m_characterCurr].localScore;
            graphics2D.drawString("" + s, n, nArray[2] + 0, 10);
        }
    }

    private void drawLane(Graphics2D graphics2D) {
        int n = Graphics2D.getWidth(43) / 2;
        int n2 = Graphics2D.getHeight(42) + Graphics2D.getHeight(LANE_IMAGE_LIST[m_laneCurr]) / 2;
        graphics2D.drawImage(LANE_IMAGE_LIST[m_laneCurr], n, n2, 3);
        if (!Game.m_app.settings.unlockedLanes[m_laneCurr] && !unlockCheatEnabled) {
            graphics2D.drawString(StringTable.get(131), n + 0, n2, 3);
        } else {
            int n3 = 2;
            graphics2D.setFont(n3);
            int n4 = Graphics2D.getHeight(42) + Graphics2D.getHeight(LANE_IMAGE_LIST[m_laneCurr]) + (Graphics2D.getHeight(43) - Graphics2D.getHeight(LANE_IMAGE_LIST[m_laneCurr]) - 3 * Graphics2D.getFontHeight(n3)) / 2;
            String string = StringTable.get(86 + m_laneCurr);
            int n5 = 0;
            int n6 = string.length();
            int n7 = 0;
            for (int i = 0; i < n6; ++i) {
                if (string.charAt(i) != '|') continue;
                graphics2D.drawChars(string.toCharArray(), n5, i - n5, n, n4 + n7 * Graphics2D.getFontHeight(n3) + 0, 17);
                n5 = i + 1;
                ++n7;
            }
            graphics2D.drawChars(string.toCharArray(), n5, n6 - n5, n, n4 + n7 * Graphics2D.getFontHeight(n3) + 0, 17);
            graphics2D.setFont(2);
        }
    }

    public boolean onKeyPressed(int n) {
        if (MenuBaseSinglePlate.demoSoftkey) {
            if (MenuBaseSinglePlate.whichDemoScreen == 1) {
                if (n == -21) {
                    MenuBaseSinglePlate.doDemoScreen = false;
                    MenuBaseSinglePlate.demoSoftkey = false;
                } else if (n == -22) {
                    if (Game.m_app.m_playerMenuIsActive) {
                        MenuBaseSinglePlate.doDemoScreen = false;
                        MenuBaseSinglePlate.demoSoftkey = false;
                        Game.m_app.m_playerMenuIsActive = false;
                        this.onHide();
                        Game.m_app.m_menuIsActive = true;
                        Game.m_app.mainMenu.onStart();
                    } else if (Game.m_app.m_laneMenuIsActive) {
                        MenuBaseSinglePlate.doDemoScreen = false;
                        MenuBaseSinglePlate.demoSoftkey = false;
                        Game.m_app.m_laneMenuIsActive = false;
                        Game.m_app.m_playerMenuIsActive = true;
                        Game.m_app.playerMenu.onStart();
                    }
                    return true;
                }
                return true;
            }
            return true;
        }
        switch (n) {
            case -22: {
                if (Game.m_app.m_playerMenuIsActive) {
                    Game.m_app.m_playerMenuIsActive = false;
                    this.onHide();
                    Game.m_app.m_menuIsActive = true;
                    Game.m_app.mainMenu.onStart();
                } else if (Game.m_app.m_laneMenuIsActive) {
                    Game.m_app.m_laneMenuIsActive = false;
                    Game.m_app.m_playerMenuIsActive = true;
                    Game.m_app.playerMenu.onStart();
                }
                return true;
            }
        }
        return super.onKeyPressed(n);
    }

    public void update(int n) {
        if (Game.m_app.m_continueScreenIsActive) {
            return;
        }
        this.game.lnkAnimator.update(n - oldTime);
        super.update(n);
        if (this.game.lnkAnimator.objAnimList.size() == 0 || m_characterCurr != animatedCharacter) {
            this.startBowlerAnim();
        }
        if (ballInHands != null) {
            ballInHands.align((Node)((World)group).getActiveCamera());
        }
        this.game.getGameWorld().setModelRendering(m_characterCurr, !this.showOverall());
    }

    public void setLaneCurr(int n) {
        m_laneCurr = n;
    }

    protected void unloadLanePicture() {
    }

    protected void unloadAllPictures() {
    }

    protected void startBowlerAnim() {
        Debug.TRACE("startBowlerAnim " + m_characterCurr);
        this.game.lnkAnimator.stopAllAnim();
        NodeObject nodeObject = this.game.getGameWorld().hashedModels[m_characterCurr];
        if (nodeObject == null || this.showOverall()) {
            animatedCharacter = -1;
            ballInHands = null;
            return;
        }
        this.game.getGameWorld().initSkeleton(m_characterCurr);
        ballInHands = (Group)nodeObject.getSwerveObject().find(821176503);
        ballInHands.setAlignment(null, 145, (Node)((World)group), 148);
        ballInHands.setTranslation(Consts.BALL_IN_HANDS_POS[0], Consts.BALL_IN_HANDS_POS[1], Consts.BALL_IN_HANDS_POS[2]);
        ((World)group).setActiveCamera((Camera)nodeObject.getSwerveObject().find(GameWorld.USERID("Cam_menu2")));
        AnimationObject animationObject = new AnimationObject(this.game, nodeObject, this.game.getGameWorld().bowlerParams[MenuBaseChoosePlayer.m_characterCurr].ids[13], 22, true);
        this.game.lnkAnimator.StartAnimation(animationObject, false);
        animatedCharacter = m_characterCurr;
    }

    protected void onItemChange(int n) {
        super.onItemChange(n);
        if (n == -1) {
            return;
        }
        if (this.m_selectedItemCharacter) {
            this.game.getGameWorld().expoInObj.setText(-1);
            this.game.getGameWorld().expoInObj.setEmotion(-1);
            if (n == 0 && this.showHighScore()) {
                String string = new String();
                for (int i = 0; i < 4; ++i) {
                    string = string + (i + 1) + ". " + StringTable.get(57 + i) + " " + Math.max(Game.m_app.records[i].localScore, Game.m_app.records[i].localTournRecord) + "|";
                }
                this.game.getGameWorld().expoInObj.setTopLineY(this.getHeaderTop() + Graphics2D.getFontHeight(2) * 2);
                this.game.getGameWorld().expoInObj.setText(string);
                this.game.getGameWorld().expoInObj.setVisible(true);
            } else {
                m_characterCurr = this.showHighScore() ? n - 1 : n;
            }
        } else if (m_laneCurr != n) {
            m_laneCurr = n;
        }
    }

    protected boolean drawSelect() {
        return !this.showHighScore();
    }

    protected boolean drawBack() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onItemSelect(int n) {
        block22: {
            block23: {
                if (this.showHighScore()) {
                    return;
                }
                if (!Game.m_app.m_playerMenuIsActive) break block22;
                if (Game.m_app.records[MenuBaseChoosePlayer.m_characterCurr].unlocked) break block23;
                if (!unlockCheatEnabled) break block22;
            }
            if (Game.m_app.mainMenu.getLastSelectedItem() == 36) {
                lastSelectedCharacter = m_characterCurr;
                characterSelected = true;
                Game.m_app.m_playerMenuIsActive = false;
                this.onHide();
                this.game.lnkAnimator.stopAllAnim();
                animatedCharacter = -1;
                Game.m_app.m_menuIsActive = true;
                Game.m_app.mainMenu.onStart();
                Game.m_app.mainMenu.setState(36, false);
                return;
            }
            if (m_firstPlayer == -1) {
                if (Game.m_app.mainMenu.getLastSelectedItem() == 38) {
                    m_firstPlayer = m_characterCurr;
                    return;
                }
            }
            if (m_firstPlayer == m_characterCurr) return;
            if (Game.m_app.mainMenu.getLastSelectedItem() == 38) {
                m_secondPlayer = m_characterCurr;
            }
            Game.m_app.m_playerMenuIsActive = false;
            Game.m_app.m_laneMenuIsActive = true;
            Game.m_app.laneMenu.onStart();
            return;
        }
        if (!Game.m_app.m_laneMenuIsActive) return;
        if (!Game.m_app.settings.unlockedLanes[m_laneCurr]) {
            if (!unlockCheatEnabled) return;
        }
        Game.m_app.m_laneMenuIsActive = false;
        this.onHide();
        super.onHide();
        this.game.lnkAnimator.stopAllAnim();
        animatedCharacter = -1;
        if (demoEnabled) {
            switch (Game.m_app.mainMenu.getLastSelectedItem()) {
                case 337: {
                    this.game.playMatch(m_characterCurr, m_laneCurr, false, 1, 4, 3);
                    return;
                }
                case 34: {
                    this.game.playMatch(m_characterCurr, m_laneCurr, false, 0, 5, 10);
                    return;
                }
                case 35: {
                    this.game.playMatch(m_characterCurr, m_laneCurr, false, 0, 3, 10);
                    return;
                }
                case 38: {
                    this.game.playMatch(m_firstPlayer, m_laneCurr, true, m_secondPlayer, 1, 10);
                    return;
                }
            }
            return;
        }
        switch (Game.m_app.mainMenu.getLastSelectedItem()) {
            case 22: {
                this.game.playMatch(m_characterCurr, m_laneCurr, false, 1, 4, 5);
                return;
            }
            case 34: {
                this.game.playMatch(m_characterCurr, m_laneCurr, false, 0, 5, 10);
                return;
            }
            case 35: {
                this.game.playMatch(m_characterCurr, m_laneCurr, false, 0, 3, 10);
                return;
            }
            case 38: {
                this.game.playMatch(m_firstPlayer, m_laneCurr, true, m_secondPlayer, 1, 10);
                return;
            }
        }
    }

    public void setCharacterNext(int n) {
        this.m_characterNext = n;
    }

    static {
        animatedCharacter = -1;
        unlockCheatEnabled = false;
    }
}

