/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import java.util.Vector;
import javax.microedition.m3g.AnimationController;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import userapp.AnimatedSkeleton;
import userapp.AnimationObject;
import userapp.CameraObject;
import userapp.Game;
import userapp.GameWorld;
import userapp.NodeObject;
import userapp.SkeletalAnimation;

class Animator {
    public static final int[] CONTROLLER_IDS = new int[]{1039489601, 259729481, 21014149, 827250417, 1050410221, 690378845, 129238218, 774239235, 543611767, 180763451, 806477142, 1009872005, 497224808, 50724622, 1060528512, 902750963, 1045444725, 714765241, 132930392, 261367656, 265358489, 35861120, 915478649, 927492028, 880080034};
    static final int[] ALL_BONES_NUM = new int[]{35, 39};
    static final String[] KITTY_BONES_NAMES = new String[]{"root", "Dummy_bow", "Player01_Pelvis", "Player01_L_Thigh", "Player01_L_Calf", "Player01_L_Foot", "shoesL01", "shoesL02", "Player01_R_Thigh", "Player01_R_Calf", "Player01_R_Foot", "shoesR02", "shoesR01", "Notebook", "book1", "book2", "Player01_Spine", "Player01_Spine1", "Player01_Neck", "Player01_L_Clavicle", "Player01_L_UpperArm", "Player01_L_Forearm", "Player01_L_Hand", "mittL", "Player01_R_Clavicle", "Player01_R_UpperArm", "Player01_R_Forearm", "Player01_R_Hand", "ball_new", "mittR", "console", "Player01_Head", "spectacles_2", "Player01_Headglow", "D_pm2", "Kitty", "Kitty_Cam_signature", "ball_free", "Cam_menu2"};
    static final String[] STREAK_BONES_NAMES = new String[]{"root", "Dummy_bow", "Player01_Pelvis", "Player01_Spine", "Player01_Spine1", "Player01_Neck", "Player01_Head", "spectacles_2", "Player01_Headglow", "Player01_L_Clavicle", "Player01_L_UpperArm", "Player01_L_Forearm", "Player01_L_Hand", "mittL", "Player01_R_Clavicle", "Player01_R_UpperArm", "Player01_R_Forearm", "Player01_R_Hand", "ball_new", "mittR", "Player01_L_Thigh", "Player01_L_Calf", "Player01_L_Foot", "shoesL02", "shoesL01", "Player01_R_Thigh", "Player01_R_Calf", "Player01_R_Foot", "shoesR02", "shoesR01", "D_pm2", "streak", "Streak_Cam_signature", "Cam_menu2", "ball_free"};
    static final String[][] ALL_BONES_NAMES = new String[][]{STREAK_BONES_NAMES, KITTY_BONES_NAMES};
    static final int[] SAR_IDS = new int[]{16, 17, 14, 15, 18, 19, 20, 21};
    private Game game;
    public Vector objAnimList = new Vector();
    private static final int CONTROLLERS_SIZE = 25;
    private AnimatedSkeleton animSkelet;
    private SkeletalAnimation[] sar = new SkeletalAnimation[3];
    private SkeletalAnimation[] hashedSars = new SkeletalAnimation[8];
    private static final boolean DEBUG = false;

    Animator() {
    }

    public void initSkeleton(NodeObject nodeObject, GameWorld.BowlerCreationParams bowlerCreationParams) {
        int n;
        int n2 = bowlerCreationParams.ids[36];
        int n3 = ALL_BONES_NUM[n2];
        String[] stringArray = ALL_BONES_NAMES[n2];
        Node[] nodeArray = new Node[n3];
        for (n = 0; n < n3; ++n) {
            nodeArray[n] = (Node)nodeObject.getSwerveObject().find(GameWorld.USERID(stringArray[n] + "Transform"));
            if (nodeArray[n] != null) continue;
        }
        this.animSkelet = new AnimatedSkeleton(nodeArray, stringArray, n3);
        n = bowlerCreationParams.ids[33];
        int n4 = bowlerCreationParams.ids[34];
        int n5 = bowlerCreationParams.ids[35];
        this.sar[0] = this.loadSar(n);
        this.sar[1] = this.loadSar(n4);
        this.sar[2] = this.loadSar(n5);
    }

    private SkeletalAnimation loadSar(int n) {
        if (this.hashedSars[n] == null) {
            this.hashedSars[n] = SkeletalAnimation.load(SAR_IDS[n]);
        }
        return this.hashedSars[n];
    }

    public void destroySkeleton(GameWorld.BowlerCreationParams bowlerCreationParams) {
        int n = bowlerCreationParams.ids[33];
        int n2 = bowlerCreationParams.ids[34];
        int n3 = bowlerCreationParams.ids[35];
        this.sar[0] = null;
        this.hashedSars[n] = null;
        this.sar[1] = null;
        this.hashedSars[n2] = null;
        this.sar[2] = null;
        this.hashedSars[n3] = null;
        System.gc();
    }

    private void startSkeletalAnumation(AnimationObject animationObject) {
        boolean bl = animationObject.isForward();
        if (animationObject.getName() == "ANIM_SPECIAL_THROW" || animationObject.getName() == "ANIM_LILZEE_SPECIAL_THROW" || animationObject.getName() == "ANIM_STREAK_SPECIAL_THROW" || animationObject.getName() == "ANIM_KITTI_SPECIAL_THROW") {
            this.animSkelet.setAnimation(this.sar[2]);
            this.animSkelet.startAnimation(this.sar[2], animationObject.IsLooped(), animationObject.GetAnimStartTime() + 550);
        } else if (animationObject.GetAnimStartTime() < 32000) {
            this.animSkelet.setAnimation(this.sar[0]);
            this.animSkelet.startAnimation(this.sar[0], animationObject.IsLooped(), animationObject.GetAnimStartTime() + 550);
        } else {
            this.animSkelet.setAnimation(this.sar[1]);
            this.animSkelet.startAnimation(this.sar[1], animationObject.IsLooped(), animationObject.GetAnimStartTime() - 32000 + 550);
        }
        this.animSkelet.setForward(bl);
        if (!bl) {
            this.animSkelet.setPosition(this.animSkelet.getPosition() + animationObject.GetDuration());
        }
    }

    public void init(Game game) {
        this.game = game;
    }

    public final void forceStopAllAnim() {
        this.forceStopAllAnim((Object3D)this.game.getGameWorld().world);
    }

    private final void forceStopAllAnim(Object3D object3D) {
        for (int i = 0; i < 25; ++i) {
            AnimationController animationController = (AnimationController)object3D.find(CONTROLLER_IDS[i]);
            if (animationController == null) continue;
            animationController.setWeight(0.0f);
        }
    }

    void StartAnimation(AnimationObject animationObject, boolean bl) {
        this.StartAnimation(animationObject, bl, true, 3.0f);
    }

    void StartAnimation(AnimationObject animationObject, boolean bl, float f) {
        this.StartAnimation(animationObject, bl, true, f);
    }

    void StartAnimation(AnimationObject animationObject, boolean bl, boolean bl2) {
        this.StartAnimation(animationObject, bl, bl2, 3.0f);
    }

    void StartAnimation(AnimationObject animationObject, boolean bl, boolean bl2, float f) {
        try {
            AnimationObject animationObject2 = animationObject;
            if (!animationObject2.isInteger()) {
                AnimationController animationController = animationObject2.getSwerveObject();
                if (!bl && animationObject2.isPlaying() && animationObject2.isForward() == bl2) {
                    return;
                }
                animationController.setWeight(1.0f);
                animationObject2.SetPlaying(true);
                Animator animator = this;
                animationObject2.SetStartTime(animator.game.getApplicationTime());
                animationObject2.SetForward(bl2);
                if (f <= 2.0f) {
                    Animator animator2 = this;
                    animationController.setSpeed(f, animator2.game.getApplicationTime());
                } else {
                    Animator animator3 = this;
                    animationController.setSpeed(animationObject2.GetSpeed(), animator3.game.getApplicationTime());
                }
                if (bl2) {
                    Animator animator4 = this;
                    animationController.setPosition((float)animationObject2.GetAnimStartTime(), animator4.game.getApplicationTime());
                } else {
                    animationController.setPosition((float)animationObject2.GetAnimStartTime(), animationObject2.GetStartTime() + animationObject2.GetDuration());
                }
                this.objAnimList.addElement(animationObject);
            } else {
                animationObject2.SetPlaying(true);
                Animator animator = this;
                animationObject2.SetStartTime(animator.game.getApplicationTime());
                animationObject2.SetForward(bl2);
                this.startSkeletalAnumation(animationObject2);
                this.objAnimList.addElement(animationObject);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void quickStopAnimation(AnimationObject animationObject) {
        animationObject.SetPlaying(false);
        animationObject.getSwerveObject().setWeight(0.0f);
        this.objAnimList.removeElement(animationObject);
    }

    void stopAnimation(AnimationObject animationObject) {
        try {
            if (animationObject.isPlaying()) {
                animationObject.SetPlaying(false);
                if (!animationObject.isInteger()) {
                    animationObject.getSwerveObject().setWeight(0.0f);
                } else {
                    this.animSkelet.setAnimation(null);
                }
                this.game.getGameWorld().animationFinished(animationObject);
                this.objAnimList.removeElement(animationObject);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void stopAllAnim() {
        this.stopAllAnim(true);
    }

    void stopAllAnim(boolean bl) {
        for (int i = 0; i < this.objAnimList.size(); ++i) {
            AnimationObject animationObject = (AnimationObject)this.objAnimList.elementAt(i);
            if (!animationObject.isPlaying()) continue;
            animationObject.SetPlaying(false);
            if (!animationObject.isInteger()) {
                animationObject.getSwerveObject().setWeight(0.0f);
            } else {
                this.animSkelet.setAnimation(null);
            }
            if (!bl) continue;
            this.game.getGameWorld().animationFinished(animationObject);
        }
        this.objAnimList.removeAllElements();
    }

    public void correctLoopAnimation() {
        for (int i = 0; i < this.objAnimList.size(); ++i) {
            AnimationObject animationObject = (AnimationObject)this.objAnimList.elementAt(i);
            if (animationObject.isPlaying()) {
                Animator animator = this;
                if (animator.game.getApplicationTime() - animationObject.GetStartTime() >= animationObject.GetDuration() && animationObject.IsLooped() && animationObject.GetDuration() > 0) {
                    while (true) {
                        Animator animator2 = this;
                        if (animator2.game.getApplicationTime() - animationObject.GetStartTime() < animationObject.GetDuration()) break;
                        animationObject.SetStartTime(animationObject.GetStartTime() + animationObject.GetDuration());
                    }
                    if (!animationObject.isInteger()) {
                        AnimationController animationController = animationObject.getSwerveObject();
                        animationController.setPosition((float)animationObject.GetAnimStartTime(), animationObject.GetStartTime());
                    }
                    this.startSkeletalAnumation(animationObject);
                }
            }
            if (!animationObject.isPlaying()) continue;
            Animator animator = this;
            if (animator.game.getApplicationTime() - animationObject.GetStartTime() < animationObject.GetDuration() || animationObject.IsLooped()) continue;
            animationObject.SetPlaying(false);
            if (!animationObject.isInteger()) {
                animationObject.getSwerveObject().setWeight(0.0f);
            } else {
                this.animSkelet.setAnimation(null);
            }
            this.game.getGameWorld().animationFinished(animationObject);
            this.objAnimList.removeElement(animationObject);
        }
    }

    void update(int n) {
        this.correctLoopAnimation();
        this.animateCamera(this.game.getGameWorld().powerCamObj);
        this.animateCamera(this.game.getGameWorld().idleCamObj);
        this.animateCamera(this.game.getGameWorld().players[this.game.getGameWorld().getCurrentBowler()].camSignatureObj);
        this.animateNode(this.game.getGameWorld().laneObj);
        this.animateGroup((Group)this.game.getGameWorld().sunWorld);
        this.animateGroup(this.game.getGameWorld().powerMeterGroup);
        this.animateGroup(this.game.getGameWorld().floorGlowGroup);
        this.animateGroup(this.game.getGameWorld().sparksRGroup);
        this.animateGroup(this.game.getGameWorld().sparksLGroup);
        this.animateBowlers(n);
    }

    private void animateNode(NodeObject nodeObject) {
        if (nodeObject != null) {
            this.animateGroup(nodeObject.getSwerveObject());
        }
    }

    private void animateCamera(CameraObject cameraObject) {
        if (cameraObject != null) {
            this.animateGroup(cameraObject.getSwerveObject());
        }
    }

    private void animateGroup(Group group) {
        if (group != null && group.isRenderingEnabled()) {
            Animator animator = this;
            group.animate(animator.game.getApplicationTime());
        }
    }

    private void animateBowlers(int n) {
        for (int i = 0; i < this.objAnimList.size(); ++i) {
            AnimationObject animationObject = (AnimationObject)this.objAnimList.elementAt(i);
            if (!animationObject.isInteger()) continue;
            Animator animator = this;
            int n2 = animator.game.getApplicationTime() - animationObject.GetStartTime();
            if (animationObject.IsLooped() && n2 > animationObject.GetDuration() / 2) {
                this.animSkelet.update(-n);
                continue;
            }
            this.animSkelet.update(n);
        }
        if (this.animSkelet != null) {
            this.animSkelet.update(-n / 2);
            this.animSkelet.update(n / 2);
        }
    }

    boolean isPlaying(AnimationObject animationObject) {
        AnimationObject animationObject2 = animationObject;
        if (animationObject2 != null) {
            return animationObject2.isPlaying();
        }
        return false;
    }

    public AnimatedSkeleton getSkeleton() {
        return this.animSkelet;
    }
}

