/*
 * Decompiled with CFR 0.152.
 */
package portinglib;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;
import portinglib.ResourceManager;

public class SoundManager
implements PlayerListener {
    private static SoundManager instance;
    private static int numRequest;
    public static final int HIGH_VOLUME = 100;
    public static final int MED_VOLUME = 60;
    public static final int LOW_VOLUME = 30;
    private static final byte TYPE_SOUND = 1;
    private static final byte TYPE_MUSIC = 2;
    private static final byte TYPE_NONE = 3;
    private static final int LOOP_CONSTANT = -1;
    private static short[] crossindex;
    private static Player[] players;
    private static int[] resIndexes;
    private static short[] types;
    private static short numSounds;
    private static boolean soundMuted;
    private static boolean musicMuted;
    private static int soundVolume;
    private static int musicVolume;
    private static int prevMusicVolume;
    private static int prevSoundVolume;
    private static byte[] typeRequest;
    private static boolean[] looped;
    private static int lastSoundIDRequest;
    private static int lastPlayedSound;
    private static final boolean DEBUG = false;
    private static final int CONFIG_VER = 3;
    private static final String[] RES_TYPES;

    private SoundManager() {
        instance = this;
    }

    public static void muteSound(boolean bl) {
        if (soundMuted != bl) {
            soundMuted = bl;
            SoundManager.mute(soundMuted, (byte)1);
        }
    }

    public static boolean isSoundMuted() {
        return soundMuted;
    }

    public static void setSoundVolume(int n) {
        soundVolume = n;
    }

    public static int getSoundVolume() {
        return soundVolume;
    }

    public static void playSound(int n, boolean bl) {
        SoundManager.play(n, bl, soundMuted, (byte)1, false, soundVolume);
    }

    public static void stopSound(int n) {
        SoundManager.stop(n, true, false);
        lastPlayedSound = -1;
        lastSoundIDRequest = -1;
    }

    public static void stopAllSounds() {
        for (int i = 0; i < numSounds; ++i) {
            SoundManager.stop(i, true, false);
        }
        lastPlayedSound = -1;
        lastSoundIDRequest = -1;
    }

    public static void muteMusic(boolean bl) {
        if (musicMuted != bl) {
            musicMuted = bl;
            SoundManager.mute(musicMuted, (byte)2);
        }
    }

    public static boolean isMusicMuted() {
        return musicMuted;
    }

    public static void setMusicVolume(int n) {
        musicVolume = n;
    }

    public static int getMusicVolume() {
        return musicVolume;
    }

    public static void playMusic(int n, boolean bl) {
        SoundManager.play(n, bl, musicMuted, (byte)2, false, musicVolume);
    }

    public static void stopMusic() {
        if (lastPlayedSound < 0) {
            return;
        }
        if (typeRequest[lastPlayedSound] == 2) {
            SoundManager.stop(lastPlayedSound, true, false);
        }
        lastPlayedSound = -1;
        lastSoundIDRequest = -1;
    }

    public static synchronized boolean isPlaying(int n) {
        if (n < 0) {
            return false;
        }
        int n2 = SoundManager.getSoundId(n);
        return players[n2] != null && lastSoundIDRequest == n && (looped[n] || players[n2].getState() == 400);
    }

    public static synchronized int getState(int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = SoundManager.getSoundId(n);
        if (players[n2] == null) {
            return -1;
        }
        return players[n2].getState();
    }

    public static synchronized void prefetch(int n) {
        SoundManager.createPlayer(n);
        try {
            players[SoundManager.getSoundId(n)].prefetch();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void deallocate(int n) {
        int n2 = SoundManager.getSoundId(n);
        SoundManager.resetID(n);
        if (players[n2] == null) {
            return;
        }
        try {
            players[n2].removePlayerListener((PlayerListener)instance);
            players[n2].close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SoundManager.players[n2] = null;
    }

    public static synchronized int getPlayingSoundID() {
        if (SoundManager.isPlaying(lastPlayedSound)) {
            return lastPlayedSound;
        }
        return -1;
    }

    static void loadData(DataInputStream dataInputStream) throws IOException {
        int n;
        numSounds = (short)dataInputStream.readUnsignedShort();
        crossindex = new short[numSounds];
        for (n = 0; n < numSounds; ++n) {
            SoundManager.crossindex[n] = dataInputStream.readShort();
        }
        n = dataInputStream.readUnsignedShort();
        resIndexes = new int[n];
        types = new short[n];
        for (int i = 0; i < n; ++i) {
            SoundManager.resIndexes[i] = dataInputStream.readUnsignedShort();
            SoundManager.types[i] = (short)dataInputStream.readUnsignedByte();
        }
        players = new Player[n];
        typeRequest = new byte[numSounds];
        looped = new boolean[numSounds];
        new SoundManager();
    }

    static void onStart() {
        if (players.length == 1) {
            SoundManager.prefetch(0);
        }
    }

    static void onDestroy() {
        for (int i = 0; i < numSounds; ++i) {
            SoundManager.deallocate(i);
        }
    }

    static void onPause(boolean bl) {
        for (int i = 0; i < numSounds; ++i) {
            SoundManager.deallocate(i);
        }
    }

    static void onResume() {
    }

    public synchronized void playerUpdate(Player player, String string, Object object) {
        if (lastPlayedSound < 0) {
            return;
        }
        int n = SoundManager.getSoundId(lastPlayedSound);
        if (player == players[n] && string.equals("endOfMedia") && !looped[lastPlayedSound]) {
            SoundManager.stop(lastPlayedSound, true, false);
        }
    }

    private static synchronized void play(int n, boolean bl, boolean bl2, byte by, boolean bl3, int n2) {
        if (!bl2 && (bl3 || !SoundManager.isPlaying(n) || lastPlayedSound == n && (looped[lastPlayedSound] != bl || typeRequest[lastPlayedSound] != by || by == 2 && prevMusicVolume != n2 || by == 1 && prevSoundVolume != n2))) {
            if (by == 2) {
                prevMusicVolume = n2;
            } else if (by == 1) {
                prevSoundVolume = n2;
            }
            lastPlayedSound = n;
            boolean bl4 = SoundManager.getSoundId(lastPlayedSound) != SoundManager.getSoundId(n);
            SoundManager.stop(lastPlayedSound, true, bl4);
            SoundManager.prefetch(n);
            int n3 = SoundManager.getSoundId(n);
            boolean bl5 = bl;
            try {
                VolumeControl volumeControl;
                if (n2 > 0 && n2 <= 100 && (volumeControl = (VolumeControl)players[n3].getControl("VolumeControl")) != null) {
                    volumeControl.setLevel(n2);
                }
                players[n3].setLoopCount(bl5 ? -1 : 1);
                players[n3].addPlayerListener((PlayerListener)instance);
                players[n3].start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SoundManager.looped[n] = bl;
        SoundManager.typeRequest[n] = by;
        lastSoundIDRequest = n;
    }

    private static void stop(int n) {
        SoundManager.stop(n, true, true);
    }

    private static synchronized void stop(int n, boolean bl, boolean bl2) {
        if (n < 0) {
            return;
        }
        if (bl) {
            SoundManager.resetID(n);
        }
        int n2 = SoundManager.getSoundId(n);
        try {
            if (players[n2] != null) {
                try {
                    players[n2].removePlayerListener((PlayerListener)instance);
                    players[n2].stop();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void mute(boolean bl, byte by) {
        if (lastSoundIDRequest >= 0 && by == typeRequest[lastSoundIDRequest]) {
            if (bl) {
                SoundManager.stop(lastSoundIDRequest, false, false);
            } else if (looped[lastSoundIDRequest]) {
                SoundManager.play(lastSoundIDRequest, true, false, by, true, by == 2 ? musicVolume : (by == 1 ? soundVolume : 0));
            }
        }
    }

    private static final void createPlayer(int n) {
        int n2 = SoundManager.getSoundId(n);
        if (players[n2] != null) {
            return;
        }
        try {
            SoundManager.players[n2] = Manager.createPlayer((InputStream)new ByteArrayInputStream(ResourceManager.getResource(resIndexes[n2])), (String)RES_TYPES[types[n2]]);
            players[n2].realize();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final void resetID(int n) {
        if (lastPlayedSound == n) {
            lastSoundIDRequest = -1;
        }
    }

    private static final int getSoundId(int n) {
        if (n < 0) {
            return -1;
        }
        short s = crossindex[n];
        return s;
    }

    static void onUpdate() {
    }

    static {
        soundMuted = false;
        musicMuted = false;
        soundVolume = 60;
        musicVolume = 60;
        prevMusicVolume = -1;
        prevSoundVolume = -1;
        lastSoundIDRequest = -1;
        lastPlayedSound = -1;
        RES_TYPES = new String[]{"audio/x-wav", "audio/basic", "audio/mpeg", "audio/midi", "audio/x-tone-seq", "audio/amr", "audio/x-smaf", "audio/qcelp", "audio/x-pmd"};
    }
}

