/*
 * Decompiled with CFR 0.152.
 */
package portinglib;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.Object3D;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import portinglib.Graphics2D;
import portinglib.SoundManager;
import portinglib.StringTable;

public final class ResourceManager {
    private static final String CONFIG_NAME = "/resources.dat";
    private static final int LOCALES_VER = 1;
    private static final String LOCALES_NAME = "/locales.dat";
    private static MIDlet midlet;
    private static int _locale;
    private static String[] fileNames;
    private static String[] locales;
    private static String[] HRlocales;
    private static int extraRecords;
    private static short[] extraIds;
    private static short[] attributes;
    private static String[] debugNames;
    private static final short ATTRIBUTE_IS_OPTIONAL = 1;
    private static final short ATTRIBUTE_IS_WRITABLE = 2;
    private static final short ATTRIBUTE_DESCRIPTION = Short.MIN_VALUE;
    private static String lastGetResourceString;
    private static final int SIZE_BUFF = 1000;
    private static final boolean DEBUG = false;

    private static String readString(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        return new String(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void startup(MIDlet mIDlet) {
        midlet = mIDlet;
        InputStream inputStream = ResourceManager.getResourceStream(CONFIG_NAME);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            try {
                int n;
                int n2;
                int n3 = dataInputStream.readUnsignedByte();
                int n4 = dataInputStream.readUnsignedByte();
                int n5 = dataInputStream.readUnsignedByte();
                int n6 = dataInputStream.readUnsignedShort();
                fileNames = new String[n6];
                for (n2 = 0; n2 < n6; ++n2) {
                    ResourceManager.fileNames[n2] = ResourceManager.readString(dataInputStream);
                }
                Graphics2D.loadData(dataInputStream);
                SoundManager.loadData(dataInputStream);
                StringTable.loadData(dataInputStream);
                n2 = dataInputStream.readUnsignedShort();
                int n7 = dataInputStream.readUnsignedByte();
                locales = new String[n7];
                HRlocales = new String[n7];
                for (n = 0; n < n7; ++n) {
                    ResourceManager.locales[n] = ResourceManager.readString(dataInputStream);
                    ResourceManager.HRlocales[n] = dataInputStream.readUTF();
                }
                if (dataInputStream.available() > 0) {
                    short s = dataInputStream.readShort();
                    extraRecords = s;
                    if (s > 0) {
                        extraIds = new short[extraRecords];
                        attributes = new short[extraRecords];
                        debugNames = new String[extraRecords];
                        for (n = 0; n < extraRecords; ++n) {
                            ResourceManager.extraIds[n] = dataInputStream.readShort();
                            ResourceManager.attributes[n] = dataInputStream.readShort();
                            if ((attributes[n] & Short.MIN_VALUE) == 0) continue;
                            ResourceManager.debugNames[n] = ResourceManager.readString(dataInputStream);
                        }
                    }
                } else {
                    extraRecords = 0;
                }
            }
            finally {
                ResourceManager.closeInputStream(dataInputStream);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResourceManager.setLocale(ResourceManager.getDefaultLocale());
    }

    private static int extraId(int n) {
        for (int i = 0; i < extraRecords; ++i) {
            if (extraIds[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static boolean isOptional(int n) {
        int n2 = ResourceManager.extraId(n);
        return n2 < 0 ? false : (attributes[n2] & 1) != 0;
    }

    public static boolean isWritable(int n) {
        int n2 = ResourceManager.extraId(n);
        return n2 < 0 ? false : (attributes[n2] & 3) != 0;
    }

    static void shutdown() {
    }

    public static String getDefaultLocale() {
        int n;
        int n2;
        String string = null;
        try {
            string = midlet.getAppProperty("Locale");
            if (string == null) {
                string = midlet.getAppProperty("Force-Locale");
            }
            if (string == null) {
                string = System.getProperty("microedition.locale");
            }
        }
        catch (Exception exception) {
            string = null;
        }
        if (string == null) {
            string = "no locale";
        }
        if ((n2 = ResourceManager.getLocaleId(string)) < 0 && (n = string.indexOf(45)) >= 0) {
            string = string.substring(0, n);
            n2 = ResourceManager.getLocaleId(string);
        }
        if (n2 < 0) {
            n2 = 0;
        }
        String string2 = locales[n2];
        return string2;
    }

    public static String getLocale() {
        return locales[_locale];
    }

    public static boolean setLocale(String string) {
        int n = ResourceManager.getLocaleId(string);
        if (n >= 0) {
            _locale = n;
            return true;
        }
        return false;
    }

    public static String[] getLocales() {
        String[] stringArray = new String[locales.length];
        System.arraycopy(locales, 0, stringArray, 0, locales.length);
        return stringArray;
    }

    public static String getLocaleName(String string) {
        int n = ResourceManager.getLocaleId(string);
        if (n >= 0) {
            return HRlocales[n];
        }
        return string;
    }

    public static boolean isResourceAvailable(int n) {
        Object object = ResourceManager.loadResource(n, null);
        boolean bl = object != null;
        ResourceManager.cleanupRS(object);
        return bl;
    }

    static final void closeInputStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Object loadRMSResource(int n, String string) {
        String string2 = ResourceManager.getRSName(n, string == null ? ResourceManager.getLocale() : string);
        RecordStore recordStore = ResourceManager.openRecordStore(string2);
        if (recordStore == null) {
            string2 = ResourceManager.getRSName(n, null);
            recordStore = ResourceManager.openRecordStore(string2);
        }
        return recordStore;
    }

    private static Object loadJARResourceLocalized(int n, String string) {
        String string2 = fileNames[n];
        String string3 = ResourceManager.constructLocaleName(string2, string);
        InputStream inputStream = ResourceManager.getResourceStream(string3);
        if (inputStream == null) {
            string3 = ResourceManager.constructLocalePath(string2, string);
            inputStream = ResourceManager.getResourceStream(string3);
        }
        return inputStream;
    }

    private static Object loadJARResourceNonLocalized(int n) {
        String string = fileNames[n];
        InputStream inputStream = ResourceManager.getResourceStream(string);
        return inputStream;
    }

    private static Object loadResource(int n, String string) {
        Object object = null;
        if (ResourceManager.isWritable(n) && (object = ResourceManager.loadRMSResource(n, string)) != null) {
            return object;
        }
        object = ResourceManager.loadJARResourceLocalized(n, string);
        if (object != null) {
            return object;
        }
        if (string == null) {
            object = ResourceManager.loadJARResourceNonLocalized(n);
        }
        return object;
    }

    public static byte[] getResource(int n) {
        Object object = ResourceManager.loadResource(n, null);
        if (object != null) {
            if (object instanceof InputStream) {
                InputStream inputStream = (InputStream)object;
                boolean bl = false;
                return ResourceManager.readFromIS(inputStream, bl);
            }
            if (object instanceof RecordStore) {
                RecordStore recordStore = (RecordStore)object;
                return ResourceManager.readFromRS(recordStore);
            }
        }
        return null;
    }

    public static Object3D getM3GResource(int n) {
        Object object = ResourceManager.loadResource(n, null);
        Object3D[] object3DArray = null;
        Object3D object3D = null;
        if (object != null) {
            try {
                if (object instanceof InputStream) {
                    InputStream inputStream = (InputStream)object;
                    ResourceManager.closeInputStream(inputStream);
                    object3DArray = Loader.load((String)lastGetResourceString);
                } else if (object instanceof RecordStore) {
                    RecordStore recordStore = (RecordStore)object;
                    object3DArray = Loader.load((byte[])ResourceManager.readFromRS(recordStore), (int)0);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (object3DArray != null && object3DArray.length == 1) {
            object3D = object3DArray[0];
        }
        return object3D;
    }

    private static String getRSName(int n, String string) {
        String string2 = fileNames[n];
        String string3 = "";
        if (string == null) {
            string = "";
        }
        int n2 = 31 - string.length() - string3.length();
        if (string2.length() > n2) {
            string2 = string2.substring(0, n2);
        }
        return string2 + string3 + string;
    }

    private static RecordStore openRecordStore(String string) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return recordStore;
    }

    private static void cleanupRS(Object object) {
        try {
            if (object instanceof RecordStore) {
                ((RecordStore)object).closeRecordStore();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFromRS(RecordStore recordStore) {
        byte[] byArray = null;
        try {
            byArray = recordStore.getRecord(1);
        }
        catch (Exception exception) {
        }
        finally {
            ResourceManager.cleanupRS(recordStore);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFromIS(InputStream inputStream, boolean bl) {
        byte[] byArray = null;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray2 = new byte[1000];
        try {
            try {
                int n = dataInputStream.read(byArray2);
                byArray = new byte[n];
                System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
                while ((n = dataInputStream.read(byArray2)) != -1) {
                    byte[] byArray3 = new byte[byArray.length + n];
                    System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                    System.arraycopy(byArray2, 0, byArray3, byArray.length, n);
                    byArray = byArray3;
                }
            }
            finally {
                ResourceManager.closeInputStream(dataInputStream);
            }
        }
        catch (Exception exception) {
            byArray = null;
        }
        return byArray;
    }

    private static String constructLocalePath(String string, String string2) {
        string2 = string2 == null ? ResourceManager.getLocale() : string2;
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(0, n + 1) + string2 + string.substring(n);
        }
        return string2 + "/" + string;
    }

    private static String constructLocaleName(String string, String string2) {
        string2 = string2 == null ? ResourceManager.getLocale() : string2;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return string.substring(0, n) + "_" + string2 + string.substring(n);
        }
        return string + "_" + string2;
    }

    static InputStream getResourceStream(String string) {
        lastGetResourceString = string;
        return string.getClass().getResourceAsStream(string);
    }

    static InputStream getResourceStream(int n) {
        Object object = ResourceManager.loadResource(n, null);
        if (object != null) {
            if (object instanceof InputStream) {
                return (InputStream)object;
            }
            if (object instanceof RecordStore) {
                return new ByteArrayInputStream(ResourceManager.readFromRS((RecordStore)object));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean putResource(int n, byte[] byArray, String string) {
        if (!ResourceManager.isWritable(n)) {
            throw new IllegalArgumentException("Attempt to overwrite a read only resource " + n);
        }
        boolean bl = true;
        String string2 = ResourceManager.getRSName(n, string);
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)string2, (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            } else {
                recordStore.addRecord(byArray, 0, byArray.length);
            }
        }
        catch (Throwable throwable) {
            bl = false;
        }
        finally {
            ResourceManager.cleanupRS(recordStore);
        }
        return bl;
    }

    public static boolean putResource(int n, byte[] byArray) {
        return ResourceManager.putResource(n, byArray, null);
    }

    public static boolean removeResource(int n, String string) {
        String string2 = ResourceManager.getRSName(n, string);
        try {
            RecordStore.deleteRecordStore((String)string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static boolean isResourceAvailable(int n, String string) {
        Object object = ResourceManager.loadResource(n, string);
        boolean bl = object != null;
        ResourceManager.cleanupRS(object);
        return bl;
    }

    static boolean isHieroglyphicLocale() {
        return false;
    }

    private static int getLocaleId(String string) {
        for (int i = 0; i < locales.length; ++i) {
            if (!locales[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    static boolean isResourcePacked(int n) {
        return false;
    }

    static String getFileName(int n) {
        return fileNames[n];
    }

    static {
        lastGetResourceString = null;
    }
}

