/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import java.util.Vector;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.World;
import portinglib.Debug;
import portinglib.ResourceManager;
import userapp.Game;
import userapp.GameObject;
import userapp.PortingParser;
import userapp.Skeleton;

class NodeObject
extends GameObject {
    public static final int STREAK_ANIM = 10;
    public static final int KITTY_ANIM = 11;
    public static final int DAZZL_ANIM = 13;
    public static final int LILZEE_ANIM = 12;
    public static final int PIN_M3G = 23;
    public static final int LANE_ENV = 22;
    public static final int STREAK_BALL_NORMAL = 28;
    private static final boolean DEBUG = false;
    private static final boolean PLACE_TO_GROUP = false;
    private static final boolean useRoundShadow = true;
    protected boolean renderImmediate = false;
    protected static float[] params = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    protected static Transform camtransform = new Transform();
    protected static Transform objtransform = new Transform();
    protected static Transform objtransformImmediate = new Transform();
    static Camera camera = new Camera();
    public static Vector immediateObjects = new Vector();
    protected Group group;
    protected Group parent;

    public NodeObject(Game game) {
        super(game);
    }

    public NodeObject(Game game, int n) {
        super(game);
        this.createGroup(n, true);
        this.buf[0] = (byte)n;
        this.finishChunkCreation();
    }

    public NodeObject(Game game, int n, World world, int n2) {
        super(game);
        this.createGroup(n, false);
        if (world != null) {
            this.setInPlace(world, n2);
        }
        this.parent = world;
        this.buf[0] = (byte)n;
        this.finishChunkCreation();
    }

    public static Vector expandGroupNodes(Group group) {
        return NodeObject._expandGroupNodes(group, new Vector());
    }

    private static Vector _expandGroupNodes(Group group, Vector vector) {
        for (int i = 0; i < group.getChildCount(); ++i) {
            Node node = group.getChild(i);
            if (node instanceof Group) {
                vector = NodeObject._expandGroupNodes((Group)node, vector);
                continue;
            }
            vector.addElement(node);
        }
        return vector;
    }

    public NodeObject(Game game, int n, World world, int n2, boolean bl) {
        super(game);
        this.renderImmediate = bl;
        this.createGroup(n, false);
        if (world != null) {
            this.setInPlace(world, n2);
        }
        this.parent = world;
        this.buf[0] = (byte)n;
        this.finishChunkCreation();
    }

    public NodeObject(Game game, int n, Group group, boolean bl) {
        super(game);
        this.renderImmediate = bl;
        this.createGroup(n, false);
        group.addChild((Node)this.group);
        this.parent = group;
        this.buf[0] = (byte)n;
        this.finishChunkCreation();
    }

    public void createGroup(int n, boolean bl) {
        while (this.group == null) {
            this.group = (Group)ResourceManager.getM3GResource(n);
        }
        if (this.group instanceof World && !bl) {
            this.parent = this.group;
            this.group = (Group)this.parent.getChild(0);
            this.parent.removeChild((Node)this.group);
        }
        PortingParser.printObjectTree((Object3D)this.group);
    }

    public void setInPlace(World world, int n) {
        try {
            this.Relink((Group)world, false);
            Group group = (Group)world.find(n);
            if (group == null) {
                return;
            }
            group.getTranslation(params);
            this.group.setTranslation(params[0], params[1], params[2]);
        }
        catch (Exception exception) {
            Debug.TRACE("setInPlace failed:");
            exception.printStackTrace();
        }
    }

    public void Duplicate(NodeObject nodeObject) {
        this.group = (Group)nodeObject.getSwerveObject().duplicate();
        ((Group)nodeObject.getSwerveObject().getParent()).addChild((Node)this.group);
        this.parent = (Group)this.group.getParent();
    }

    public void SetRenderingEnable(boolean bl) {
        this.group.setRenderingEnable(bl);
    }

    public Group getSwerveObject() {
        return this.group;
    }

    public void Relink(Group group, boolean bl) {
        if (!this.renderImmediate) {
            if (this.parent != null) {
                this.parent.getParent();
                this.parent.removeChild((Node)this.group);
            }
            if (group != null) {
                group.addChild((Node)this.group);
            }
        } else if (group != null) {
            immediateObjects.addElement(this);
        } else {
            immediateObjects.removeElement(this);
        }
        if (group == null && bl) {
            this.group = null;
            this.removeChunk();
        }
        this.parent = group;
    }

    public static void renderImmediates(Graphics3D graphics3D, World world) {
        NodeObject.tuneCamera(world);
        graphics3D.setCamera(camera, camtransform);
        for (int i = 0; i < immediateObjects.size(); ++i) {
            ((NodeObject)immediateObjects.elementAt(i)).render(graphics3D);
        }
    }

    public void render(Graphics3D graphics3D) {
        if (this.group != null && this.group.isRenderingEnabled()) {
            float[] fArray = new float[3];
            this.group.getTranslation(fArray);
            float[] fArray2 = new float[]{1.0f, 0.0f, 0.0f, fArray[0], 0.0f, 1.0f, 0.0f, fArray[1], 0.0f, 0.0f, 1.0f, fArray[2], 0.0f, 0.0f, 0.0f, 1.0f};
            objtransformImmediate.set(fArray2);
            graphics3D.render((Node)this.group, objtransformImmediate);
        }
    }

    public static void renderSkeleton(Graphics3D graphics3D, World world, Skeleton skeleton, Node node) {
        NodeObject.tuneCamera(world);
        graphics3D.setCamera(camera, camtransform);
        for (int i = 0; i < skeleton.getBoneCount(); ++i) {
            if (skeleton.getBones()[i] == null) continue;
            skeleton.getBones()[i].getTransformTo((Node)world, objtransform);
            node.align((Node)world.getActiveCamera());
            node.setRenderingEnable(true);
            graphics3D.render(node, objtransform);
        }
    }

    public static void moveShadow(Node node, World world) {
        Group group = (Group)world.find(887133535);
        if (group == null) {
            return;
        }
        if (node == null) {
            group.setRenderingEnable(false);
            return;
        }
        group.setRenderingEnable(true);
        Transform transform = new Transform();
        float[] fArray = new float[16];
        node.getTransformTo((Node)world, transform);
        transform.get(fArray);
        group.setTranslation(fArray[3], fArray[7], 0.01f);
    }

    public static void addShadow(World world) {
        Group group = (Group)world.find(887133535);
        if (group == null) {
            if ((Group)world.find(887133536) == null) {
                return;
            }
            group = (Group)world.find(887133536).duplicate();
            group.scale(2.5f, 2.5f, 2.5f);
            group.setUserID(887133535);
        } else {
            Group group2 = (Group)group.getParent();
            group2.getParent();
            group2.removeChild((Node)group);
        }
        group.setRenderingEnable(true);
        world.addChild((Node)group);
    }

    private static void tuneCamera(World world) {
        Camera camera = world.getActiveCamera();
        camera.getTransformTo((Node)world, camtransform);
        camera.getProjection(params);
        NodeObject.camera.setPerspective(params[0], params[1], params[2], params[3]);
    }
}

