/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import portinglib.Debug;
import portinglib.Graphics2D;
import portinglib.StringTable;
import userapp.Device;
import userapp.Game;
import userapp.MenuBaseChoosePlayer;

class MenuDialogGameResults
extends MenuBaseChoosePlayer {
    private int m_winnerId;
    private int m_loserId;
    private boolean showWinner;
    private int[] m_timeScore = new int[2];
    private int playersNum;
    public boolean init;
    private String winnerName = new String();
    private String loserName = new String();
    private String playerName = new String();

    public MenuDialogGameResults(Game game) {
        super(game);
    }

    public void onStart() {
        if (!this.init) {
            super.onStart();
            this.playersNum = this.game.playersNum;
            if (this.game.playersNum > 1) {
                this.m_loserId = this.game.playerWon ? this.game.getGameWorld().getOpponentId() : this.game.getGameWorld().getPlayerId();
                this.m_winnerId = this.game.playerWon ? this.game.getGameWorld().getPlayerId() : this.game.getGameWorld().getOpponentId();
                Debug.TRACE("m_loserId=" + this.m_loserId + " m_winnerId=" + this.m_winnerId);
                if (this.game.gameMode != 1) {
                    this.winnerName = this.game.getGameWorld().getPlayerName(this.game.playerWon ? 0 : 1);
                    this.loserName = this.game.getGameWorld().getPlayerName(this.game.playerWon ? 1 : 0);
                } else {
                    this.winnerName = StringTable.get(this.game.playerWon ? 2 : 3);
                    this.loserName = StringTable.get(this.game.playerWon ? 3 : 2);
                }
                Debug.TRACE("winnerName=" + this.winnerName + " loserName=" + this.loserName);
                m_characterCurr = this.m_loserId;
                this.showWinner = false;
                if (this.game.gameMode == 1) {
                    this.playerName = this.loserName;
                }
            } else {
                m_characterCurr = this.m_winnerId = this.game.getGameWorld().getPlayerId();
                this.showWinner = true;
            }
            this.m_characterNext = -1;
            this.m_timeScore[0] = this.game.getGameWorld().getTotalTimeScore(0);
            this.m_timeScore[1] = this.game.getGameWorld().getTotalTimeScore(1);
            this.init = true;
        } else {
            if (this.playersNum > 1) {
                m_characterCurr = this.m_loserId;
                this.showWinner = false;
                if (this.game.gameMode == 1) {
                    this.playerName = this.loserName;
                }
            } else {
                m_characterCurr = this.m_winnerId;
                this.showWinner = true;
            }
            this.m_characterNext = -1;
        }
    }

    public void render2D(Graphics2D graphics2D) {
        if (this.game.playersNum > 1) {
            this.setHeader(this.showWinner ? 140 : 139);
        } else {
            this.setHeader(-1);
        }
        this.setText(-1);
        this.setText2(-1);
        if (this.game.gameMode != 1) {
            int n = (this.showWinner ? this.m_winnerId : this.m_loserId) + 57;
            this.setText(n);
        } else {
            this.setTextString(this.playerName);
        }
        super.render2D(graphics2D);
        this.drawStats(graphics2D);
    }

    public boolean onKeyPressed(int n) {
        Debug.TRACE("GameRES::onKeyPressed");
        switch (n) {
            case -21: 
            case -20: 
            case 53: {
                if (this.game.gameMode == 4 && this.game.playersNum > 1 || this.game.gameMode == 1) {
                    if (this.showWinner) {
                        Game.m_app.m_gameResMenuIsActive = false;
                        Game.m_app.m_winnerResMenuIsActive = true;
                        Game.m_app.winnerResMenu.onStart();
                    } else {
                        m_characterCurr = this.m_winnerId;
                        this.showWinner = true;
                        if (this.game.gameMode == 1) {
                            this.playerName = this.winnerName;
                        }
                    }
                } else {
                    this.goToMainMenu();
                }
                return true;
            }
            case -22: {
                if ((this.game.gameMode == 4 && this.game.playersNum > 1 || this.game.gameMode == 1) && this.showWinner) {
                    m_characterCurr = this.m_loserId;
                    this.showWinner = false;
                    if (this.game.gameMode == 1) {
                        this.playerName = this.loserName;
                    }
                } else {
                    this.goToMainMenu();
                }
                return true;
            }
        }
        return false;
    }

    private void goToMainMenu() {
        this.onHide();
        this.init = false;
        Game.m_app.m_gameResMenuIsActive = false;
        Game.m_app.m_menuIsActive = true;
        Game.m_app.mainMenu.onStart();
        Game.m_app.mainMenu.setState(142, false);
    }

    public boolean onItemSelect() {
        return false;
    }

    protected int getHeaderTop() {
        return Device.SCREEN_MENU_FIRST_HEADER_TOP + Graphics2D.getFontHeight(2);
    }

    protected void drawStats(Graphics2D graphics2D) {
        int n;
        int n2 = Graphics2D.getFontHeight(2);
        int n3 = (Graphics2D.getHeight(43) - 10) / 3;
        int[] nArray = new int[3];
        nArray[0] = Graphics2D.getHeight(42) + 5 + 0;
        nArray[1] = nArray[0] + n3;
        nArray[2] = nArray[1] + n3;
        int n4 = Graphics2D.getWidth(43) / 2;
        graphics2D.drawImage(41, n4, nArray[0] + 0, 17);
        graphics2D.drawImage(41, n4, nArray[1] + 0, 17);
        graphics2D.drawImage(41, n4, nArray[2] + 0, 17);
        int n5 = this.game.playersNum <= 1 ? 0 : (this.game.playerWon ? (this.showWinner ? 0 : 1) : (this.showWinner ? 1 : 0));
        int n6 = (Graphics2D.getWidth(43) + Graphics2D.getWidth(41) >> 1) - 2;
        graphics2D.setFont(2);
        graphics2D.setColor(0xFFFFFF);
        for (n = 0; n < 3; ++n) {
            if (n == 0) {
                int n7 = n;
                nArray[n7] = nArray[n7] - (n2 + 0 + 1);
                continue;
            }
            int n8 = n;
            nArray[n8] = nArray[n8] - (n2 + 0);
        }
        graphics2D.drawString(StringTable.get(61), Device.SCREEN_MENU_CHOOSE_PLAYER_HEADER_X, Device.SCREEN_MENU_FIRST_HEADER_TOP, 20);
        graphics2D.drawString(StringTable.get(62), 10, nArray[0], 20);
        graphics2D.drawString(StringTable.get(63), 10, nArray[1], 20);
        graphics2D.drawString(StringTable.get(64), 10, nArray[2], 20);
        n = 0;
        while (n < 3) {
            int n9 = n++;
            nArray[n9] = nArray[n9] + (n2 + Graphics2D.getHeight(41) / 2 + 1);
        }
        n = this.m_timeScore[n5] / 1000;
        int n10 = n % 60;
        int n11 = n / 60 % 60;
        int n12 = n / 60 / 60 % 60;
        String string = new String();
        string = "" + this.game.scores[n5].playerScore[this.game.scores[n5].lastClosedFrame];
        graphics2D.drawString(string, n6 - 1, nArray[0], 10);
        string = "" + n12 + ":" + MenuDialogGameResults.zero(n11) + n11 + ":" + MenuDialogGameResults.zero(n10) + n10;
        graphics2D.drawString(string, n6, nArray[1], 10);
        string = "" + Game.m_app.records[MenuDialogGameResults.m_characterCurr].localScore;
        graphics2D.drawString(string, n6, nArray[2], 10);
    }

    private static String zero(int n) {
        return n < 10 ? "0" : "";
    }
}

