/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Object3D;
import portinglib.Graphics2D;
import portinglib.StringTable;
import userapp.AIThrowParams;
import userapp.AnimationObject;
import userapp.Animator;
import userapp.Cfg;
import userapp.Consts;
import userapp.ExpoInObject;
import userapp.GameMath;
import userapp.GameWorld;
import userapp.MenuBaseSinglePlate;
import userapp.OptimizationUtils;
import userapp.Physics;
import userapp.PortingParser;
import userapp.PortingUtils;
import userapp.TrackRecorder;
import userapp.UserApp;

class Game {
    static final byte[][] OpponentsExpositionReplies = new byte[][]{{5, 3, 6, 9, 12, 11, 18, 17, 15, 21, 23, 24}, {5, 1, 6, 7, 12, 11, 18, 17, 13, 19, 23, 24}, {3, 1, 6, 7, 12, 9, 18, 15, 13, 19, 21, 24}, {3, 1, 5, 7, 11, 9, 17, 15, 13, 19, 21, 23}};
    private float tempSpin = 50.0f;
    private static int updateTime = -1;
    private long resultsShowDelay;
    protected final int MAX_GAME_DTIME;
    private int pauseLoadedBowler;
    private int pauseLoadedFace;
    private int pauseStartTime;
    private boolean m_pauseResume;
    private boolean m_isPausedGame;
    private static int applicationTime;
    private int realAppTime;
    private static final int RIGHT_PRESSED = 1;
    private static final int LEFT_PRESSED = 2;
    private static final int OK_PRESSED = 4;
    private static final int DOWN_PRESSED = 8;
    private int keyMask;
    private static boolean m_keysIgnore;
    private int m_keysIgnoreStartTime;
    private int m_keysIgnoreTime;
    public int m_keyIdleTime;
    public int m_keyLastPressedTime;
    public static UserApp m_app;
    public int gameMode;
    public int numOfFrames;
    public boolean opponentInitialized;
    public int playersNum;
    public int currentPlayer;
    public boolean m_firstUpdate;
    public boolean firstThrow;
    public boolean AIWasFault;
    private int[][] scoresForUnlocks = new int[2][3];
    public int unlockingLane;
    public boolean unlockingGift;
    public int unlockingPlayer;
    public int unlockingStatPoint;
    public boolean unlockingGoldenBall;
    private String unlocksText;
    public boolean finishedTurnaments;
    public boolean playerWon;
    public int throwResult;
    public int precisionTarget;
    public int precisionSequence;
    public ScoreParams[] scores = new ScoreParams[2];
    private GameWorld lnkWorld = new GameWorld();
    public Physics lnkPhysics = new Physics();
    public Animator lnkAnimator = new Animator();
    public INIParams iniParams = new INIParams();
    public GameParams currentParams;
    public int lastFrame;
    public float lastStepPos;
    private float rot;
    private int spinPressKeyTime;
    public static int aiResult;
    private static final boolean DEBUG = false;

    public Game(UserApp userApp) {
        this.MAX_GAME_DTIME = 200;
        m_app = userApp;
    }

    public void init() {
        int n = 0;
        n = 40;
        this.iniParams.maxBallSpeed = (float)n / 100.0f;
        this.iniParams.maxBallSpeed /= 2.0f;
        n = 12;
        this.iniParams.minBallSpeed = (float)n / 100.0f;
        this.iniParams.minBallSpeed /= 2.0f;
        n = 5;
        this.iniParams.spinStep = (float)n / 100000.0f;
        this.iniParams.spinStep /= 2.0f;
        n = 10;
        this.iniParams.maxSpin = (float)n / 10000.0f;
        this.iniParams.maxSpin /= 2.0f;
        n = 350;
        this.iniParams.posStep = (float)n / 10000.0f;
        n = 110;
        this.iniParams.normalParams.ballRadius = GameMath.FP_1 * n / 100;
        this.iniParams.normalParams.ballRadiusFloat = (float)n / 1000.0f;
        n = 60;
        this.iniParams.normalParams.pinRadius = GameMath.FP_1 * n / 100;
        this.iniParams.normalParams.pinRadiusFloat = (float)n / 1000.0f;
        n = 60;
        this.iniParams.normalParams.pinHeadRadius = GameMath.FP_1 * n / 100;
        n = 260;
        this.iniParams.normalParams.pinHeight = GameMath.FP_1 * n / 100;
        this.iniParams.normalParams.pinHeightFloat = (float)n / 1000.0f;
        n = 7250;
        this.iniParams.normalParams.ballWeight = GameMath.FP_1 * n / 1000;
        n = 1500;
        this.iniParams.normalParams.pinWeight = GameMath.FP_1 * n / 1000;
        n = 64;
        this.iniParams.duckPinsParams.ballRadius = GameMath.FP_1 * n / 100;
        this.iniParams.duckPinsParams.ballRadiusFloat = (float)n / 1000.0f;
        n = 36;
        this.iniParams.duckPinsParams.pinRadius = GameMath.FP_1 * n / 100;
        this.iniParams.duckPinsParams.pinRadiusFloat = (float)n / 1000.0f;
        n = 36;
        this.iniParams.duckPinsParams.pinHeadRadius = GameMath.FP_1 * n / 100;
        n = 156;
        this.iniParams.duckPinsParams.pinHeight = GameMath.FP_1 * n / 100;
        this.iniParams.duckPinsParams.pinHeightFloat = (float)n / 1000.0f;
        n = 1450;
        this.iniParams.duckPinsParams.ballWeight = GameMath.FP_1 * n / 1000;
        n = 300;
        this.iniParams.duckPinsParams.pinWeight = GameMath.FP_1 * n / 1000;
        this.scoresForUnlocks[1][0] = 30;
        this.scoresForUnlocks[1][1] = 40;
        this.scoresForUnlocks[1][2] = 50;
        this.scoresForUnlocks[0][0] = 70;
        this.scoresForUnlocks[0][1] = 75;
        this.scoresForUnlocks[0][2] = 80;
        this.lnkPhysics.init(this, 0);
        this.lnkWorld.init(this);
        this.lnkAnimator.init(this);
        for (int i = 0; i < 2; ++i) {
            if (this.scores[i] != null) continue;
            this.scores[i] = new ScoreParams();
        }
    }

    public int getOpponentsExpositionReply(int n, int n2) {
        return OpponentsExpositionReplies[n][n2] - 1;
    }

    public GameWorld getGameWorld() {
        return this.lnkWorld;
    }

    private void drawForegrowndGui(Graphics2D graphics2D) {
        if (Game.m_app.m_continueScreenIsActive) {
            return;
        }
        switch (this.lnkWorld.getGameState()) {
            case 1: {
                this.lnkWorld.guiObj.drawReadyForegrownd(graphics2D);
                break;
            }
            case 13: {
                this.lnkWorld.guiObj.drawFaultForegrownd(graphics2D);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.lnkWorld.guiObj.drawPositionForegrownd(graphics2D);
                break;
            }
            case 25: {
                PortingUtils.beginProf("renderSpinM");
                this.lnkWorld.spinMeterObj.drawForegrownd(graphics2D);
                this.lnkWorld.guiObj.drawSpinForegrownd(graphics2D);
                PortingUtils.endProf();
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.lnkWorld.guiObj.drawPowerForeground(graphics2D);
            }
        }
        this.lnkWorld.triangleObj.draw(graphics2D);
        this.lnkWorld.throwResultObj.draw(graphics2D);
        this.lnkWorld.guiObj.drawPauzaForegrownd(graphics2D, this.lnkWorld.players[0].frameResultsObj != null && this.lnkWorld.players[0].frameResultsObj.isVisible() ? this.playersNum : 0);
        for (int i = 0; i < this.playersNum; ++i) {
            if (this.lnkWorld.players[i].frameResultsObj == null) continue;
            this.lnkWorld.players[i].frameResultsObj.draw(graphics2D);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renderAll(Graphics2D graphics2D) {
        if (Game.m_app.m_continueScreenIsActive) {
            return;
        }
        Graphics graphics = graphics2D.getGraphics();
        PortingUtils.beginProf("renderBack");
        OptimizationUtils.renderSnapShot(graphics);
        PortingUtils.endProf();
        PortingUtils.beginProf("render3D");
        Graphics3D graphics3D = Graphics3D.getInstance();
        graphics3D.bindTarget((Object)graphics, true, 0);
        try {
            PortingUtils.setFreeCamera(this.lnkWorld.world);
            if (this.lnkWorld.sunWorld != null) {
                graphics3D.render(this.lnkWorld.sunWorld);
            }
            graphics3D.render(this.lnkWorld.world);
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            graphics3D.releaseTarget();
            PortingUtils.endProf();
        }
        this.drawForegrowndGui(graphics2D);
        if (this.getGameWorld() != null) {
            this.getGameWorld();
            GameWorld.pAnim.correctLoopAnimation();
        }
    }

    void render3D(Graphics2D graphics2D) {
        if (Game.m_app.m_continueScreenIsActive) {
            return;
        }
        if (this.lnkWorld == null || this.lnkWorld.isLoading() || this.lnkWorld.world == null) {
            return;
        }
        if (!PortingParser.PARSE1) {
            this.renderAll(graphics2D);
        } else {
            PortingParser.drawObjectTree((Object3D)this.lnkWorld.world, graphics2D.getGraphics(), UserApp.getWidth(), UserApp.getHeight());
        }
        OptimizationUtils.renderDebug(graphics2D);
    }

    void blockKeys(int n) {
        m_keysIgnore = true;
        this.m_keysIgnoreTime = n;
        this.m_keysIgnoreStartTime = this.currentTimeMillis();
    }

    void updateBlockedKeys() {
        int n = this.currentTimeMillis();
        if (n > this.m_keysIgnoreStartTime + this.m_keysIgnoreTime) {
            m_keysIgnore = false;
        }
    }

    public static void setKeysIgnore(boolean bl) {
        m_keysIgnore = bl;
    }

    public static boolean getKeysIgnore() {
        return m_keysIgnore;
    }

    void pauseMatch() {
        int n;
        if (!Game.m_app.m_continueScreenIsActive) {
            m_app.regularRunStr(-1);
            this.lnkWorld.triangleObj.setVisible(false);
            this.lnkWorld.throwResultObj.setVisible(false);
        }
        if (this.lnkWorld.isLoading()) {
            this.lnkWorld.deInit();
            Game.m_app.m_menuIsActive = true;
            Game.m_app.mainMenu.setState(144, false);
            Game.m_app.mainMenu.onStart();
            return;
        }
        this.pauseStartTime = Game.getApplicationTime();
        for (n = 0; n < this.playersNum; ++n) {
            if (!this.lnkWorld.players[n].isLoaded) continue;
            this.pauseLoadedBowler = n;
            break;
        }
        for (n = 0; n < this.playersNum; ++n) {
            if (!this.lnkWorld.players[n].isLoadedFace) continue;
            this.pauseLoadedFace = n;
            break;
        }
        Game.m_app.m_menuIsActive = true;
        if (!Game.m_app.initMainMenu_after_continueScreen) {
            Game.m_app.mainMenu.setState(144, false);
            Game.m_app.mainMenu.onStart();
        }
        this.keyMask = 0;
        this.tempSpin = this.lnkWorld.spinMeterObj.getDX();
    }

    public void resumeMatch() {
        Game.setApplicationTime(this.pauseStartTime);
        Game.pickUpdateTime();
        this.m_pauseResume = true;
        this.resetApplicationTime();
        if (this.lnkWorld.getGameState() == 10) {
            this.lnkWorld.setGameState(9);
        } else {
            this.lnkWorld.setGameState(this.lnkWorld.getGameState());
        }
        this.lnkWorld.spinMeterObj.setDX(this.tempSpin);
        ExpoInObject cfr_ignored_0 = this.lnkWorld.expoInObj;
        if (ExpoInObject.isGameHelp) {
            this.lnkWorld.expoInObj.onKeyPressed(42);
        }
    }

    void onKeyPressed(int n) {
        this.m_keyIdleTime = 0;
        this.m_keyLastPressedTime = this.realAppTime;
        if (m_keysIgnore || this.m_pauseResume) {
            return;
        }
        if (this.lnkWorld.isLoading()) {
            return;
        }
        if (Game.m_app.cheatsEnabled) {
            this.processCheats(n);
        }
        if (n == -20 || n == 53) {
            if (this.unlocksText != null) {
                this.lnkWorld.deInit();
                this.unlocksText = null;
                this.lnkWorld.expoInObj.setVisible(false);
                Game.m_app.m_gameResMenuIsActive = true;
                Game.m_app.gameResMenu.onStart();
                return;
            }
            switch (this.lnkWorld.getGameState()) {
                case 1: {
                    this.lnkWorld.setGameState(2);
                    break;
                }
                case 23: {
                    if (this.gameMode == 4) {
                        this.lnkWorld.setGameState(1);
                        break;
                    }
                    this.lnkWorld.setGameState(4);
                    break;
                }
                case 24: {
                    this.finishGame();
                    break;
                }
                case 4: {
                    this.lnkWorld.setGameState(25);
                    this.keyMask = 4;
                    break;
                }
                case 8: {
                    if (this.lnkWorld.getCurrentBowler() != 1 || this.gameMode == 1) break;
                    this.switchAItoBallMoving();
                    break;
                }
                case 25: {
                    this.lnkWorld.setGameState(10);
                    this.keyMask = 4;
                    break;
                }
                case 9: {
                    if (this.lnkWorld.getCurrentBowler() != 1 || this.gameMode == 1) {
                        this.lnkWorld.setGameState(10);
                        this.resetKeys();
                        break;
                    }
                    this.switchAItoBallMoving();
                    break;
                }
                case 10: {
                    if (this.lnkWorld.getCurrentBowler() != 1 || this.gameMode == 1) {
                        this.lnkWorld.setGameState(11);
                        break;
                    }
                    this.switchAItoBallMoving();
                    break;
                }
                case 11: {
                    if (this.lnkWorld.getCurrentBowler() != 1 || this.gameMode == 1) {
                        if (this.lnkWorld.powerMeterObj.getDX() < 86.0f) {
                            this.lnkWorld.setGameState(16);
                            break;
                        }
                        this.lnkWorld.setGameState(13);
                        this.lnkWorld.setInFaultPlace();
                        break;
                    }
                    this.switchAItoBallMoving();
                    break;
                }
                case 17: {
                    this.lnkPhysics.updateAll();
                    this.lnkPhysics.finishVisualization();
                    if (!this.scores[this.currentPlayer].updated) {
                        this.throwResult = this.lnkPhysics.getThrowResult();
                    }
                    this.lnkWorld.setGameState(18);
                    break;
                }
                case 13: {
                    this.lnkAnimator.stopAllAnim(false);
                    this.throwResult = -1;
                    this.updateScore();
                    ++this.scores[this.currentPlayer].currentThrow;
                    this.processGameOver();
                    break;
                }
                case 18: {
                    if (!this.scores[this.currentPlayer].updated) {
                        this.updateScore();
                        ++this.scores[this.currentPlayer].currentThrow;
                    }
                    if (MenuBaseSinglePlate.demoEnabled) {
                        this.resultsShowDelay = System.currentTimeMillis();
                    }
                    this.lnkWorld.setGameState(19);
                    break;
                }
                case 19: {
                    this.lnkPhysics.deinitRecorders();
                    this.processGameOver();
                }
            }
        } else if (n == -22) {
            this.pauseMatch();
        } else {
            if (this.currentPlayer > 0 && this.gameMode != 1 && this.lnkWorld.getGameState() != 19 && this.lnkWorld.getGameState() != 17 && this.lnkWorld.getGameState() != 18) {
                return;
            }
            switch (this.lnkWorld.getGameState()) {
                case 4: {
                    if (n == -5 || n == 54) {
                        this.keyMask |= 1;
                        this.lnkWorld.setGameState(6);
                    }
                    if (n != -2 && n != 52) break;
                    this.keyMask |= 2;
                    this.lnkWorld.setGameState(5);
                    break;
                }
                case 19: {
                    if (n == -5 || n == 54) {
                        this.keyMask |= 1;
                        break;
                    }
                    if (n == -2 || n == 52) {
                        this.keyMask |= 2;
                        break;
                    }
                    if (n != 48) break;
                    this.lnkWorld.setGameState(17);
                    this.lnkPhysics.Replay();
                    break;
                }
                case 25: {
                    if (n == -5 || n == 54) {
                        this.keyMask |= 1;
                        this.spinPressKeyTime = applicationTime;
                        this.lnkWorld.spinMeterObj.incArrows(1);
                        break;
                    }
                    if (n != -2 && n != 52) break;
                    this.keyMask |= 2;
                    this.spinPressKeyTime = applicationTime;
                    this.lnkWorld.spinMeterObj.incArrows(-1);
                    break;
                }
                case 17: 
                case 18: {
                    if (n != 48) break;
                    if (this.lnkWorld.getGameState() == 17) {
                        this.lnkPhysics.updateAll();
                        this.lnkPhysics.finishVisualization();
                    }
                    this.lnkWorld.setGameState(17);
                    this.lnkPhysics.Replay();
                }
            }
        }
    }

    void switchAItoBallMoving() {
        if (!this.AIWasFault) {
            this.lnkPhysics.calcAllTracks(TrackRecorder.x, TrackRecorder.dx, TrackRecorder.dy);
            OptimizationUtils.movingCameraType = 1;
            this.lnkWorld.setGameState(16);
        } else {
            this.lnkWorld.setGameState(13);
            this.lnkWorld.setInFaultPlace();
        }
    }

    void onKeyReleased(int n) {
        if (this.m_pauseResume || Game.m_app.m_continueScreenIsActive) {
            return;
        }
        if (this.lnkWorld.getGameState() == 19) {
            if (n == -5 || n == 54) {
                this.keyMask &= 0xFFFFFFFE;
            } else if (n == -2 || n == 52) {
                this.keyMask &= 0xFFFFFFFD;
            }
        }
        if (this.currentPlayer > 0 && this.gameMode != 1) {
            return;
        }
        switch (this.lnkWorld.getGameState()) {
            case 4: 
            case 5: 
            case 6: {
                if (n == -5 || n == 54) {
                    this.keyMask &= 0xFFFFFFFE;
                    break;
                }
                if (n != -2 && n != 52) break;
                this.keyMask &= 0xFFFFFFFD;
                break;
            }
            case 25: {
                if (n == -5 || n == 54) {
                    this.keyMask &= 0xFFFFFFFE;
                    this.lnkWorld.spinMeterObj.snapDX();
                    break;
                }
                if (n != -2 && n != 52) break;
                this.keyMask &= 0xFFFFFFFD;
                this.lnkWorld.spinMeterObj.snapDX();
                break;
            }
            case 8: {
                if (n != -20 && n != 53) break;
                this.resetKeys();
                break;
            }
            case 10: {
                if (n != -20 && n != 53 || this.lnkWorld.getCurrentBowler() == 1 && this.gameMode != 1) break;
                this.lnkWorld.setGameState(11);
            }
        }
    }

    void processGameOver() {
        this.scores[this.currentPlayer].updated = false;
        boolean bl = true;
        for (int i = 0; i < this.playersNum; ++i) {
            if (this.scores[i].lastClosedFrame >= this.lastFrame) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.currentPlayer = 0;
            if (this.gameMode == 5) {
                this.finishGame();
            } else {
                this.lnkWorld.setGameState(21);
            }
        } else {
            boolean bl2;
            if (this.gameMode == 5) {
                this.precisionTarget = this.lnkPhysics.getRandomTarget();
            }
            this.firstThrow = this.throwResult == -1;
            ScoreParams scoreParams = this.scores[this.currentPlayer];
            boolean bl3 = bl2 = scoreParams.currentFrame <= this.lastFrame && scoreParams.playerFrames[scoreParams.currentFrame] == scoreParams.currentThrow || scoreParams.currentFrame > this.lastFrame && this.scores[this.currentPlayer].lastClosedFrame >= this.lastFrame;
            if (bl2) {
                ++this.currentPlayer;
                if (this.currentPlayer == this.playersNum) {
                    this.currentPlayer = 0;
                }
            }
            this.resetKeys();
            this.lnkPhysics.resetPins(this.firstThrow);
            if (this.gameMode == 1) {
                this.lnkWorld.setGameState(1);
            } else {
                this.lnkWorld.setGameNextState(3);
            }
            this.AIWasFault = false;
            boolean bl4 = false;
            if (this.currentPlayer > 0 && this.gameMode != 1) {
                int n;
                int n2;
                int n3;
                Random random = new Random(System.currentTimeMillis());
                int n4 = Game.m_app.records[this.lnkWorld.playerBowlerId].nextMatch * 3 + this.scores[this.currentPlayer].currentFrame / 4;
                if (Cfg.AI_TABLE[n4 * 3 + 2] != 0) {
                    n3 = Math.abs(random.nextInt());
                    n2 = Math.abs(random.nextInt());
                    n = 100 / Cfg.AI_TABLE[n4 * 3 + 2];
                    if (n3 % n == 0) {
                        this.AIWasFault = true;
                    }
                    if (n2 % n == 0) {
                        bl4 = true;
                    }
                }
                n3 = 10;
                if (!bl4) {
                    if (this.firstThrow) {
                        n2 = Cfg.AI_TABLE[n4 * 3 + 1] - Cfg.AI_TABLE[n4 * 3];
                        n3 = 10 - (Math.abs(random.nextInt()) % n2 + Cfg.AI_TABLE[n4 * 3]);
                    } else {
                        n3 = 10 - (Math.abs(random.nextInt()) % (Cfg.AI_TABLE[n4 * 3 + 1] - 1) + 1);
                    }
                }
                int[] nArray = AIThrowParams.THROWS[n3];
                aiResult = n3;
                n = Math.abs(random.nextInt());
                TrackRecorder.x = nArray[(n %= AIThrowParams.LENGTHES[10 - n3]) * 4];
                TrackRecorder.dx = nArray[n * 4 + 1];
                TrackRecorder.dy = nArray[n * 4 + 2];
                TrackRecorder.iterLimit = nArray[n * 4 + 3];
                if (this.AIWasFault) {
                    TrackRecorder.dy = 100000;
                }
                this.lnkPhysics.setAiMove(true);
            }
        }
    }

    private void processCheats(int n) {
        switch (n) {
            case 49: {
                if (this.lnkWorld.getGameState() != 18) break;
                this.currentPlayer = 0;
                while (this.scores[this.currentPlayer].lastClosedFrame < this.lastFrame) {
                    this.throwResult = 0;
                    this.updateScore();
                    ++this.scores[this.currentPlayer].currentThrow;
                }
                if (this.playersNum > 1) {
                    this.currentPlayer = 1;
                    while (this.scores[this.currentPlayer].lastClosedFrame < this.lastFrame) {
                        this.throwResult = 10;
                        this.updateScore();
                        ++this.scores[this.currentPlayer].currentThrow;
                    }
                    this.currentPlayer = 0;
                }
                this.lnkWorld.setGameState(19);
                break;
            }
            case 51: {
                if (this.lnkWorld.getGameState() != 18) break;
                this.currentPlayer = 0;
                while (this.scores[this.currentPlayer].lastClosedFrame < this.lastFrame) {
                    this.throwResult = 10;
                    this.updateScore();
                    ++this.scores[this.currentPlayer].currentThrow;
                }
                if (this.playersNum > 1) {
                    this.currentPlayer = 1;
                    while (this.scores[this.currentPlayer].lastClosedFrame < this.lastFrame) {
                        this.throwResult = 0;
                        this.updateScore();
                        ++this.scores[this.currentPlayer].currentThrow;
                    }
                    this.currentPlayer = 0;
                }
                this.lnkWorld.setGameState(19);
                break;
            }
            case 42: {
                OptimizationUtils.timeCoef = (float)((double)OptimizationUtils.timeCoef + 0.2);
                break;
            }
            case 35: {
                OptimizationUtils.timeCoef = (float)((double)OptimizationUtils.timeCoef - 0.2);
            }
        }
    }

    void moveBowler(float[] fArray, boolean bl) {
        float f = this.lnkPhysics.GetPos();
        float f2 = TrackRecorder.keepOnTrack(f += fArray[0], false);
        fArray[0] = fArray[0] - (f - f2);
        f = f2;
        this.lnkPhysics.SetPos(f);
        if (bl) {
            this.lastStepPos = f;
        }
    }

    boolean canMakeStep() {
        float f = this.lnkPhysics.GetPos() + this.calcStepDx(true) + this.calcStepDx(false);
        float f2 = TrackRecorder.keepOnTrack(f, false);
        return this.lnkPhysics.GetPos() != f2;
    }

    private float getStepWidth() {
        return this.iniParams.posStep * 100.0f / 200.0f;
    }

    private float calcStepDx(boolean bl) {
        float f = 0.0f;
        if (this.lnkWorld.getGameState() == 6) {
            f += this.getStepWidth();
        }
        if (this.lnkWorld.getGameState() == 5) {
            f -= this.getStepWidth();
        }
        if (!bl && this.lnkWorld.getGameState() == 5 || bl && this.lnkWorld.getGameState() == 6) {
            f *= 5.0f;
        }
        return f;
    }

    void makeStep(boolean bl) {
        float[] fArray = new float[]{this.calcStepDx(bl)};
        this.moveBowler(fArray, !bl);
        this.lnkWorld.moveBowler(fArray[0]);
    }

    public float getArrowScale(boolean bl) {
        float f = 0.6f;
        AnimationObject animationObject = this.getGameWorld().players[this.getGameWorld().getCurrentBowler()].bowlerStepLeftAnimObj;
        if (this.lnkAnimator.isPlaying(animationObject) && bl == animationObject.isForward()) {
            f = 1.0f;
        }
        return f;
    }

    public float getPosInterpolationAdd() {
        float f = 0.0f;
        AnimationObject animationObject = this.getGameWorld().players[this.getGameWorld().getCurrentBowler()].bowlerStepLeftAnimObj;
        if (this.lnkAnimator.isPlaying(animationObject)) {
            float f2 = (float)(animationObject.isForward() ? -1 : 1) * 5.0f * this.getStepWidth();
            f = f2 * (float)(Game.getApplicationTime() - animationObject.GetStartTime()) / (float)animationObject.GetDuration();
        }
        return f;
    }

    void update(int n) {
        if (this.m_isPausedGame || Game.m_app.m_continueScreenIsActive) {
            return;
        }
        PortingUtils.beginProf("update steps");
        if (this.m_pauseResume) {
            this.m_pauseResume = false;
        }
        if (m_keysIgnore) {
            this.updateBlockedKeys();
        }
        if (this.lnkWorld.getGameState() == 19 && this.scores[0].lastClosedFrame == this.lastFrame && System.currentTimeMillis() - this.resultsShowDelay >= 5000L) {
            this.onKeyPressed(-20);
        }
        if (this.realAppTime != 0 && (this.lnkWorld.getGameState() == 8 || this.lnkWorld.getGameState() == 9 || this.lnkWorld.getGameState() == 10 || this.lnkWorld.getGameState() == 11 || this.lnkWorld.getGameState() == 13) && n - this.realAppTime < 100) {
            try {
                Thread.sleep(100 - (n - this.realAppTime));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n2 = 0;
        if (this.realAppTime != 0) {
            n2 = (int)((float)(n - this.realAppTime) * OptimizationUtils.timeCoef);
            if (n2 > 200) {
                n2 = 200;
            }
            Game.setApplicationTime(Game.getApplicationTime() + n2);
        }
        this.realAppTime = n;
        int n3 = Game.getApplicationTime();
        switch (this.lnkWorld.getGameState()) {
            case 4: 
            case 5: 
            case 6: {
                this.lnkWorld.moveArrows();
                break;
            }
            case 10: {
                this.lnkWorld.powerMeterObj.setValue(n3);
                break;
            }
            case 25: {
                float f = 0.04f * (float)n2;
                if ((this.keyMask & 1) > 0 && n3 - this.spinPressKeyTime > 300) {
                    this.lnkWorld.spinMeterObj.incDX(f);
                }
                if ((this.keyMask & 2) > 0 && n3 - this.spinPressKeyTime > 300) {
                    this.lnkWorld.spinMeterObj.incDX(-f);
                }
                if (this.lnkPhysics.holes == null) break;
                float f2 = 0.09f * (this.lnkWorld.spinMeterObj.getDX() - 50.0f) / 100.0f;
                this.rot -= f2;
                this.lnkPhysics.holes.setOrientation(360.0f * this.rot, Consts.HOLES_ROTATION_AXIS[0], Consts.HOLES_ROTATION_AXIS[1], Consts.HOLES_ROTATION_AXIS[2]);
            }
        }
        if (!this.lnkWorld.isLoading()) {
            this.m_keyIdleTime += n - this.m_keyLastPressedTime;
            if (this.lnkWorld.getGameState() == 16 || this.lnkWorld.getGameState() == 17) {
                this.getGameWorld().sparksRGroup.setRenderingEnable(this.lnkPhysics.getSpin() > 0.0f);
                this.getGameWorld().sparksLGroup.setRenderingEnable(this.lnkPhysics.getSpin() < 0.0f);
            } else if (this.lnkWorld.getGameState() == 19) {
                if ((this.keyMask & 1) > 0) {
                    this.lnkWorld.scrollFrameResults(-3 * UserApp.getHeight() / 100);
                }
                if ((this.keyMask & 2) > 0) {
                    this.lnkWorld.scrollFrameResults(3 * UserApp.getHeight() / 100);
                }
            }
        }
        PortingUtils.endProf();
        PortingUtils.beginProf("update state");
        this.lnkWorld.updateState();
        PortingUtils.endProf();
        if (!this.lnkWorld.isLoading()) {
            PortingUtils.beginProf("update physics");
            this.lnkPhysics.updateAll();
            this.lnkWorld.triangleObj.resetPins();
            PortingUtils.endProf();
            PortingUtils.beginProf("update anim");
            this.lnkAnimator.update(n2);
            PortingUtils.endProf();
            PortingUtils.beginProf("move cam");
            this.lnkWorld.moveCamera(n3);
            PortingUtils.endProf();
            this.lnkWorld.updateMeters();
            PortingUtils.beginProf("align objects");
            this.lnkWorld.alignObjects();
            PortingUtils.endProf();
        }
    }

    public void playMatch(int n, int n2, boolean bl, int n3, int n4, int n5) {
        this.gameMode = n4;
        if (MenuBaseSinglePlate.demoEnabled) {
            UserApp.gamesPlayed = (byte)(UserApp.gamesPlayed + 1);
            m_app.saveDemoCounter(UserApp.gamesPlayed);
        }
        if (n4 == 4 && bl) {
            n2 = this.lnkWorld.getTournamentLaneId(n);
            n3 = this.lnkWorld.getOpponentId(n);
        }
        this.lnkWorld.playerBowlerId = n;
        this.currentParams = n4 == 3 ? this.iniParams.duckPinsParams : this.iniParams.normalParams;
        if (n4 == 1) {
            this.lnkWorld.playerBowlerId = n3;
            this.currentPlayer = n;
        } else {
            this.currentPlayer = n;
        }
        this.playersNum = bl ? 2 : 1;
        this.numOfFrames = n5;
        if (n4 == 1) {
            this.lnkWorld.createLane(this.currentPlayer, n2);
        } else {
            this.lnkWorld.createLane(this.lnkWorld.playerBowlerId, n2);
        }
    }

    void ResetMatch() {
        this.lnkWorld.sunWorld = null;
        this.lnkAnimator.stopAllAnim(false);
        this.playerWon = false;
        this.lastFrame = this.numOfFrames - 1;
        this.resetKeys();
        this.currentPlayer = 0;
        this.lnkPhysics.resetRemovedPins();
        this.lnkPhysics.resetPins(true);
        if (this.gameMode == 4 && this.playersNum > 1) {
            this.lnkWorld.setGameState(23);
        } else {
            this.lnkWorld.setGameState(1);
        }
        if (this.gameMode == 5) {
            ++this.precisionSequence;
            if (this.precisionSequence == 5) {
                this.precisionSequence = 0;
            }
            this.precisionTarget = this.lnkPhysics.getRandomTarget();
        }
        this.firstThrow = true;
        for (int i = 0; i < this.playersNum; ++i) {
            this.scores[i].currentThrow = 0;
            this.scores[i].currentFrame = 0;
            this.scores[i].lastClosedFrame = -1;
            this.scores[i].playerFrames[0] = 0;
            this.scores[i].strikesInARow = 0;
            this.scores[i].bonusScore = 0;
            this.scores[i].updated = false;
        }
        this.resetApplicationTime();
        this.m_keyIdleTime = 0;
        this.m_keyLastPressedTime = this.realAppTime;
        m_app.regularRunStr(-1);
    }

    public void resetKeys() {
        this.keyMask = 0;
    }

    public int getKeyMask() {
        return this.keyMask;
    }

    public static void setApplicationTime(int n) {
        applicationTime = n;
    }

    public static void pickUpdateTime() {
        updateTime = applicationTime;
    }

    public static int getApplicationTime() {
        if (updateTime == -1) {
            updateTime = applicationTime;
        }
        return updateTime;
    }

    public void resetApplicationTime() {
        this.realAppTime = 0;
    }

    public int getPlayersNum() {
        return this.playersNum;
    }

    private int currentTimeMillis() {
        return (int)System.currentTimeMillis();
    }

    public void updateScore() {
        this.scores[this.currentPlayer].updated = true;
        this.scores[this.currentPlayer].playerFaults[this.scores[this.currentPlayer].currentThrow] = false;
        if (this.gameMode == 5) {
            int n = this.lnkPhysics.getFirstPin();
            ++this.scores[this.currentPlayer].currentFrame;
            this.scores[this.currentPlayer].playerFrames[this.scores[this.currentPlayer].currentFrame] = this.scores[this.currentPlayer].currentThrow + 1;
            int n2 = this.scores[this.currentPlayer].playerScore[++this.scores[this.currentPlayer].lastClosedFrame] = this.scores[this.currentPlayer].lastClosedFrame - 1 >= 0 ? this.scores[this.currentPlayer].playerScore[this.scores[this.currentPlayer].lastClosedFrame - 1] : 0;
            if (n == this.precisionTarget && this.throwResult != -1) {
                int n3 = this.lnkPhysics.getRemovedNum() - 1;
                int n4 = this.scores[this.currentPlayer].lastClosedFrame;
                this.scores[this.currentPlayer].playerScore[n4] = this.scores[this.currentPlayer].playerScore[n4] + (10 - this.throwResult - n3);
                if (this.throwResult == 0) {
                    int n5 = this.scores[this.currentPlayer].lastClosedFrame;
                    this.scores[this.currentPlayer].playerScore[n5] = this.scores[this.currentPlayer].playerScore[n5] + 10;
                }
                this.scores[this.currentPlayer].playerThrows[this.scores[this.currentPlayer].lastClosedFrame] = 10;
                this.lnkPhysics.removePin(n);
            } else {
                this.scores[this.currentPlayer].playerThrows[this.scores[this.currentPlayer].lastClosedFrame] = 0;
            }
            this.firstThrow = true;
            this.throwResult = -1;
        } else {
            int n = 0;
            if (this.gameMode == 3) {
                n = 1;
            }
            if (this.throwResult == -1) {
                this.scores[this.currentPlayer].playerThrows[this.scores[this.currentPlayer].currentThrow] = 0;
                this.scores[this.currentPlayer].playerFaults[this.scores[this.currentPlayer].currentThrow] = true;
                this.throwResult = this.scores[this.currentPlayer].playerFrames[this.scores[this.currentPlayer].currentFrame] == this.scores[this.currentPlayer].currentThrow - 1 ? 10 - this.scores[this.currentPlayer].playerThrows[this.scores[this.currentPlayer].currentThrow - 1] : (this.scores[this.currentPlayer].playerFrames[this.scores[this.currentPlayer].currentFrame] == this.scores[this.currentPlayer].currentThrow - 2 ? 10 - this.scores[this.currentPlayer].playerThrows[this.scores[this.currentPlayer].currentThrow - 1] - this.scores[this.currentPlayer].playerThrows[this.scores[this.currentPlayer].currentThrow - 2] : 10);
            } else {
                this.scores[this.currentPlayer].playerThrows[this.scores[this.currentPlayer].currentThrow] = 10 - this.throwResult;
                if (this.scores[this.currentPlayer].playerFrames[this.scores[this.currentPlayer].currentFrame] < this.scores[this.currentPlayer].currentThrow - 1) {
                    int n6 = this.scores[this.currentPlayer].currentThrow;
                    this.scores[this.currentPlayer].playerThrows[n6] = this.scores[this.currentPlayer].playerThrows[n6] - this.scores[this.currentPlayer].playerThrows[this.scores[this.currentPlayer].currentThrow - 2];
                }
                if (this.scores[this.currentPlayer].playerFrames[this.scores[this.currentPlayer].currentFrame] < this.scores[this.currentPlayer].currentThrow) {
                    int n7 = this.scores[this.currentPlayer].currentThrow;
                    this.scores[this.currentPlayer].playerThrows[n7] = this.scores[this.currentPlayer].playerThrows[n7] - this.scores[this.currentPlayer].playerThrows[this.scores[this.currentPlayer].currentThrow - 1];
                }
                this.scores[this.currentPlayer].strikesInARow = this.scores[this.currentPlayer].playerThrows[this.scores[this.currentPlayer].currentThrow] != 10 ? 0 : ++this.scores[this.currentPlayer].strikesInARow;
            }
            if (this.throwResult == 0 || this.scores[this.currentPlayer].playerFrames[this.scores[this.currentPlayer].currentFrame] + n < this.scores[this.currentPlayer].currentThrow || this.scores[this.currentPlayer].currentThrow - this.scores[this.currentPlayer].playerFrames[this.lastFrame] == 2 && this.scores[this.currentPlayer].currentFrame > this.lastFrame) {
                this.throwResult = -1;
                ++this.scores[this.currentPlayer].currentFrame;
                this.scores[this.currentPlayer].playerFrames[this.scores[this.currentPlayer].currentFrame] = this.scores[this.currentPlayer].currentThrow + 1;
            } else {
                this.firstThrow = false;
            }
            int n8 = this.scores[this.currentPlayer].playerFrames[this.scores[this.currentPlayer].lastClosedFrame + 1];
            while (this.scores[this.currentPlayer].playerThrows[n8] == 10) {
                if (n8 + 2 <= this.scores[this.currentPlayer].currentThrow) {
                    this.scores[this.currentPlayer].playerScore[++this.scores[this.currentPlayer].lastClosedFrame] = (this.scores[this.currentPlayer].lastClosedFrame - 1 >= 0 ? this.scores[this.currentPlayer].playerScore[this.scores[this.currentPlayer].lastClosedFrame - 1] : 0) + 10 + this.scores[this.currentPlayer].playerThrows[n8 + 1] + this.scores[this.currentPlayer].playerThrows[n8 + 2];
                    n8 = this.scores[this.currentPlayer].playerFrames[this.scores[this.currentPlayer].lastClosedFrame + 1];
                    continue;
                }
                return;
            }
            if (this.scores[this.currentPlayer].playerThrows[n8] + this.scores[this.currentPlayer].playerThrows[n8 + 1] == 10) {
                if (n8 + 2 <= this.scores[this.currentPlayer].currentThrow) {
                    this.scores[this.currentPlayer].playerScore[++this.scores[this.currentPlayer].lastClosedFrame] = (this.scores[this.currentPlayer].lastClosedFrame - 1 >= 0 ? this.scores[this.currentPlayer].playerScore[this.scores[this.currentPlayer].lastClosedFrame - 1] : 0) + 10 + this.scores[this.currentPlayer].playerThrows[n8 + 2];
                } else {
                    return;
                }
            }
            if ((n8 = this.scores[this.currentPlayer].playerFrames[this.scores[this.currentPlayer].lastClosedFrame + 1]) + 1 + n <= this.scores[this.currentPlayer].currentThrow) {
                this.scores[this.currentPlayer].playerScore[++this.scores[this.currentPlayer].lastClosedFrame] = (this.scores[this.currentPlayer].lastClosedFrame - 1 >= 0 ? this.scores[this.currentPlayer].playerScore[this.scores[this.currentPlayer].lastClosedFrame - 1] : 0) + this.scores[this.currentPlayer].playerThrows[n8] + this.scores[this.currentPlayer].playerThrows[n8 + 1];
                if (this.gameMode == 3) {
                    int n9 = this.scores[this.currentPlayer].lastClosedFrame;
                    this.scores[this.currentPlayer].playerScore[n9] = this.scores[this.currentPlayer].playerScore[n9] + this.scores[this.currentPlayer].playerThrows[n8 + 2];
                }
            }
        }
    }

    void finishGame() {
        try {
            if (Game.m_app.records[this.lnkWorld.playerBowlerId].localScore > Game.m_app.records[this.lnkWorld.playerBowlerId].localTournRecord) {
                Game.m_app.records[this.lnkWorld.playerBowlerId].localTournRecord = Game.m_app.records[this.lnkWorld.playerBowlerId].localScore;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getUnlocks()) {
            try {
                this.initUnlocks();
                this.lnkWorld.expoInObj.setVisible(true);
                this.lnkWorld.expoInObj.setEmotion(-1);
                this.lnkWorld.expoInObj.setText(this.unlocksText);
            }
            catch (Exception exception) {}
        } else {
            this.lnkWorld.deInit();
            this.unlocksText = null;
            if (this.gameMode == 5 && this.lnkPhysics.getRemovedNum() < 10) {
                Game.m_app.m_menuIsActive = true;
                Game.m_app.mainMenu.onStart();
                Game.m_app.mainMenu.setState(142, true);
            } else if (MenuBaseSinglePlate.demoEnabled) {
                MenuBaseSinglePlate.allFramesPlayed = true;
                MenuBaseSinglePlate.whichDemoScreen = (byte)3;
                Game.m_app.m_menuIsActive = true;
                Game.m_app.mainMenu.onStart();
                Game.m_app.mainMenu.setState(142, true);
            } else {
                Game.m_app.m_gameResMenuIsActive = true;
                Game.m_app.gameResMenu.onStart();
            }
        }
        m_app.savePrefs();
    }

    void initUnlocks() {
        if (this.unlockingLane != -1) {
            String[] stringArray = new String[]{StringTable.get(79 + this.unlockingLane)};
            String string = StringTable.get(109);
            this.unlocksText = StringTable.get(string, stringArray);
            this.unlockingLane = -1;
        } else if (this.unlockingPlayer != -1) {
            String[] stringArray = new String[]{StringTable.get(57 + this.unlockingPlayer)};
            String string = StringTable.get(108);
            this.unlocksText = StringTable.get(string, stringArray);
            this.unlockingPlayer = -1;
        } else if (this.unlockingGift) {
            this.unlocksText = StringTable.get(110);
            this.unlockingGift = false;
        } else if (this.unlockingStatPoint != -1) {
            String[] stringArray = new String[]{this.unlockingStatPoint == 0 ? StringTable.get(70) : StringTable.get(69)};
            String string = StringTable.get(112);
            this.unlocksText = StringTable.get(string, stringArray);
            this.unlockingStatPoint = -1;
        } else if (this.unlockingGoldenBall) {
            this.unlocksText = StringTable.get(113);
            this.unlockingGoldenBall = false;
        } else if (this.finishedTurnaments) {
            this.unlocksText = StringTable.get(111);
            this.finishedTurnaments = false;
        } else {
            this.unlocksText = StringTable.get(161);
        }
    }

    private boolean viewUnlocks() {
        return this.unlockingGift || this.unlockingLane != -1 || this.unlockingPlayer != -1 || this.unlockingGoldenBall || this.finishedTurnaments;
    }

    private boolean getUnlocks() {
        this.unlockingLane = -1;
        this.unlockingPlayer = -1;
        this.unlockingStatPoint = -1;
        if (this.gameMode == 4 && this.playersNum > 1) {
            if (this.scores[0].playerScore[this.scores[0].lastClosedFrame] > this.scores[1].playerScore[this.scores[1].lastClosedFrame]) {
                int n = this.lnkWorld.getPlayerId();
                switch (Game.m_app.records[this.lnkWorld.playerBowlerId].nextMatch) {
                    case 1: {
                        this.unlockingLane = GameWorld.PLAYERS[n][2];
                        break;
                    }
                    case 4: {
                        this.unlockingLane = GameWorld.PLAYERS[n][1];
                        break;
                    }
                    case 6: {
                        this.unlockingLane = 4;
                        break;
                    }
                    case 7: {
                        this.unlockingLane = GameWorld.PLAYERS[n][3];
                        break;
                    }
                    case 8: {
                        this.unlockingLane = GameWorld.PLAYERS[n][0];
                        break;
                    }
                    case 10: {
                        this.unlockingLane = 5;
                    }
                }
                if (this.unlockingLane != -1) {
                    if (Game.m_app.settings.unlockedLanes[this.unlockingLane]) {
                        this.unlockingLane = -1;
                    } else {
                        Game.m_app.settings.unlockedLanes[this.unlockingLane] = true;
                    }
                }
                if (Game.m_app.records[this.lnkWorld.playerBowlerId].nextMatch == 5) {
                    this.unlockingPlayer = 3;
                }
                if (this.unlockingPlayer != -1) {
                    if (Game.m_app.records[this.unlockingPlayer].unlocked) {
                        this.unlockingPlayer = -1;
                    } else {
                        Game.m_app.records[this.unlockingPlayer].unlocked = true;
                    }
                }
                this.unlockingGift = false;
                this.unlockingGoldenBall = false;
            }
            this.finishedTurnaments = Game.m_app.records[this.lnkWorld.playerBowlerId].nextMatch == 12;
            return this.viewUnlocks();
        }
        if (this.gameMode == 5 || this.gameMode == 3) {
            if (this.gameMode == 5 && this.lnkPhysics.getRemovedNum() != 10) {
                return false;
            }
            int n = this.gameMode == 5 ? 1 : 0;
            int n2 = this.scores[0].playerScore[this.scores[0].lastClosedFrame];
            int n3 = 0;
            int n4 = this.lnkWorld.getPlayerId();
            n3 = this.gameMode == 5 ? (Game.m_app.records[n4].power < 4 ? 0 : 1) : (Game.m_app.records[n4].control < 4 ? 1 : 0);
            for (int i = 0; i < 3; ++i) {
                if (n2 < this.scoresForUnlocks[n][i] || Game.m_app.records[n4].unlockedStats[n][i]) continue;
                Game.m_app.records[n4].unlockedStats[n][i] = true;
                this.unlockingStatPoint = n3;
                if (n3 == 0) {
                    if (Game.m_app.records[n4].power >= 4) break;
                    Game.m_app.records[n4].power = (byte)(Game.m_app.records[n4].power + 1);
                    break;
                }
                if (Game.m_app.records[n4].control >= 4) break;
                Game.m_app.records[n4].control = (byte)(Game.m_app.records[n4].control + 1);
                break;
            }
            return this.unlockingStatPoint != -1;
        }
        return false;
    }

    class ScoreParams {
        boolean[] playerFaults = new boolean[30];
        int[] playerThrows = new int[30];
        int[] playerScore = new int[30];
        int[] playerFrames = new int[13];
        int bonusScore;
        int currentThrow;
        int currentFrame;
        int lastClosedFrame;
        int strikesInARow;
        boolean updated = false;

        ScoreParams() {
        }

        public void copyFrom(ScoreParams scoreParams) {
            int n;
            for (n = 0; n < 30; ++n) {
                this.playerFaults[n] = scoreParams.playerFaults[n];
                this.playerThrows[n] = scoreParams.playerThrows[n];
                this.playerScore[n] = scoreParams.playerScore[n];
            }
            for (n = 0; n < 13; ++n) {
                this.playerFrames[n] = scoreParams.playerFrames[n];
            }
            this.bonusScore = scoreParams.bonusScore;
            this.currentThrow = scoreParams.currentThrow;
            this.currentFrame = scoreParams.currentFrame;
            this.lastClosedFrame = scoreParams.lastClosedFrame;
            this.strikesInARow = scoreParams.strikesInARow;
        }
    }

    class INIParams {
        float minBallSpeed;
        float maxBallSpeed;
        float spinStep;
        float maxSpin;
        float posStep;
        GameParams normalParams;
        GameParams duckPinsParams;

        INIParams() {
            this.normalParams = new GameParams();
            this.duckPinsParams = new GameParams();
        }
    }

    class GameParams {
        int ballRadius;
        int pinRadius;
        int pinHeadRadius;
        int pinHeight;
        float ballRadiusFloat;
        float pinRadiusFloat;
        float pinHeightFloat;
        int pinWeight;
        int ballWeight;

        GameParams() {
        }
    }
}

