/*
 * Decompiled with CFR 0.152.
 */
package userapp;

import java.util.Vector;
import portinglib.Graphics2D;
import portinglib.StringTable;
import userapp.Device;
import userapp.FlatObject;
import userapp.Game;
import userapp.UserApp;

class ExpoInObject
extends FlatObject {
    public static boolean isGameHelp = false;
    private String[] textBoxLines = null;
    private boolean showContext = false;
    private boolean oldVisibility = false;
    private String oldText;
    private int oldEmotion;
    protected String m_pText;
    AEERect m_rc = new AEERect();
    protected int m_selectionLeft;
    protected int m_selectionRight;
    protected int m_topLineY;
    protected int m_bottomLineY;
    protected boolean m_hasScrolling;
    protected int m_curLine;
    protected int m_linesAmount;
    protected int m_drawingLines;
    protected Vector m_lines = new Vector();
    protected Vector m_lengths = new Vector();
    protected static final int BLINK_TIME = 300;

    public ExpoInObject(Game game) {
        super(game);
        int n = Graphics2D.getFontHeight(2);
        this.m_topLineY = Graphics2D.getHeight(17);
        this.m_bottomLineY = UserApp.getHeight() - this.m_topLineY + n * 2;
        this.m_rc.x = n;
        this.m_rc.dx = UserApp.getWidth() - n * 2;
        this.m_rc.y = this.m_topLineY + Graphics2D.getHeight(31) + n;
        this.m_rc.dy = this.m_bottomLineY - this.m_topLineY - n * 2;
        FlatObject.TFlatElement tFlatElement = new FlatObject.TFlatElement(this);
        tFlatElement.isVisible = true;
        tFlatElement.imageId = 17;
        tFlatElement.xPos = UserApp.getWidth() - Graphics2D.getWidth(17);
        tFlatElement.yPos = 0;
        this.elements.addElement(tFlatElement.duplicate());
        tFlatElement.xPos = UserApp.getWidth() - Graphics2D.getWidth(17) + 6;
        tFlatElement.yPos = 3;
        tFlatElement.imageId = 19;
        this.elements.addElement(tFlatElement.duplicate());
        this.m_hasScrolling = true;
        this.setVisible(false);
    }

    public void setEmotion(int n) {
        int n2 = Graphics2D.getFontHeight(2);
        if (n != -1) {
            super.getElement((int)1).imageId = n;
            super.getElement((int)0).xPos = UserApp.getWidth() - Graphics2D.getWidth(17);
            super.getElement((int)1).xPos = UserApp.getWidth() - Graphics2D.getWidth(17) + 6;
            this.m_topLineY = Graphics2D.getHeight(17);
            this.m_bottomLineY = UserApp.getHeight() - this.m_topLineY + n2 * 2;
        } else if (this.showContext) {
            super.getElement((int)1).imageId = -1;
            this.m_topLineY = UserApp.getHeight() * 5 / 100;
            this.m_bottomLineY = UserApp.getHeight() * 95 / 100;
        } else {
            super.getElement((int)1).imageId = -1;
            int n3 = UserApp.getHeight() - Device.SCREEN_MENU_PLATE_HEIGHT - Graphics2D.getHeight(40);
            this.m_topLineY = n3 * 5 / 100;
            this.m_bottomLineY = n3 * 85 / 100;
        }
        super.getElement((int)1).isVisible = n != -1;
        super.getElement((int)0).isVisible = n != -1;
    }

    public void setTopLineY(int n) {
        this.m_topLineY = n;
    }

    public void setText(String string) {
        this.m_pText = string;
        this.recalculate();
    }

    public void setText(int n) {
        this.m_pText = n == -1 ? null : StringTable.get(n);
        this.recalculate();
    }

    public static String formatTextWithButtons(int n) {
        int[] nArray = new int[]{321, 322, 323, 324, 325, 326, 327, 328, 330};
        String[] stringArray = new String[9];
        for (int i = 0; i < 9; ++i) {
            stringArray[i] = StringTable.get(nArray[i]);
        }
        if (n == 159) {
            // empty if block
        }
        return StringTable.get(StringTable.get(n), stringArray);
    }

    public static String formatTextWithButtons(int n, int n2) {
        int[] nArray = new int[]{321, 322, 323, 324, 325, 326, 327, 328, 330};
        String[] stringArray = new String[9];
        for (int i = 0; i < 9; ++i) {
            stringArray[i] = StringTable.get(nArray[i]);
        }
        if (n == 159 && n2 == 3) {
            return StringTable.get("Hier dreht sich alles um Pr\u00e4zision!|Triff das blinkende Ziel, um Punkte zu erhalten! Du hast 10 Versuche, um den Zielkegel zu treffen. Bewege dich links oder rechts mit der Navi-Taste oder %2 und %4, w\u00e4hle die Richtung mit %3. Mit der Navi-Taste oder %2 und %4 gibst du der Kugel Drall. Dr\u00fccke %3, wenn du zufrieden bist. Nochmaliges %3-Dr\u00fccken wirft dir Bowlingkugel. Um die Kraft festzulegen, dr\u00fccke %3 bevor die Kugel den oberen Kreis der Anzeige passiert. Zu sp\u00e4tes Dr\u00fccken gilt als Fehlwurf. Achtung, triffst du den Zielkegel nicht, erh\u00e4lst du 0 Punkte! Zus\u00e4tzliche Punkte erh\u00e4lst du, f\u00fcr jeden Kegel, der nach dem Zielkegel f\u00e4llt, und wenn alle Kegel fallen.", stringArray);
        }
        return StringTable.get(StringTable.get(n), stringArray);
    }

    private void setContextText() {
        String string;
        this.showContext = true;
        this.oldText = this.m_pText;
        this.oldVisibility = this.isVisible;
        this.oldEmotion = super.getElement((int)1).imageId;
        if (Game.m_app.isAnyMenuActive()) {
            string = ExpoInObject.formatTextWithButtons(154);
        } else {
            switch (this.game.gameMode) {
                case 3: {
                    string = ExpoInObject.formatTextWithButtons(158);
                    break;
                }
                case 4: {
                    if (this.game.playersNum == 1) {
                        string = ExpoInObject.formatTextWithButtons(155);
                        break;
                    }
                    string = ExpoInObject.formatTextWithButtons(160);
                    break;
                }
                case 5: {
                    string = ExpoInObject.formatTextWithButtons(159, Game.m_app.langMenu.langsel);
                    break;
                }
                case 1: {
                    string = StringTable.get(156);
                    break;
                }
                default: {
                    string = StringTable.get(161);
                }
            }
        }
        this.setSelection(0, 0);
        this.setVisible(true);
        this.setEmotion(-1);
        this.setText(string);
    }

    public static final int RGB2Int(int n, int n2, int n3) {
        return (n << 16) + (n2 << 8) + n3;
    }

    public static final void Int2ARGB(int n, int[] nArray) {
        nArray[0] = (0xFF000000 & n) >> 24;
        nArray[1] = (0xFF0000 & n) >> 16;
        nArray[2] = (0xFF00 & n) >> 8;
        nArray[3] = 0xFF & n;
    }

    public int[] postProcess(int[] nArray) {
        if (this.m_pText == null || !this.isVisible) {
            return nArray;
        }
        int[] nArray2 = new int[4];
        for (int i = UserApp.getWidth() * this.m_topLineY; i < UserApp.getWidth() * this.m_bottomLineY; ++i) {
            ExpoInObject.Int2ARGB(nArray[i], nArray2);
            nArray[i] = ExpoInObject.RGB2Int(nArray2[1] >> 2, nArray2[2] >> 2, nArray2[3] >> 2);
        }
        return nArray;
    }

    public void draw(Graphics2D graphics2D) {
        int n;
        if (this.m_pText == null || !this.isVisible) {
            return;
        }
        int n2 = graphics2D.getClipWidth();
        int n3 = graphics2D.getClipHeight();
        int n4 = graphics2D.getClipX();
        int n5 = graphics2D.getClipY();
        if (Game.m_app.useStrips) {
            graphics2D.setFillColor(0x444444);
            graphics2D.setFillMode(1);
            graphics2D.drawRect(0, this.m_topLineY, UserApp.getWidth(), this.m_bottomLineY - this.m_topLineY);
        }
        if (this.m_selectionRight > this.m_selectionLeft && (int)(System.currentTimeMillis() / 300L) % 2 == 0) {
            graphics2D.setFillColor(0xFF0000);
            graphics2D.setFillMode(1);
            graphics2D.drawRect(this.m_selectionLeft, this.m_topLineY, this.m_selectionRight - this.m_selectionLeft, this.m_bottomLineY - this.m_topLineY);
        }
        graphics2D.setFont(2);
        int n6 = 2;
        if (this.m_drawingLines != this.m_linesAmount && this.m_hasScrolling) {
            if (UserApp.useSystemFont()) {
                graphics2D.setFont(1);
            }
            if (this.m_curLine > 0) {
                graphics2D.drawString("^", UserApp.getWidth() >> 1, this.m_topLineY + Graphics2D.getHeight(31), 17);
            }
            if (this.m_curLine + this.m_drawingLines < this.m_linesAmount) {
                graphics2D.drawString("_", UserApp.getWidth() >> 1, this.m_bottomLineY - Graphics2D.getFontHeight(2), 17);
            }
            if (UserApp.useSystemFont()) {
                graphics2D.setFont(2);
            }
        }
        int n7 = Graphics2D.getWidth(31);
        int n8 = UserApp.getWidth() / Graphics2D.getWidth(31) + (UserApp.getWidth() % Graphics2D.getWidth(31) != 0 ? 1 : 0);
        for (n = 0; n < n8; ++n) {
            graphics2D.drawImage(31, n * n7, this.m_topLineY, 20);
            graphics2D.drawImage(31, n * n7, this.m_bottomLineY, 20);
        }
        graphics2D.setClip(this.m_rc.x, this.m_rc.y, this.m_rc.dx, this.m_rc.dy);
        for (n = 0; n < this.m_drawingLines; ++n) {
            int n9 = 0;
            n9 = this.m_selectionRight > this.m_selectionLeft ? (this.m_rc.dx - Graphics2D.charsWidth(n6, this.m_pText.toCharArray(), (Integer)this.m_lines.elementAt(this.m_curLine + n), (Integer)this.m_lengths.elementAt(this.m_curLine + n))) / 2 : this.m_rc.x;
            int n10 = this.m_rc.y + n * (Graphics2D.getFontHeight(n6) + 2);
            graphics2D.drawString(this.textBoxLines[this.m_curLine + n], n9, n10, 20);
        }
        graphics2D.setClip(n4, n5, n2, n3);
        super.draw(graphics2D);
    }

    public boolean onKeyPressed(int n) {
        if (UserApp.m_LangSelIsActive || UserApp.m_SoundPoundOffScreen || UserApp.m_splashIsActive) {
            return false;
        }
        if (!(this.m_pText != null && this.isVisible || n == 42)) {
            return false;
        }
        if (isGameHelp && n != 42 && n != 50 && n != 56 && n != -1 && n != -6) {
            return true;
        }
        switch (n) {
            case -1: 
            case 50: {
                if (this.m_curLine <= 0) break;
                --this.m_curLine;
                return true;
            }
            case -6: 
            case 56: {
                if (this.m_drawingLines == this.m_linesAmount || this.m_curLine >= this.m_linesAmount - this.m_drawingLines) break;
                ++this.m_curLine;
                return true;
            }
            case 42: {
                if (!this.showContext) {
                    this.setContextText();
                    isGameHelp = !isGameHelp;
                    UserApp.gameFreeze = true;
                    return true;
                }
                isGameHelp = !isGameHelp;
                this.showContext = false;
                this.setEmotion(this.oldEmotion);
                this.setText(this.oldText);
                this.setVisible(this.oldVisibility);
                UserApp.gameFreeze = false;
                return true;
            }
        }
        return this.showContext;
    }

    protected void recalculate() {
        int n;
        int n2;
        int n3;
        if (this.m_pText == null) {
            return;
        }
        this.m_lines.setSize(0);
        this.m_lengths.setSize(0);
        this.m_lines.ensureCapacity(100);
        this.m_lengths.ensureCapacity(100);
        this.m_curLine = 0;
        this.m_linesAmount = 0;
        this.m_drawingLines = 0;
        this.m_lines.addElement(new Integer(0));
        ++this.m_linesAmount;
        this.m_lengths.addElement(new Integer(0));
        int n4 = 2;
        this.m_rc.x = n3 = Graphics2D.getFontHeight(2);
        this.m_rc.dx = UserApp.getWidth() - n3 * 2;
        this.m_rc.y = this.m_topLineY + Graphics2D.getHeight(31) + n3 / 2;
        this.m_rc.dy = this.m_bottomLineY - this.m_topLineY - n3 * 3 / 2;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = this.m_pText.length(); i > 0; i -= n2 - n5 + 1) {
            n = 0;
            n2 = n5 - 1;
            while (n <= this.m_rc.dx) {
                ++n2;
                while (n2 < this.m_pText.length() && this.m_pText.charAt(n2) != ' ' && this.m_pText.charAt(n2) != '|') {
                    ++n2;
                }
                n = this.m_pText.length() > 0 ? (n2 < this.m_pText.length() ? Graphics2D.charsWidth(n4, this.m_pText.toCharArray(), n5, n2 - n5) : Graphics2D.charsWidth(n4, this.m_pText.toCharArray(), n5, this.m_pText.length() - n5)) : 0;
                if (n2 < this.m_pText.length() && this.m_pText.charAt(n2) != '|') continue;
            }
            if (n2 < this.m_pText.length() && this.m_pText.charAt(n2) != '|' || n > this.m_rc.dx) {
                --n2;
                while (this.m_pText.charAt(n2) != ' ' && n2 != n5) {
                    if (Graphics2D.charsWidth(n4, this.m_pText.toCharArray(), n5, n2 - n5) < this.m_rc.dx && !bl) {
                        n6 = n2;
                        bl = true;
                    }
                    --n2;
                }
                if (n2 == n5) {
                    n2 = n6;
                    bl2 = true;
                }
            }
            if (this.m_linesAmount + 1 > this.m_lines.size()) {
                this.m_lines.setSize(this.m_linesAmount + 1);
            }
            if (this.m_linesAmount + 1 > this.m_lengths.size()) {
                this.m_lengths.setSize(this.m_linesAmount + 1);
            }
            if (!bl2) {
                this.m_lines.setElementAt(new Integer((Integer)this.m_lines.elementAt(this.m_linesAmount - 1) + n2 - n5 + 1), this.m_linesAmount);
            } else {
                this.m_lines.setElementAt(new Integer((Integer)this.m_lines.elementAt(this.m_linesAmount - 1) + n2 - n5), this.m_linesAmount);
            }
            this.m_lengths.setElementAt(new Integer(n2 - n5), this.m_linesAmount - 1);
            ++this.m_linesAmount;
            n5 = !bl2 ? n2 + 1 : n2;
            bl = false;
            bl2 = false;
        }
        --this.m_linesAmount;
        this.m_drawingLines = this.m_rc.dy / (Graphics2D.getFontHeight(n4) + 2);
        if (this.m_drawingLines >= this.m_linesAmount) {
            this.m_hasScrolling = false;
            this.m_drawingLines = this.m_linesAmount;
            this.m_bottomLineY = this.m_topLineY + n3 + (Graphics2D.getFontHeight(2) + 2) * this.m_linesAmount;
        } else {
            this.m_hasScrolling = true;
        }
        if (this.m_hasScrolling) {
            this.m_rc.y += Graphics2D.getFontHeight(2) / 2;
            this.m_rc.dy -= Graphics2D.getFontHeight(2) / 2;
            this.m_drawingLines = this.m_rc.dy / (Graphics2D.getFontHeight(n4) + 2);
        }
        this.textBoxLines = new String[this.m_linesAmount];
        for (n = 0; n < this.m_linesAmount; ++n) {
            n2 = (Integer)this.m_lines.elementAt(n);
            int n7 = (Integer)this.m_lengths.elementAt(n);
            this.textBoxLines[n] = n7 == 0 ? "" : this.m_pText.substring(n2, n2 + n7);
        }
    }

    public void setSelection(int n, int n2) {
        this.m_selectionLeft = n;
        this.m_selectionRight = n2;
    }

    public boolean contextActive() {
        return this.showContext;
    }

    public boolean isVisible() {
        return this.isVisible && this.m_pText != null;
    }

    class AEERect {
        int x;
        int dx;
        int y;
        int dy;

        AEERect() {
        }
    }
}

