/*
 * Decompiled with CFR 0.152.
 */
package portinglib;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import portinglib.Application;
import portinglib.Graphics2D;
import portinglib.ResourceManager;
import portinglib.SoundManager;
import portinglib.Surface;
import userapp.UserApp;

public final class Framework
extends MIDlet
implements Runnable {
    static final boolean DEBUG_MIDLET_LIFE_CYCLE = false;
    static Framework theMIDlet;
    static Display theDisplay;
    static Surface theSurface;
    private static boolean theSurfaceInitialized;
    public static long _tme;
    static Application theApp;
    private static boolean doIt;
    private static volatile boolean updatePending;
    private static boolean aboutToDie;
    private long appStartTime = -1L;
    private long pauseStartTime = 0L;
    private int appTime;
    private static final int STATE_CREATED = 0;
    private static final int STATE_PAUSED = 1;
    private static final int STATE_ACTIVE = 2;
    private static final int STATE_DESTROYED = 3;
    private static int state;
    private static final Object monitor;
    private static final int KEYPRESS_THRESHOLD = 100;
    private static final int WAIT_THRESHOLD = -1;
    static final int RESUME_MODE_SHOWNOTIFY_DISABLED = 0;
    static final int RESUME_MODE_SHOWNOTIFY_REQUESTS_STARTAPP = 1;
    static final int RESUME_MODE_SHOWNOTIFY_CALLS_STARTAPP = 2;
    static final int RESUME_MODE_HIDENOTIFY_DISABLED = 0;
    static final int RESUME_MODE_HIDENOTIFY_REQUESTS_PAUSEAPP = 4;
    static final int RESUME_MODE_HIDENOTIFY_CALLS_PAUSEAPP = 8;
    static final int RESUME_MODE_DEFAULT = 13;
    static int RESUME_MODE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void kick() {
        if (!updatePending && !aboutToDie) {
            updatePending = true;
            Object object = monitor;
            synchronized (object) {
                monitor.notify();
            }
        }
    }

    static void terminate() {
        Framework.prepareToDestroy();
        theMIDlet.notifyDestroyed();
    }

    public static Canvas getCanvas() {
        return theSurface;
    }

    public Framework() {
        theMIDlet = this;
        theDisplay = Display.getDisplay((MIDlet)this);
        theSurfaceInitialized = false;
        theSurface = new Surface();
        theSurface.initialize(this);
        state = 0;
        ResourceManager.startup(this);
        theApp = new UserApp();
    }

    void paint(Graphics2D graphics2D) {
        if (theSurfaceInitialized) {
            theApp.doPaint(graphics2D);
        }
    }

    protected final void startApp() throws MIDletStateChangeException {
        if (0 == state) {
            this.startApplication();
        } else if (1 == state) {
            state = 2;
            SoundManager.onResume();
            theApp.doOnResume();
            this.appStartTime += (long)((int)(System.currentTimeMillis() - this.pauseStartTime));
            this.pauseStartTime = 0L;
            updatePending = false;
            Framework.kick();
        }
    }

    private final void startApplication() {
        state = 2;
        this.appStartTime = System.currentTimeMillis();
        theDisplay.setCurrent((Displayable)theSurface);
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void prepareToPause(boolean bl) {
        Surface surface = theSurface;
        synchronized (surface) {
            if (2 == state) {
                updatePending = false;
                SoundManager.onPause(bl);
                theApp.doOnPause();
                this.pauseStartTime = System.currentTimeMillis();
                state = 1;
            }
        }
    }

    protected final void pauseApp() {
        this.prepareToPause(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void prepareToDestroy() {
        Surface surface = theSurface;
        synchronized (surface) {
            if (3 != state) {
                aboutToDie = true;
                doIt = false;
                theApp.onDestroy();
                SoundManager.onDestroy();
                state = 3;
            }
        }
    }

    protected final void destroyApp(boolean bl) throws MIDletStateChangeException {
        Framework.prepareToDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        theSurface.waitUntilInitialized();
        SoundManager.onStart();
        theApp.onStart();
        theSurfaceInitialized = true;
        _tme = System.currentTimeMillis();
        try {
            while (true) {
                if (Application.useBacklight) {
                    // empty if block
                }
                SoundManager.onUpdate();
                int n = 0L == this.pauseStartTime ? this.update(this.updateAppTime()) : Integer.MAX_VALUE;
                if (!doIt) break;
                if (!updatePending && n > -1) {
                    if (0 == n) {
                        n = 1;
                    } else if (Integer.MAX_VALUE == n) {
                        n = 0;
                    }
                    Object object = monitor;
                    synchronized (object) {
                        monitor.wait(n);
                    }
                }
                Thread.yield();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int update(int n) {
        int n2;
        int n3 = (int)System.currentTimeMillis();
        updatePending = false;
        Surface surface = theSurface;
        synchronized (surface) {
            n2 = theApp.doUpdate(n);
        }
        if (!aboutToDie) {
            theSurface.flush();
        }
        if (Integer.MAX_VALUE != n2) {
            if ((n2 -= (int)System.currentTimeMillis() - n3) < 0) {
                n2 = 0;
            }
            updatePending = n2 <= -1;
        }
        return n2;
    }

    int updateAppTime() {
        this.appTime = (int)(System.currentTimeMillis() - this.appStartTime);
        return this.appTime;
    }

    static void initializePlatformSettings(int n) {
        RESUME_MODE = n;
    }

    static {
        doIt = true;
        monitor = new Object();
        RESUME_MODE = 10;
    }
}

