/*
 * Decompiled with CFR 0.152.
 */
package portinglib;

import javax.microedition.io.ConnectionNotFoundException;
import portinglib.Framework;
import portinglib.Graphics2D;
import userapp.UserApp;

public abstract class Application {
    public static final int INFINITE = Integer.MAX_VALUE;
    private static final int ONINTERRUPT_FRAME_TIME = 100;
    private boolean paused = false;
    private boolean pausePainted = false;
    private boolean allowResume = false;
    static boolean useBacklight;

    protected void onStart() {
    }

    protected void onPause() {
    }

    void doOnPause() {
        if (UserApp.m_LangSelIsActive) {
            return;
        }
        if (this.paintContinueScreen(null)) {
            this.allowResume = false;
            this.paused = true;
        }
        this.pausePainted = false;
        this.onPause();
    }

    protected void onResume() {
    }

    private void processResume() {
        if (this.allowResume) {
            this.paused = false;
            this.onResume();
        }
    }

    void doOnResume() {
        if (UserApp.m_LangSelIsActive) {
            return;
        }
        if (this.paintContinueScreen(null)) {
            this.allowResume = true;
        } else {
            this.onResume();
        }
    }

    protected void onDestroy() {
    }

    protected int update(int n) {
        return Integer.MAX_VALUE;
    }

    private void queryQueue() {
    }

    int doUpdate(int n) {
        if (this.paused) {
            return 100;
        }
        this.queryQueue();
        return this.update(n);
    }

    void doPaint(Graphics2D graphics2D) {
        if (this.paused) {
            if (!this.pausePainted) {
                if (!this.paintContinueScreen(graphics2D)) {
                    this.paint(graphics2D);
                }
                this.pausePainted = true;
            }
        } else {
            this.paint(graphics2D);
        }
    }

    protected abstract void paint(Graphics2D var1);

    protected boolean paintContinueScreen(Graphics2D graphics2D) {
        return false;
    }

    protected boolean resumeOnKey(int n) {
        return true;
    }

    protected void onKeyPressed(int n) {
    }

    void doOnKeyPressed(int n) {
        if (!this.paintContinueScreen(null) || !this.paused) {
            this.onKeyPressed(n);
        }
    }

    protected void onKeyReleased(int n) {
    }

    void doOnKeyReleased(int n) {
        if (this.paintContinueScreen(null) && this.paused) {
            if (this.resumeOnKey(n)) {
                this.processResume();
            }
        } else {
            this.onKeyReleased(n);
        }
    }

    public static int getHeight() {
        return Framework.theSurface.getSurfaceHeight();
    }

    public static int getWidth() {
        return Framework.theSurface.getSurfaceWidth();
    }

    public static void forceUpdate() {
        Framework.kick();
    }

    public static void destroy() {
        Framework.terminate();
    }

    public static String getProperty(String string) {
        String string2 = null;
        try {
            string2 = Framework.theMIDlet.getAppProperty(string);
            if (string2 == null) {
                string2 = System.getProperty(string);
            }
        }
        catch (Exception exception) {
            string2 = null;
        }
        return string2;
    }

    public static final boolean platformRequest(String string) throws ConnectionNotFoundException {
        return Framework.theMIDlet.platformRequest(string);
    }

    public static final void keepBacklightOn(boolean bl) {
        useBacklight = bl;
    }

    public static final void vibrate(int n) {
        try {
            Framework.theDisplay.vibrate(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onLoadImage(byte[] byArray, int n, int n2, int n3, int n4) {
    }
}

