/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.rms.RecordStore;

class IoUtil {
    IoUtil() {
    }

    static int writeString(byte[] data, int s, String v) {
        for (int i = 0; i < v.length(); ++i) {
            data[s + i] = (byte)v.charAt(i);
        }
        return v.length();
    }

    static String readString(byte[] data, int s, int len) {
        return new String(data, s, len);
    }

    static long readRadix(char[] buf, int start, int len) {
        long tot = 0L;
        long rate = 1L;
        for (int index = 0; index < len; ++index) {
            tot += rate * (long)(buf[index + start] - 33);
            rate *= 95L;
        }
        return tot;
    }

    static int writeRadix(char[] buf, int start, long value, int len) {
        for (int index = 0; index < len; ++index) {
            buf[index + start] = (char)(value % 95L + 33L);
            value /= 95L;
        }
        return len;
    }

    static void saveToRMS(String name, byte[] data, int len) throws Exception {
        RecordStore rs = null;
        int result = -1;
        rs = RecordStore.openRecordStore((String)name, (boolean)true);
        if (rs.getNumRecords() > 0) {
            rs.closeRecordStore();
            RecordStore.deleteRecordStore((String)name);
            rs = RecordStore.openRecordStore((String)name, (boolean)true);
        }
        rs.addRecord(data, 0, len);
        rs.closeRecordStore();
    }

    static byte[] loadFromRMS(String name) throws Exception {
        byte[] data = null;
        RecordStore rs = RecordStore.openRecordStore((String)name, (boolean)false);
        int index = rs.getNextRecordID() - 1;
        data = rs.getRecord(index);
        rs.closeRecordStore();
        return data;
    }

    static long read64_le(byte[] data, int s) {
        return (long)data[s] & 0xFFL | ((long)data[s + 1] & 0xFFL) << 8 | ((long)data[s + 2] & 0xFFL) << 16 | ((long)data[s + 3] & 0xFFL) << 24 | ((long)data[s + 4] & 0xFFL) << 32 | ((long)data[s + 5] & 0xFFL) << 40 | ((long)data[s + 6] & 0xFFL) << 48 | ((long)data[s + 7] & 0xFFL) << 56;
    }

    static int write64_le(byte[] data, int s, long v) {
        data[s + 7] = (byte)(v >>> 56);
        data[s + 6] = (byte)(v >> 48);
        data[s + 5] = (byte)(v >> 40);
        data[s + 4] = (byte)(v >> 32);
        data[s + 3] = (byte)(v >> 24);
        data[s + 2] = (byte)(v >> 16);
        data[s + 1] = (byte)(v >> 8);
        data[s] = (byte)v;
        return 8;
    }

    static int read32_le(byte[] data, int s) {
        return data[s] & 0xFF | (data[s + 1] & 0xFF) << 8 | (data[s + 2] & 0xFF) << 16 | (data[s + 3] & 0xFF) << 24;
    }

    static int write32_le(byte[] data, int s, int v) {
        data[s + 3] = (byte)(v >>> 24);
        data[s + 2] = (byte)(v >> 16);
        data[s + 1] = (byte)(v >> 8);
        data[s] = (byte)v;
        return 4;
    }

    static int memcpy(char[] dest, int deststart, char[] src, int srcstart, int cnt) {
        cnt = Math.min(cnt, Math.min(dest.length - deststart, src.length - srcstart));
        System.arraycopy(src, srcstart, dest, deststart, cnt);
        return cnt;
    }

    static void memset(char[] mem, int memstart, char val, int cnt) {
        int until = memstart + Math.min(mem.length - memstart, cnt);
        for (int i = memstart; i < until; ++i) {
            mem[i] = val;
        }
    }
}

