/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class LanguageCanvas
extends Canvas
implements Runnable {
    private final int LOAD_LANGUAGE;
    private final int LOAD_MFORMA;
    public static final int EN = 0;
    public static final int FR = 1;
    public static final int IT = 2;
    public static final int DE = 3;
    public static final int ES = 4;
    public static int currentLanguage = 0;
    static final int mw = 24;
    static final int rw = 10;
    static final int step = 4;
    static final int gh = 22;
    static final long delay = 80L;
    private int w = 240;
    private int h = 320;
    private int hw = this.w >> 1;
    private int hh = this.h >> 1;
    private int rx;
    private int tx;
    private int gy;
    private int sh;
    Image bkg;
    Image bkg1;
    Image word;
    String msg;
    private static final Font font = Font.getFont((int)32, (int)0, (int)16);
    private int x = this.w;
    int currentState = 2;
    String[] _menuStrs;
    int _selected = 0;
    boolean _bFire = false;
    public static String[] txtFileNames = new String[]{"/English_utf.txt", "/French_utf.txt", "/Italian_utf.txt", "/German_utf.txt", "/Spanish_utf.txt"};
    boolean isLoading = false;
    Font menuFont = Font.getFont((int)64, (int)0, (int)16);
    static final String[] SELECT_EXIT = new String[]{"SELECT", "EXIT", "S\u00c9LECT.", "QUITTER", "SELEZIONA", "ESCI", "AUSW\u00c4HLEN", "BEENDEN", "SELEC.", "SALIR"};
    boolean isMenuPainted = false;
    boolean _bQuit = false;
    boolean isRunnig = true;

    LanguageCanvas() {
        this.LOAD_LANGUAGE = 1;
        this.LOAD_MFORMA = 2;
        try {
            this.bkg = Image.createImage((String)"/mf0.png");
            this.word = Image.createImage((String)"/mf1.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sh = this.word.getHeight() - 22;
        this.gy = this.hh - 11 - 10;
        this.tx = this.hw - (this.word.getWidth() >> 1);
        this.rx = this.tx + this.word.getWidth() - 10;
        this.setFullScreenMode(true);
        new Thread(this).start();
        this._menuStrs = this.LoadLanguageNames();
    }

    public void paint(Graphics g) {
        switch (this.currentState) {
            case 1: {
                this.drawMenu(g);
                break;
            }
            case 2: {
                this.drawMforma(g);
            }
        }
    }

    public void drawMforma(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 240, WPT.my_Heigth);
        g.drawImage(this.bkg, this.hw, this.hh, 3);
        this.msg = null;
        if (this.msg != null) {
            g.setColor(0xFFFFFF);
            g.setFont(font);
            g.drawString(this.msg, this.hw, this.h - (this.hh >> 2), 33);
            if (this.x == Integer.MIN_VALUE) {
                g.drawImage(this.bkg1, this.hw, 10, 3);
            }
        }
        g.setClip(0, this.gy, this.w, 22);
        if (this.x >= this.tx) {
            g.clipRect(this.x + 22, this.gy, this.rx - (this.x + 22), 22);
            g.drawImage(this.word, this.hw, this.gy, 17);
            g.setClip(0, this.gy, this.w, 22);
            g.clipRect(this.x, this.gy, 24, 22);
            g.drawImage(this.word, this.x, this.gy, 20);
        } else if (this.x == Integer.MIN_VALUE) {
            g.drawImage(this.word, this.hw, this.gy, 17);
        } else if (this.tx - this.x < this.hw) {
            g.drawImage(this.word, this.hw, this.gy, 17);
            if (this.sh == 0) {
                this.x -= this.hw;
                return;
            }
            g.setColor(0xFFFFFF);
            g.setClip(this.hw - (this.tx - this.x), this.gy + 22, 1 + (this.tx - this.x << 1), this.sh);
            g.fillRect(this.hw - (this.tx - this.x), this.gy + 22, 1, this.sh);
            g.fillRect(this.hw + (this.tx - this.x), this.gy + 22, 1, this.sh);
            g.drawImage(this.word, this.hw, this.gy, 17);
        } else {
            g.setClip(0, this.gy, this.w, 22 + this.sh);
            g.drawImage(this.word, this.hw, this.gy, 17);
        }
    }

    void drawMenu(Graphics g) {
        g.setColor(0);
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        g.setFont(this.menuFont);
        if (this._bQuit) {
            return;
        }
        if (this.isLoading) {
            g.setColor(0);
            g.fillRect(0, (this.getHeight() >> 1) - (g.getFont().getHeight() >> 1) - 3, this.getWidth(), g.getFont().getHeight() + 6);
            g.setColor(255, 255, 255);
            String[] Loading = this.LoadLanguageTranslatedLoadingString();
            g.drawString("" + Loading[this._selected], this.getWidth() - g.getFont().stringWidth(Loading[this._selected]) >> 1, (this.getHeight() >> 1) - (g.getFont().getHeight() >> 1) + 1, 0);
            return;
        }
        int startX = 10;
        int startY = 15;
        int menuHeigth = g.getFont().getHeight() + 4;
        int menuOffsetHeigth = menuHeigth + 4;
        int menuStringsColor = 0xFFFFFF;
        int menuStringsSelectColor = 0xFFFFFF;
        int menuStringBGColor = 0x999999;
        int menuStringSelectedBGColor = 0;
        int menuBGColor = 0xFFFFFF;
        g.setColor(menuBGColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int i = 0; i < this._menuStrs.length; ++i) {
            if (i == this._selected) {
                g.setColor(menuStringSelectedBGColor);
            } else {
                g.setColor(menuStringBGColor);
            }
            g.fillRect(0, startY + i * menuOffsetHeigth, this.getWidth(), menuHeigth);
            if (i == this._selected) {
                g.setColor(menuStringsSelectColor);
            } else {
                g.setColor(menuStringsColor);
            }
            g.drawString("" + this._menuStrs[i], startX, startY + i * menuOffsetHeigth + 1, 0);
        }
        g.setColor(0);
        g.drawString(SELECT_EXIT[this._selected << 1], 10, this.getHeight() - g.getFont().getHeight() - 4, 20);
        g.drawString(SELECT_EXIT[(this._selected << 1) + 1], this.getWidth() - 10, this.getHeight() - g.getFont().getHeight() - 4, 24);
        this.isMenuPainted = true;
    }

    void preKeyPressed(int key) {
        this.preKeyPressed(key, 0, this._menuStrs.length - 1);
    }

    void preKeyPressed(int key, int start, int end) {
        if (!this.isMenuPainted) {
            return;
        }
        this._bFire = false;
        if (key == -6 || key == 42) {
            this._bFire = true;
            return;
        }
        if (key == -7 || key == 35) {
            this._bQuit = true;
            return;
        }
        int gameAction = this.getGameAction(key);
        switch (gameAction) {
            case 1: {
                --this._selected;
                if (this._selected >= start) break;
                this._selected = end;
                break;
            }
            case 6: {
                ++this._selected;
                if (this._selected <= end) break;
                this._selected = start;
                break;
            }
            case 8: {
                this._bFire = true;
            }
        }
    }

    public void keyPressed(int key) {
        this.preKeyPressed(key);
        if (this._bFire) {
            this.isLoading = true;
            this.repaint();
            this.serviceRepaints();
            this.LoadLanguage(txtFileNames[this._selected]);
            currentLanguage = this._selected;
            WPT.ref.setCanvas(new WPTCanvas(240, WPT.my_Heigth, 1000));
        } else if (this._bQuit) {
            WPT.ref.notifyDestroyed();
        } else {
            this.repaint();
        }
    }

    private String[] LoadLanguageNames() {
        System.out.println("Load langugae names");
        return this.GetUTFStrings("/lang_sel.txt", 5);
    }

    private String[] LoadLanguageTranslatedLoadingString() {
        return this.GetUTFStrings("/load_str.txt", 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] GetUTFStrings(String FileName, int Cnt) {
        String[] m_Strings = null;
        InputStream IS = null;
        FilterInputStream DAIS = null;
        try {
            m_Strings = new String[Cnt];
            IS = m_Strings.getClass().getResourceAsStream(FileName);
            DAIS = new DataInputStream(IS);
            for (int i = 0; i < m_Strings.length; ++i) {
                m_Strings[i] = ((DataInputStream)DAIS).readUTF();
            }
        }
        catch (Exception E) {
            E.printStackTrace();
        }
        finally {
            try {
                if (DAIS != null) {
                    DAIS.close();
                }
                if (IS != null) {
                    IS.close();
                }
            }
            catch (Exception E) {}
        }
        return m_Strings;
    }

    private void LoadLanguage(String FileName) {
        StringsConst.loadStrings(FileName);
    }

    public void run() {
        while (this.isRunnig) {
            switch (this.currentState) {
                case 1: {
                    this.ThreadSleep(80L);
                    this.repaint();
                    this.ThreadSleep(80L);
                    this.isRunnig = false;
                    break;
                }
                case 2: {
                    this.x = this.w;
                    this.repaint();
                    while (this.x >= -this.hw) {
                        this.ThreadSleep(80L);
                        if (!this.isShown()) continue;
                        this.repaint(0, this.gy, this.w, 22 + this.sh);
                        this.x -= 4;
                    }
                    long ts = System.currentTimeMillis();
                    ts = System.currentTimeMillis() - ts;
                    if (ts >= 1000L) break;
                    this.ThreadSleep(1000L - ts);
                }
            }
            long sTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - sTime < 2000L) {
            }
            this.currentState = 1;
        }
    }

    private void ThreadSleep(long t) {
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

