/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class LFont {
    static final int LEFT = 0;
    static final int CENTER = 1;
    static final int RIGHT = 2;
    SpritesEx _spFont = new SpritesEx();
    static char _lineFeed = (char)124;

    LFont() {
    }

    void init(Image iFont, short[] fontW) {
        this._spFont.setImage(iFont, fontW);
    }

    int drawChar(Graphics g, char c, int x, int y) {
        return this.drawChar(g, c, x, y, -1);
    }

    int drawChar(Graphics g, char c, int x, int y, int color) {
        int width;
        int index = 32;
        if (c == '\u201c' || c == '\u201d') {
            c = (char)34;
        }
        if (c > ' ' && c < '\u007f') {
            index = c - 33;
            if (c > '`' && c < '{') {
                index -= 32;
            }
            width = this._spFont.getWidth(index);
            if (color != -1) {
                g.setClip(0, 0, GameCanvas._width, GameCanvas._height * 2);
                g.setColor(color);
                g.fillRect(x - 1, y - 1 - 1, width + 2, this._spFont.getHeight() + 2);
            }
            this._spFont.paint(g, x, y - 2, index);
        } else if (c > '\u00a0') {
            index = this.GetNewCharIndex(c);
            width = this._spFont.getWidth(index);
            if (color != -1) {
                g.setClip(0, 0, GameCanvas._width, GameCanvas._height * 2);
                g.setColor(color);
                g.fillRect(x - 1, y - 1 - 1, width + 2, this._spFont.getHeight() + 2);
            }
            this._spFont.paint(g, x, y - 2, index);
        } else {
            width = 2;
        }
        return width;
    }

    private int GetNewCharIndex(char c) {
        int index = 32;
        switch (c) {
            case '\u00c4': 
            case '\u00e4': {
                index = 94;
                break;
            }
            case '\u00dc': 
            case '\u00fc': {
                index = 95;
                break;
            }
            case '\u00d6': 
            case '\u00f6': {
                index = 96;
                break;
            }
            case '\u00c0': 
            case '\u00e0': {
                index = 97;
                break;
            }
            case '\u00cc': {
                index = 98;
                break;
            }
            case '\u00d9': {
                index = 99;
                break;
            }
            case '\u00c9': 
            case '\u00e9': {
                index = 100;
                break;
            }
            case '\u00c8': 
            case '\u00e8': {
                index = 101;
                break;
            }
            case '\u00d3': 
            case '\u00f3': {
                index = 102;
                break;
            }
            case '\u00c1': 
            case '\u00e1': {
                index = 103;
                break;
            }
            case '\u00da': 
            case '\u00fa': {
                index = 104;
                break;
            }
            case '\u00ea': {
                index = 111;
                break;
            }
            case '\u00e7': {
                index = 112;
                break;
            }
            case '\u00f4': {
                index = 113;
                break;
            }
            case '\u00a1': {
                index = 115;
                break;
            }
            case '\u00cd': 
            case '\u00ed': {
                index = 118;
                break;
            }
            case '\u00f1': {
                index = 119;
                break;
            }
            case '\u00a9': {
                index = 120;
                break;
            }
            case '\u00df': {
                index = 121;
                break;
            }
            case '\u00b0': {
                index = 122;
                break;
            }
            case '\u00ba': {
                index = 123;
                break;
            }
            case '\u00bf': {
                index = 124;
                break;
            }
            case '\u201e': {
                index = 125;
                break;
            }
            default: {
                index = 32;
            }
        }
        return index;
    }

    void drawString(Graphics g, String ch, int x, int y, int gap) {
        this.drawString(g, ch, x, y, gap, 0, 0, -1);
    }

    void drawString(Graphics g, String ch, int x, int y, int gap, int len, int align) {
        this.drawString(g, ch, x, y, gap, len, align, -1);
    }

    void drawString(Graphics g, String ch, int x, int y, int gap, int len, int align, int color) {
        g.setClip(0, 0, 240, 320);
        if (ch != null) {
            if (len <= 0 || len > ch.length()) {
                len = ch.length();
            }
            switch (align) {
                case 1: {
                    x -= this.stringWidth(ch, gap, len) >> 1;
                    break;
                }
                case 2: {
                    x -= this.stringWidth(ch, gap, len);
                }
            }
            for (int k = 0; k < len; ++k) {
                x += this.drawChar(g, ch.charAt(k), x, y, color) + gap;
            }
        }
    }

    int charWidth(char c) {
        int width;
        int index = 32;
        if (c > ' ' && c < '\u007f') {
            index = c - 33;
            if (c > '`' && c < '{') {
                index -= 32;
            }
            width = this._spFont.getWidth(index);
        } else if (c > '\u00a0') {
            index = this.GetNewCharIndex(c);
            width = this._spFont.getWidth(index);
        } else {
            width = 2;
        }
        return width;
    }

    int stringWidth(String ch, int gap, int len) {
        int width = 0;
        if (len == 0) {
            len = ch.length();
        }
        char[] charMas = ch.toCharArray();
        if (ch != null) {
            for (int k = 0; k < charMas.length; ++k) {
                width += this.charWidth(charMas[k]) + gap;
            }
        }
        return width;
    }

    int getHeight() {
        return this._spFont.getHeight();
    }

    int drawStoryBox(Graphics g, String msg, int x, int y, int width, int height, int startY, int charGap, int lineGap) {
        if (msg == null) {
            return 0;
        }
        int fontHeight = this.getHeight();
        int stringWidth = 0;
        int stringStartX = x;
        int stringStartY = y + startY;
        int recommandStringWidth = width - this.charWidth('W');
        int msgLen = msg.length();
        for (int a = 0; a < msgLen; ++a) {
            int index;
            int index2;
            char ch = msg.charAt(a);
            if (ch != _lineFeed) {
                stringWidth = stringStartY > y - fontHeight && stringStartY < y + height ? (stringWidth += this.drawChar(g, ch, stringStartX + stringWidth, stringStartY)) : (stringWidth += this.charWidth(ch));
            }
            if (stringWidth > recommandStringWidth || ch == _lineFeed || a == msgLen - 1) {
                stringStartY += fontHeight + lineGap;
                stringWidth = 0;
            }
            stringWidth += charGap;
            if (ch != ' ') continue;
            int index1 = msg.indexOf(32, a + 1);
            if (index1 == -1) {
                index1 = msg.length();
            }
            if ((index2 = msg.indexOf(_lineFeed, a + 1)) == -1) {
                index2 = msg.length();
            }
            int n = index = index1 < index2 ? index1 : index2;
            if (stringWidth + this.stringWidth(msg.substring(a, index - 1), 1, 0) <= recommandStringWidth) continue;
            stringStartY += fontHeight + lineGap;
            stringWidth = 0;
        }
        return stringStartY - y - startY - lineGap;
    }

    int getStoryHeight(String msg, int width, int charGap, int lineGap) {
        int fontHeight = this.getHeight();
        int stringWidth = 0;
        boolean stringStartX = false;
        int stringStartY = 0;
        int recommandStringWidth = width - this.charWidth('W');
        int msgLen = msg.length();
        for (int a = 0; a < msgLen; ++a) {
            int index;
            int index2;
            char ch = msg.charAt(a);
            if ((stringWidth += this.charWidth(ch)) > recommandStringWidth || ch == _lineFeed || a == msgLen - 1) {
                stringStartY += fontHeight + lineGap;
                stringWidth = 0;
            }
            stringWidth += charGap;
            if (ch != ' ') continue;
            int index1 = msg.indexOf(32, a + 1);
            if (index1 == -1) {
                index1 = msg.length();
            }
            if ((index2 = msg.indexOf(_lineFeed, a + 1)) == -1) {
                index2 = msg.length();
            }
            int n = index = index1 < index2 ? index1 : index2;
            if (stringWidth + this.stringWidth(msg.substring(a, index - 1), 1, 0) <= recommandStringWidth) continue;
            stringStartY += fontHeight + lineGap;
            stringWidth = 0;
        }
        return stringStartY - lineGap;
    }
}

