/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

abstract class GameCanvas
extends Canvas
implements Runnable {
    static final int TOPLEFT = 20;
    static final int TOPRIGHT = 24;
    static final int TOPCENTER = 17;
    static final int CENTER = 3;
    Thread _thread;
    int _processTime;
    int _xadd;
    int _yadd;
    int _iPulseCnt;
    boolean _bKeyInput = true;
    boolean _bDrawOn = true;
    GameScreen _nowScreen = null;
    GameScreen _nextScreen = null;
    MIDlet _midlet = null;
    public static int _width;
    public static int _height;
    int _hWidth;
    int _hHeight;
    int _screenSize;
    boolean isPaused = false;
    boolean b;
    boolean _bPaintWait;
    int _bgColor = -1;
    int[] _keyPressQueue = new int[1];
    int _keyPressQueueIndex = 0;
    int keyp1 = 0;
    int keyp2 = 0;
    int KEY_SOFTKEY1 = -6;
    int KEY_SOFTKEY2 = -7;

    GameCanvas(int width, int height, int processTime) {
        this.setFullScreenMode(true);
        _width = width;
        _height = height;
        this._hWidth = width >> 1;
        this._hHeight = height >> 1;
        this._screenSize = width * 1000 + height;
        this._processTime = processTime;
        this._xadd = this.getWidth() - width >> 1;
        this._yadd = this.getHeight() - height >> 1;
    }

    void setProcessTime(int processTime) {
        this.easyNotify();
        this._processTime = processTime;
    }

    int getProcessTime() {
        return this._processTime;
    }

    int getScreenSize() {
        return this._screenSize;
    }

    void setDrawOn(boolean bOn) {
        this._bDrawOn = bOn;
    }

    boolean isDrawOn() {
        return this._bDrawOn;
    }

    void init() {
    }

    void destroy() {
        this.pause();
        this._thread = null;
        this.pulseNotify(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        GameCanvas gameCanvas = this;
        synchronized (gameCanvas) {
            if (this._thread == null) {
                this._thread = new Thread(this);
                this._thread.start();
            }
        }
    }

    void pause() {
    }

    public void hideNotify() {
        this.pause();
        this.isPaused = true;
    }

    public void showNotify() {
        this.start();
        this.isPaused = false;
        this.b = true;
        this.repaint();
        this.serviceRepaints();
    }

    public int getGameAction(int keyCode) {
        try {
            return keyCode;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    void notifyDestroyed() {
        WPT.ref._bStarted = false;
        this._midlet.notifyDestroyed();
    }

    public void run() {
        while (this._thread != null) {
            long startTime = System.currentTimeMillis();
            this.processKeyQueue();
            if (this._nextScreen != null) {
                if (this._nowScreen != null) {
                    this._nowScreen.lastProcess();
                    this._nowScreen.stop();
                }
                this._nowScreen = this._nextScreen;
                this._nextScreen = null;
                this._nowScreen.start();
                this._nowScreen.firstProcess();
            } else {
                this.processImpl();
            }
            this.processKeyQueue();
            if (this._iPulseCnt > 0) {
                --this._iPulseCnt;
                Thread.yield();
                continue;
            }
            if (this._processTime > -1) {
                long gap = System.currentTimeMillis() - startTime;
                if (gap < (long)this._processTime) {
                    this.easyWait((long)this._processTime - gap);
                    continue;
                }
                Thread.yield();
                continue;
            }
            this.easyWait();
        }
    }

    public void processImpl() {
        if (this._nowScreen != null) {
            this._nowScreen.process();
        }
    }

    void paintImpl(Graphics g) {
        if (this._bDrawOn && this._nowScreen != null) {
            this._nowScreen.paint(g);
        }
    }

    public void keyPressedImpl(int key) {
        if (this._nowScreen != null) {
            this._nowScreen.keyPressed(key);
        }
    }

    void serviceRepaintInTime(int _processTime) {
        if (this._bDrawOn) {
            long oldTime = System.currentTimeMillis();
            this.serviceRepaint();
            long gap = System.currentTimeMillis() - oldTime;
            if (gap < (long)_processTime) {
                this.easySleep((long)_processTime - gap);
            }
        }
    }

    synchronized void serviceRepaint() {
        if (this._bDrawOn) {
            this._bPaintWait = true;
            this.repaintAll();
            while (this._bPaintWait) {
                this.easyWait(500L);
            }
        }
    }

    synchronized void serviceRepaintRect(int x, int y, int width, int height) {
        if (this._bDrawOn) {
            this._bPaintWait = true;
            this.repaintRect(x, y, width, height);
            while (this._bPaintWait) {
                this.easyWait();
            }
        }
    }

    void serviceRepaintRectInTime(int _processTime, int x, int y, int width, int height) {
        if (this._bDrawOn) {
            long oldTime = System.currentTimeMillis();
            this.serviceRepaintRect(x, y, width, height);
            long gap = System.currentTimeMillis() - oldTime;
            if (gap < (long)_processTime) {
                this.easySleep((long)_processTime - gap);
            }
        }
    }

    void repaintRect(int x, int y, int width, int height) {
        if (this._bDrawOn) {
            this.repaint(this._xadd + x, this._yadd + y, width, height);
        }
    }

    void repaintAbsolute(int x, int y, int width, int height) {
        if (this._bDrawOn) {
            this.repaint(x, y, width, height);
        }
    }

    void repaintAll() {
        if (this._bDrawOn) {
            this.repaint(this._xadd, this._yadd, _width, _height);
        }
    }

    void eraseBackground(int color) {
        if (this._bDrawOn) {
            this._bgColor = color;
            this.repaint(0, 0, this.getWidth(), this.getHeight());
        }
    }

    synchronized void serviceEraseBackground(int color) {
        if (this._bDrawOn) {
            this._bPaintWait = true;
            this.eraseBackground(color);
            while (this._bPaintWait) {
                this.easyWait();
            }
        }
    }

    void serviceEraseBackgroundInTime(int _processTime, int color) {
        if (this._bDrawOn) {
            long oldTime = System.currentTimeMillis();
            this.serviceEraseBackground(color);
            long gap = System.currentTimeMillis() - oldTime;
            if (gap < (long)_processTime) {
                this.easySleep((long)_processTime - gap);
            }
        }
    }

    public int getWidth() {
        return 240;
    }

    public int getHeight() {
        return 320;
    }

    public void paint(Graphics g) {
        try {
            if (this._bDrawOn) {
                if (this._bgColor != -1) {
                    g.setColor(this._bgColor);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    this._bgColor = -1;
                }
                g.translate(this._xadd, this._yadd);
                g.setClip(0, 0, _width, _height);
                this.paintImpl(g);
                if (this._bPaintWait) {
                    this._bPaintWait = false;
                    this.easyNotify();
                }
            } else if (this.b) {
                this.b = false;
                if (this._nowScreen != null) {
                    this._nowScreen.paint(g);
                }
                WPTCanvas.ref._bigFontW.drawString(g, StringsConst.m_Strings_Func(0), this.getWidth() >> 1, this.getHeight() >> 1, 1, 0, 1, 43520);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void initClip(Graphics g) {
        if (this._bDrawOn) {
            g.setClip(0, 0, _width, _height);
        }
    }

    void keyInputOn(boolean flag) {
        this._bKeyInput = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearKeyQueue() {
        int[] nArray = this._keyPressQueue;
        synchronized (this._keyPressQueue) {
            this._keyPressQueueIndex = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processKeyQueue() {
        if (this._keyPressQueueIndex <= 0) return;
        int key = 0;
        int[] nArray = this._keyPressQueue;
        synchronized (this._keyPressQueue) {
            key = this._keyPressQueue[0];
            --this._keyPressQueueIndex;
            if (this._keyPressQueueIndex > 0) {
                System.arraycopy(this._keyPressQueue, 1, this._keyPressQueue, 0, this._keyPressQueueIndex);
                this.pulseNotify(1);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.keyPressedImpl(key);
            this.serviceRepaint();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void keyPressed(int key) {
        if (this.isPaused) {
            return;
        }
        this.keyp1 = key;
        this.keyp2 = key = KeyChange.ChangeKey(key);
        if (!this._bKeyInput) return;
        int[] nArray = this._keyPressQueue;
        synchronized (this._keyPressQueue) {
            if (this._keyPressQueueIndex < this._keyPressQueue.length) {
                this._keyPressQueue[this._keyPressQueueIndex++] = key;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.pulseNotify(1);
            return;
        }
    }

    public void keyReleased(int key) {
        if (this._nowScreen != null) {
            this._nowScreen.keyReleased(key);
        }
    }

    void setScreen(GameScreen next) {
        WPTCanvas.ref.clearKeyQueue();
        this._nextScreen = next;
        if (this._nowScreen == null) {
            this._nowScreen = next;
        }
        this.pulseNotify(1);
    }

    void changeScreen(GameScreen next) {
        this._nowScreen = next;
        this.pulseNotify(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void easyNotify() {
        GameCanvas gameCanvas = this;
        synchronized (gameCanvas) {
            try {
                this.notifyAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void pulseNotify(int cnt) {
        this._iPulseCnt = cnt;
        this.easyNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void easyWait(long milli) {
        if (this._bDrawOn) {
            GameCanvas gameCanvas = this;
            synchronized (gameCanvas) {
                try {
                    this.wait(milli);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void easyWait() {
        if (this._bDrawOn) {
            GameCanvas gameCanvas = this;
            synchronized (gameCanvas) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    boolean isKeyOK(int key) {
        return key == this.KEY_SOFTKEY1 || key == 42 || key == -5 || key == -6;
    }

    boolean isKeyCancel(int key) {
        return key == this.KEY_SOFTKEY2 || key == 35 || key == -7;
    }

    void easySleep(long milli) {
        if (this._bDrawOn) {
            try {
                Thread.sleep(milli);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

