/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class GameTextArea {
    String _msg = "";
    int _x;
    int _y;
    int _width;
    int _height;
    int _startY;
    int _charGap;
    int _lineGap;
    int _msgHeight;
    int _barHeight;
    LFont _font;

    GameTextArea() {
    }

    void init(String msg, int x, int y, int width, int height, int charGap, int lineGap, LFont font) {
        this.setMessage(msg);
        this._x = x;
        this._y = y;
        this._width = width;
        this._height = height;
        this._charGap = charGap;
        this._lineGap = lineGap;
        this._font = font;
        this._msgHeight = font.getStoryHeight(msg, width, charGap, lineGap);
        this._barHeight = 0;
        if (this._msgHeight > 0) {
            this._barHeight = this._height * this._height / this._msgHeight;
            if (this._barHeight > this._height) {
                this._barHeight = this._height;
            }
        }
    }

    void setMessage(String msg) {
        this._msg = msg;
        this._startY = 0;
    }

    void draw(Graphics g) {
        if (this._msgHeight > 0) {
            this._font.drawStoryBox(g, this._msg, this._x, this._y, this._width, this._height, this._startY, this._charGap, this._lineGap);
            int x = this._x + this._width + 3;
            int y = this._y - this._startY * this._height / this._msgHeight;
            g.setClip(0, 0, 240, WPT.my_Heigth);
            g.setColor(0x999999);
            g.fillRect(x, this._y, 3, this._height);
            if (this._barHeight != this._height) {
                g.setColor(0x5555FF);
                g.fillRect(x, y, 3, this._barHeight);
            }
        }
    }

    boolean key(int key) {
        int startY = this._startY;
        if (this._barHeight != this._height) {
            switch (WPTCanvas.ref.getGameAction(key)) {
                case -1: {
                    this._startY += this._height >> 1;
                    break;
                }
                case -2: {
                    this._startY -= this._height >> 1;
                }
            }
            if (this._startY > 0) {
                this._startY = 0;
            }
            if (this._startY < this._height - this._msgHeight) {
                this._startY = this._height - this._msgHeight;
            }
        }
        return startY != this._startY;
    }
}

