/*
 * Decompiled with CFR 0.152.
 */
package com.dittostudios.dupe.portlib.midp2;

import com.dittostudios.dupe.portlib.midp2.ScaledDirectGraphics;
import com.dittostudios.dupe.portlib.midp2.ScaledFont;
import com.dittostudios.dupe.portlib.midp2.ScaledImage;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;

public class ScaledGraphics
implements ScaledDirectGraphics {
    Graphics graphics;
    DirectGraphics directGraphics;
    private static final int scaleWidth = 2;
    private static final int scaleHeight = 2;
    public static final int BASELINE = 64;
    public static final int BOTTOM = 32;
    public static final int DOTTED = 1;
    public static final int HCENTER = 1;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int SOLID = 0;
    public static final int TOP = 16;
    public static final int VCENTER = 2;
    private static final int[] MANIPULATION_MAP = new int[]{0, 6, 3, 5, 2, 7, 1, 4, 1, 4, 2, 7, 3, 5, 0, 6};

    public ScaledGraphics(Graphics g2) {
        this.graphics = g2;
    }

    public void clipRect(int x2, int y2, int width, int height) {
        this.graphics.clipRect(x2 * 2, y2 * 2, width * 2, height * 2);
    }

    public void drawArc(int x2, int y2, int width, int height, int startAngle, int arcAngle) {
        this.graphics.drawArc(x2 * 2, y2 * 2, width * 2, height * 2, startAngle, arcAngle);
        this.graphics.drawArc(x2 * 2, y2 * 2 + 1, width * 2, height * 2, startAngle, arcAngle);
        this.graphics.drawArc(x2 * 2 + 1, y2 * 2, width * 2, height * 2, startAngle, arcAngle);
        this.graphics.drawArc(x2 * 2 + 1, y2 * 2 + 1, width * 2, height * 2, startAngle, arcAngle);
    }

    public void drawChar(char character, int x2, int y2, int anchor) {
        this.graphics.drawChar(character, x2 * 2, y2 * 2, anchor);
    }

    public void drawChars(char[] character, int offset, int len, int x2, int y2, int anchor) {
        this.graphics.drawChars(character, offset, len, x2 * 2, y2 * 2, anchor);
    }

    public void drawImage(ScaledImage img, int x2, int y2, int anchor) {
        this.graphics.drawImage(img.image, x2 * 2, y2 * 2, anchor);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.graphics.drawLine(x1 * 2, y1 * 2, x2 * 2, y2 * 2);
        this.graphics.drawLine(x1 * 2 + 1, y1 * 2, x2 * 2 + 1, y2 * 2);
        this.graphics.drawLine(x1 * 2, y1 * 2 + 1, x2 * 2, y2 * 2 + 1);
        this.graphics.drawLine(x1 * 2 + 1, y1 * 2 + 1, x2 * 2 + 1, y2 * 2 + 1);
    }

    public void drawRect(int x2, int y2, int width, int height) {
        this.fillRect(x2, y2, width + 1, 1);
        this.fillRect(x2, y2 + height, width + 1, 1);
        this.fillRect(x2, y2 + 1, 1, height - 1);
        this.fillRect(x2 + width, y2 + 1, 1, height - 1);
    }

    public void drawRegion(ScaledImage src, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
        this.graphics.drawRegion(src.image, x_src * 2, y_src * 2, width * 2, height * 2, transform, x_dest * 2, y_dest * 2, anchor);
    }

    public void drawRGB(int[] rgbData, int offset, int scanlength, int x2, int y2, int width, int height, boolean processAlpha) {
        int i2;
        int[] scaledImage = new int[width * 2 * height * 2];
        int column = 0;
        int row = 0;
        for (i2 = 0; i2 < width * height; ++i2) {
            column = i2 % width;
            row = (i2 - column) / width;
            column *= 2;
            row *= row * 2 * (width * 2);
            int sampleImageRow = i2 % width;
            int sampleImageColumn = (i2 - row) / width;
            for (int cS = 0; cS < 2; ++cS) {
                scaledImage[column + row + cS] = rgbData[offset + sampleImageColumn + sampleImageRow * scanlength];
            }
        }
        for (i2 = 0; i2 < height; ++i2) {
            System.arraycopy(scaledImage, i2 * (width * 2) * 2, scaledImage, i2 * (width * 2) * 2 + width * 2, width * 2);
        }
        this.graphics.drawRGB(scaledImage, 0, 1, x2 * 2, y2 * 2, width * 2, height * 2, processAlpha);
    }

    public void drawRoundRect(int x2, int y2, int width, int height, int arcWidth, int arcHeight) {
        this.graphics.drawRoundRect(x2 * 2, y2 * 2, width * 2, height * 2, arcWidth * 2, arcHeight * 2);
    }

    public void drawString(String str, int x2, int y2, int anchor) {
        this.graphics.drawString(str, x2 * 2, y2 * 2, anchor);
    }

    public void drawSubstring(String str, int offset, int len, int x2, int y2, int anchor) {
        this.graphics.drawSubstring(str, offset, len, x2 * 2, y2 * 2, anchor);
    }

    public void fillArc(int x2, int y2, int width, int height, int startAngle, int arcAngle) {
        this.graphics.fillArc(x2 * 2, y2 * 2, width * 2, height * 2, startAngle, arcAngle);
    }

    public void fillRect(int x2, int y2, int width, int height) {
        this.graphics.fillRect(x2 * 2, y2 * 2, width * 2, height * 2);
    }

    public void fillRoundRect(int x2, int y2, int width, int height, int arcWidth, int arcHeight) {
        this.graphics.fillRoundRect(x2 * 2, y2 * 2, width * 2, height * 2, arcWidth * 2, arcHeight * 2);
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.graphics.fillTriangle(x1 * 2, y1 * 2, x2 * 2, y2 * 2, x3 * 2, y3 * 2);
    }

    public int getBlueComponent() {
        return this.graphics.getBlueComponent();
    }

    public int getClipHeight() {
        return this.graphics.getClipHeight() / 2;
    }

    public int getClipWidth() {
        return this.graphics.getClipWidth() / 2;
    }

    public int getClipX() {
        return this.graphics.getClipX() / 2;
    }

    public int getClipY() {
        return this.graphics.getClipY() / 2;
    }

    public int getColor() {
        return this.graphics.getColor();
    }

    public int getDisplayColor(int color) {
        return this.graphics.getDisplayColor(color);
    }

    public ScaledFont getFont() {
        return ScaledFont.getFont(this.graphics.getFont());
    }

    public int getGrayScale() {
        return this.graphics.getGrayScale();
    }

    public int getGreenComponent() {
        return this.graphics.getGreenComponent();
    }

    public int getRedComponent() {
        return this.graphics.getRedComponent();
    }

    public int getStrokeStyle() {
        return this.graphics.getStrokeStyle();
    }

    public int getTranslateX() {
        return this.graphics.getTranslateX() / 2;
    }

    public int getTranslateY() {
        return this.graphics.getTranslateY() / 2;
    }

    public void setClip(int x2, int y2, int width, int height) {
        this.graphics.setClip(x2 * 2, y2 * 2, width * 2, height * 2);
    }

    public void setColor(int RGB) {
        this.graphics.setColor(RGB);
    }

    public void setColor(int r2, int g2, int b2) {
        this.graphics.setColor(r2, g2, b2);
    }

    public void setFont(ScaledFont font) {
        this.graphics.setFont(font.getInternalFont());
    }

    public void setGrayScale(int value) {
        this.graphics.setGrayScale(value);
    }

    public void setStrokeStyle(int style) {
        this.graphics.setStrokeStyle(style);
    }

    public void translate(int x2, int y2) {
        this.graphics.translate(x2 * 2, y2 * 2);
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public void drawImage(ScaledImage image, int x2, int y2, int anchor, int manipulation) {
        if (this.directGraphics == null) {
            this.directGraphics = DirectUtils.getDirectGraphics((Graphics)this.graphics);
        }
        this.directGraphics.drawImage(image.image, x2 * 2, y2 * 2, anchor, manipulation);
    }

    public void drawTriangle(int i2, int j2, int k2, int l2, int i1, int j1, int k1) {
        if (this.directGraphics == null) {
            this.directGraphics = DirectUtils.getDirectGraphics((Graphics)this.graphics);
        }
        this.directGraphics.drawTriangle(i2 * 2, j2 * 2, k2 * 2, l2 * 2, i1 * 2, j1 * 2, k1);
    }

    public void fillTriangle(int i2, int j2, int k2, int l2, int i1, int j1, int k1) {
        if (this.directGraphics == null) {
            this.directGraphics = DirectUtils.getDirectGraphics((Graphics)this.graphics);
        }
        this.directGraphics.fillTriangle(i2 * 2, j2 * 2, k2 * 2, l2 * 2, i1 * 2, j1 * 2, k1);
    }

    public void drawPolygon(int[] ai2, int i2, int[] ai1, int j2, int k2, int l2) {
    }

    public void fillPolygon(int[] ai2, int i2, int[] ai1, int j2, int k2, int l2) {
    }

    public void setARGBColor(int argb) {
        if (this.directGraphics == null) {
            this.directGraphics = DirectUtils.getDirectGraphics((Graphics)this.graphics);
        }
        this.directGraphics.setARGBColor(argb);
    }
}

