/*
 * Decompiled with CFR 0.152.
 */
package com.dittostudios.dupe.portlib.midp2;

import com.dittostudios.dupe.portlib.midp2.ScaledGraphics;
import com.iplay.framework.IOUtils;
import com.iplay.framework.PNGUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class ScaledImage {
    Image image;
    private final int imageWidth;
    private final int imageHeight;
    private static final int scaleWidth = 2;
    private static final int scaleHeight = 2;
    public static final boolean DEFAULT_CACHE_SETTING = true;
    private static boolean useCache = true;
    private static Hashtable imageCache = new Hashtable();
    private static Vector imageDataCache = new Vector();
    private static final boolean DEBUG = false;
    private static final boolean AVOID_createRGBImage = false;

    private ScaledImage(Image image) {
        this.image = image;
        this.imageWidth = image.getWidth() / 2;
        this.imageHeight = image.getHeight() / 2;
    }

    public static void setEnableCache(boolean enable) {
        useCache = enable;
        if (enable) {
            if (imageCache == null) {
                imageCache = new Hashtable();
            }
            if (imageDataCache == null) {
                imageDataCache = new Vector();
            }
        } else {
            imageCache = null;
            imageDataCache = null;
        }
    }

    public static ScaledImage createImage(byte[] imageData, int offset, int length) {
        ScaledImage image;
        if (useCache) {
            block0: for (int i2 = 0; i2 < imageDataCache.size(); i2 += 2) {
                byte[] cachedImageData = (byte[])imageDataCache.elementAt(i2);
                if (cachedImageData.length != length) continue;
                for (int j2 = 0; j2 < length; ++j2) {
                    if (imageData[offset + j2] != cachedImageData[offset]) continue block0;
                }
                image = (ScaledImage)imageDataCache.elementAt(i2 + 1);
                break;
            }
        } else {
            image = ScaledImage.createImage0(imageData, offset, length);
            if (useCache) {
                byte[] dataToCache = new byte[length];
                System.arraycopy(imageData, offset, dataToCache, 0, length);
                imageDataCache.addElement(dataToCache);
                imageDataCache.addElement(image);
            }
        }
        return image;
    }

    private static ScaledImage createImage0(byte[] imageData, int offset, int length) {
        byte[] newImageData = new byte[length];
        System.arraycopy(imageData, offset, newImageData, 0, length);
        imageData = newImageData;
        offset = 0;
        int plteChunkStart = PNGUtils.getChunkIndex(imageData, offset + 8, 1347179589);
        if (plteChunkStart == -1) {
            throw new RuntimeException("Not Implemented yet. No palette!");
        }
        int trnsChunkStart = PNGUtils.getChunkIndex(imageData, offset + 8, 1951551059);
        int trnsLength = trnsChunkStart != -1 ? PNGUtils.getChunkLength(imageData, trnsChunkStart) : 0;
        int plteLength = PNGUtils.getChunkLength(imageData, plteChunkStart);
        int TRANSPARENCY_COLOR = 0xFF00FF;
        int trnsDataStart = trnsChunkStart + 4 + 4;
        int paletteOffset = plteChunkStart + 4 + 4;
        int plteCount = plteLength / 3;
        for (int i2 = 0; i2 < plteCount; ++i2) {
            boolean isOpaque;
            int paletteValue = PNGUtils.MSB.readInt(imageData, paletteOffset) >>> 8;
            boolean bl = isOpaque = i2 >= trnsLength || (imageData[trnsDataStart + i2] & 0xFF) == 255;
            if (paletteValue == 0xFF00FF) {
                if (isOpaque) {
                    imageData[paletteOffset] = -2;
                    imageData[paletteOffset + 1] = 0;
                    imageData[paletteOffset + 2] = -2;
                }
            } else if (!isOpaque) {
                imageData[paletteOffset] = -1;
                imageData[paletteOffset + 1] = 0;
                imageData[paletteOffset + 2] = -1;
            }
            paletteOffset += 3;
        }
        int plteCrcOffset = plteChunkStart + 4 + 4 + plteLength;
        PNGUtils.MSB.writeInt(PNGUtils.generateCRC(imageData, plteChunkStart + 4, plteCrcOffset), imageData, plteCrcOffset);
        boolean hasAlpha = PNGUtils.hasAlpha(imageData, offset);
        Image srcImage = Image.createImage((byte[])imageData, (int)offset, (int)length);
        int srcWidth = srcImage.getWidth();
        int srcHeight = srcImage.getHeight();
        int[] srcRGB = new int[srcWidth * srcHeight];
        int n2 = srcHeight;
        int n3 = srcWidth;
        int n4 = 0;
        int n5 = 0;
        int n6 = srcWidth;
        int n7 = 0;
        int[] nArray = srcRGB;
        Image image = srcImage;
        image.getRGB(nArray, n7, n6, n5, n4, n3, n2);
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            int n8 = nArray[i3] & 0xFFFFFF;
            if (n8 != 0xFF00FF) continue;
            nArray[i3] = 0xFF00FF;
        }
        if (hasAlpha) {
            for (int i4 = 0; i4 < srcRGB.length; ++i4) {
                if ((srcRGB[i4] & 0xFFFFFF) != 0xFF00FF) continue;
                srcRGB[i4] = 0xFF00FF;
            }
        }
        srcImage = null;
        int[] dstRGB = ScaledImage.scale2x(srcRGB, srcWidth, srcHeight);
        srcRGB = null;
        Image dstImage = Image.createRGBImage((int[])dstRGB, (int)(srcWidth * 2), (int)(srcHeight * 2), (boolean)hasAlpha);
        dstRGB = null;
        return new ScaledImage(dstImage);
    }

    public static ScaledImage createImage(ScaledImage source) {
        if (source.isMutable()) {
            return new ScaledImage(Image.createImage((Image)source.image));
        }
        return new ScaledImage(source.image);
    }

    public static ScaledImage createImage(ScaledImage image, int x2, int y2, int width, int height, int transform) {
        return new ScaledImage(Image.createImage((Image)image.image, (int)(x2 * 2), (int)(y2 * 2), (int)(width * 2), (int)(height * 2), (int)transform));
    }

    public static ScaledImage createImage(InputStream stream) throws IOException {
        byte[] data = IOUtils.readFullyStream(stream);
        return ScaledImage.createImage(data, 0, data.length);
    }

    public static ScaledImage createImage(int width, int height) {
        return new ScaledImage(Image.createImage((int)(width * 2), (int)(height * 2)));
    }

    public static ScaledImage createImage(String imageName) throws IOException {
        ScaledImage img;
        ScaledImage scaledImage = img = useCache ? (ScaledImage)imageCache.get(imageName) : null;
        if (img == null) {
            byte[] data = IOUtils.getResourceAsByteArray(imageName, null);
            img = ScaledImage.createImage0(data, 0, data.length);
            if (useCache) {
                imageCache.put(imageName, img);
            }
        }
        return img;
    }

    private static final int[] scale2x(int[] srcRGB, int width, int height) {
        int[] dstRGB = new int[width * 2 * height * 2];
        int colourH = 0;
        int colourF = 0;
        int colourD = 0;
        int colourB = 0;
        int pixelE = 0;
        int colourE = 0;
        int pixelD = pixelE - 1;
        int pixelF = pixelE + 1;
        int pixelB = pixelE - width;
        int pixelH = pixelE + width;
        while (pixelE < srcRGB.length) {
            try {
                colourB = srcRGB[pixelB < 0 ? pixelE : pixelB];
                colourD = srcRGB[pixelD % width == width - 1 || pixelD < 0 ? pixelE : pixelD];
                colourF = srcRGB[pixelF % width == 0 ? pixelE : pixelF];
                colourH = srcRGB[pixelH >= srcRGB.length ? pixelE : pixelH];
                colourE = srcRGB[pixelE];
            }
            catch (ArrayIndexOutOfBoundsException aaa) {
                // empty catch block
            }
            int column = pixelE % width;
            int row = pixelE / width;
            int newIndex = column * 2 + row * width * 2 * 2;
            try {
                if (colourB != colourH && colourD != colourF) {
                    dstRGB[newIndex] = colourD == colourB ? colourD : colourE;
                    dstRGB[newIndex + 1] = colourB == colourF ? colourF : colourE;
                    dstRGB[newIndex + width * 2] = colourD == colourH ? colourD : colourE;
                    dstRGB[newIndex + width * 2 + 1] = colourH == colourF ? colourF : colourE;
                } else {
                    dstRGB[newIndex] = colourE;
                    dstRGB[newIndex + 1] = colourE;
                    dstRGB[newIndex + width * 2] = colourE;
                    dstRGB[newIndex + width * 2 + 1] = colourE;
                }
            }
            catch (ArrayIndexOutOfBoundsException aaa) {
                // empty catch block
            }
            ++pixelE;
            ++pixelD;
            ++pixelF;
            ++pixelB;
            ++pixelH;
        }
        return dstRGB;
    }

    public static ScaledImage createRGBImage(int[] srcRGB, int width, int height, boolean processAlpha) {
        int[] dstRGB = ScaledImage.scale2x(srcRGB, width, height);
        srcRGB = null;
        return new ScaledImage(Image.createRGBImage((int[])dstRGB, (int)(width * 2), (int)(height * 2), (boolean)processAlpha));
    }

    public void getRGB(int[] rgbArray, int startX, int startY, int w2, int h2, int offset, int scansize) {
        int n2 = scansize;
        int n3 = offset;
        int n4 = h2;
        int n5 = w2;
        int n6 = startY;
        int n7 = startX;
        int[] nArray = rgbArray;
        Image image = this.image;
        image.getRGB(nArray, n7, n6, n5, n4, n3, n2);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n8 = nArray[i2] & 0xFFFFFF;
            if (n8 != 0xFF00FF) continue;
            nArray[i2] = 0xFF00FF;
        }
    }

    public ScaledGraphics getGraphics() {
        return new ScaledGraphics(this.image.getGraphics());
    }

    public int getHeight() {
        return this.imageHeight;
    }

    public int getWidth() {
        return this.imageWidth;
    }

    public boolean isMutable() {
        return this.image.isMutable();
    }

    public Image getOriginalImage() {
        return this.image;
    }
}

