/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.framework;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class IOUtils {
    private static byte[] sharedBuffer;
    private static Graphics renderTargetGraphics;
    private static Hashtable fileCache;

    private IOUtils() {
    }

    public static byte[] readFullyStream(InputStream is) throws IOException {
        Vector<byte[]> buffers = new Vector<byte[]>();
        byte[] activeBuffer = new byte[4096];
        int bytesStored = 0;
        int bytesRead = 0;
        do {
            if ((bytesStored += bytesRead) != 4096) continue;
            buffers.addElement(activeBuffer);
            activeBuffer = new byte[4096];
            bytesStored = 0;
        } while ((bytesRead = is.read(activeBuffer, bytesStored, 4096 - bytesStored)) != -1);
        int numBuffers = buffers.size();
        byte[] buffer = new byte[numBuffers * 4096 + bytesStored];
        for (int i2 = 0; i2 < numBuffers; ++i2) {
            byte[] b2 = (byte[])buffers.elementAt(i2);
            System.arraycopy(b2, 0, buffer, i2 * 4096, 4096);
        }
        if (bytesStored > 0) {
            System.arraycopy(activeBuffer, 0, buffer, numBuffers * 4096, bytesStored);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getResourceAsByteArray(String strFile, String packFile) {
        byte[] data = null;
        try {
            DataInputStream is = IOUtils.getResourceAsDataStream(strFile, null);
            try {
                data = IOUtils.readFullyStream(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public static Image createImage(byte[] data, int offset, int len) {
        Image result = Image.createImage((byte[])data, (int)offset, (int)len);
        return result;
    }

    public static Image createImage(String strFile, String packFile) {
        Image result;
        try {
            result = Image.createImage((String)strFile);
        }
        catch (Exception e2) {
            result = null;
        }
        return result;
    }

    private static final byte[] getPackedResource(String fileName, String packFile) {
        return null;
    }

    public static final DataInputStream getResourceAsDataStream(String resource, String packFile) {
        InputStream fis = resource.getClass().getResourceAsStream(resource);
        return new DataInputStream(fis);
    }

    public static class DeviceConstants {
        public static final boolean USE_ALTERNATE_READ_FULLY_STREAM = false;
        public static final int FILE_BUFFER_SIZE = 4096;
        public static final boolean SUPPORTS_PACKED_RESOURCES = false;
        public static final boolean PRE_RENDER_IMAGES = false;
        public static final boolean AVOID_CREATE_IMAGE_STRING = false;
        public static final boolean USE_SHARED_PNG_BYTE_BUFFER = false;
        public static final int SHARED_PNG_BYTE_BUFFER_SIZE = 32768;
        public static final boolean GARBAGE_COLLECT_BEFORE_IMAGE_CREATION = false;
        public static final boolean INPUTSTREAM_LEAKS = false;
        public static final int IO_LOAD_ATTEMPT_COUNT = 1;
    }
}

