/*
 * Decompiled with CFR 0.152.
 */
public class Quaternion {
    float w;
    float x;
    float y;
    float z;

    Quaternion() {
        this.w = 0.0f;
        this.x = 1.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    Quaternion(float qw, float qx, float qy, float qz) {
        this.w = qw;
        this.x = qx;
        this.y = qy;
        this.z = qz;
    }

    void set(Quaternion q) {
        this.w = q.w;
        this.x = q.x;
        this.y = q.y;
        this.z = q.z;
    }

    void setAxisAngle(float[] axisAngle) {
        try {
            this.w = 1.0f / (float)Math.tan((double)axisAngle[0] * Math.PI / 360.0);
            this.x = axisAngle[1];
            this.y = axisAngle[2];
            this.z = axisAngle[3];
            float norm = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
            this.w /= norm;
            this.x /= norm;
            this.y /= norm;
            this.z /= norm;
        }
        catch (Exception e) {
            this.w = 1.0f;
            this.z = 0.0f;
            this.y = 0.0f;
            this.x = 0.0f;
        }
    }

    float[] toAxisAngle() {
        float[] result = new float[4];
        float s = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (s != 0.0f) {
            result[0] = (float)(2.0 * Float11.acos(this.w)) * 180.0f / (float)Math.PI;
            result[1] = this.x / s;
            result[2] = this.y / s;
            result[3] = this.z / s;
        } else {
            result[0] = 0.0f;
            result[1] = 1.0f;
            result[2] = 0.0f;
            result[3] = 0.0f;
        }
        return result;
    }
}

