/*
 * Decompiled with CFR 0.152.
 */
public class QMath {
    Quaternion quaternionMult(Quaternion q1, Quaternion q2) {
        float[] v1 = new float[3];
        float[] v2 = new float[3];
        float[] cp = new float[3];
        Quaternion q = new Quaternion();
        v1[0] = q1.x;
        v1[1] = q1.y;
        v1[2] = q1.z;
        v2[0] = q1.x;
        v2[1] = q1.y;
        v2[2] = q1.z;
        q.w = q1.w * q2.w - (q1.x * q2.x + q1.y * q2.y + q1.z * q2.z);
        cp[0] = q1.y * q2.z - q2.y * q1.z;
        cp[1] = q1.z * q2.x - q2.z * q1.x;
        cp[2] = q1.x * q2.y - q2.x * q1.y;
        q.x = v2[0] * q1.w + cp[0] + v1[0] * q2.w;
        q.y = v2[1] * q1.w + cp[1] + v1[1] * q2.w;
        q.z = v2[2] * q1.w + cp[2] + v1[2] * q2.w;
        return q;
    }

    static Quaternion qSLERP(Quaternion q1, Quaternion q2, float t) {
        float scale1;
        float scale0;
        float EPS = 0.01f;
        float[] qi = new float[4];
        Quaternion q = new Quaternion();
        float co = q1.x * q2.x + q1.y * q2.y + q1.z * q2.z + q1.w * q2.w;
        if (co < 0.0f) {
            co = -co;
            qi[0] = -q2.x;
            qi[1] = -q2.y;
            qi[2] = -q2.z;
            qi[3] = -q2.w;
        } else {
            qi[0] = q2.x;
            qi[1] = q2.y;
            qi[2] = q2.z;
            qi[3] = q2.w;
        }
        if (1.0f - co <= EPS) {
            scale0 = 1.0f - t;
            scale1 = t;
        } else {
            float o = (float)Float11.acos(co);
            float so = (float)Math.sin(o);
            scale0 = (float)Math.sin((1.0f - t) * o) / so;
            scale1 = (float)Math.sin(t * o) / so;
        }
        q.w = scale0 * q1.w + scale1 * qi[3];
        q.x = scale0 * q1.x + scale1 * qi[0];
        q.y = scale0 * q1.y + scale1 * qi[1];
        q.z = scale0 * q1.z + scale1 * qi[2];
        return q;
    }
}

